/*	if_il.c	6.4	84/03/22	*/

/*
 * Interlan Ethernet Communications Controller interface Standalone driver
 */

#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "../is68kif/if_il.h"
#include "../is68kif/if_ilreg.h"

extern char *arguments;

struct ildevice *ilstd[] = { /* KLUDGE */(struct ildevice *)0x3fe800, 0 };

struct	ether_addr myaddr;	/* hardware Ethernet address of this machine */
struct	ether_addr hostaddr;	/* hardware Ethernet address of host machine */
struct  ether_addr broaddr 	/*= { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF} */ ;

struct ilrboot_packet {
	struct il_rheader	bp_eh;		/* standard ethernet header */
	int			bp_pkid;	/* packet id */
	char			bp_cmd;		/* command */
	int			bp_offset;	/* offset */
	int			bp_len;		/* length */
	char			bp_data[BOOT_DATACNT];	/* data */
};

#define	QBUSADDR(x)	((u_long)paddr(x))
#define	P_QBUSADDR(x)	((u_long)paddr(x))

struct ilrboot_packet	boot_rcv;
struct boot_packet	boot_xmt;
struct boot_packet	*ilsend();
int			pkid;
/*static struct st	ilst = {1, -1, -1, -1, -1, NULL}; /**/
static struct st	ilst = {512, -1, -1, -1, -1, NULL}; /**/

#define ilcwait(x)	while ((x->il_csr & IL_CDONE) == 0)
#define ilrwait(x)	while ((x->il_csr & IL_RDONE) == 0)

struct	il_stats is_stats;	/* holds on-board statistics */
struct	il_stats is_sum;	/* summation over time */

ilopen(io)
	register struct iob *io;
{
	register struct boot_packet *bp;
	register struct ildevice *iladdr;
	register unsigned int i;
	register char *p0;

	pkid = 0;
	io->i_flgs |= F_REMOTE;
	io->i_st = ilst;
	iladdr = ilstd[0];

	/*
	 * Reset the board and map the statistics buffer onto the Unibus.
	 */
	iladdr->il_csr = ILC_RESET;
	ilcwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il: rst fail, csr=%b\n", iladdr->il_csr, IL_BITS);
	i = paddr((int)&is_stats);
	iladdr->il_bar = i;
	iladdr->il_bcr = sizeof (struct il_stats);
	iladdr->il_bae = i >> 16;
	iladdr->il_csr = ILC_STAT;
	ilcwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il: sts fail, csr=%b\n", iladdr->il_csr, IL_BITS);
	byterev(&is_stats, sizeof(struct il_stats));
	myaddr = is_stats.ils_addr;

	iladdr->il_csr = ILC_OFFLINE;
	ilcwait(iladdr);
	iladdr->il_csr = ILC_CISA;
	ilcwait(iladdr);
	iladdr->il_csr = ILC_ONLINE;
	ilcwait(iladdr);

	/*
	 * broadcast a host connect packet
	 */
	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = broaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CONNECT;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	
	if (arguments)
		while((*arguments != ':') &&  (*p0++ = *arguments++));
	else {
		printf("no remote file name\n");
		return (-1);
	}
	if (*arguments == ':') arguments++;

	if ((bp = ilsend()) == 0)
		return (-1);
	hostaddr = bp->bp_eh.ether_shost;

	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_OPEN;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	while((*arguments != '(') &&  (*p0++ = *arguments++));
	if (*arguments != '(')
		arguments = NULL;

	if ((bp = ilsend()) == 0)
		return (-1);
	return(0);
}

ilclose()
{
	register struct boot_packet *bp;

	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CLOSE;
	bp->bp_pkid = pkid;
	if ((bp = ilsend()) == 0)
		return (-1);
	return(0);
}

ilstrategy(io, func)
	register struct iob *io;
{
	register int count = io->i_cc;
	register int offset = io->i_offset;
	/* CAUTION this is now a physical addr, things better be 1:1 */
	register struct boot_packet *bp;
	register int len;

	while (count > 0) {
		len = count < BOOT_DATACNT ? count : BOOT_DATACNT;
		bp = &boot_xmt;
		bzero(bp, sizeof(struct boot_packet));
		bp->bp_eh.ether_shost = myaddr;
		bp->bp_eh.ether_dhost = hostaddr;
		bp->bp_eh.ether_type = ETHERPUP_BOOT;
		bp->bp_pkid = pkid;
		bp->bp_offset = offset;
		bp->bp_len = len;
		if (func == READ)
			bp->bp_cmd = BOOT_READ;
		else {
			bp->bp_cmd = BOOT_WRITE;
			bcopy(bp->bp_data, io->i_ma, len);
		}
		if ((bp = ilsend()) == 0)
			return(-1);
		if (func == READ)
			bcopy(bp->bp_data, io->i_ma, bp->bp_len);
		offset += bp->bp_len;
		io->i_ma += bp->bp_len;
		count -= bp->bp_len;
		if (bp->bp_len != len)
			break;
	}

	return(io->i_cc - count);
}

/*
 * output the packet in the tansmit buffer.  Wait for a non-broadcast packet 
 * with the same 'pkid' to come back in the recieve buffer as an acknoldge.  
 * If nothing comes back then wait and do retransmitions.  Return a pointer
 * to the recieved packet, return null if a timeout occured.  The ethernet
 * source field of a recieved CONNECT packet will have the address of the
 * host that responded to the broadcasted CONNECT packet.  The data portion
 * of a recieved READ packed will have the data read.  The data portion of
 * a transmited (and recieved) WRITE packet will have the data to be writen.
 * The host acknoldges packets by performing the specified action, swaping the
 * source and destination addresses in the packet, and sending the packet back 
 * out onto the network.  The host should never change the 'pkid' field of a 
 * boot packet.
 */
struct boot_packet *
ilsend()
{
	register struct ildevice *iladdr = ilstd[0];
	register struct boot_packet *bp;
	register struct ilrboot_packet *rbp;
	int i;

	bp = &boot_xmt;
	byterev(bp, sizeof(struct boot_packet));

   rex:	i = paddr(bp);
	iladdr->il_bar = loword(i);
	iladdr->il_bcr = sizeof (struct boot_packet);
	iladdr->il_bae = hiword(i);
	iladdr->il_csr = ILC_XMIT;
	ilcwait(iladdr);
	if (iladdr->il_csr & IL_STATUS) {
		printf("ex: xmit error");
		goto rex;
	}
	do {
		rbp = &boot_rcv;
		i = paddr(rbp);
   rer:		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof (struct ilrboot_packet) + 5;
		iladdr->il_bae = hiword(i);
		iladdr->il_csr = ILC_RCV;
		ilrwait(iladdr);
		if (iladdr->il_csr & IL_STATUS) {
			printf("ex: rcv error");
			goto rer;
		}
		byterev(&rbp->bp_eh.ilr_dhost, sizeof(struct boot_packet));
	} while (rbp->bp_eh.ilr_dhost.ether_addr_octet[0] == 0xFF || 
		 rbp->bp_eh.ilr_type != ETHERPUP_BOOT ||
		 rbp->bp_pkid != pkid );
	pkid++;
	return ( (struct boot_packet *) &rbp->bp_eh.ilr_dhost);
}
