/* VMEBUS ICP8/16 execersizer:
 * 	TODO: make this test use ../is68kdev/cpreg.h
 */
#define SEL	0
#define ICR	1
#define LER	2
#define TCR	3
#define BRK	4
#define SWR	5
#define ACR	6
#define DCR	7
#define DRR	8
#define PR	9
#define PR_VAL	0x52BB
#define SR	10
#define BAH	11
#define BAL	12
#define BC	13

#define DELAY(x) {int D_i; for ( D_i = 0 ; D_i < x ; D_i++);}

#ifdef	M68020
unsigned short *dicp=(unsigned short *)0xFFF520;
#else	M68020
unsigned short *dicp=(unsigned short *)0x7FF520;
#endif	M68020
char *string = "The quick brown fox jumped over the lazy dog.\n\r";

char buf[50];
char character[50];

main()
{
	register char *s;
	register int i;
	register unsigned int line = 0;
	register unsigned int c;
	register unsigned short *icp = 0;

	printf("\n--- Integrated Solutions %i ICP8/16 Standalone Tests ---");
	printf("\n                 Version 2.0\n\n");
	printf("  Enter address of ICP8/16 (default = %x): ",dicp);
	stripwhite(gets(buf));
	icp = (unsigned short *)gethex(buf);
	if (icp == 0)
		icp = dicp;

menu:	printf(" a) Select line number\n");
	printf(" b) Echo test\n");
	printf(" c) Transfer test\n");
	printf(" d) all ports transfer\n");
	printf(" e) printer test\n");
	printf(" f) modem line test\n");
	printf(" g) Preform reset\n");
	printf(" h) Print resigters\n");

	while (1) {
		printf("Enter letter of functionality: ");
		stripwhite(gets(buf));
		if (buf[0] == 'a') {
			printf("    line number (0-15): ");
			stripwhite(gets(buf));
			line = getnum(buf);
			if (line > 15 || line < 0)
				line = 0;
		} else if (buf[0] == 'b') {
			icp[SEL] = line << 4;
			icp[PR] = PR_VAL;
			icp[ACR] = 1 << line;
			icp[LER] = 1 << line;
			while (1) {
				if (getlocal())
					break;
				if ((c = icp[SWR]) &0x8000) {
if(icp[ICR]);
				    character[0] = c & 0xFF;
				    icp[BAH] = 
					(((unsigned int)character)>>16)&0xFFFF;
				    icp[BAL] = ((unsigned int)character)&0xFFFF;
				    icp[BC] = 1;
				    icp[TCR] = 1 << line;
				    printf("%c",c); /* echo on console */
				    while (icp[TCR] == 0)
					DELAY(1000);
if(icp[ICR]);
				}
			}
		} else if (buf[0] == 'c') {
			icp[SEL] = line << 4;
			icp[PR] = PR_VAL;
			icp[ACR] = 1 << line;
			icp[LER] = 1 << line;
			while (1) {
				if (getlocal())
					break;
				icp[BAH] = (((unsigned int)string)>>16)&0xFFFF;
				icp[BAL] = ((unsigned int)string)&0xFFFF;
				icp[BC] = 47;
				icp[TCR] = 1 << line;
				DELAY(1000);
				while (icp[TCR] == 0)
					DELAY(1000);
if(icp[ICR]);
			}
		} else if (buf[0] == 'd') {
		  int xline;
		  printf("    number of lines (1-16): ");
		  stripwhite(gets(buf));
		  line = getnum(buf);
		  if (line > 16 || line <= 0)
			line = 1;
		  while (1) {
		    if (getlocal())
			break;
		    for (i = 0 ; i < line ; i++) {
			icp[SEL] = i << 4;
			icp[PR] = PR_VAL;
			icp[BAH] = (((unsigned int)string)>>16)&0xFFFF;
			icp[BAL] = ((unsigned int)string)&0xFFFF;
			icp[BC] = 47;
			xline |= 1 << line;
		    }
		    icp[ACR] = xline;
		    icp[LER] = xline;
		    icp[TCR] = xline;
		    line = 0;
		    DELAY(1000);
		    while ((i |= icp[TCR]) != xline) /* wait for all lines */
			DELAY(1000);
if(icp[ICR]);
		  }
		} else if (buf[0] == 'e') {
			icp[SEL] = 17 << 4;	/* select printer */
			while (1) {
				if (getlocal())
					break;
				icp[BAH] = (((unsigned int)string)>>16)&0xFFFF;
				icp[BAL] = ((unsigned int)string)&0xFFFF;
				icp[BC] = 47;
				icp[SR] = 1;
				DELAY(1000);
				while (icp[SR] & 1)
					DELAY(1000);
				icp[SR] = 2;
				DELAY(10);
				while (icp[SR] & 2)
					DELAY(1000);
				printf("...\r");
			}
		} else if (buf[0] == 'f') {
		  icp[ACR] = 0xFFFF;
		  DELAY(100000);
		  printf("    Carrier Asserted on all lines, detected on\n");
		  while (1) {
			DELAY(100000);
			if (getlocal())
				break;
			printf(
"\r                                                                     \r");
			c = icp[DCR];
			if (c) {
				printf("    Detected on line(s): ");
				for (i = 0 ; i < 16 ; i++)
				    if (c & (1<<i))
					printf("%d ",i);
			} else
				printf("    Not detected on any lines");
		  }
		  icp[ACR] = 0x0000;
		} else if (buf[0] == 'g') {
			printf("    Perform Master Clear\n");
			icp[SEL] = 0x8000;
			DELAY(1000);
			while (icp[SEL] & 0x8000)
				DELAY(1000);
			printf("    Done.\n");
		} else if (buf[0] == 'h') {
			printf("    Print Registers\n");
			printf("    SEL	%x\n",icp[SEL]);
			printf("    ICR	%x\n",icp[ICR]);
			printf("    LER	%x\n",icp[LER]);
			printf("    TCR	%x\n",icp[TCR]);
			printf("    BRK	%x\n",icp[BRK]);
			printf("    SWR	%x\n",icp[SWR]);
			printf("    ACR	%x\n",icp[ACR]);
			printf("    DCR	%x\n",icp[DCR]);
			printf("    DRR	%x\n",icp[DRR]);
			printf("    PR	%x\n",icp[PR]);
			printf("    SR	%x\n",icp[SR]);
			printf("    BAH	%x\n",icp[BAH]);
			printf("    BAL	%x\n",icp[BAL]);
			printf("    BC	%x\n",icp[BC]);
		} else
			goto menu;
		printf("\n");
	}
}
