/*	hp.c	6.1	83/07/29	*/
/*#define DEBUG/**/

/*
 * RP??/RM?? disk driver
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68k/board.h"
#include "../is68kdev/hpreg.h"

#include "saio.h"
#include "sais68k.h"

#define	MASKREG(reg)	((reg)&0xffff)

struct hpdevice 	*hp_std[] = {(struct hpdevice *)0x3FFDC0,
				     (struct hpdevice *)0x3FFCC0 };

struct st hpst[] = {
	512, 32,	5,	32*5,	823,	NULL,	/* RM02 */
	512, 32,	5,	32*5,	823,	NULL,	/* RM03 */
	512, 32,	19,	32*19,	823,	NULL,	/* RM05 */
	512, 22,	19,	22*19,	815,	NULL,	/* RP06 */
	512, 31,	14, 	31*14,	559,	NULL,	/* RM80 */
	512, 22,	19,	22*19,	411,	NULL,	/* RP05 */
	512, 50,	32,	50*32,	630,	NULL,	/* RP07 */
};

short	hptypes[] = {
	HPDT_RM02,
	HPDT_RM03,
	HPDT_RM05,
	HPDT_RP06,
	HPDT_RM80,
	HPDT_RP05,
	HPDT_RP07,
	0
};

int hpstrat(), forbb;

hpopen(io)
	register struct iob *io;
{
	register unit = io->i_unit;
	struct hpdevice *hpaddr = (struct hpdevice *)hp_std[UTOCN(unit)];

	if (!probe(&hpaddr->hpba,&hpaddr->hpba)) {
		printf("hp: controller not present\n");
		return (-1);
	}

	hpmaptype(hpaddr, io);

	if ((io->i_boff = diskpart(io)) < 0) {
		printf("hp: bad offset\n");
		return (-1);
	}
	return (0);
}


hpmaptype(hpaddr, io)
	register struct hpdevice 	*hpaddr;
	register struct iob		*io;
{
	register int i, type;

	hpaddr->hpcs1 = 0;			/* conservative */
	hpaddr->hpcs2 = UTODR(io->i_unit);
	hpaddr->hpcs1 = HP_PRESET | HP_GO;
	hpaddr->hpof = HPOF_FMT16 | HPOF_ECI;

	/*
	 * If the CPU switches indicate that we have an EMULEX controller then 
	 * get drive stat info from the controller.  Otherwise read the drive 
	 * type register and settle for that definition.
	 */
	if (((*(u_short *)BSR) & BSR_DISK) == BSR_DISK_EHP) {
/*		printf("hp: maptype: EMULEX "); /* */
		io->i_st.nbsec = 512;
		hpaddr->hphr = HPHR_MAXSECT;
		io->i_st.nsect = hpaddr->hphr + 1;
		hpaddr->hphr = HPHR_MAXTRAK;
		io->i_st.ntpc = hpaddr->hphr + 1;
		io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
		hpaddr->hphr = HPHR_MAXCYL;
		io->i_st.ncyl = hpaddr->hphr + 1;
		io->i_st.off = NULL;
	} else {
 		type = hpaddr->hpdt & 0x3F;
		for (i = 0; hptypes[i]; i++)
			if (hptypes[i] == type)
				goto found;
		printf("hp: unknown drive type\n");
		return (-1);
	found:
#ifdef DEBUG
		printf("hp: maptype: %o:%d \n", type, i);
#endif
		io->i_st = hpst[i];
	}

#ifdef DEBUG
	printf("hp: maptype: (nsect * ntpc * ncyl) = (%d * %d * %d)\n",
		io->i_st.nsect,io->i_st.ntpc,io->i_st.ncyl);
#endif
	hpaddr->hpcs1 = HP_DCLR|HP_GO;		/* init drive */
	hpaddr->hpcs1 = HP_PRESET|HP_GO;
	hpaddr->hpof = HPOF_FMT16 | HPOF_ECI;
}

hpstrategy(io, func)
	register struct iob *io;
{
	register int wc = io->i_cc;

	if (forbb)
		return hpstrat(io,io->i_bn,wc,func);
	else if (badstrat(io,io->i_bn,wc,func,hpstrat,READ) == -1)
		return -1;
	else
		return wc;
}

hpstrat(io, bn, wc, func)
register struct iob *io;
int bn,wc,func;
{
	struct hpdevice *hpaddr = (struct hpdevice *)hp_std[UTOCN(io->i_unit)];
	register int cn, tn, sn;

	if ((hpaddr->hpds & HPDS_VV) == 0) {
		hpaddr->hpcs1 = HP_DCLR|HP_GO;
		hpaddr->hpcs1 = HP_PRESET|HP_GO;
		hpaddr->hpof = HPOF_FMT16 | HPOF_ECI;
	}
	cn = bn/io->i_st.nspc;
	sn = bn%io->i_st.nspc;
	tn = sn/io->i_st.nsect;
	sn = sn%io->i_st.nsect;
	hpaddr->hpdc = cn;
	hpaddr->hpda = (tn << 8) + sn;
	hpaddr->hpba = loword(io->i_ma);
	hpaddr->hpbae = hiword(io->i_ma);
	hpaddr->hpwc = -wc / sizeof (short);
	if (func == READ)
	    hpaddr->hpcs1 = (short)(((long)io->i_ma>>8)&0x300)|HP_RCOM|HP_GO;
	else
	    hpaddr->hpcs1 = (short)(((long)io->i_ma>>8)&0x300)|HP_WCOM|HP_GO;
	hpwait(hpaddr);
	if (hpaddr->hpds&HPDS_ERR) {
		printf("hp: error (cyl,trk,sec)=(%d,%d,%d) ds=%b er1=%b\n",
		    cn, tn, sn, MASKREG(hpaddr->hpds), HPDS_BITS,
		    MASKREG(hpaddr->hper1), HPER1_BITS);
		hpaddr->hpcs1 = HP_DCLR|HP_GO;	/* reset drive */
		return (-1);
	}
	if (forbb)
		io->i_ma += wc;
	return wc;
}

hpwait(hpaddr)
	register struct hpdevice *hpaddr;
{
	register int i;
	short cs1;

#ifdef	M68020
	for ( i = 2000000; i ; i--)
#else	M68020
	for ( i = 500000; i ; i--)
#endif	M68020
		if (probe(&hpaddr->hpcs1, &cs1) && (cs1 & HP_RDY) != 0)
			break;
	if (i == 0) {
		printf("hp: timeout\n");
		return(-1);
	}
	return (0);
}
