/* 
 * Standalone driver for VMEBUS ISI Graphics Processor (GIP):
 *	NOTE: non-UCODE version is out of date...
 *   	comment following out definition of GIP for stubs, see ./sio.c.
 */
#define GIP
#define UCODE

#include "../h/param.h"

#ifndef	GIP
putgip(c){}				/* stub */
#else	GIP

#include "../is68k/board.h"
#include "../is68kdev/gpreg.h"

/*
 * possible graphics processor address tuples
 */
#define	GP_NADDR	8

struct gp_addr_tuple {
	ushort		*dm;		/* display memory */
	struct gpdevice	*addr;		/* gip address */
} gp_addrs[GP_NADDR] = {
#ifdef	M68020
	{(ushort *)0xE00000, (struct gpdevice *)0xFFC000},
	{(ushort *)0xD00000, (struct gpdevice *)0xFF8000},
	{(ushort *)0xC00000, (struct gpdevice *)0xFF4000},
	{(ushort *)0xB00000, (struct gpdevice *)0xFF0000},
	{(ushort *)0xA00000, (struct gpdevice *)0xFEC000},
	{(ushort *)0x900000, (struct gpdevice *)0xFE8000},
	{(ushort *)0x800000, (struct gpdevice *)0xFE4000},
	{(ushort *)0x700000, (struct gpdevice *)0xFE0000},
#else	M68020
	{(ushort *)0xE00000, (struct gpdevice *)0x7FC000},
	{(ushort *)0xD00000, (struct gpdevice *)0x7F8000},
	{(ushort *)0xC00000, (struct gpdevice *)0x7F4000},
	{(ushort *)0xB00000, (struct gpdevice *)0x7F0000},
	{(ushort *)0xA00000, (struct gpdevice *)0x7EC000},
	{(ushort *)0x900000, (struct gpdevice *)0x7E8000},
	{(ushort *)0x800000, (struct gpdevice *)0x7E4000},
	{(ushort *)0x700000, (struct gpdevice *)0x7E0000},
#endif	M68020
};

#define	SCREENX		0
#define	SCREENY		0
#define	SCREENW 	1280
#define	SCREENH 	1024
#define CHAR_HEIGHT	20
#define CHAR_WIDTH	12
#ifdef	M68020
#define GIP_DELAY	1600000
#else	M68020
#define GIP_DELAY	400000
#endif	M68020

static int col = 0;			/* current column */
static int g_init = 0;			/* processor initialized */
static int g_ing = 0; 			/* stop recursion on printfs */
static struct gpdevice *gpaddr = 0;	/* pointer to gip registers */
#ifdef	M68010
static char mem_map[4096*3];		/* array to remap on display memory */
#endif	M68010
static int xxx;

static unsigned short gp_initcmds[] = {
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,		/* flush fifo*/
	GP_CLIPOF,
	GP_ALUC,
	GP_SPTCH, 0x28,
	GP_DPTCH, 0x28,
	0xFFFF						/* end marker */
};

/*
 * Screen parameters
 */
struct raster
{
	short    width;
	short   *address;
} screen;


extern int plane_desc;
extern int vbnum;

typedef int	    *COLOR;
/* Video Colors */
#define BLACK	0
int black = BLACK;
#define WHITE	1
int white = WHITE;

#ifdef	UCODE
#define UCODE_WAIT(x)	{   x->gp_fifo = GP_INTOF;			\
			    DELAY(128);					\
			    while ((x->gp_fifo&(1<<GPFIFOEMPTY)) == 0);	\
			    DELAY(128);					\
			}
#endif	UCODE

static
g_iscroll()
{
#ifdef	UCODE
	static unsigned short gp_iscrollcmd[] = {
		GP_BOX, 0, 0, 0, (((SCREENH/CHAR_HEIGHT)-1)*CHAR_HEIGHT),
	 	SCREENW, CHAR_HEIGHT*3, 0xFFFF };

	gp_cmd(gp_iscrollcmd);
#else	UCODE
	ClearRaster(&screen, 0, 0, SCREENW, CHAR_HEIGHT*2, WHITE);
#endif	UCODE
}

static
g_scroll()
{
#ifdef	UCODE
	static unsigned short gp_scrollcmd[] = {
		GP_BOXC, 0, 0, 0, CHAR_HEIGHT, 0, 0, 0, 0, 
		SCREENW, SCREENH, 0xFFFF };

	gp_cmd(gp_scrollcmd);
#else	UCODE
	CopyRaster(&screen, 0, CHAR_HEIGHT, &screen, 0, 0, SCREENW, SCREENH);
#endif	UCODE
}

static
g_putchar(ccol,c)
int ccol;
char *c;
{
#ifdef	UCODE
	register struct gpdevice *gp = gpaddr;

	UCODE_WAIT(gp);
#endif	UCODE
	DrawString(40+ccol*CHAR_WIDTH,CHAR_HEIGHT-5,&plane_desc,&white,1,c);
}

static
g_blank(ccol)
{
#ifdef	UCODE
	register struct gpdevice *gp = gpaddr;

	gp->gp_fifo = GP_BOX;			/* box */
	gp->gp_fifo = 0;			/* dest_h */
	gp->gp_fifo = 0;			/* dest_l */
	gp->gp_fifo = 40+ccol*CHAR_WIDTH;	/* xd */
	gp->gp_fifo=
		(((SCREENH/CHAR_HEIGHT)-1)*CHAR_HEIGHT);/* yd */
	gp->gp_fifo = CHAR_WIDTH;		/* w */
	gp->gp_fifo = CHAR_HEIGHT*2;		/* h */
	UCODE_WAIT(gp);
#else	UCODE
	TODO: -- not done
#endif	UCODE
}

static
g_block(ccol)
{
#ifdef	UCODE
	register struct gpdevice *gp = gpaddr;

	gp->gp_fifo = GP_ALUS;
	gp->gp_fifo = GP_BOX;			/* box */
	gp->gp_fifo = 0;			/* dest_h */
	gp->gp_fifo = 0;			/* dest_l */
	gp->gp_fifo = 40+ccol*CHAR_WIDTH;	/* xd */
	gp->gp_fifo=
		(((SCREENH/CHAR_HEIGHT)-1)*CHAR_HEIGHT);/* yd */
	gp->gp_fifo = CHAR_WIDTH;		/* w */
	gp->gp_fifo = CHAR_HEIGHT*2;		/* h */
	gp->gp_fifo = GP_ALUC;
	UCODE_WAIT(gp);
#else	UCODE
	TODO: -- not done
#endif	UCODE
}

g_putc(c)
register int c;
{
#ifdef	M68010
	extern ushort *shortio;
#endif	M68010
	register int x, dm, i;
	register unsigned short *p, pv;
	char ch;
	register short ccol = col;

	if (g_ing)
		return;
	g_ing = 1;

	if (!g_init) {
	    g_init++;
	    DELAY(GIP_DELAY);		/* wait for mem so probe's will work */
	    i = vbnum;
	    if (i >= 0 && i < GP_NADDR &&    /* first clusters get graphics */
#ifdef	M68010
	        gp_addrs[i].dm > (shortio+0x8000) && 
#endif	M68010
		probe(gp_addrs[i].addr, &xxx) &&
		!probeb((int)gp_addrs[i].addr + 1, &xxx)) {
		    dm = (int)gp_addrs[i].dm + 
			(((SCREENH/CHAR_HEIGHT)-1)*CHAR_HEIGHT*(SCREENW/8));
#ifdef	M68020
		    screen.address = (short *)dm;
#else	M68020
		    x = ((int)mem_map + PGOFSET) & 0x007FF000;
		    *(short *)((x>>11)|PAGREGBASE) = dm >> 12;
		    *(short *)(((x+NBPG)>>11)|PAGREGBASE) = (dm+NBPG)>>12;
		    screen.address = (short *)(x | (dm & 0xFFF));
#endif	M68020
		    screen.width = SCREENW/8;
		    if (probe(screen.address, &xxx)) {
			    gpaddr = gp_addrs[i].addr;
/*printf("GIP at (%x,%x) ",screen.address,gpaddr);/**/
#ifdef	UCODE
			    gp_cmd(gp_initcmds);
#endif	UCODE
			    g_iscroll();
		    }
		}
	}

	if (gpaddr == 0) {
		g_ing = 0;
		return;
	} 
	g_blank(ccol);
	if (c == '\r')
		ccol = 0;
	else if (c == '\n') {
		g_scroll();
		ccol = 0;
	} else if (c == '\t') {
		for (i = 8 - (ccol&7); i > 0 ; i--) {
			g_blank(ccol);
			ccol++;
		}
	} else if (c == ' ') {
		g_blank(ccol);
		ccol++;
	} else if (c == '\b') {
		ccol--;
		if (ccol < 0)
			ccol = 0;
		g_blank(ccol);
	} else if (c >= ' ' && c < '') {
		ch = c;
		g_blank(ccol);
		g_putchar(ccol, &ch);
		ccol++;
	}
	g_block(ccol);
	g_ing = 0;
	col = ccol;
	return;
}

#ifdef	UCODE
gp_cmd(cmdstr)
register ushort *cmdstr;
{
	register struct gpdevice *gp = gpaddr;
	while (*cmdstr != 0xFFFF) {
		gp->gp_fifo = *cmdstr;
		cmdstr++;
	}
	UCODE_WAIT(gp);
}
#endif	UCODE
#endif	GIP
