/* VBUS 68020 Specific, 
 *	test translation buffer and memory PTE updates by sequencer
 */
#include "../machine/pte.h"
#include "../machine/board.h"

#define btop(x)		((int)x >> 12)
#define btoptp(x)	( btop(x) | (((int)x&PTP_LSBMASK) << PTP_LSBSHIFT) )
#define btov(x)		(int *)((int)x | SYSV_BASE )

main()
{
	int *ptp = (int *)PTP_BASE;
	register int *pte;
	register int *tbuf = (int *)TBUF_BASE_SYS;
	register int *vaddr, *paddr;
	register int x, p0, p1, tb, t0, t1, pattern, verbose, pass1;
	char buf[20];

	printf("\n--- Integrated Solutions 68020 MMU PAGE FAULT Diagnostic Tests ---");
	printf("\n                 Version 2.0\n");
	*CTX = 0;				/* set context */
	vaddr = btov(0x0);			/* virtual address */
	pte = (int *)0x1000;
	paddr = (int *)0x2000;
	pattern = 0xCACAFECE;			
	*ptp = btoptp(pte);			/* point ptp to page of ptes */
loop:	printf("\nEnter hex value to 'or' into TBUF entry :");
	stripwhite(gets(buf));
	tb = gethex(buf);
	verbose = 1;
	printf("Verbose? (default yes): ");
	stripwhite(gets(buf));
	if (buf[0] == 'n' || buf[0] == 'N')
		verbose = 0;

	p0 = PG_V|PG_KW|PG_R|PG_M|btop(paddr);
	p1 = p0;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nread with PG_R|PG_M set\n");
	*tbuf = t0; *pte = p0;
	printf("PTP TBUF            PTE\n");
	printf("%x  %b   %b\n", *ptp&PTP_MASK,
		*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (getlocal()) {
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*paddr = pattern; x = *vaddr;
		if (verbose || pass1)
		    printf("%x  %b   %b\r", *ptp&PTP_MASK,
			*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
		if (*tbuf&TBUF_MASK != t1)
			printf("\nTBUF incorrect\n");
		else if (*pte&TBUF_MASK != p1)
			printf("\nPTE incorrect\n");
		else if (x != 0xCACAFECE)
			printf("\ntranslation incorrect\n");
		else if (verbose || pass1)
			printf("\r");
	}

	p0 = PG_V|PG_KW|PG_M|btop(paddr);
	p1 = p0|PG_R;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nread with PG_M, should set PG_R\n");
	*tbuf = t0; *pte = p0;
	printf("PTP TBUF            PTE\n");
	printf("%x  %b   %b\n", *ptp&PTP_MASK,
		*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (getlocal()) {
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*paddr = pattern; x = *vaddr;
		if (verbose || pass1)
		    printf("%x  %b   %b\r", *ptp&PTP_MASK,
			*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
		if (*tbuf&TBUF_MASK != t1)
			printf("\nTBUF incorrect\n");
		else if (*pte&TBUF_MASK != p1)
			printf("\nPTE incorrect\n");
		else if (x != 0xCACAFECE)
			printf("\ntranslation incorrect\n");
		else if (verbose || pass1)
			printf("\r");
	}

	p0 = PG_V|PG_KW|PG_R|btop(paddr);
	p1 = p0|PG_M;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nwrite with PG_R, should set PG_M\n");
	*tbuf = t0; *pte = p0;
	printf("PTP TBUF            PTE\n");
	printf("%x  %b   %b\n", *ptp&PTP_MASK,
		*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (getlocal()) {
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*vaddr = pattern; x = *paddr;
		if (verbose || pass1)
		    printf("%x  %b   %b\r", *ptp&PTP_MASK,
			*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
		if (*tbuf&TBUF_MASK != t1)
			printf("\nTBUF incorrect\n");
		else if (*pte&TBUF_MASK != p1)
			printf("\nPTE incorrect\n");
		else if (x != 0xCACAFECE)
			printf("\ntranslation incorrect\n");
		else if (verbose || pass1)
			printf("\r");
	}

	p0 = PG_V|PG_KW|btop(paddr);
	p1 = p0|PG_R|PG_M;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nwrite, should set PG_R and PG_M\n");
	*tbuf = t0; *pte = p0;
	printf("PTP TBUF            PTE\n");
	printf("%x  %b   %b\n", *ptp&PTP_MASK,
		*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (getlocal()) {
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*vaddr = pattern; x = *paddr;
		if (verbose || pass1)
		    printf("%x  %b   %b\r", *ptp&PTP_MASK,
			*tbuf&TBUF_MASK,TBUF_BITS,*pte&TBUF_MASK,PG_BITS);
		if (*tbuf&TBUF_MASK != t1)
			printf("\nTBUF incorrect\n");
		else if (*pte&TBUF_MASK != p1)
			printf("\nPTE incorrect\n");
		else if (x != 0xCACAFECE)
			printf("\ntranslation incorrect\n");
		else if (verbose || pass1)
			printf("\r");
	}
	goto loop;
}
