/*	ex.c	6.1	84/03/22	*/

/*
 * Excelan EXOS 202(VME) EX)S 203(QBUS)  Link Level Ethernet Interface 
 * Standalone Boot Protocol Driver
 */
#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68kif/if_exreg.h"

#include "saio.h"
#include "sais68k.h"
#include "saboot.h"

struct exdevice *exstd[] = { 
#ifdef	QBUS
		(struct exdevice *)0x3FE800,
		(struct exdevice *)0x3FE810,
		(struct exdevice *)0x3FE820,
#else	QBUS
#ifdef	M68020
		(struct exdevice *)0xFF0000,
		(struct exdevice *)0xFE0000,
#else	M68020
		(struct exdevice *)0x7F0000,
		(struct exdevice *)0x7E0000,
#endif	M68020
#endif	QBUS
		0 };

extern char *arguments;

#define	NH2X 1			/* Host to eXcelan message queues */
#define	NX2H 1			/* eXcelan to Host message queues */

struct ex_msg *exgetcbuf();

struct	ether_addr myaddr;	/* hardware Ethernet address of this machine */
struct	ether_addr hostaddr;	/* hardware Ethernet address of host machine */
struct  ether_addr broaddr = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

#ifdef	QBUS
#define	BUSADDR(x)	((u_long)paddr(x))
#define	P_BUSADDR(x)	((u_long)paddr(x))
#else	QBUS
#define	BUSADDR(x)	(0x3D000000 | ((u_long)paddr(x)))
#define	P_BUSADDR(x)	(0x3D000000 | ((u_long)paddr(x)))
#endif	QBUS

#define	INCORE_BASE	(((u_long)(&xs_h2xhdr)) & 0xFFFFFFF0)
#define	RVAL_OFF(n)	((u_long)(&(n)) - INCORE_BASE)
#define	LVAL_OFF(n)	((u_long)(n) - INCORE_BASE)

struct ex_msg		*xs_h2xnext;		/* host's request queue ptr */
struct ex_msg		*xs_x2hnext;		/* host's reply queue ptr */
u_short			xs_h2xhdr;		/* EXOS request queue header */
u_short			xs_x2hhdr;		/* EXOS reply queue header */
struct ex_msg		xs_h2xent[NH2X];	/* request msg buffers */
struct ex_msg		xs_x2hent[NX2H];	/* reply msg buffers */
struct confmsg		xs_cm;			/* configuration message */

#define	H2XHDR_OFFSET	RVAL_OFF(xs_h2xhdr)
#define	X2HHDR_OFFSET	RVAL_OFF(xs_x2hhdr)
#define	H2XENT_OFFSET	LVAL_OFF(xs_h2xent)
#define	X2HENT_OFFSET	LVAL_OFF(xs_x2hent)
#define	CM_OFFSET	RVAL_OFF(xs_cm)

struct boot_packet	boot_rcv;
struct boot_packet	boot_xmt;
struct boot_packet	*exsend();
int			pkid;
/*static struct st	exst = {1, -1, -1, -1, -1, NULL}; /**/
static struct st	exst = {512, -1, -1, -1, -1, NULL}; /**/
static int		ex_opened;

exopen(io)
	register struct iob *io;
{
	register struct boot_packet *bp;
	register struct exdevice *exaddr;
	register struct ex_msg *mb;
	register int	i;
	register char *p0;

	ex_opened = 0;
	if ((p0 = arguments) == (char *)0)
		goto bad;
	while (*p0 != ':') {
		if (*p0++ == '\0') {
  bad:			printf("bad remote file name\n");
			goto err;
		}
	}
	io->i_flgs |= F_REMOTE;
	io->i_st = exst;
	exaddr = exstd[0];
	if (!probeb(((char *)exaddr)+1,&pkid)) {
		printf("ex: not present\n");
		goto err;
	}
	pkid = 0;

	/*
	 * Reset EXOS and run self-test (should complete within 2 seconds).
	 */
	exaddr->ex_porta = EX_RESET;
	i = 1000000;
	while (((exaddr->ex_portb & EX_TESTOK) == 0) && --i) ;
	if ((exaddr->ex_portb & EX_TESTOK) == 0) {
		printf("ex: selftest failed\n");
		goto err;
	}
	exconfig();

	/*
	 * Get Ethernet address.
	 */
	mb = exgetcbuf();
	mb->mb_rqst = LLNET_ADDRS;
	mb->mb_na.na_mask = READ_OBJ;
	mb->mb_na.na_slot = PHYSSLOT;
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	mb = xs_x2hnext;
	if (exwait(mb))
		goto err;
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;
#ifdef DEBUG
	printf("	(%d.%d.%d.%d.%d.%d)",
		mb->mb_na.na_addrs[0], mb->mb_na.na_addrs[1],
		mb->mb_na.na_addrs[2], mb->mb_na.na_addrs[3],
		mb->mb_na.na_addrs[4], mb->mb_na.na_addrs[5]);
#endif DEBUG
	bcopy((caddr_t)&mb->mb_na.na_addrs[0],(caddr_t)&myaddr,sizeof(myaddr));

	/*
	 * Put EXOS on the Ethernet, using NET_MODE command
	 */
	mb = exgetcbuf();
	mb->mb_rqst = LLNET_MODE;
	mb->mb_nm.nm_mask = WRITE_OBJ;
	mb->mb_nm.nm_optn = 0;
	mb->mb_nm.nm_mode = MODE_PERF;
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;

	mb = xs_x2hnext;
	if (exwait(mb))
		goto err;
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;

	/*
	 * broadcast a host connect packet
	 */
	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = broaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CONNECT;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	while((*arguments != ':') &&  (*p0++ = *arguments++)) ;
	if (*arguments == ':')
		arguments += 1;

	if ((bp = exsend()) == 0)
		goto err;
	hostaddr = bp->bp_eh.ether_shost;

	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_OPEN;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	while((*arguments != '(') &&  (*p0++ = *arguments++));
	if (*arguments != '(')
		arguments = NULL;

	if ((bp = exsend()) == 0)
		goto err;
   	ex_opened = 1;
	return(0);
   err:	return(-1);
}

exclose()
{
	register struct boot_packet *bp;

	if (ex_opened == 0)
		return (-1);
	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CLOSE;
	bp->bp_pkid = pkid;
	if ((bp = exsend()) == 0)
		return (-1);
	return(0);
}

exstrategy(io, func)
	register struct iob *io;
{
	register int count = io->i_cc;
	register int offset = io->i_offset;
	/* CAUTION this is now a physical addr, things better be 1:1 */
	register struct boot_packet *bp;
	register int len;

	while (count > 0) {
		len = count < BOOT_DATACNT ? count : BOOT_DATACNT;
		bp = &boot_xmt;
		bzero(bp, sizeof(struct boot_packet));
		bp->bp_eh.ether_shost = myaddr;
		bp->bp_eh.ether_dhost = hostaddr;
		bp->bp_eh.ether_type = ETHERPUP_BOOT;
		bp->bp_pkid = pkid;
		bp->bp_offset = offset;
		bp->bp_len = len;
		if (func == READ)
			bp->bp_cmd = BOOT_READ;
		else {
			bp->bp_cmd = BOOT_WRITE;
			bcopy(bp->bp_data, io->i_ma, len);
		}
		if ((bp = exsend()) == 0)
			return(-1);
		if (func == READ)
			bcopy(bp->bp_data, io->i_ma, bp->bp_len);
		offset += bp->bp_len;
		io->i_ma += bp->bp_len;
		count -= bp->bp_len;
		if (bp->bp_len != len)
			break;
	}
	return(io->i_cc - count);
}

/*
 * Get a request buffer, fill in standard values, advance pointer.
 */
struct ex_msg *
exgetcbuf()
{
	register struct ex_msg *mb = xs_h2xnext;

	mb->mb_1rsrv = 0;
	mb->mb_length = MBDATALEN;
	xs_h2xnext = mb->mb_next;
	return mb;
}

/*
 * Process an ioctl request.
 */
exioctl(ifp, cmd, data)
{
}

/*
 * output the packet in the tansmit buffer.  Wait for a non-broadcast packet 
 * with the same 'pkid' to come back in the recieve buffer as an acknoldge.  
 * If nothing comes back then wait and do retransmitions.  Return a pointer
 * to the recieved packet, return null if a timeout occured.  The ethernet
 * source field of a recieved CONNECT packet will have the address of the
 * host that responded to the broadcasted CONNECT packet.  The data portion
 * of a recieved READ packed will have the data read.  The data portion of
 * a transmited (and recieved) WRITE packet will have the data to be writen.
 * The host acknoldges packets by performing the specified action, swaping the
 * source and destination addresses in the packet, and sending the packet back 
 * out onto the network.  The host should never change the 'pkid' field of a 
 * boot packet.
 */
struct boot_packet *exsend()
{
	register struct ex_msg *mb;
	register struct exdevice *exaddr = exstd[0];
	register struct boot_packet *bp;

	mb = exgetcbuf();
	bp = &boot_xmt;
	mb->mb_rqst = LLRTRANSMIT;
	mb->mb_et.et_nblock = 1;
	mb->mb_et.et_blks[0].bb_len = sizeof(struct boot_packet);
	*(u_long *)mb->mb_et.et_blks[0].bb_addr = BUSADDR(bp);
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
#ifdef DEBUG
printf("X ");
printf("to (%d.%d.%d.%d.%d.%d) ",
bp->bp_eh.ether_dhost.ether_addr_octet[0], 
bp->bp_eh.ether_dhost.ether_addr_octet[1],
bp->bp_eh.ether_dhost.ether_addr_octet[2], 
bp->bp_eh.ether_dhost.ether_addr_octet[3],
bp->bp_eh.ether_dhost.ether_addr_octet[4], 
bp->bp_eh.ether_dhost.ether_addr_octet[5]);
#endif
	mb = xs_x2hnext;
	if (exwait(mb))
		return(0);
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;
	bp = &boot_rcv;

	do {
		mb = exgetcbuf();
		mb->mb_rqst = LLRECEIVE;
		mb->mb_er.er_nblock = 1;
		mb->mb_er.er_blks[0].bb_len = sizeof(struct boot_packet);
		*(u_long *)mb->mb_er.er_blks[0].bb_addr = BUSADDR(bp);
		mb->mb_status |= MH_EXOS;
		exaddr->ex_portb = EX_NTRUPT;
		mb = xs_x2hnext;
		if (exwait(mb))
			return(0);
		mb->mb_length = MBDATALEN;
		mb->mb_status |= MH_EXOS;		/* free up buffer */
		exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
		xs_x2hnext = xs_x2hnext->mb_next;
#ifdef DEBUG
printf("from (%d.%d.%d.%d.%d.%d) type %x pkid %x,%x %x ",
bp->bp_eh.ether_shost.ether_addr_octet[0], 
bp->bp_eh.ether_shost.ether_addr_octet[1],
bp->bp_eh.ether_shost.ether_addr_octet[2], 
bp->bp_eh.ether_shost.ether_addr_octet[3],
bp->bp_eh.ether_shost.ether_addr_octet[4], 
bp->bp_eh.ether_shost.ether_addr_octet[5], 
bp->bp_eh.ether_type, bp->bp_pkid, pkid, bp->bp_eh.ether_dhost.ether_addr_octet[0]);
#endif
	} while (bp->bp_eh.ether_dhost.ether_addr_octet[0] == 0xFF || 
		 bp->bp_eh.ether_type != ETHERPUP_BOOT ||
		 bp->bp_pkid != pkid );
	pkid++;
	return (bp);
}

/*
 * Reset, test, and configure EXOS. Returns 0 if successful, 1 if failure.
 */
exconfig()
{
	register struct exdevice *exaddr = exstd[0];
	register struct confmsg *cm = &xs_cm;
	register struct ex_msg 	*mb;
	register int 	i;
	register u_long	shiftreg;
	static	u_char	cmaddr[8] = {0xFF, 0xFF, 0, 0};

	/*
	 * Reset EXOS, wait for self-test to complete
	 */
	exaddr->ex_porta = EX_RESET;
	while ((exaddr->ex_portb & EX_TESTOK) == 0) ;

	/*
	 * Set up configuration message.
	 */
	cm->cm_1rsrv = 1;
	cm->cm_cc = 0xFF;
	cm->cm_opmode = 0;		/* link-level controller mode */
	cm->cm_dfo = 0x0101;		/* enable host data order conversion */
	cm->cm_dcn1 = 1;
	cm->cm_2rsrv[0] = cm->cm_2rsrv[1] = 0;
	cm->cm_ham = 3;			/* absolute address mode */
	cm->cm_3rsrv = 0;
	cm->cm_mapsiz = 0;
	cm->cm_byteptrn[0] = 0x01;	/* EXOS deduces data order of host */
	cm->cm_byteptrn[1] = 0x03;	/*  by looking at this pattern */
	cm->cm_byteptrn[2] = 0x07;
	cm->cm_byteptrn[3] = 0x0F;
	cm->cm_wordptrn[0] = 0x0103;
	cm->cm_wordptrn[1] = 0x070F;
	cm->cm_lwordptrn = 0x0103070F;
	for (i=0; i<20; i++) cm->cm_rsrvd[i] = 0;
	cm->cm_mba = 0xFFFFFFFF;
	cm->cm_nproc = 0xFF;
	cm->cm_nmbox = 0xFF;
	cm->cm_nmcast = 0xFF;
	cm->cm_nhost = 1;
	cm->cm_h2xba = P_BUSADDR(INCORE_BASE);
	cm->cm_h2xhdr = H2XHDR_OFFSET;
	cm->cm_h2xtyp = 0;		/* should never wait for rqst buffer */
	cm->cm_x2hba = cm->cm_h2xba;
	cm->cm_x2hhdr = X2HHDR_OFFSET;
	cm->cm_x2htyp = 0;		/* 0 for no interupts */

	/*
	 * Set up message queues and headers: first the request queue
	 */
	for (mb = &xs_h2xent[0]; mb < &xs_h2xent[NH2X]; mb++) {
		mb->mb_link = (u_short)((char *)(mb+1)-INCORE_BASE);
		mb->mb_rsrv = 0;
		mb->mb_length = MBDATALEN;
		mb->mb_status = MH_HOST;
		mb->mb_next = mb+1;
	}
	xs_h2xhdr = xs_h2xent[NH2X-1].mb_link = (u_short)H2XENT_OFFSET;
	xs_h2xnext = xs_h2xent[NH2X-1].mb_next = xs_h2xent;

	/* now the reply queue */
	for (mb = &xs_x2hent[0]; mb < &xs_x2hent[NX2H]; mb++) {
		mb->mb_link = (u_short)((char *)(mb+1)-INCORE_BASE);
		mb->mb_rsrv = 0;
		mb->mb_length = MBDATALEN;
		mb->mb_status = MH_EXOS;
		mb->mb_next = mb+1;
	}
	xs_x2hhdr = xs_x2hent[NX2H-1].mb_link = (u_short)X2HENT_OFFSET;
	xs_x2hnext = xs_x2hent[NX2H-1].mb_next = xs_x2hent;

	/*
	 * Write config msg address to EXOS and wait for configuration to 
	 * complete (guaranteed response within 2 seconds).
	 */
	shiftreg = P_BUSADDR(INCORE_BASE) + CM_OFFSET;
	for (i = 4; i < 8; i++) {
		cmaddr[i] = (u_char)(shiftreg & 0xFF);
		shiftreg >>= 8;
	}
	for (i = 0; i < 8; i++) {
		while (exaddr->ex_portb & EX_UNREADY) ;
		DELAY(500);
		exaddr->ex_portb = cmaddr[i];
	}
	for (i = 100000; (cm->cm_cc == 0xFF) && i; --i) DELAY(10);
	if (cm->cm_cc)
		printf("ex: config failed; cc=%x\n", cm->cm_cc);
}

exwait(mb)
	register struct ex_msg *mb;
{
	register int i;

#ifdef	M68020
	i = 20000;
#else	M68020
	i = 5000;
#endif	M68020
	while (--i) {
		if ((mb->mb_status & MH_OWNER) != MH_EXOS) 
			return (0);
		if (getlocal()) {
			printf("ex: aborted\n");
			goto err;
		}
		DELAY(400);
	}
	printf("ex: timeout\n");
   err:	ex_opened = 0;
	return (-1);
}
