/*
 * Standalone driver for the IS extended RL101 disk controller.
 */
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68kdev/elreg.h"

#include "saio.h"
#include "sais68k.h"

#define	ELADDR0	  	((struct eldevice *) 0x3FF900) /* 1st addr */
#define	ELADDR1  	((struct eldevice *) 0x3FF910) /* 2nd addr */
#define	EL_CN		2			/* number of controllers */
#define	EL_DR		4			/* drives per controller */
#define	EL_MAXCNT	0x1F000

static struct eldevice *elstd[EL_CN] = { ELADDR0, ELADDR1 };
static int 		el_off[] = { 0, 0, 0, 0, 0, 0, 0, 0};
static struct st	elst = { 512, 0, 0, 0, 0, el_off };

int elstrat(), forbb;

elopen(io)
register struct iob *io;
{
	register int			cn = UTOCN(io->i_unit); 
	register int 			dr = UTODR(io->i_unit);
	register struct eldevice 	*eladdr;

	if (dr >= EL_DR || cn >= EL_CN) {
		printf("el: bad unit\n");
		return (-1);
	}
	eladdr = elstd[cn];
	if (!probe(&eladdr->elbae,&eladdr->elbae)) {
		printf("el: controller not present\n");
		return (-1);
	}
	eladdr->elba.getstat = 0;
	eladdr->elcs = (dr << 8) | EL_GETSTAT; /* get status */
	if (elwait(eladdr))
		return (-1);
	/* dont mistake a rl for an el; if # heads not given then rl */
	if (eladdr->elba.getstat == 0) {
		printf("el: controller not present\n");
		return (-1);
	}
	io->i_st.nbsec = 512;
	io->i_st.nsect = eladdr->elmp.getstat;
	io->i_st.ntpc = eladdr->elba.getstat;
	io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
	io->i_st.ncyl = eladdr->elda.getstat / io->i_st.ntpc;
	io->i_st.off = NULL;
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("el: bad offset\n");
		return (-1);
	}
	return (0);
}

elstrategy(io, func)
register struct iob *io;
{
	register int			bleft, 
					bpart;
	register int 			bn = io->i_bn;


	switch (func) {
	  case READ:
		func = EL_READ; 
		break;
	  case WRITE:
		func = EL_WRITE; 
		break;
	  default:
		printf("el: bad func 0x%x\n", func);
		return -1;
	}
	bleft = io->i_cc;	/* byte cnt */
	do {
		bpart = (bleft < EL_MAXCNT) ? bleft : EL_MAXCNT;
		if (forbb) {
			if (elstrat(io,bn,bpart,func) == -1)
				return -1;
			io->i_ma += bpart;
		} else if (badstrat(io,bn,bpart,func,elstrat,EL_READ) == -1)
			return -1;
		bleft -= bpart;
		bn += bpart / io->i_st.nbsec;
	} while (bleft > 0);
	return io->i_cc;
}

elstrat(io,bn,bpart,func)
register struct iob *io;
register int bn; 
int bpart, func;
{
	register int 			cn = UTOCN(io->i_unit);
	register int 			dr = UTODR(io->i_unit);
	register struct eldevice 	*eladdr = elstd[cn];
	static int 			errcnt = 0;

	while (1) {
		eladdr->elda.rw = bn / io->i_st.nsect;
		eladdr->elba.rw = loword(io->i_ma);
		eladdr->elbae = (short)(hiword(io->i_ma)&0x3f) |
				((bn % io->i_st.nsect) << 6);
		eladdr->elmp.rw = -((bpart + sizeof(short) - 1) >> 1);
		eladdr->elcs = dr<<8 | func;
		if (elwait(eladdr))
			return (-1);
		if (eladdr->elcs & EL_ERR) {
			printf("el: error cs=%b\n",eladdr->elcs,ELCS_BITS);
			if (++errcnt < 5)
				continue;
			errcnt = 0;
			return -1;
		}
		return 0;
	}
}

static 
elwait(eladdr)
struct eldevice *eladdr;
{ 	
	long l = 0;

	while ((eladdr->elcs & EL_CRDY) == 0) 
#ifdef	M68020
		if (++l == 3200000) {
#else	M68020
		if (++l == 800000) {
#endif	M68020
			printf("el: timeout\n");
			return (-1);
		}
	return (0);
}
