int		bufsiz	= 0x8000;
int		rep	= 1024;
unsigned char	*bstart = (char *)0x40000;

main()
{
	register int start, end;
        register int i;
	int fi, nlap;
        char buf[50];

	printf("\n--- Integrated Solutions %i Disk Preformance Test ---");
	printf("\n                 Version 2.0\n\n");

loop:	printf("Hit RETURN to continue, any other key to return to PROM\n");
	if (getchar() != '\r')
		_rtt();
        do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	printf("Perform %d sequential reads of %d bytes = %mMeg per lap\n",
		rep,bufsiz,rep*bufsiz);
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);
	if (nlap == 0)
		nlap = 1;
	printf("\n");
	for (i = 0 ; i < nlap ; i++) {
		printf(" %d  \r",i);
		if (dtest(fi))
			break;
	}
	printf("\n%mMeg\n",rep*bufsize*nlap);
	close(fi);
	goto loop;
}

dtest(fi)
register int fi;
{
	register int j;

	for (j = 0; j < rep; j++)
	{
		lseek(fi, bufsiz*j, 0);
		if (qread(fi, bstart, bufsiz) != bufsiz) {
			printf("Bad read\n");
			continue;
		}
	}
	return 0;
}

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/dir.h"
#include "saio.h"

qread(fdesc, buf, count)
	register int fdesc, count;
	register char *buf;
{
	register int size;
	register struct iob *io;

	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return (-1);
	if ((io->i_flgs&F_READ) == 0)
		return (-1);

	io->i_cc = count;
	io->i_ma = paddr(buf);
	io->i_bn = io->i_boff + (io->i_offset/io->i_st.nbsec);
	if ((size = devread(io)) < 0)
		return (-1);
	io->i_offset += size;
	io->i_cc -= size;
	return (size);
}
