/*#define	DEBUG */
#define BSIZE	512
#define DBLOCK	1000
#define PCLEAR	0x0

unsigned char	*pbuf1, *pbuf2;
int		maxbufsiz, maxdblock, mindblock;
unsigned char	*bstart, *bend;
int		v;
int		rep, ran, retry;
int		werr, rerr, verr;

main()
{
	register int start, end;
        register int inc, i;
	int fi, nlap;
        char buf[50];

	printf("\n--- Integrated Solutions %i Standalone DMAX Test ---");
	printf("\n                 Version 2.0\n\n");

loop:	rerr = 0; werr = 0; verr = 0;
	printf("Hit RETURN to continue, any other key to return to PROM\n");
	if (getchar() != '\r')
		_rtt();
        do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	do  {
		printf("Max block length (default is %d bytes): ", BSIZE);
		gets(buf);
		if (buf[0]) {
			maxbufsiz = getnum(buf);
			if (maxbufsiz < 0)
				printf("Illegal number\n");
			if (maxbufsiz & 1) {
				printf("Block size must be even\n");
				maxbufsiz = -1;
			}
		} else
			maxbufsiz = BSIZE;
	} while (maxbufsiz < 0);
	do  {
		printf("Min disk block number (default is block %d): ", 0);
		gets(buf);
		if (buf[0]) {
			mindblock = getnum(buf);
			if (mindblock < 0)
				printf("Illegal number\n");
			if (mindblock & 1) {
				printf("Block size must be even\n");
				mindblock = -1;
			}
		} else
			mindblock = 0;
	} while (mindblock < 0);
	do  {
		printf("Max disk block number (default is block %d): ", DBLOCK);
		gets(buf);
		if (buf[0]) {
			maxdblock = getnum(buf);
			if (maxdblock < 0)
				printf("Illegal number\n");
			else if (maxdblock & 1)
				printf("Block size must be even\n");
			else if (maxdblock < mindblock)
				printf("Max < Min\n");
			else
				continue;
			maxdblock = -1;
		} else
			maxdblock = DBLOCK;
	} while (maxdblock < 0);
	maxdblock -= mindblock;
	do  {
		printf("Number of blocks per lap (default 1000) : ");
		gets(buf);
		rep =  getnum(buf);
		if (rep == 0)
			rep = 1000;
		else if (rep < 0)
			printf("Illegal number\n");
	} while (rep < 0);
	do  {
		printf("Read/Verify retry count (default 0) : ");
		gets(buf);
		if (buf[0]) {
			retry = getnum(buf);
			if (retry < 0) 
				printf("Illegal number\n");
		} else
			retry = 0;
	} while (retry < 0);
	printf("Random patterns (default no) : ");
	stripwhite(gets(buf));
	ran =  (buf[0]=='y' || buf[0]=='Y') ? 1 : 0;
	printf("Test with parity? (default no): ");
	stripwhite(gets(buf));
	if (buf[0] == 'y' || buf[0] == 'Y')
		_parityon();
	else
		_parityoff();
	printf("Verbose ? (default yes): ");
	stripwhite(gets(buf));
	v =  (buf[0]=='n' || buf[0]=='N') ? 0 : 1;
barea:	printf("Start of buffer area (NO DEFAULT): ");
	gets(buf);
	bstart =  (unsigned char *)(getnum(buf) & ~1);
	printf("End of buffer area (NO DEFAULT)  : ");
	gets(buf);
	bend =  (unsigned char *)(getnum(buf) & ~1);
	if (bend-bstart <= 2*maxbufsiz) {
		printf("  buffer area too small\n");
		goto barea;
	}
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);
	printf("\n");
	for (i = 0 ; ((nlap == 0) ? 1 : (i < nlap)) ; i++) {
		printf("  Lap %d                     \n",i);
		if (dtest(fi))
			break;
	}
	printf("\nDone DMA Test: %d Read-errors, %d Write-errors, %d Verify-errors\n", 
		rerr, werr, verr);
	close(fi);
	goto loop;
}

dtest(fi)
{
	register int i, count;
	register int j, k;
	unsigned rand();
	int dblock,bufsiz;

	for (j = 0; j < rep; j++)
	{
		dblock = mindblock + (int)(((double)rand()/0x7ffffffe)*(maxdblock));
buffcom:	bufsiz = (int)(((double)rand()/0x7ffffffe)*(maxbufsiz));
		if (bufsiz & 1 || bufsiz==0)
			goto buffcom;
		pbuf1 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		pbuf2 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		if (pbuf1 + bufsiz > bend)
			pbuf1 -= bufsiz;
		if (pbuf2 + bufsiz > bend)
			pbuf2 -= bufsiz;
		if (abs(pbuf1 - pbuf2) <= bufsiz)
			if (pbuf2 > pbuf1) {
				pbuf2 += bufsiz;
				if (pbuf2< bstart || pbuf2 + bufsiz > bend)
					pbuf2 = bstart;
			} else {
				pbuf1 += bufsiz;
				if (pbuf1 < bstart || pbuf1 + bufsiz > bend)
					pbuf1 = bstart;
			}
		pbuf1 = (unsigned char *)((int)pbuf1 & ~1);
		pbuf2 = (unsigned char *)((int)pbuf2 & ~1);
		if (pbuf1 < bstart || pbuf2 < bstart || pbuf1+bufsiz > bend ||
			pbuf2+bufsiz > bend || abs(pbuf1-pbuf2) < bufsiz)
			goto buffcom;
		if (v) printf("\r    Load    ");
		k = rand();
		for (i = 0; i < bufsiz; i++)	/* load pattern */
			if (ran)
				pbuf1[i] = rand();
			else
				pbuf1[i] = k;
#ifdef	DEBUG
		printf("block %x: pbuf1=%x pbuf2=%x len=%x val=%x\n", 
			dblock, (int)pbuf1, (int)pbuf2, bufsiz, pbuf1[0]);
#endif	DEBUG
		if (getlocal() == 'x')
			return -1;
		lseek(fi, dblock*512, 0);
		if (v) printf("\r    Write   ");
		if (write(fi, pbuf1, bufsiz) != bufsiz) {
			werr++;
			printf("Bad write: block %x: pbuf1=%x pbuf2=%x len=%x\n", 
				dblock, (int)pbuf1, (int)pbuf2, bufsiz);
		}
doretry:	for (i = 0; i < bufsiz; i++)	/* clear pattern */
			pbuf2[i] = PCLEAR;
		if (getlocal() == 'x')
			return -1;
		lseek(fi, dblock*512, 0);
		if (v) printf("\r    Read    ");
		if (read(fi, pbuf2, bufsiz) != bufsiz) {
			rerr++;
			printf("Bad read: block %x: pbuf1=%x pbuf2=%x len=%x\n",
				 dblock, (int)pbuf1, (int)pbuf2, bufsiz);
			continue;
		}
		/* check pattern */
		if (v) printf("\r    Verify  ");
		for (i = 0; i < bufsiz; i++) {
			register unsigned char pc1,pc2;
			register int nclear;

			pc1 = pbuf1[i];
			pc2 = pbuf2[i];
			if (pc1 != pc2) {
				verr++;
				nclear = 0;
				printf("Bad compare: block %x: pbuf1=%x pbuf2=%x len=%x\n", 
					dblock, (int)pbuf1, (int)pbuf2, bufsiz);
				printf("             index %x: expected %x got %x ",
					i, pc1, pc2);
				if (pc2 == PCLEAR)
					nclear++;
				for (k = i + 1; k < bufsiz; k++) {
					pc1 = pbuf1[i];
					pc2 = pbuf2[i];
					if (pc1 != pc2) {
						if (pc2 == PCLEAR)
							nclear++;
						verr++;
					} else 
						break;
				}
				printf("             run of %x bytes",k-i+2);
				if (k == bufsiz)
					printf(" (end of buffer)");
				printf(", %x bytes of clear pattern ",nclear);
				i = k;
				if (retry > 0) {
					printf(", retry read/verify\n");
					retry--;
					goto doretry;
				}
				printf("\n");
			}
		}
	if (v) printf("\r                                \r"); /**/
	}
	return 0;
}
