#define BSIZE	512
#define PCLEAR	0x0

unsigned char	buf1[2*BSIZE];
unsigned char	*pbuf1, *pbuf2;
int		bufsiz;
unsigned char	*bstart, *bend;
int 		rep;
int		werr, rerr, verr;

main()
{
	register int start, end;
        register int inc, i;
	int fi, nlap;
        char buf[50];

	printf("\n--- Integrated Solutions %i Standalone DMA Test ---");
	printf("\n                 Version 2.0\n\n");

loop:	rerr = 0; werr = 0; verr = 0;
	printf("Hit RETURN to continue, any other key to return to PROM\n");
	if (getchar() != '\r')
		_rtt();
        do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	do  {
		printf("Block size (default is %d bytes): ", BSIZE);
		gets(buf);
		if (buf[0]) {
			bufsiz = getnum(buf);
			if (bufsiz < 0)
				printf("Illegal number\n");
			if (bufsiz & 1) {
				printf("Block size must be even\n");
				bufsiz = -1;
			}
		} else
			bufsiz = BSIZE;
	} while (bufsiz < 0);
	do  {
		printf("Number of blocks (default 1000) : ");
		gets(buf);
		rep =  getnum(buf);
		if (rep == 0)
			rep = 1000;
		else if (rep < 0)
			printf("Illegal number\n");
	} while (rep < 0);
barea:	printf("Start of buffer area (NO DEFAULT): ");
	gets(buf);
	bstart =  (unsigned char *)(getnum(buf) & ~1);
	printf("End of buffer area (NO DEFAULT)  : ");
	gets(buf);
	bend =  (unsigned char *)(getnum(buf) & ~1);
	if (bend-bstart <= 2*bufsiz) {
		printf("  buffer area too small\n");
		goto barea;
	}
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);
	printf("\n");
	for (i = 0 ; ((nlap == 0) ? 1 : (i < nlap)) ; i++) {
		printf("  Lap %d                     \n",i);
		if (dtest(fi))
			break;
	}
	printf("\nDone DMA Test: %d Read-errors, %d Write-errors, %d Verify-errors\n", 
		rerr, werr, verr);
	close(fi);
	goto loop;
}

dtest(fi)
{
	register int i, count;
	register int j, k;
	unsigned rand();

	for (j = 0; j < rep; j++) {
buffcom:	pbuf1 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		pbuf2 = bstart + 
			(int)(((double)rand()/0x7ffffffe)*(bend-bstart));
		if (pbuf1 + bufsiz > bend)
			pbuf1 -= bufsiz;
		if (pbuf2 + bufsiz > bend)
			pbuf2 -= bufsiz;
		if (abs(pbuf1 - pbuf2) <= bufsiz)
			if (pbuf2 > pbuf1) {
				pbuf2 += bufsiz;
				if (pbuf2< bstart || pbuf2 + bufsiz > bend)
					pbuf2 = bstart;
			} else {
				pbuf1 += bufsiz;
				if (pbuf1 < bstart || pbuf1 + bufsiz > bend)
					pbuf1 = bstart;
			}
		pbuf1 = (unsigned char *)((int)pbuf1 & ~1);
		pbuf2 = (unsigned char *)((int)pbuf2 & ~1);
		if (pbuf1 < bstart || pbuf2 < bstart || pbuf1+bufsiz > bend ||
			pbuf2+bufsiz > bend || abs(pbuf1-pbuf2) < bufsiz)
			goto buffcom;
		printf("\r    Load    "); /**/
		for (i = 0; i < bufsiz; i++)	/* load pattern */
			pbuf1[i] = rand();
		if (getlocal() == 'x')
			return -1;
		lseek(fi, 0, 0);
		printf("\r    Write   "); /**/
		if (write(fi, pbuf1, bufsiz) != bufsiz) {
			werr++;
			printf("Bad write: block %d: pbuf1=%x pbuf2=%x\n", 
				0, (int)pbuf1, (int)pbuf2);
		}
		for (i = 0; i < bufsiz; i++)	/* clear pattern */
			pbuf2[i] = PCLEAR;
		if (getlocal() == 'x')
			return -1;
		lseek(fi, 0, 0);
		printf("\r    Read    "); /**/
		if (read(fi, pbuf2, bufsiz) != bufsiz) {
			rerr++;
			printf("Bad read: block %d: pbuf1=%x pbuf2=%x\n", 
				0, (int)pbuf1, (int)pbuf2);
			continue;
		}
		/* check pattern */
		printf("\r    Verify  "); /**/
		for (i = 0; i < bufsiz; i++) {
			register unsigned char pc1,pc2;
			register int nclear;

			pc1 = pbuf1[i];
			pc2 = pbuf2[i];
			if (pc1 != pc2) {
				verr++;
				nclear = 0;
				printf("Bad compare: block %d: pbuf1=%x pbuf2=%x\n", 
					0, (int)pbuf1, (int)pbuf2);
				printf("             index %d: expected %x got %x\n",
					i, pc1, pc2);
				if (pc2 == PCLEAR)
					nclear++;
				for (k = i + 1; k < bufsiz; k++) {
					pc1 = pbuf1[i];
					pc2 = pbuf2[i];
					if (pc1 != pc2) {
						if (pc2 == PCLEAR)
							nclear++;
						verr++;
					} else 
						break;
				}
				printf("             run of %d bytes",k-i+2);
				if (k == bufsiz)
					printf(" (end of buffer)");
				printf(", %d bytes of clear pattern\n",nclear);
				i = k;
			}
		}
	}
	printf("\r                                \r"); /**/
	return 0;
}
