/*
 *	FORMAT VME BUS DISKS:
 *		sd:	w/ Adaptec ACB-4000 or ACB-4070
 *		sm:
 *
 */
#include "../h/types.h"

#include "../is68kdev/sdreg.h"

#ifdef	M68020
#define	SDADDR0	  	((struct sddevice *) 0xFFFFE0) /* 1st addr */
#define	SDADDR1	  	((struct sddevice *) 0xFFFFFF) /* 2nd addr */
#else	M68020
#define	SDADDR0	  	((struct sddevice *) 0x7FFFE0) /* 1st addr */
#define	SDADDR1	  	((struct sddevice *) 0x7FFFFF) /* 2nd addr */
#endif	M68020

#define	SD_CN		2			/* number of controllers */
#define	SD_DR		4			/* drives per controller */
#define	SDDELAY(n)	{ register int N = (n); while (--N > 0); }

static struct sddevice *sdstd[SD_CN] = { SDADDR0, SDADDR1 };

struct	sdfmt_param	{
	u_char	rsvd1[3];
	u_char	extent_desc_len;
	u_char	density_code;
	u_char	rsvd2[5];
	u_short	block_size;
	u_char	list_format_code;
	u_char	cylinder_count[2];
	u_char	head_count;
	u_short	reduce_write_cyl;
	u_short	write_precomp_cyl;
	u_char	landing_zone;
	u_char	step_pulse_rate;
	u_short	rsvd3;
	u_short	n_blocks;
	u_short	rsvd4;
	u_short	len_defects;
};

struct	sdfmt_defects {
	u_char	cylinder[3];
	u_char	head;
	u_int	byteoffset;
};

char buf[100];

main()
{
	char test;

	printf("\n--- Integrated Solutions %i Standalone Disk Formatter ---");
	printf("\n                 Version 2.0\n\n");

	for (;;) {
	    printf("select drive type to be formatted:");
	    printf("\n  a) sd\n  b) sm\n");
	    printf("Enter letter of desired drive type: ");

	    stripwhite(gets(buf));
	    test = buf[0];
	    if (test == 'a' || test == 'A') {
		fmtsd();
	    }
	    else if (test == 'b' || test == 'B') {
		fmtsm();
	    }
	    else
		printf("invalid entry\n");
	}
}

fmtsd()
{
	register struct sddevice *sdaddr;
	register struct sdfmt_param *p;
	register struct sdfmt_defects *d;
	register int i, n;
	int nheads, ncyl, fc;
	char test;
	u_short drive;

	printf("\nformatting SD disk\n");
 	for (test = 'H';;) {
	    if (test == 'H') {
		printf("Functions available:\n");
		printf("  a) Format Disk\n  b) Display Parameter/Defect list\n");
	    }
	    printf("Enter letter of desired function ('H' for help): ");
	    stripwhite(gets(buf));
	    test = buf[0];
	    if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		continue;
    cntlr:  printf("Controller number (0-%d) ? ",SD_CN-1);
	    stripwhite(gets(buf));
	    i = getnum(buf);
	    if (i < 0 || i >= SD_CN) {
		printf("illegal controller number\n");
		goto cntlr;
	    }
	    sdaddr = sdstd[i];
	    if (!probe(&sdaddr->sdba,&sdaddr->sdba)) {
		printf("controller %d at 0x%x not present\n", i, sdaddr);
		goto cntlr;
	    }
    drv:    printf("Drive number (0-%d) ? ",SD_DR-1);
	    stripwhite(gets(buf));
	    drive = getnum(buf);
	    if (drive < 0 || drive >= SD_DR) {
		printf("illegal drive number\n");
		goto drv;
	    }
	    drive = ((drive<<8) & 0x0300) | SD_CBSY | SD_FORMAT;

	    if (test == 'a' || test == 'A') {
	head:	printf("Number of heads ? ");
	    	stripwhite(gets(buf));
		nheads = getnum(buf);
		if (nheads > 16 || nheads < 1)
			goto head;
	cyl:	printf("Number of cylinders ? ");
	    	stripwhite(gets(buf));
		ncyl = getnum(buf);
		if (ncyl > 2048 || ncyl < 20)
			goto cyl;
		fc = (nheads-1)<<11 | (ncyl-1);
		printf(" Estimated time until completion is ");
		printf("%d hours and %d min\n",
			((nheads*ncyl)/100)/60,((nheads*ncyl)/100)%60);
		printf("format constant = %x, ok ? ",fc);
		stripwhite(gets(buf));
		if (buf[0] != 'y' && buf[0] != 'Y')
			continue;
		sdaddr->sdda = fc;
		sdaddr->sdcs = drive;
		while (sdaddr->sdcs == 0xFFFF) {
			SDDELAY(2000);
			printf(".");
			SDDELAY(2000);
			printf(".");
			SDDELAY(2000);
			printf(".");
			SDDELAY(2000);
			printf(".");
			SDDELAY(2000);
			printf("\r     \r");
		}
		if (sdaddr->sdcs & SD_ERR) {
			printf("DRIVE DID NOT FORMAT\n");
			printf("sd: cs=%b sw=%x %x %x\n",
				sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
		} else
			printf("SUCCESSFUL FORMAT\n");
	    } else if (test == 'b' || test == 'B') {
		sdaddr->sdda = 0x8000;		/* read parameter/defect list */
		sdaddr->sdcs = drive;
		p = (struct sdfmt_param *)0x1000;
		d = (struct sdfmt_defects *)0x101E;
		if (sdwait(sdaddr) || sdaddr->sdcs & SD_ERR) {
			printf("sd: cs=%b sw=%x %x %x\n",
				sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
			printf("cannot read bad track map\n");
			continue;
		}
		printf("%x: %d 	extent_desc_len\n", 
				&p->extent_desc_len, p->extent_desc_len);
		printf("%x: %d 	density_code\n", 
				&p->density_code, p->density_code);
		printf("%x: %d 	block_size\n", 
				&p->block_size, p->block_size);
		printf("%x: %d 	list_format_code\n", 
				&p->list_format_code, p->list_format_code);
		printf("%x: %d 	cylinder_count\n",
				&p->cylinder_count[0],
				p->cylinder_count[0]<<8|p->cylinder_count[1]);
		printf("%x: %d 	head_count\n", 
				&p->head_count, p->head_count);
		printf("%x: %d 	reduce_write_cyl\n", 
				&p->reduce_write_cyl, p->reduce_write_cyl);
		printf("%x: %d 	write_precomp_cyl\n", 
				&p->write_precomp_cyl, p->write_precomp_cyl);
		printf("%x: %d 	landing_zone\n", 
				&p->landing_zone, p->landing_zone);
		printf("%x: %d 	step_pulse_rate\n", 
				&p->step_pulse_rate, p->step_pulse_rate);
		printf("%x: %d 	n_blocks\n", 
				&p->n_blocks, p->n_blocks);
		printf("%x: %d 	len_defects\n", 
				&p->len_defects, p->len_defects);
		n = p->len_defects/sizeof(struct sdfmt_defects);
		printf("	%d defects\n",n);
		if (n == 0)
			continue;
		printf("Hit RETURN for list of DEFECTS: ");
		gets(buf);
		printf("	#	CYL  	HEAD	OFFSET\n");
		for (i = 0 ; i < n ; i++) {
			printf("%x:	%d	%d", d, i, 
			d->cylinder[0]<<16|d->cylinder[1]<<8|d->cylinder[2]);
			printf("	%d	%d\n",d->head,d->byteoffset);
			d++;
			SDDELAY(10000);
		}
	    }
	}
}

static 
sdwait(sdaddr)
	struct sddevice *sdaddr;
{ 	
	long l = 0;

	SDDELAY(400);
/*	while (sdaddr->sdcs & SD_CBSY)  { /**/
	while (sdaddr->sdcs == 0xffff)  { /**/
		if (++l == 10000) {
			printf("sd: timeout\n");
			return (-1);
		}
#ifdef	M68020
		SDDELAY(1600);
#else	M68020
		SDDELAY(400);
#endif	M68020
	}
	return (0);
}


#include "../is68kdev/smreg.h"

#ifdef	M68020
#define	SMADDR0	  	((struct smdevice *) 0xFD0000) /* 1st addr */
#define	SMADDR1	  	((struct smdevice *) 0xFD0200) /* 2nd addr */
#define	SMADDR2	  	((struct smdevice *) 0xFD0400) /* 3rd addr */
#define	SMADDR3	  	((struct smdevice *) 0xFD0600) /* 4th addr */
#else	M68020
#define	SMADDR0	  	((struct smdevice *) 0x7D0000) /* 1st addr */
#define	SMADDR1	  	((struct smdevice *) 0x7D0200) /* 2nd addr */
#define	SMADDR2	  	((struct smdevice *) 0x7D0400) /* 3rd addr */
#define	SMADDR3	  	((struct smdevice *) 0x7D0600) /* 4th addr */
#endif	M68020

#define	SM_CN		4			/* number of controllers */
#define	SM_DR		2			/* drives per controller */
#define	SMDELAY(n)	{ register int N = (n); while (--N > 0); }

static struct smdevice *smstd[SM_CN] = { SMADDR0, SMADDR1, SMADDR2, SMADDR3 };

struct smuib	uib;
	
fmtsm()
{
	register struct smdevice *smaddr;
	register struct sm_iopb	*iopb;
	register char *p;
	register int i, j, n, t;
	int nheads, ncyl, fc;
	char test;
	u_short drive = 0x0;


	printf("\nformatting SM disk\n");
	for (test = 'H';;) {
	    if (test == 'H') {
		printf("\nFunctions available:\n");
		printf("  a) Format Disk\n");
		printf("  b) Read UIB\n\n");
	    }
	    printf("Enter letter of desired function ('H' for help): ");
	    stripwhite(gets(buf));
	    test = buf[0];
	    if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		continue;
    cntlr:  printf("Controller number (0-%d) ? ",SM_CN-1);
	    stripwhite(gets(buf));
	    i = getnum(buf);
	    if (i < 0 || i >= SM_CN) {
		printf("illegal controller number\n");
		goto cntlr;
	    }
	    smaddr = smstd[i];
	    if (!probe(&smaddr->sm_cstatus,&smaddr->sm_cstatus)) {
		printf("controller %d at 0x%x not present\n", i, smaddr);
		goto cntlr;
	    }
	    if ((smaddr->sm_cstatus & CS_BOK) == 0) {
		printf("CONTROLLERS SELF DIAGNOSTICS FAILED\n");
		goto cntlr;
	    }
	    smaddr->sm_cstatus &= ~CS_SLED;
	    iopb = &smaddr->sm_iopb[0];

    drv:    printf("Drive number (0-%d) ? ",SM_DR-1);
	    stripwhite(gets(buf));
	    drive = getnum(buf);
	    if (drive < 0 || drive >= SM_DR) {
		printf("illegal drive number\n");
		goto drv;
	    }
	    drive = (drive&1) << 7;
	    if (test == 'a' || test == 'A') {
		printf("Start head volume 0 ?          ");
	    	stripwhite(gets(buf));
		uib.uib_vol_head[0].start_head = getnum(buf);
		printf("Number of heads volume 0 ?     ");
	    	stripwhite(gets(buf));
		uib.uib_vol_head[0].num_heads = getnum(buf);

		printf("Start head volume 1 ?          ");
	    	stripwhite(gets(buf));
		uib.uib_vol_head[1].start_head = getnum(buf);
		printf("Number of heads volume 1 ?     ");
	    	stripwhite(gets(buf));
		uib.uib_vol_head[1].num_heads = getnum(buf);

		printf("Number of cylinders ?          ");
	    	stripwhite(gets(buf));
		uib.uib_num_cyl = getnum(buf);

		printf("Number of sectors per track ?  ");
		stripwhite(gets(buf));
		uib.uib_sec_trk = getnum(buf);

		printf("Amount of cylinder skew ?      ");
		stripwhite(gets(buf));
		uib.uib_skew_factor = getnum(buf);

		uib.uib_bytes_sec = 512;

		printf("Size of gap 1 ?                ");
		stripwhite(gets(buf));
		uib.uib_gap1_words = getnum(buf);

		printf("Size of gap 2 ?                ");
		stripwhite(gets(buf));
		uib.uib_gap2_words = getnum(buf);

		printf("Sector interleave factor ?     ");
		stripwhite(gets(buf));
		uib.uib_sct_int = getnum(buf);

		uib.uib_retries = 10;
		uib.uib_attrib = UIB_AT_CE | UIB_AT_RSK | UIB_AT_INH;
		uib.uib_magic = UIB_MAGIC;

		iopb->iopb_cmd = CMD_INIT;
		iopb->iopb_coptions = drive | COP_LOG_TRAN | COP_ECC_EN;
		iopb->iopb_buf_addrh =  ((int)&uib) >> 16;
		iopb->iopb_buf_addrl =  ((int)&uib) & 0xFFFF;
		iopb->iopb_mem_type = MEMT_16BIT;
		iopb->iopb_adr_mod = ADRM_STD_N_D;
		iopb->iopb_dma_burst = DMA_BURST;
		iopb->iopb_skew_offset = 0;
		smaddr->sm_cstatus |= CS_GO;
		smwait(smaddr);
		if (smaddr->sm_cstatus & CS_ERR) {
			printf("Would not init\n");
			goto err;
		}
		smaddr->sm_cstatus &= ~CS_DONE;
		
		printf(  "Cylinder Volume 0\n");
		for ( i = 0 ; i < uib.uib_num_cyl; i++) {
		printf("\r%d",i);
		    for (j = uib.uib_vol_head[0].start_head ; 
			j < uib.uib_vol_head[0].start_head + 
			uib.uib_vol_head[0].num_heads; j++) {
			iopb->iopb_cmd = CMD_FMT_TRK;
			iopb->iopb_coptions = drive | COP_ECC_EN;
			iopb->iopb_dsk_addr.log.logh = 0;
			iopb->iopb_dsk_addr.log.logl = 0;
			iopb->iopb_blk_count = 0;
			iopb->iopb_dsk_addr.phys.cyl = i;
			iopb->iopb_dsk_addr.phys.hd = j;
			t = (iopb->iopb_dsk_addr.log.logh << 16) |
			    iopb->iopb_dsk_addr.log.logl;
			iopb->iopb_buf_addrh =  t >> 16;
			iopb->iopb_buf_addrl =  t & 0xFFFF;
			iopb->iopb_skew_offset = 0;
			smaddr->sm_cstatus |= CS_GO;
			if (smwait(smaddr) || (smaddr->sm_cstatus & CS_ERR))
				goto err;
			smaddr->sm_cstatus &= ~CS_DONE;
		    }
		}
		printf(  "\nCylinder Volume 1\n");
		for ( i = 0 ; i < uib.uib_num_cyl; i++) {
		printf("\r%d",i);
		    for (j = uib.uib_vol_head[1].start_head ; 
			j < uib.uib_vol_head[1].start_head + 
			uib.uib_vol_head[1].num_heads; j++) {
			iopb->iopb_cmd = CMD_FMT_TRK;
			iopb->iopb_coptions = drive | 0x40 | COP_ECC_EN;
			iopb->iopb_dsk_addr.log.logh = 0;
			iopb->iopb_dsk_addr.log.logl = 0;
			iopb->iopb_blk_count = 0;
			iopb->iopb_dsk_addr.phys.cyl = i;
			iopb->iopb_dsk_addr.phys.hd = j;
			t = (iopb->iopb_dsk_addr.log.logh << 16) |
			    iopb->iopb_dsk_addr.log.logl;
			iopb->iopb_buf_addrh =  t >> 16;
			iopb->iopb_buf_addrl =  t & 0xFFFF;
			iopb->iopb_skew_offset = 0;
			smaddr->sm_cstatus |= CS_GO;
			if (smwait(smaddr) || (smaddr->sm_cstatus & CS_ERR))
				goto err;
			smaddr->sm_cstatus &= ~CS_DONE;
		    }
		}
		if (smaddr->sm_cstatus & CS_ERR) {
err:			printf("\nERROR ");
			printf("cstatus=%b dstat=%b %b iopb: stat %x ec %x\n",
				smaddr->sm_cstatus, CS_BITS,
				smaddr->sm_dstatus[0], DS_BITS,
				smaddr->sm_dstatus[1], DS_BITS,
				iopb->iopb_status, iopb->iopb_error_code);
			smaddr->sm_cstatus &= ~(CS_DONE | CS_ERR_LC);
		} else {
			iopb->iopb_cmd = CMD_WRITE;
			iopb->iopb_coptions = drive | COP_ECC_EN;
			iopb->iopb_dsk_addr.log.logh = UIB_DSK_ADDR >> 16;
			iopb->iopb_dsk_addr.log.logl = UIB_DSK_ADDR & 0xFFFF;
			iopb->iopb_blk_count = 1;
			*((struct smuib*)0x400) = uib;
			t = (int) 0x400;
			iopb->iopb_buf_addrh =  t >> 16;
			iopb->iopb_buf_addrl =  t & 0xFFFF;
			iopb->iopb_mem_type = MEMT_16BIT;
			iopb->iopb_adr_mod = ADRM_STD_N_D;
			iopb->iopb_dma_burst = DMA_BURST;
			iopb->iopb_skew_offset = 0;
			smaddr->sm_cstatus |= CS_GO;
			if (smwait(smaddr) || (smaddr->sm_cstatus & CS_ERR))
				goto err;
			smaddr->sm_cstatus &= ~CS_DONE;
			printf("\nSUCCESSFUL FORMAT\n");
		}
	    } else if (test == 'b' || test == 'B') {
		iopb->iopb_cmd = CMD_READ;
		iopb->iopb_coptions = drive | COP_ECC_EN;
		iopb->iopb_dsk_addr.log.logh = UIB_DSK_ADDR >> 16;
		iopb->iopb_dsk_addr.log.logl = UIB_DSK_ADDR & 0xFFFF;
		t = (int) 0x400;
		iopb->iopb_buf_addrh =  t >> 16;
		iopb->iopb_buf_addrl =  t & 0xFFFF;
		iopb->iopb_blk_count = 1;
		iopb->iopb_mem_type = MEMT_16BIT;
		iopb->iopb_adr_mod = ADRM_STD_N_D;
		iopb->iopb_dma_burst = DMA_BURST;
		iopb->iopb_skew_offset = 0;
		smaddr->sm_cstatus |= CS_GO;
		if (smwait(smaddr) || (smaddr->sm_cstatus & CS_ERR))
			goto err;
		smaddr->sm_cstatus &= ~CS_DONE;

		uib = *((struct smuib*)0x400);

		if (uib.uib_magic != UIB_MAGIC) {
			printf("BAD UIB\n");
			continue;
		}
		printf(" [0].start_head  %d\n", uib.uib_vol_head[0].start_head);
		printf(" [0].num_heads   %d\n", uib.uib_vol_head[0].num_heads);
		printf(" [1].start_head  %d\n", uib.uib_vol_head[1].start_head);
		printf(" [1].num_heads   %d\n", uib.uib_vol_head[1].num_heads);
		printf(" sec_trk         %d\n", uib.uib_sec_trk);
		printf(" skew_factor     %d\n", uib.uib_skew_factor);
		printf(" bytes_sec       %d\n", uib.uib_bytes_sec);
		printf(" gap1_words      %d\n", uib.uib_gap1_words);
		printf(" gap2_words      %d\n", uib.uib_gap2_words);
		printf(" sct_int         %d\n", uib.uib_sct_int);
		printf(" retries         %d\n", uib.uib_retries);
		printf(" num_cyl         %d\n", uib.uib_num_cyl);
		printf(" attrib          %b\n", uib.uib_attrib, UIB_AT_BITS);
		printf(" reserved        %d\n", uib.uib_reserved);
		printf(" d0_level        %d\n", uib.uib_d0_level);
		printf(" d0_vector       %d\n", uib.uib_d0_vector);
	    }
	}
}

static 
smwait(smaddr)
	struct smdevice *smaddr;
{ 	
	long l = 0;

	SMDELAY(400);
	while (smaddr->sm_cstatus & CS_BUSY)  {
		if (++l == 10000) {
			printf("sm: timeout\n");
			return (-1);
		}
#ifdef	M68020
		SMDELAY(1600);
#else	M68020
		SMDELAY(400);
#endif	M68020
	}
	return (0);
}
