#include "../h/types.h"

#include "../is68kdev/elreg.h"

#define	ELADDR0		((struct eldevice *) 0x3ff900)
#define	ELADDR1  	((struct eldevice *) 0x3FF910)
#define	EL_CN		2			/* number of controllers */
#define	EL_DR		4			/* drives per controller */
#define	DELAY(n)	{ register int N = (n); while (--N > 0); }

static struct eldevice *elstd[EL_CN] = { ELADDR0, ELADDR1 };

struct elfmt_param {
	u_short	n_headcyl;
};

struct elfmt_defects {
	u_short	track_spared;
	u_short	offset;
};

char buf[100];
	
main()
{
	register struct eldevice *eladdr = ELADDR0;
	register struct elfmt_param *p;
	register struct elfmt_defects *d;
	register int i, n;
	int nheads, ncyl, fc;
	char test;
	u_short drive;
	u_short *c;

	printf("\n--- Integrated Solutions %i ERL Disk Formater ---");
	printf("\n                 Version 2.0\n\n");

	for (test = 'H';;) {
	    if (test == 'H') {
		printf("\nFunctions available:\n");
		printf("  a) Format Disk\n  b) Display Defect Track List\n");
	    }
	    printf("Enter letter of desired function ('H' for help): ");
	    stripwhite(gets(buf));
	    test = buf[0];
	    if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		continue;
    cntlr:  printf("Controller number (0-%d) ? ",EL_CN-1);
	    stripwhite(gets(buf));
	    i = getnum(buf);
	    if (i < 0 || i >= EL_CN) {
		printf("illegal controller number\n");
		goto cntlr;
	    }
	    eladdr = elstd[i];
	    if (!probe(&eladdr->elbae,&eladdr->elbae)) {
		printf("controller %d at 0x%x not present\n", i, eladdr);
		goto cntlr;
	    }
    drv:    printf("Drive number (0-%d) ? ",EL_DR-1);
	    stripwhite(gets(buf));
	    drive = getnum(buf);
	    if (drive < 0 || drive >= EL_DR) {
		printf("illegal drive number\n");
		goto drv;
	    }
	    drive = ((getnum(buf)<<8) & 0x0300) | EL_FORMAT;

	    if (test == 'a' || test == 'A') {
	head:	printf("Number of heads ? ");
	    	stripwhite(gets(buf));
		nheads = getnum(buf);
		if (nheads > 16 || nheads < 2)
			goto head;
	cyl:	printf("Number of cylinders ? ");
	    	stripwhite(gets(buf));
		ncyl = getnum(buf);
		if (ncyl > 2048 || ncyl < 20)
			goto cyl;
		fc = (nheads-1)<<11 | (ncyl-1);
		printf(" Estimated time until completion is ");
		printf("%d hours and %d min\n",
			((nheads*ncyl)/100)/60,((nheads*ncyl)/100)%60);
		printf("format constant = %x, ok ? ",fc);
		stripwhite(gets(buf));
		if (buf[0] != 'y' && buf[0] != 'Y')
			continue;
		eladdr->elda.rw = fc;
		eladdr->elcs = drive;
		c = (u_short *)0x1000;
		ncyl = *c;
		printf("Cylinder being formatted:\n");
		while (eladdr->elcs == 0x0000) {
			if (*c != ncyl) {
				ncyl = *c;
				printf("\r %d  ",ncyl);
			}
			DELAY(400);
		}
		printf("\n");
		if (eladdr->elcs & EL_ERR) {
			printf("DRIVE DID NOT FORMAT\n");
			printf("el: error cs=%b\n",eladdr->elcs,ELCS_BITS);
		} else
			printf("SUCCESSFUL FORMAT\n");
	    } else if (test == 'b' || test == 'B') {
		eladdr->elda.rw = 0x8000;	/* read parameter/defect list */
		eladdr->elcs = drive;
		if (elwait(eladdr) || eladdr->elcs & EL_ERR) {
			printf("el: error cs=%b\n",eladdr->elcs,ELCS_BITS);
			printf("cannot read bad track map\n");
			continue;
		}
		p = (struct elfmt_param *)0x1000;
		d = (struct elfmt_defects *)0x1002;

		nheads = ((p->n_headcyl>>12) & 0xF) + 1;
		ncyl = (p->n_headcyl & 0xFFF) + 1;
		printf("%d heads, %d cylinders, 16 sec/track\n", nheads, ncyl);
		printf("DEFECT	#	CYL  	HEAD\n");
		for (i = 0 ; ; i++) {
			if (d->offset == 0xffff)
				break;
			n = d->track_spared + d->offset;
			printf("%x:	%d	%d	%d\n",
				d, i, n/nheads, n%nheads);
			d++;
			DELAY(10000);
		}
	    }
	}
}

static 
elwait(eladdr)
	struct eldevice *eladdr;
{ 	
	long l = 0;

	DELAY(400);
/*	while (eladdr->elcs & EL_CBSY)  { /**/
	while (eladdr->elcs == 0xffff)  { /**/
		if (++l == 10000) {
			printf("el: timeout\n");
			return (-1);
		}
#ifdef	M68020
		DELAY(1600);
#else	M68020
		DELAY(400);
#endif	M68020
	}
	return (0);
}
