/*	da.c	6.1	83/07/29	*/

#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "saio.h"
#include "sais68k.h"

extern int	 	(*putch)(), (*getch)();
extern int		putslow;
extern char		*arguments;
static char		rf[60];
static char		*rfname = rf;
int 			wputremote(), wgetremote();
static struct st	dast = {1, -1, -1, -1, -1, NULL};
static int 		dainit = 0;

#ifdef	M68020
#define	DATIMEOUT	8000000
#else	M68020
#define	DATIMEOUT	1000000
#endif	M68020

daopen(io)
	register struct iob *io;
{
	register char *p0;

	if (dainit) {
		printf("da: already open\n");
		return (-1);
	}
	io->i_flgs |= F_REMOTE;
	io->i_st = dast;
	p0 = rfname;
	if (arguments)
		while((*arguments != '(') &&  (*p0++ = *arguments++));
	else
		*p0 = 0;
	if (*arguments != '(')
		arguments = NULL;
	return(0);
}

daclose(io)
	register struct iob *io;
{
	register int c;
	int (*savput)(), (*savget)();

	if (dainit) {
		savput = putch; savget = getch; 
		putch = wputremote; getch = wgetremote; putslow = 1;
		printf("%x %x \n|\n",0,0);
		putch = savput; getch = savget;
		while((c = getremote()) != '|') 	/* get sync char */
			if (c) {
				while (getremote()) DELAY(1000);
				wputremote('|');wputremote('\n');
			}
		dainit = 0;
	}
	return(0);
}

dastrategy(io, func)
	register struct iob *io;
{
	register int c1, c2;
	register int count = io->i_cc;
	/* CAUTION this is now a physical addr, things better be 1:1 */
	register char *buf = (char *)io->i_ma;	
	register int i;
	static int nch, fb;
	int (*savput)(), (*savget)();

	fb = 0;
	savput = putch; savget = getch; 
	if (!dainit) {
		if (*rfname == 0) {
			printf ("da: no filename\n");
			return (-1); 
		}
		putch = wputremote; getch = wgetremote; putslow = 1;
		if (func == READ)
			printf("stty -echo;./xfer %s r;stty echo\n",rfname);
		else
			printf("stty -echo;./xfer %s w;stty echo\n",rfname);
		putch = savput; getch = savget;
		for (i = DATIMEOUT; i > 0; i--)
			if (getremote() == '|')
				break;		/* got sync char */
		if (i == 0) {
			printf("da: no xfer daemon\n");
			return (-1);
		}
		if (wgetremote() == '1') {
			printf("da: cannot open file\n");
			return (-1);
		}
		dainit = 1;
		rfname = NULL;
	}
	if (getremote()) {
		printf("da: out of sync\n");
		return (-1);
	}
	putch = wputremote; getch = wgetremote; putslow = 1;
	printf("%x %x\n",io->i_offset,count);
	putch = savput; getch = savget;
	if (func == READ)
		while (count > 0) {
			for (i = DATIMEOUT; i > 0; i--)
				if ( c1 = getremote())
					break;		/* got char */
			if (i == 0) {
   tout:			printf("da: timeout\n");
				dainit = 0;;
				return (-1);
			}
			if (c1 == 0x6F)
				break;
			for (i = DATIMEOUT; i > 0; i--)
				if ( c2 = getremote())
					break;		/* got char */
			if (i == 0)
				goto tout;
			*buf++ = (c1&0x0F)<<4 | c2&0x0F;
			count--;
			if ((nch = (nch + 1)%128) == 0)
				if (fb ^= 1)
					printf(" ");
				else
					printf("\b");
		}
	else
		while (count > 0) {
			c1 = *buf++;
			wputremote(((c1>>4) & 0x0F) + '0');
			wputremote((c1 & 0x0F) + '0');
			if (getremote())
				break;
			count--;
			if ((nch = (nch + 1)%128) == 0)
				if (fb ^= 1)
					printf(" ");
				else
					printf("\b");
		}

	if (fb)
		printf("\b");

	if (getremote()) {
		printf("da: out of sync\n");
		return (-1);
	}
	if (io->i_cc == count)
		return (0);
	io->i_cc -= count;
	io->i_ma += io->i_cc;
	return(io->i_cc);
}
