/*	conf.c	6.1	83/07/29	*/

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "saio.h"

devread(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_RDDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, READ);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devwrite(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_WRDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, WRITE);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devopen(io)
	register struct iob *io;
{
	return ((*devsw[io->i_ino.i_dev].dv_open)(io));
}

devclose(io)
	register struct iob *io;
{
	return ((*devsw[io->i_ino.i_dev].dv_close)(io));
}

devioctl(io, cmd, arg)
	register struct iob *io;
	int cmd;
	caddr_t arg;
{
	return ((*devsw[io->i_ino.i_dev].dv_ioctl)(io, cmd, arg));
}

/*ARGSUSED*/
nullsys(io)
	struct iob *io;
{
}

/*ARGSUSED*/
nullioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{
	return (ECMD);
}

int	nullsys(), nullioctl();
#ifdef	QBUS
int	elstrategy(), elopen();
int	hpstrategy(), hpopen();
int	rkstrategy(), rkopen();
int	rastrategy(), raopen(), raioctl();
int	rlstrategy(), rlopen();
int	smstrategy(), smopen(), smioctl();
int	rxstrategy(), rxopen(), rxioctl();
int	tmstrategy(), tmopen(), tmclose();
int	tsstrategy(), tsopen(), tsclose();
int	dastrategy(), daopen(), daclose();
int	ilstrategy(), ilopen(), ilclose();
int	exstrategy(), exopen(), exclose();

/*
 * Standalone dev switch.  Devices must be listed in auto-boot search priority
 */
struct devsw devsw[] = {
	{"el",	makedev(1,0), "(0,0)vmunix",	
			elstrategy,elopen,nullsys,nullioctl },
	{"hp", 	makedev(2,0), "(0,0)vmunix",	
			hpstrategy,hpopen,nullsys,nullioctl },
	{"rk",	makedev(3,0), "(0,0)vmunix",	
			rkstrategy,rkopen,nullsys,nullioctl },
	{"ra",	makedev(4,0), "(0,0)vmunix",
			rastrategy,raopen,nullsys,raioctl },
	{"rl",	makedev(5,0), "(0,40b)vmunix",
			rlstrategy,rlopen,nullsys,nullioctl },
	{"sm",	makedev(6,0), "(2,0)vmunix",	
			smstrategy,smopen,nullsys,smioctl },
	{"rx",	makedev(7,0), "(2,0)vmunix",	
			rxstrategy,rxopen,nullsys,rxioctl },
	{"tm",	8, "(0,0)",	    	
			tmstrategy,tmopen,tmclose,nullioctl },
	{"ts",	9, "(0,0)",  	  	
			tsstrategy,tsopen,tsclose,nullioctl },
	{"da",	0, 0,			
			dastrategy,daopen,daclose,nullioctl },
	{"il",	makedev(6,0), "(0,0)?",			
			ilstrategy,ilopen,ilclose,nullioctl },
	{"ex",	makedev(6,0), "(0,0)?",			
			exstrategy,exopen,exclose,nullioctl },
	{0, 	0, 0, 			
			0,0,0,0 },
};
#else	VBUS
int	sdstrategy(), sdopen(), sdioctl();
int	smstrategy(), smopen(), smioctl();
int	tsstrategy(), tsopen(), tsclose();
int	dastrategy(), daopen(), daclose(), daioctl();
int	exstrategy(), exopen(), exclose(), exioctl();
int	vbstrategy(), vbopen(), vbclose(), nullioctl();
/*
#ifdef	M68010
#else	M68010
#define	vbstrategy	nullsys
#define	vbopen		nullsys
#define	vbclose		nullsys
#endif	M68010
*/

/*
 * Standalone dev switch.  Devices must be listed in auto-boot search priority
 */
struct devsw devsw[] = {
	{"sd",	makedev(1,0), "(0,0)vmunix",	
			sdstrategy,sdopen,nullsys,nullioctl },
	{"sm",	makedev(2,0), "(0,0)vmunix",	
			smstrategy,smopen,nullsys,nullioctl },
	{"ts",	9, "(0,0)",  	  	
			tsstrategy,tsopen,tsclose,nullioctl },
	{"da",	0, 0,			
			dastrategy,daopen,daclose,nullioctl },
	{"ex",	makedev(6,0), "(0,0)PUBLIC:vmunix",
			exstrategy,exopen,exclose,exioctl },
	{"vb",	makedev(6,0), "(0,0)PUBLIC:vmunix",
			vbstrategy,vbopen,vbclose,nullioctl },
	{0, 	0, 0, 			
			0,0,0,0 },
};
#endif	VBUS
