/* clock diagnostic */ 

main()
{
#ifdef	M68020
	register unsigned short *cp = (unsigned short *)0xFFF520;
#else	M68020
	register unsigned short *cp = (unsigned short *)0x7FF520;
#endif	M68020
	register unsigned short hr,min,sec;
	char buf[80];
	register char *p, *p0;
	int i;

	printf("\n--- Integrated Solutions %i Standalone Clock Test ---");
	printf("\n                 Version 2.0\n\n");
	printf("Default address of clock register is %x\n",cp);
	while (1) {
		printf("address, set, display, or exit ?:");
		stripwhite(gets(buf));
		if (buf[0] == 'E' || buf[0] == 'e')
			exit();
		else if (buf[0] == 'A' || buf[0] == 'a') {
			printf("  Enter address of clock: ");
			stripwhite(gets(buf));
			cp = (unsigned short *)gethex(buf);
		} else if (buf[0] == 'D' || buf[0] == 'd') {
		   while (1) {
			if (getlocal())
				break;
			*cp = 0xE000;		/* update clock buffer */
			wait(cp);
			*cp = 0xC400;
			wait(cp);
			hr = *cp & 0x3F;
			*cp = 0xC300;
			wait(cp);
			min = *cp & 0x7F;
			*cp = 0xC200;
			wait(cp);
			sec = *cp & 0x7F;
			printf("%x:%x.%x   \r",hr,min,sec);
			for (i=0 ; i < 500 ; i++);
		    }
		} else if (buf[0] == 'S' || buf[0] == 's') {
	retry:		stripwhite(gets(buf));
			p0 = buf;
			for (p = p0 ; *p && *p != ':'; p++);
			if (*p == 0) {
	err:			printf("hr:min.sec\n");
				goto retry;
			}
			*p = 0;
			hr = gethex(p0);
			p0 = p + 1;
			for (p = p0; *p && *p != '.'; p++);
			if (*p == 0) goto err;
			*p = 0;
			min = gethex(p0);
			p0 = p + 1;
			sec = gethex(p0);
			printf("%x:%x.%x\n",hr,min,sec);
			*cp = 0xD400 | hr;
			wait(cp);
			*cp = 0xD300 | min;
			wait(cp);
			*cp = 0xD200 | sec;
			wait(cp);
			*cp = 0xD901;		/* set 24 hour mode */
			wait(cp);
			*cp = 0xF000;		/* set time */
			wait(cp);
		}
	}
}
wait(cp)
unsigned short *cp;
{
	register int i, j;

	for (j = 0 ; j < 100000 ; j++) {
		if (*cp & 0x8000)
			for (i = 0 ; i < 100; i++);
		else
			return;
	}
	printf("wait timeout\n");
	exit();
}
