/*
 * boot: main routine for boot proms.
 */

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/reboot.h"
#include <a.out.h>
#include "saio.h"
#include "sais68k.h"

extern int	howto;
extern int	devtp;
extern char 	*sboot;
extern char	*arguments;
extern int	autoboot;
extern int	dorte;
extern int	lsflag;
#ifdef	VBUS
extern int	vbnum;
#endif	VBUS
char		*strarg();

#ifdef	M68020
#define WFACTOR		400000
#else	M68020
#define WFACTOR		100000
#endif	M68020
#define WAITAUTO	30*WFACTOR	/* seconds to wait before AUTOBOOT */
#define WAITREBO	30*WFACTOR	/* seconds to wait before AUTOREBOOT */

main()
{
	register int io, c, lastc;
	register struct devsw *ds = devsw;
	register int retry = 0;
	register int i, start;
	register char *p, *q;
	register char *line = (char *)LINEBUF;
#ifdef	VBUS
	char		*vbarg = "VBNUM=0";

	vbnum = cpux();
	vbarg[6] += vbnum;
	DELAY(50000);
	if (vbnum != 0) {
		retry += 1;		/* prevent autoboot of cluster nodes */
		printf("Cluster Node %d\n", vbnum);
	}
#endif	VBUS

	if (howto & RB_LOGO) {
		printf("\n\n\n\n\n\n\n\n\
        iii\n\
        iii\n\
    ssss   ssss \n\
   sssss   sssss\n\
   sssss   sssss\n\
   sssss       \n\
   sssssssssssss\n\
           sssss\n\
   sssss   sssss\n\
   sssss   sssss       Integrated Solutions, an NBI Company.\n\
    ssss   ssss	       %i 4.2 boot %s :%s\n\n\n", REV, DATE);
	} else
		printf("Integrated Solutions 4.2 boot\n");

	for (;;) {
	    bzero(line, LINELEN);
	    lsflag = 0;
	    printf(": ");
	    if (howto & RB_ASKNAME) {
		/*
		 * poll for the first character. If nothing is typed in WAITAUTO
		 * secs and this is the first prompt then start auto boot 
		 * procedure.
		 */
	   	for ( i=WAITAUTO; i > 0 ; i-- )
			if (line[0] = getlocal()) {
				if (line[0] == '\r' || line[0] == '\n') {
					putchar('\n');
					putchar('\r');
				} else
					putchar(line[0]);
				break;
			}
		if ( i==0 && !retry ) {
    bootauto:		printf("AUTOBOOT: ");
			/*
			 * loop through device switch, which is aranged in boot
			 * priority, and try to boot from each device which has
			 * a boot file specified.
			 */
			howto &= ~RB_SINGLE;	/* timeout asknames go multi */
			ds = devsw;
			while (ds->dv_bootf) {
				p = line;
				q = ds->dv_name;
				while (*q) *p++ = *q++;
				q = ds->dv_bootf;
				while (*q) *p++ = *q++;
				*p = 0;
				printf("%s",line);
				autoboot = 1;
				if ((start = copyunix(line)))
					goto doboot;
				autoboot = 0;
				for (q=line;*q;q++)
					printf("\b \b");
				ds++;
			}
			printf(" can't find bootable file\n: ");
	    		bzero(line, LINELEN);
			i = 0;
		} 
    manual:	retry++;
		howto |= RB_SINGLE;		/* asknames go single */

		if (i == 0 || line[0]=='\b')
			gets(line);
		else if (line[0] == 0x04)
			exit();
		else if (line[0] != '\r' && line[0] != '\n')
			getsi(line,1);
		else
			continue;
		/* 
		 * Look at the first character:
		 *	#address val			open/modify long access
		 *	$address val			open/modify word access
		 *	%address val			open/modify byte access
		 *	!				toggle interrupt enable
		 *	<dev(unit,part)file(args)	load image
		 *	>address			jump to location
		 *	@					autoboot
		 *	?				list directory
		 *	~				enter transparent mode
		 *					~. to exit
		 *	else load and execute "dev(unit,partition)file(args)".
		 */
		striplwhite(line);
		zerowhite(line);
		switch (line[0]) {
		    case '#':
			dobug(line+1,sizeof(long));
			break;

		    case '$':
			dobug(line+1,sizeof(short));
			break;

		    case '%':
			dobug(line+1,sizeof(char));
			break;

		    case '<':
			if ((start = copyunix(line+1)))
				printf("loaded\n");
			break;

		    case '>':
			if ((start = gethex(line+1)) != -1) {
				printf("jumping to %x\n",start);
				goto doboot;
			}
			break;

		    case '?':
			lsflag = 1;
			for (p = line+1; *p ; p++)
				;
			*p++ = '/'; *p++ = '.' ; *p++ = 0;
			io = open(line+1, 0);
			close(io);
			break;

		    case '@':
	    		printf(": ");
			goto bootauto;

		    case '!':
			if (dorte) {
				_splx(0x2700);
				dorte = 0;
				printf("interrupts disabled\n");
			} else {
				printf("interrupts enabled\n");
				dorte = 1;
				_splx(0x2000);
			}
			break;

		    case '~':
			lastc = 0;
			for (;;) {
			    if ( c = getlocal() ) {
				if ( lastc == '~' && c == '.') {
					printf(".\nClosed connection.\n");
					break;
				} else if (lastc == '\r' && c == '~')
			        	wputlocal(lastc = c);
				else {
					wputremote(c);
					lastc = (c == '\r') ? c : 0;
				}
			    }
			    if ( c = getremote() )
			    	wputlocal(c);
			}
			break;

		    default:
			if ((start = copyunix(line)))
				goto doboot;
		}
	    } else {
		/*
		 * poll for the first character. If nothing is typed in WAITREBO
		 * secs then autoreboot from specified devtp.
		 */
	   	for ( i=WAITREBO; i > 0 ; i-- )
			if (line[0] = getlocal()) {
				if (line[0] == '\r' || line[0] == '\n') {
					putchar('\n');
					putchar('\r');
				} else
					putchar(line[0]);
				goto manual;
			}
		for (ds = devsw ; ds->dv_name ; ds++)
			if (major(ds->dv_kermajmin) == major(devtp))
				break;
		if (!ds->dv_name)
			goto autoerr;
		p = line;
		q = ds->dv_name;
		while (*p++ = *q++) ;
		*(p-1) = '(';
		*p++ = '0' + (minor(devtp) >> 3);
		*p++ = ',';
		*p++ = '0' + (minor(devtp) & 0x7);
		*p++ = ')';
		q = ds->dv_bootf;
		while (*q++ != ')') ;
		while (*p++ = *q++) ;
		printf("AUTOREBOOT: %s",line);
		autoboot = 1;
		if ((start = copyunix(line)))
			goto doboot;
		autoboot = 0;
    autoerr:	howto |= RB_ASKNAME;
		printf(" can't find auto reboot kernel\n");
	    }
	}

doboot:	
#ifdef	VBUS
	addarg(vbarg);
#endif	VBUS
	booty(start);
}

/*ARGSUSED*/
copyunix(cp)
	register char *cp;
{
	union {				/* KLUDGE: for sm block transfer */
		struct exec exec;
		char dummy[520];
	} X;
#define	x	X.exec
	register int i, io;
	register char *addr;

	if ((io = open(cp, 0)) < 0)
		goto ret0;
	i = read(io, (char *)&x, sizeof x);
	if (i != sizeof x ||
	    (x.a_magic != 0407 /*&& x.a_magic != 0413 && x.a_magic != 0410*/)) {
		printf("file not bootable\n");
		goto ret0;
	}
	printf("%d", x.a_text);
	if (x.a_magic == 0413 && lseek(io, 0x400, 0) == -1)
		goto shread;
#ifdef	QBUS
# ifdef	M68020
	x.a_entry &= ??????????;
# else	M68020
	x.a_entry &= 0x003FFFFF;
# endif	M68020
#else	QBUS
# ifdef	M68020
	x.a_entry &= 0x0FFFFFFF;
# else	M68020
	x.a_entry &= 0x007FFFFF;
# endif	M68020
#endif	QBUS
	addr = (char *)x.a_entry;
	if (addr+(x.a_text+x.a_data+x.a_bss) >= sboot)
		goto nomem;
	if (read(io, addr, x.a_text) != x.a_text)
		goto shread;
	addr += x.a_text;
	if (x.a_magic == 0413 || x.a_magic == 0410)
		while ((int)addr & CLOFSET)
			*addr++ = 0;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
/*	x.a_bss += 128*512;	/* slop */
	for (i = 0; i < x.a_bss; i++)
		*addr++ = 0;
	devtp = makedev(major(devsw[iob[io-3].i_ino.i_dev].dv_kermajmin),
		(iob[io-3].i_unit << 3 ) | (iob[io-3].i_fpart & 0x7) );
	close(io);
	printf(" start 0x%x", x.a_entry);
	autoboot = 0;
	printf("\n");
	if (doargs()) {
		close(io);
		return(x.a_entry);
	}
	goto ret0;

shread:	printf("short read\n");
	goto ret0;

nomem:	printf("more memory needed to load image\n");
ret0:	close(io);
	return(0);
}

doargs()
{
	register char	*p = arguments;
	register char	*t;
	register struct devsw *dp;
	register char	c;

	if (p == NULL)
		return (1);
	if (*p == '(')
		p++;
	for (t=p ; *t ; t++)
		if (*t == '=' || *t == ')')
			break;
	if (*t == '=') {
		*t++='\0';
		if (strcmp(p,"root"))
			goto bad;
		p = t;
		t = &p[2];
		c = *t;
		*t = '\0';
		for (dp = devsw; dp->dv_name; dp++)
			if (!strcmp(p, dp->dv_name))
				break;
		if (!dp->dv_name)
			goto bad;
		*t=c;
		devtp = makedev(major(dp->dv_kermajmin),
			(ctoh(t[0])<<3)+(ctoh(t[1])-0xa));
		return (1);
	}

bad:	printf("bad argument specification\n"); 
	return (0);
}

dobug(cp, size)
	register char *cp;
	register int size;
{
	register int c, n, num, k, count;
	register unsigned char *loc;

	if ((num = gethex(cp)) == -1) {
		printf("invalid address\n");
		return;
	}
	loc = (unsigned char *)num;
	while (*cp)
		cp++;
	count = 0;
	cp++;
	if (*cp) {
		if ((n = gethex(cp)) == -1) {
			printf("invalid value\n");
			return;
		}
		count = 1;
		c = '\r';
	}
	while (1) {
	    DELAY(20000);		/* wait for GIP to scroll */
	    if (count == 0) {
		if (size == sizeof(char))
			printf("%x| %x  ", loc, *loc);
		else if (size == sizeof(short))
			printf("%x: %x  ", loc, *(unsigned short *)loc);
		else 
			printf("%x; %x  ", loc, *(unsigned long *)loc);
		n = count = 0;
		while (c = getchar())
			if ((k = ctoh(c)) == -1)
				break;
			else {
				count++;
				n = n * 16 + k;
			}
	    }
	    if (c == '\r' || c == '\n' || c == '\\') {
		if (count) {
	    		DELAY(20000);		/* wait for GIP to scroll */
			if (size == sizeof(char))
				*loc = n;
			else if (size == sizeof(short))
				*(unsigned short *)loc = n;
			else
				*(unsigned long *)loc = n;
		}
		if (c == '\r')
			return;
		else if (c == '\\') {
			printf("\n");
			loc -= size;
		} else
			loc += size;
	    } else
		printf("bad value\n");
	    count = 0;
	}
}

#define	ARGBUF		((char *)LINEBUF)
#define	ARGBUFSIZE	(LINELEN - 0x10)

char *
strarg(p)
	register char *p;
{
	register char *q = ARGBUF;
	register int len = strlen(p);
	register int nleft = ARGBUFSIZE - len - 2;

	while (--nleft >= 0) {
		switch (q[-1]) {
		  case '\0': case ' ': case '\t':
		  case '\n': case '\r':
			break;
		  default:
			q++;
			continue;
		}
		if (strncmp(p, q, len) == 0  &&  q[len] == '=') {
			q = p = &q[len + 1];
			while (--nleft >= 0)
				switch (*p++) {
				  case '\0': case ' ': case '\t':
				  case '\n': case '\r':
					*--p = '\0';
					return q;
				}
			*--p = '\0';
			return q;
		}
		q++;
	}
	return (char *)0;
}

#ifdef	VBUS
addarg(s)
	register char *s;
{
	register char *p = (char *)LINEBUF, *q = (char *)0;
	register int n = LINELEN - strlen(s) - 2;

	while (--n)
		if (*p++)
			q = p;
	if (q  &&  q != p)
		strcpy(q + 1, s);
}
#endif	VBUS
