char _Version_[] = "(C) Copyright 1983 UniSoft Corp., Version III.1.1";
char _Origin_[] = "UniSoft Systems of Berkeley";

/* Version 1.1 adds  -f & -r flag */

/*
 *	Copyright 1981 UniSoft Corporation
 *
 * hex - translate object files into ASCII formats
 *	suitable for Motorola S-record downloading
 *
 * 	Usage:
 *		hex [-f] [-l] [-n#] [-r] [-s0] [-s2] [-ns8] [+saddr] ifile
 *	where:
 *		f = just ship ifile as data, not as an executable file
 *		l = output "Loading at" message
 *		n# = number of characters to output
 *		r = output a \r instead of a \n after each record
 *		s0 = output a leading s0 record
 *		s2 = S2 records only
 *		ns8 = do not output a trailing s8 record
 *		saddr = starting load address (in hex)
 *		files starting address is used if saddr is not present
 *
 *	Author:
 *		Jeff Schriebman		8-81
 *		(modifications by m.w. ,e.l. and e.v.)
 */

#include <stdio.h>
#include <a.out.h>	/* MC68000 header definition */
#include <sys/types.h>
#include <sys/stat.h>

#define MAXOUT	1000	/* Max size of output line */
#define NOUT	12	/* Default number of characters to send */

	/* no bss for UNIX 68000 loader */
/* # define USE_BSS	USE_BSS	* download BSS segment */

char *ifile;		/* input file name */
#ifdef BOZO
struct bhdr filhdr;	/* area to read in file header */
#endif BOZO
char tbuf[MAXOUT+10];	/* output area */
int nout = NOUT;
int lflg;
int fflg;
int rflg;
int s0flg;
int s2flg;
int ns8flg;
int csum;		/* check sum */
long saddr;		/* starting address */
FILE *inp;		/* input file descriptor */

char hex[] = {		/* hex conversion table */
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};

#define FATAL 1		/* flag for fatal/nonfatal errors */
#define NONFATAL 0
#define TWO_BYTES ((unsigned) 0xffff)


/* 
 * main - process args, open files
 */
main(argc, argv)
char **argv;
{
#ifdef BOZO
	register struct bhdr *hp;
#endif BOZO
	register i;
	long addr = -1;
	char _obuf[BUFSIZ];

	setbuf(stdout, _obuf);		/* buffer output */

	ifile = NULL;			/* default input file */
	if (argc == 1)
bad:
		diagnostic(FATAL, "usage:hex [-f] [-l] [-n#] [-r] [-s0] [-s2] [-ns8] [+saddr] ifile", NULL);
	while (argc > 1) {
		if (strcmp("-f", argv[1]) == 0) {
			fflg++;
			--argc; ++argv;
			continue;
		}
		if (strcmp("-l", argv[1]) == 0) {
			lflg++;
			--argc; ++argv;
			continue;
		}
		if (strcmp("-r", argv[1]) == 0) {
			rflg++;
			--argc; ++argv;
			continue;
		}
		if (strcmp("-s0", argv[1]) == 0) {
			s0flg++;
			--argc; ++argv;
			continue;
		}
		if (strcmp("-s2", argv[1]) == 0) {
			s2flg++;
			--argc; ++argv;
			continue;
		}
		if (strcmp("-ns8", argv[1]) == 0) {
			ns8flg++;
			--argc; ++argv;
			continue;
		}
		if (strncmp("-n", argv[1], 2) == 0) {
			nout = atoi(&argv[1][2]);
			if (nout >= MAXOUT)
				diagnostic(FATAL, "hex:n parameter must be less than %d", MAXOUT, NULL);
			--argc; ++argv;
			continue;
		}
		if (*argv[1] == '+') { 	/* if '+', read address (hex) */
			sscanf(argv[1] , "+%lx" , &addr);
			--argc; ++argv;
			continue;
		} 		/* else read input file */
		if (ifile != NULL)
			goto bad;
		ifile = argv[1];
		--argc;
		++argv;
	}

	if (ifile == NULL)
		goto bad;

	if ((inp = fopen(ifile, "r")) == NULL) 		
		diagnostic(FATAL, "Can't open ", ifile, NULL);

#ifdef BOZO
	if (fflg == 0) {
		hp = &filhdr;
		/* read file header */
		if (getbytes(inp, hp, sizeof *hp) != sizeof *hp)
			diagnostic(FATAL, "Can't fetch file header", NULL);

		/* check it */
		if (hp->fmagic != OMAGIC && hp->fmagic != FMAGIC &&
		    hp->fmagic != NMAGIC && hp->fmagic != IMAGIC) 
			diagnostic(FATAL, "Bad file type", NULL);

		/* normal files only for now */
		if (hp->fmagic != FMAGIC) 
			diagnostic(FATAL, "Can only handle 0407 type files", 0);
	}
#endif BOZO
/*getbytes(inp, tbuf, 32);/**/

	if (addr == -1)
		if (fflg)
			addr = 0;
#ifdef BOZO
		else
			addr = hp->entry;
#endif BOZO
	if (lflg)
		printf("Load starting at 0x%lx\n", addr);

	saddr = addr;			/* save start address */
	if (s0flg)
		sends0(ifile);		/* output an S0 record */ 
#ifdef BOZO
	if (fflg) {
#endif BOZO
		senddata(addr, siz());	/* output file */
#ifdef BOZO
	} else {
		senddata(addr, hp->tsize);	/* output text */
		addr += hp->tsize;		/* add in text size */
		senddata(addr, hp->dsize);	/* output data */
# ifdef USE_BSS
		addr += hp->dsize;		/* add in data size */
		senddata(addr, hp->bsize);	/* output bss */
# endif
	}
#endif BOZO
	if (ns8flg == 0)
		sends8(saddr);		/* output an S8 (or S9) record */
	exit(0);
}

siz()
{
	struct stat sb;

	if (fstat(fileno(inp), &sb) < 0)
		return(0);
	return(sb.st_size);
}

/*
 * diagnostic -- spit out error messages 
 *	fatal = flag for nonrecoverable errors (0 = recoverable)
 *	args = string(s) to print
 */
diagnostic(fatal, args)
int fatal;
char *args;
{
	register char **a;

	for (a = &args; *a != NULL; a++)
		printf("%s", *a);
	printf("\n");
	if (fatal)
		exit(0);
}


/* 
 * getbytes - get bytes from the input stream 
 *	stream = input file descriptor
 *	addr = buffer to store bytes
 *	ct = number of bytes to fetch
 */
getbytes(stream, addr, ct)
register FILE *stream;
char *addr;
register ct;
{
	register n;

	n = 0;
	while (ct-- > 0) {
		*addr++ = getc(stream);
		if (feof(stream) || ferror(stream))
			break;
		n++;
	}
	return(n);
}


/*
 * sends0 - output an S0 record 
 */
sends0(fname)
register char *fname;
{
	csum = 0;			/* initialize check sum */
	printf("S0");			/* output S0 */
	sendhex(strlen(fname)+1);	/* output count */
	while (*fname != 0)		/* output file name */
		sendhex(*fname++);
	sendhex((255-csum) & 0xff);	/* output check sum */
	sendend();			/* output end characters */
}


/*
 * sends8 - output an S9 record (S8 if addr > 2 bytes)
 */
sends8(addr)
long addr;
{
	csum = 0;			/* initialize check sum */
	if (s2flg || addr > TWO_BYTES) {	/* if address > 2 bytes ... */
		printf("S8");			/* output S8 */
		sendhex(3+1);			/* output count */
		sendlong(addr);			/* output starting address */
	} else {			/* if normal address */
		printf("S9");			/* output S9 */
		sendhex(2+1);			/* output count */
		sendint((int) addr);		/* output starting address */
	}
	sendhex((255-csum) & 0xff);	/* output check sum */
	sendend();			/* output end characters */
}

/*
 * senddata - send text, bss, or data
 *	addr = starting address
 *	ct = byte count
 */
senddata(addr, ct)
long addr, ct;
{
	register i, n;

	for (;ct > 0; ct -= n) { 
		n = (ct > nout) ? nout : ct;
		if ((n = getbytes(inp, tbuf, n)) == 0)
			break;
		csum = 0;		/* initialize check sum */
		if (s2flg || addr > TWO_BYTES) {/* if long address .. */
			printf("S2");		/* output S2 */
			sendhex(3+n+1);		/* output count */ 
			sendlong(addr);		/* output starting address */
		} else {
			printf("S1");		/* output S1 */
			sendhex(2+n+1);		/* output count */
			sendint((int) addr);	/* output starting address */
		}
		for (i = 0; i < n; i++) 	/* output data */
			sendhex(tbuf[i]);
		sendhex((255-csum) & 0xff);	/* output check sum */
		sendend();			/* output end characters */
		addr += n;			/* next address */
	}
}

/*
 * sendend - send enough new lines to allow the 68000 time to process
 */
sendend()
{
	if (rflg)
		printf("\r");
	else
		printf("\n");
}

/*
 * sendhex - compute check sum and send one hex pair
 */
sendhex(c)
register char c;
{
	csum += c;
	putchar(hex[(c>>4)&0xf]);
	putchar(hex[c&0xf]);
}


/* 
 * sendint - send an integer field
 */
sendint(ct)
int ct;
{
	sendhex((ct >> 8) & 0xff);
	sendhex(ct & 0xff);
}


/*
 * sendlong - send a long integer field
 */
sendlong(ct)
long ct;
{
	int loint, hiint;

	hiint = ((int) (ct >> 16));	/* get hi int of a long */
	loint = ((int) ct & TWO_BYTES);	/* get low int of a long */

	sendhex(hiint  & 0xff);		/* send one byte of upper half */
	sendhex((loint >> 8) & 0xff);
	sendhex(loint & 0xff);
}
