/* 
 *  VME 68020 Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'Base' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified).  For the PROMBOOT version the 
 *	label 'Base' should be localed twords the end of the logical address 
 *	space but not so far out that it runs into the invalid and io pages 
 *	(3E0000 is a good value for now). For the BOOT version the same value 
 *	for the -T option as PROMBOOT can be used, however the a.out header 
 *	must be modified by hand (adb) so that the file is loaded somewhere 
 *	else initialy (such as 22000).
 *
 *	Registers d6 and d7 contain reboot information.
 *
 *	Debug trace skeleton:
 */
#define LOCORE

#include "../h/reboot.h"
#include "../is68k/board.h"
#include "../is68kdev/sioreg.h"

/*
 *	Debug trace skeleton and flags:
 *		TRACE(<ea>)
 *		Printn(reg, scratch_D_reg, scratch_D_reg, scratch_A_reg)
 */
#define	TXW		9: btst #2,S2681_R_SR_A; jeq 9b; /* wait for transmit */
#define	TRACE(x)	TXW; movb x,S2681_W_THR_A
#define	PN(X,Y,Z)	roll #4,X; movb X,Y; andw #0xF,Y; TRACE(Z@(0,Y:w))
#define	Printn(W,X,Y,Z) movl #N2C,X;andl #0xFFFFFFF,X;movl X,Z;movl W,X; \
			TRACE(#0x7b);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z); \
			PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);TRACE(#0x7d)

	MEMTRAP	=	0x000008	/* memory trap address */
	ILITRAP	=	0x000010	/* illegal instruction trap */
	INISTACK=	0x001000	/* initial stack pointer */

	.text
	.globl	Base
	.globl	start
	.globl	_begin
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
	.globl	__cacheon
	.globl	__cacheoff
	.globl	__cacheclear
#ifdef	BOOT
	.globl	_booty
#endif	BOOT
Base:
_begin:
#ifdef	PROMBOOT
	/* cold start PROM entry */
	.long	INISTACK		/* PROM+00 reset SSP */
	.long	PROM+(Coldboot-Base)	/* PROM+04 initial reset address */
#endif	PROMBOOT

start:	
#ifdef	BOOT
#ifdef	PROMBOOT
Reboot:					/* reboot entry */
	jra	Boot			/* PROM+08 */
Coldboot:				/* PROM+0A */
#endif	PROMBOOT
#endif	BOOT
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
/*	movl	d0,cacr /**/		/* clear and enable cache */
	.long	0x4E7B0002		/* KLUDGE	movl	d0,cacr */
#ifdef	BOOT
	movl	#RB_ASKNAME+RB_LOGO,d7	/* Ask for name on cold start */
	movl	#-1,d6			/* flag first boot */
Boot:	movw	#0x2700,sr		/* set priority level to 7 */
	movl	#0xFFFF,d0		/* let things warm up */
  L_00:	dbra	d0,L_00

/* 
 * Initialize SIO ports
 */
	movb	#0,S2681_W_IMR
	movb	#CR_CMD_RST_MR,S2681_W_CR_A
	movb	#CR_CMD_RST_MR,S2681_W_CR_B
	movb	#CR_CMD_RST_RX,S2681_W_CR_A
	movb	#CR_CMD_RST_RX,S2681_W_CR_B
	movb	#CR_CMD_RST_TX,S2681_W_CR_A
	movb	#CR_CMD_RST_TX,S2681_W_CR_B
	movb	#CR_CMD_RST_ERR,S2681_W_CR_A
	movb	#CR_CMD_RST_ERR,S2681_W_CR_B
	movb	#CR_CMD_RST_BRK,S2681_W_CR_A
	movb	#CR_CMD_RST_BRK,S2681_W_CR_B
	movb	#(MR1_PAR_NONE|MR1_8_BIT),S2681_MR1_A
	movb	#(MR1_PAR_NONE|MR1_8_BIT),S2681_MR1_B
	movb	#MR2_1_STOP,S2681_MR2_A
	movb	#MR2_1_STOP,S2681_MR2_B
	movb	#ACR_BRGS,S2681_W_ACR	/* baud rate table 1 */
	movb	BSR,d0
	andb	#BSR_BAUD,d0
	cmpb	#BSR_BAUD_9600,d0
	jne	1f
	movb	#0xBB,d0		/* 9600 */
	jra	2f
    1:	cmpb	#BSR_BAUD_1200,d0
	jne	1f
	movb	#0x66,d0		/* 1200 */
	jra	2f
    1:	cmpb	#BSR_BAUD_19200,d0
	jne	1f
	movb	#0xCC,d0		/* 19200 ?? */
	jra	2f
    1:	movb	#0x44,d0		/* 300 */
    2:	movb	d0,S2681_W_CSR_A
	movb	d0,S2681_W_CSR_B
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),S2681_W_CR_A
	movb	#(CR_ENABLE_TX|CR_ENABLE_RX),S2681_W_CR_B

#ifdef	PROMBOOT
/*
 *	Initialize all of memory on first boot, use nontranslated addresses
 *	Print out a "." for every megabyte found.
 */
	cmpl	#-1,d6
	jne	L_20

	lea	pc@(imem0),a2
  L_10:	btst	#2,S2681_R_SR_A		/* test transmit ready */
	jeq	L_10
	movb	a2@+,S2681_W_THR_A
	jne	L_10

	movl	#0,0			/* clear initial ssp location */
	movl	#0,4			/* clear initial pc location */
  	lea	MEMTRAP,a1
	lea	pc@(L_12),a0
	movl	a0,a1@

	movl	#0x0,d0
	movl	#0xFFFFF,d2
	lea	MEMTRAP+4,a0		/* start addr */

  L_11:	movl	d0,a0@
	cmpl	a0@+,d0
	jne	L_12
	movl	a0,d1
	andl	d2,d1
	jne	L_11
	movb	#0x2e,S2681_W_THR_A
	jra	L_11

  L_12:	lea	pc@(imem1),a2
  L_13:	btst	#2,S2681_R_SR_A
	jeq	L_13
	movb	a2@+,S2681_W_THR_A
	jne	L_13
#endif	PROMBOOT
#else	BOOT
	lea	INISTACK,sp
#endif	BOOT

  L_20:	nop

#ifdef	BOOT
/* 
 * Relocate out side of PROM (or load area) into the link space, which was 
 * just maped to the end of physical memory.
 */
  	bsr	L_30			/* compute source address */
  L_30:	movl	sp@+,d0			/* relative to current pc */
	andw	#0xF000,d0		/* back to last page boundry */
	movl	d0,a0
	lea	Base,a1			/* destination address */
	movl	#_edata+4,d0		/* compute image size */
	subl	a1,d0
	lsrl	#2,d0			/* byte to long */
  L_31:	movl	a0@+,a1@+
	dbra	d0,L_31
	jmp	L_40			/* long jump */

/* 
 * running in link space
 */
  L_40:	movl	#CTX_LED,d0
	movl	d0,CTX			/* extinguish led */
#else	BOOT
/*	lea	INISTACK,sp	/**/
#endif	BOOT
	lea	Base,sp			/* define the stack pointer */
					/* it grows down from start of code */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
	jra	L_51
  L_50:	movl	#tperr,a0@+
  L_51:	cmpl	#0x3fc,a0
	jls	L_50

/* 
 * clear bss
 */
/* OLD
	lea	_edata,a0
	lea	_end,a1
  L_60:	clrl	a0@+	
	cmpl	a0,a1
	jgt	L_60
*/

	lea	_edata,a0
	movl	_end+4,d0
	subl	a0,d0
	lsrl	#2,d0			/* byte to long */
	movl	#0,d1
  L_60:	movl	d1,a0@+
	dbra	d0,L_60

	movl	#0x10000000,d5	/* KLUDGE sboot */
/*
 * jump to main, never to return
 */
	movl	a5,_topmem		/* high address */
#ifdef	BOOT
	movl	d5,_sboot		/* start of boot in physical space */
	movl	d6,_devtp
	movl	d7,_howto
#endif	BOOT
	jmp	_main
	jsr	_exit			/* if main should return */

	/* servie interrupts and traps */
tperr:	movml	#0xC0C0,sp@-		/* save [da][01] */
	jsr	_traperr
	movml	sp@+,#0x0303		/* restore [da][01] */
	tstl	_dorte			/* if dorte return from interrupt */
	jeq	__rtt
	rte

/*
 * return to PROM
 */
__rtt:	movl	#RB_ASKNAME,d7		/* Ask for name after exit */
	movl	#0xFFFF,d6		/* not a cold boot */
	movl	#0xF000,d0		/* let things cool down */
1:	dbra	d0,1b
	jmp	PROM_REBOOT

__splx: movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movb	#0,d0
	orb	#CTX_PARITY,d0
	movb	d0,CTX
	rts

__parityoff:
	movb	#0,d0
	andb	#~CTX_PARITY,d0
	movb	d0,CTX
	rts

__cacheon:
	movl	#0x00000001,d0
/* 	movl	d0,cacr /**/
	.long	0x4E7B0002		/* KLUDGE */
	rts

__cacheoff:
	movl	#0x00000000,d0
/* 	movl	d0,cacr /**/
	.long	0x4E7B0002		/* KLUDGE */
	rts

__cacheclear:
	movl	#0x00000009,d0
/* 	movl	d0,cacr /**/
	.long	0x4E7B0002		/* KLUDGE */
	rts

/*
 * Test-and-set primative.
 *  Sets the high-order bit of the pointed-to byte.
 *  Returns zero (failure) if the byte had been nonzero, else 1 (success).
 *  Routine is indivisible even in multi-processor environment
 *  IF the byte is in VME memory.
 */
	.globl	_tas
_tas:	movq	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addqw	#1,d0
    1:	rts

#ifdef	BOOT
/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@
#endif	BOOT

	.data
	.globl	_bdata
	.globl	_errno
	.globl  _cpuchip
	.globl	is68020
	.globl  _topmem
	.globl  _shortio
	.globl	_dorte
	.globl	_hadint
_bdata:
_errno:	.long	0
_cpuchip:
	.long	68020
is68020:
	.long	0xFFFFFFFF
_topmem:
	.long	0
_shortio:
	.long	0x800000	/* KLUDGE */
_dorte:	.long	0
_hadint:
	.long	0
N2C:	.asciz "0123456789ABCDEF"
	.long	0
#ifdef	BOOT
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
_howto:	.long	0
_devtp:	.long	0
_sboot: .long	0

imem0:	.asciz	"Initialize all memory "
imem1:	.asciz	"\r\n"
#endif	BOOT
