/* 
 *  VME Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'Base' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified).  For the PROMBOOT version the 
 *	label 'Base' should be localed twords the end of the logical address 
 *	space but not so far out that it runs into the invalid and io pages 
 *	(3E0000 is a good value for now). For the BOOT version the same value 
 *	for the -T option as PROMBOOT can be used, however the a.out header 
 *	must be modified by hand (adb) so that the file is loaded somewhere 
 *	else initialy (such as 22000).
 *
 *	Registers d6 and d7 contain reboot information.
 *
 *	Debug trace skeleton:
 */
#define	DEBUG
#define LOCORE

#ifdef	DEBUG
#define	TRACE(xxx) 			movb	#xxx,SIO0_ADR 		\
					movw	#0x7FFF,d4		\
			L/**/xxx:	dbra	d4,L/**/xxx
#else	DEBUG
#define	TRACE(xxx)
#endif	DEBUG

#include "../h/reboot.h"
#include "../is68k/board.h"
#include "../is68kdev/ctcreg.h"
#include "../is68kdev/sioreg.h"

	MEMTRAP	=	0x000008	/* memory trap address */
	ILITRAP	=	0x000010	/* illegal instruction trap */
	INISTACK=	0x03B000	/* initial stack pointer */

	.text
	.globl	Base
	.globl	start
	.globl	_begin
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
#ifdef	BOOT
	.globl	_booty
#endif	BOOT
Base:
_begin:

#ifdef	PROMBOOT
	/* cold start PROM entry */
	.long	INISTACK		/* C00000 reset SSP */
	.long	PROM+(Coldboot-Base)	/* C00004 initial reset address */
#endif	PROMBOOT

start:	

#ifdef	BOOT
#ifdef	PROMBOOT
Reboot:					/* C00008 reboot entry */
	jra	Boot
Coldboot:				/* C0000A */
#endif	PROMBOOT
	movl	#RB_ASKNAME+RB_LOGO,d7	/* Ask for name on cold start */
	movl	#-1,d6			/* flag first boot */
#ifdef	PROMBOOT
Boot:
#endif	PROMBOOT
	movw	#0x2700,sr		/* set priority level to 7 */
	movw	#BSR_PARITYOFF,BSR	/* turn off parity */
	lea	INISTACK,sp
	reset
	movl	#0xFFFF,d0		/* let things warm up */
1:	nop
	dbra	d0,1b
#else	BOOT
	lea	INISTACK,sp
#endif	BOOT

#ifdef	BOOT
/* 
 * Initialize CTC baud rate chanels
 */
 	movl	#CTC0_ADR,a0		/* CTC 0 */
	movl	#CTC1_ADR,a1		/* CTC 1 */
	movw	BSR,d0			/* get switches */
	notw	d0			/* complement */
	andw	#BSR_CPUSPEED+BSR_BAUD,d0 /* get machine speed and baud rate */
	lsrw	#4,d0			/* convert to index */
	lea	pc@(ctctab),a2
	movb	a2@(0,d0:W),d2		/* Pick up time constant */
	movb	#CTC_CNT,a0@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a0@ 
	movb	d2,a0@
	movb	#CTC_CNT,a1@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a1@
	movb	d2,a1@

/* 
 * Initialize SIO ports
 */
	lea	pc@(siodvtab),a2
	movb	a2@(0,d0:W),d2		/* Pick up division WW4 constant */
	movl	#SIO0_ADR+SIO_CTRL,a0	/* SIO 0 control */
	movl	#SIO1_ADR+SIO_CTRL,a1	/* SIO 1 control */
	movw	#8,d0
	lea	pc@(siotab),a2
L61:	movb	a2@,a0@
	movb	a2@+,a1@
	dbra	d0,L61
	movb	#SIOW0_REXT+4,a0@	/* reprogram divide constant */
	movb	d2,a0@
	movb	#SIOW0_REXT+4,a1@
	movb	d2,a1@
#endif	BOOT
/* 
 * Initialize memory managment for a 1:1 logical to physical mapping
 */
	/* program the segment table */
	movl	#NSEGPERCTX-1,d1	/* one context worth */
	movl	#0x80,d0		/* all accesses are permited */
	movl	#SEGREGBASE,a0
L10:	movb	d0,a0@
	addl	#SEGNXTINCR,d0
	addl	#SEGREGINCR,a0		/* next segment in context */
	dbra	d1,L10

	/* program the page table */
	movl	#NPAGREG-1,d1		/* complete address space */
	movl	#0x00,d0
	movl	#PAGREGBASE,a0
L11:	movw	d0,a0@
	addl	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a0
	dbra	d1,L11

#ifdef	PROMBOOT
/*
 *	Initialize all of memory on first boot, use virtual page 1 to physical
 *	page to be cleared.  Print out a "." for every megabyte found.
 */
	cmpl	#-1,d6
	jne	L121
	lea	pc@(imem0),a0
L111:	movw	#0x7fff,d0
L112:	dbra	d0,L112
	movb	a0@+,SIO0_ADR
	jne	L111
	lea	MEMTRAP,a1
	lea	pc@(L114),a0
	movl	a0,a1@
	movl	#0x1000,a1			/* virtual addr, use page 1 */
	movl	#PAGREGBASE+PAGREGINCR,a2	/* page register for vaddr */
	movl	#(0x1000/4)-1,d3		/* number of bytes in a page */
	movl	#0x0,d1				/* physical page number */
	movl	d1,d0				/* clear pattern */
	movl	#0x1000+MEMTRAP+4,a0		/* first pass virtual */
	movl	#(0x1000/4)-((MEMTRAP+4)/4)-1,d2/* number of bytes first pass */
L113:	movw	d1,a2@				/* map virtual to physical */
	tstw	a0@(4096-2)			/* whole page ??? */
	tstw	a0@(2048)
	tstw	a0@(1024)
	tstw	a0@(512)
	tstw	a0@(256)
	tstw	a0@(128)
	tstw	a0@
L1131:	movl	d0,a0@				/* zero and test */
	cmpl	a0@+,d0
	jne	L114
	dbra	d2,L1131			/* loop on page */
	addqw	#PAGNXTINCR,d1			/* next page */
	movl	d3,d2				/* full page */
	movl	a1,a0				/* reset virtual address */
	movw	d1,d4				/* put out a "." for each meg */
	andw	#0xFF,d4
	jne	L113
	movb	#0x2e,SIO0_ADR
	jra	L113
L114:	movw	#PAGNXTINCR,a2@			/* reset mapping for page 1 */
	lea	pc@(imem1),a0
L1141:	movw	#0x7fff,d0
L1142:	dbra	d0,L1142
	movb	a0@+,SIO0_ADR
	jne	L1141
#endif	PROMBOOT
/*
 * Reprogram pages 0x7E0-0x7FF in virtual to point to the standard IO segment 
 * in physical memory (pages 0xFE0-0xFFF)
 */
L121:	movl	#PAGREGBASE+0xFC0,a0
	movw	#0xFE0,d0
	movl	#NPAGPERSEG-1,d1	/* one segment of page registers */
L12:	movw	d0,a0@
	addl	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a0
	dbra	d1,L12

/*
 * Define the vector base register to point to 0.  On the 68000 the base
 * register is always zero, and an illegal instruction trap will occur if
 * you try to execute the 68010 instruction to redefine it.  Dont bother
 * cleaning up the stack after traps...
 */
	movl	#68000,d4
	lea	ILITRAP,a1
	lea	pc@(L20),a0
	movl	a0,a1@
	clrl	d0
	movl	d0,vb
	movl	#68010,d4
L20:
/*
 * Size physical memory by steping through first word of each page, waiting 
 * for a fault or write/read mismatch. Note write/read mismatch as end of 
 * usable memory, and fault as start of short io space.
 */
	/* fill in fault vector for recovery */
	lea	MEMTRAP,a1
	lea	pc@(L30),a0
	movl	a0,a1@

	movl	#0x1000,a0		/* virtual addr, use page 1 */
	movl	#PAGREGBASE+PAGREGINCR,a1
	movl	#0,d0			/* compair fail page */
	movl	#PAGNXTINCR,d1		/* physical page */
	movl	#0xCACA,d2

L25:	movw	d1,a1@			/* map virtual to physical */
#ifdef	BOOT
	/* POSSIBLE PROBLEM WITH NON-PROM VERSION OF BOOT */
	movw	a0@,d3
	movw	d2,a0@
#else	BOOT
	movw	a0@,d2
#endif	BOOT
	cmpw	a0@,d2			/* note first mismatch */
	beq	L26
	tstl	d0
	jne	L26
	movl	d1,d0
	andw	#0xFF0,d0
L26:	addql	#PAGNXTINCR,d1
#ifdef	BOOT
	movw	d3,a0@			/* put back */
#endif	BOOT
	jra	L25

L30:	movw	#PAGNXTINCR,a1@		/* reset mapping for page 1 */
	andw	#0xFF0,d1
	tstl	d0
	jne	L301
	movl	d1,d0

/*
 * Reprogram pages 0x7D0-0x7DF in virtual to point to the short IO space
 */
L301:	
	movl	#PAGREGBASE+0xFA0,a0
	movl	#15,d3			/* 64K short io space */
	movl	d1,d2
L122:	movw	d2,a0@
	addl	#PAGNXTINCR,d2
	addl	#PAGREGINCR,a0
	dbra	d3,L122
/*
 * You get here either by a fault, or fall through. Reprogram pages of logical
 * link address space to point to the last pages of physical address space. 
 */
	movl	#12,d2			/* convert page to address */
	lsll	d2,d0
	movl	d0,a5			/* save address of top of memory */
	lsll	d2,d1
	movl	d1,a4			/* save physical address of shortio */

#ifdef	BOOT
	/* compute size of BOOT image and define stack pointer */
	movl	#_end+0xFFF,d1	
	subl	#Base,d1
	andl	#0xFFF000,d1		/* to a page boundry */
	addl	#0x4000,d1		/* add 3 pages for stack and */
	subl	d1,d0			/* back up this physical amount */
	movl	d0,d5			/* boot firewall on loading images */
	movb	#12,d2
	lsrl	d2,d0			/* templete, remember access bits */
	lsrl	d2,d1			/* number of pages to reprogram */
	movl	#Base-0x3000,d3
	lsrl	d2,d3
	movl	#PAGREGBASE,a1		 /* first page table for link space */
	lsll	#1,d3
	addl	d3,a1
L31:	movw	d0,a1@
	addw	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a1
	dbra	d1,L31

/* 
 * Relocate out side of PROM (or load area) into the link space, which was 
 * just maped to the end of physical memory.
 */
	bsr	L40			/* compute source address */
L40:	movl	sp@+,d0			/* relative to current pc */
	andl	#0xFFF000,d0		/* back to last page boundry */
	movl	d0,a0
	lea	Base,a1			/* destination address */
	movl	#_edata+4,d0		/* compute image size */
	subl	#Base,d0
	lsrl	#2,d0			/* byte to long */
L41:	movl	a0@+,a1@+
	dbra	d0,L41
	jmp	L50			/* long jump */

L50:					/* running in link space */
#else	BOOT
/*	lea	INISTACK,sp 		/**/
#endif	BOOT
	lea	Base,sp			/* define the stack pointer */
					/* it grows down from start of code */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
	jra	L71
L70:	movl	#tperr,a0@+
L71:	cmpl	#0x3fc,a0
	jls	L70

/* 
 * clear bss
 */
	lea	_edata,a0
	lea	_end,a1
L80:	clrl	a0@+	
	cmpl	a0,a1
	jgt	L80

/*
 * jump to main, never to return
 */
	movl	d4,_cpuchip		/* type of chip */
	movl	a5,_topmem		/* high address */
	movl	a4,_shortio		/* physical address of short io*/
#ifdef	BOOT
	movl	d5,_sboot		/* start of boot in physical space */
	movl	d6,_devtp
	movl	d7,_howto
#endif	BOOT
	jmp	_main
	jsr	_exit			/* if main should return */

	/* servie interrupts and traps */
tperr:	movml	#0xC0C0,sp@-		/* save [da][01] */
	jsr	_traperr
	movml	sp@+,#0x0303		/* restore [da][01] */
	tstl	_dorte			/* if dorte return from interrupt */
	jeq	__rtt
	rte

/*
 * return to PROM
 */
__rtt:	movl	#RB_ASKNAME,d7		/* Ask for name after exit */
	movl	#0xFFFF,d6		/* not a cold boot */
	movl	#0xF000,d0		/* let things cool down */
1:	dbra	d0,1b
	jmp	PROM_REBOOT

__splx: movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movw	BSR,d0
	andw	#CTXMASK,d0
	orw	#BSR_PARITYON,d0
	movw	d0,BSR
	rts

__parityoff:
	movw	BSR,d0
	andw	#CTXMASK,d0
	orw	#BSR_PARITYOFF,d0
	movw	d0,BSR
	rts

/*
 * Test-and-set primative.
 *  Sets the high-order bit of the pointed-to byte.
 *  Returns zero (failure) if the byte had been nonzero, else 1 (success).
 *  Routine is indivisible even in multi-processor environment
 *  IF the byte is in VME memory.
 */
	.globl	_tas
_tas:	movq	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addqw	#1,d0
    1:	rts

#ifdef	BOOT
/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@
#endif	BOOT

	.data
	.globl	_bdata
	.globl	_errno
	.globl  _cpuchip
	.globl  _topmem
	.globl  _shortio
	.globl	_dorte
	.globl	_hadint
	.globl	_xbad144
_bdata:
_errno:	.long	0
_cpuchip:
	.long	68000
_topmem:
	.long	0
_shortio:
	.long	0
_dorte:	.long	0
_hadint:
	.long	0
_xbad144:
	.long	0
#ifdef	BOOT
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
_howto:	.long	0
_devtp:	.long	0
_sboot: .long	0

imem0:	.asciz	"Initialize all memory "
imem1:	.asciz	"\r\n"

siotab:	.byte	0x18		/* WW0 Channel Reset			*/
	.byte	0x14		/* WW0 Reset Ext Status, Select WW4	*/
	.byte	0x44		/* WW4 X16 Clock, 1 Stop bit/char	*/
	.byte	0x13		/* WW0 Reset Ext Status, Select WW3	*/
	.byte	0xC1		/* WW3 Rx 8 bits/char, enable		*/
	.byte	0x15		/* WW0 Reset Ext Status, Select WW5	*/
	.byte	0xEA		/* WW5 Tx DTR, 8 bits/char, enable, RTS	*/
	.byte	0x11		/* WW0 Reset Ext Status, Select WW1	*/
	.byte	0x00		/* WW1 No interupts			*/
	.byte	0x00		/* WW0 Null code			*/

/* 
 * CTCTAB: Note that 1200 and 300 have the same entries in ctctab; they are 
 * distinguished by the baud rate divider in SIODVTAB. 
 */
ctctab:	
	.byte  	16			/* 10MHz	9600	*/
	.byte	19			/* 12MHz		*/
	.byte	18			/* 11MHz		*/
	.byte	13			/*  8MHz		*/

	.byte	8			/* 10MHz	19200	*/
	.byte	9			/* 12MHz		*/
	.byte	9			/* 11MHz		*/
	.byte	7			/*  8MHz		*/

	.byte	130			/* 10MHz	1200	*/
	.byte	151			/* 12MHz		*/
	.byte	144			/* 11MHz		*/
	.byte	104			/*  8MHz		*/

	.byte	130			/* 10MHz	300	*/
	.byte	151			/* 12MHz		*/
	.byte	144			/* 11MHz		*/
	.byte	104			/*  8MHz		*/
siodvtab:	
	.byte  	SIOW4_X16+SIOW4_1STOP	/* 10MHz	9600	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	19200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	1200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X64+SIOW4_1STOP	/* 10MHz	300	*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X64+SIOW4_1STOP	/*  8MHz		*/
#endif	BOOT
