/* 
 *  QBUS Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'Base' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified).  For the PROMBOOT version the 
 *	label 'Base' should be localed twords the end of the logical address 
 *	space but not so far out that it runs into the invalid and io pages 
 *	(3E0000 is a good value for now). For the BOOT version the same value 
 *	for the -T option as PROMBOOT can be used, however the a.out header 
 *	must be modified by hand (adb) so that the file is loaded somewhere 
 *	else initialy (such as 22000).
 *
 *	Registers d6 and d7 contain reboot information.
 *
 *	Debug trace skeleton:
 */
#define	DEBUG
#define LOCORE

#ifdef	DEBUG
#define	TRACE(xxx) 			movb	#xxx,SIO0_ADR+SIO_DATA	\
					movw	#0x7FFF,d4		\
			L/**/xxx:	dbra	d4,L/**/xxx
#else	DEBUG
#define	TRACE(xxx)
#endif	DEBUG

#include "../h/reboot.h"
#include "../is68k/board.h"
#include "../is68kdev/ctcreg.h"
#include "../is68kdev/sioreg.h"

	MEMTRAP	=	0x000008	/* memory trap address */
	ILITRAP	=	0x000010	/* illegal instruction trap */
	INISTACK=	0x03B000	/* initial stack pointer */

	.text
	.globl	Base
	.globl	start
	.globl	_begin
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
	.globl	_byterev
#ifdef	BOOT
	.globl	_booty
#endif	BOOT
Base:
_begin:

#ifdef	PROMBOOT
	/* cold start PROM entry */
	.long	INISTACK		/* C00000 reset SSP */
	.long	PROM+(Coldboot-Base)	/* C00004 initial reset address */
#endif	PROMBOOT

start:	

#ifdef	BOOT
#ifdef	PROMBOOT
Reboot:					/* C00008 reboot entry */
	jra	Boot
Coldboot:				/* C0000A */
#endif	PROMBOOT
	movl	#RB_ASKNAME+RB_LOGO,d7	/* Ask for name on cold start */
	movl	#0xFFFFFFFF,d6		/* flag first boot */
#ifdef	PROMBOOT
Boot:
#endif	PROMBOOT
	movw	#0x2700,sr		/* set priority level to 7 */
	movw	#0x10,CXW		/* turn off parity */
	lea	INISTACK,sp
	reset
	movl	#0xFFFF,d0		/* let things warm up */
1:	nop
	dbra	d0,1b
#else	BOOT
	lea	INISTACK,sp
#endif	BOOT

#ifdef	BOOT
/* 
 * Initialize CTC baud rate chanels
 */
 	movl	#CTC0_ADR,a0		/* CTC 0 */
	movl	#CTC1_ADR,a1		/* CTC 1 */
	movw	BSR,d0			/* get switches */
	andw	#BSR_BAUD+BSR_CPUSPEED,d0 /* machine speed and baud rate */
	lea	pc@(ctctab),a2
	movb	a2@(0,d0:W),d2		/* Pick up time constant */
	movb	#CTC_CNT,a0@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a0@ 
	movb	d2,a0@
	movb	#CTC_CNT,a1@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a1@
	movb	d2,a1@

/* 
 * Initialize SIO ports
 */
	lea	pc@(siodvtab),a2
	movb	a2@(0,d0:W),d2		/* Pick up division WW4 constant */
	movl	#SIO0_ADR+SIO_CTRL,a0	/* SIO 0 control */
	movl	#SIO1_ADR+SIO_CTRL,a1	/* SIO 1 control */
	movw	#8,d0
	lea	pc@(siotab),a2
L61:	movb	a2@,a0@
	movb	a2@+,a1@
	dbra	d0,L61
	movb	#SIOW0_REXT+4,a0@	/* reprogram divide constant */
	movb	d2,a0@
	movb	#SIOW0_REXT+4,a1@
	movb	d2,a1@
#endif	BOOT
/* 
 * Initialize memory managment for a 1:1 logical to physical mapping
 */
	/* program the segment table */
	movw	#0x80,d0		/* all accesses are permited */
	movl	#SEGREGBASE,a0
	movw	#0x3F,d1		/* one context worth */
L10:	movb	d0,a0@
	addqw	#1,d0
	addl	#0x10000,a0		/* next segment in context */
	dbra	d1,L10

	/* program the page table */
	movw	#0x3ff,d1		/* complete address space */
	clrw	d0			/* page not accessed or writen */
	movl	#PAGREGBASE,a0
L11:	movw	d0,a0@
	addw	#4,d0
	addw	#0x1000,a0		/* next page */
	dbra	d1,L11

#ifdef	PROMBOOT
/*
 *	Initialize all of memory on first boot
 */
	cmpl	#0xFFFFFFFF,d6
	jne	L114
	lea	pc@(imem),a0
L111:	movw	#0x7fff,d0
L112:	dbra	d0,L112
	movb	a0@+,SIO0_ADR
	jne	L111
	lea	MEMTRAP,a1
	lea	pc@(L114),a0
	movl	a0,a1@
	lea	MEMTRAP+4,a0
	movl	#0x0,d0
L113:	movl	d0,a0@
	cmpl	a0@+,d0
	jeq	L113
L114:
#endif	PROMBOOT

/*
 * Define the vector base register to point to 0.  On the 68000 the base
 * register is always zero, and an illegal instruction trap will occur if
 * you try to execute the 68010 instruction to redefine it.  Dont bother
 * cleaning up the stack after traps...
 */
	movl	#68000,d4
	lea	ILITRAP,a1
	lea	pc@(L20),a0
	movl	a0,a1@
	clrl	d0
	movl	d0,vb
	movl	#68010,d4
L20:
#ifdef	BOOT
/*
 * Size physical memory by steping through it 1/16 Meg (64K, 16 pages, 1 full 
 * segment) at a time, waiting for a fault or read/write error.  Dont look at 
 * the segment which contains the I/O pages.
 */
	/* fill in fault vector for recovery */
	lea	MEMTRAP,a1
	lea	pc@(L30),a0
	movl	a0,a1@

	/* step through all segments (except last) in 1:1 address space */
	/* dont look at frist 8 bytes of segment, they might be prom */
	movl	#0xE,a0
	movw	#0x3e,d1
	movw	#0xCACA,d0
L25:	movw	d0,a0@
	cmpw	a0@,d0
	bne	L30
	addl	#0x10000,a0
	dbra	d1,L25

/*
 * You get here either by a fault, or fall through.  Reprogram pages of logical
 * link address space to point to the last pages of physical address space. 
 */
L30:	movl	a0,d0
	andl	#0xFFF000,d0

	/* compute size of BOOT image and define stack pointer */
	movl	#_end+0xFFF,d1	
	subl	#Base,d1
	andl	#0xFFF000,d1		/* to a page boundry */
	addl	#0x4000,d1		/* add 3 pages for stack and */
	subl	d1,d0			/* back up this physical amount */
	movl	d0,d5			/* boot firewall on loading images */
	movb	#12-2,d2
	lsrl	d2,d0			/* templete, remember access bits */
	movb	#12,d2
	lsrl	d2,d1			/* number of pages to reprogram */
	movl	#PAGREGBASE+Base-0x3000,a1 /* first page table for link space */
L31:	movw	d0,a1@
	addw	#4,d0
	addw	#0x1000,a1		/* next page */
	dbra	d1,L31

/* 
 * Relocate out side of PROM (or load area) into the link space, which was 
 * just maped to the end of physical memory.
 */
	bsr	L40			/* compute source address */
L40:	movl	sp@+,d0			/* relative to current pc */
	andl	#0xFFF000,d0		/* back to last page boundry */
	movl	d0,a0
	lea	Base,a1			/* destination address */
	movl	#_edata+4,d0		/* compute image size */
	subl	#Base,d0
	lsrl	#2,d0			/* byte to long */
L41:	movl	a0@+,a1@+
	dbra	d0,L41
	jmp	L50			/* long jump */

L50:					/* running in link space */
#else	BOOT
/*	lea	INISTACK,sp		/**/
#endif	BOOT
	lea	Base,sp			/* define the stack pointer */
					/* it grows down from start of code */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
	jra	L71
L70:	movl	#tperr,a0@+
L71:	cmpl	#0x3fc,a0
	jls	L70

/* 
 * clear bss
 */
	lea	_edata,a0
	lea	_end,a1
L80:	clrl	a0@+	
	cmpl	a0,a1
	jgt	L80

/*
 * jump to main, never to return
 */
	movl	d4,_cpuchip		/* type of chip */
#ifdef	BOOT
	movl	d5,_sboot		/* start of boot in physical space */
	movl	d6,_devtp
	movl	d7,_howto
#endif	BOOT
	jsr	_main
	jsr	_exit			/* if main should return */

	/* service interrupts and traps */
tperr:	movml	#0xC0C0,sp@-		/* save [da][01] */
	jsr	_traperr
	movml	sp@+,#0x0303		/* restore [da][01] */
	tstl	_dorte			/* if dorte return from interrupt */
	jeq	__rtt
	rte

/*
 * return to PROM
 */
__rtt:	movl	#RB_ASKNAME,d7		/* Ask for name after exit */
	movl	#0xFFFF,d6		/* not a cold boot */
	movl	#0xF000,d0		/* let things cool down */
1:	dbra	d0,1b
	jmp	PROM_REBOOT

__splx: movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movb	CXR,d0
	orw	#0x01,d0
	nop
	movw	d0,CXW			/**/
	rts

__parityoff:
	movb	CXR,d0
	andw	#0xFE,d0
	nop
	movw	d0,CXW			/**/
	rts

_byterev:
	movl	sp@(4),a0		/* address of byte string */
	movl	a0,a1
	movl	sp@(8),d1		/* length of string */
	addql	#1,d1
	lsrl	#1,d1
	jra	2f

1:	movw	a1@,d0
	rolw	#8,d0
	movw	d0,a1@+
2:	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b

	movl	a1,d0
	rts


#ifdef	BOOT
/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@
#endif	BOOT

	.data
	.globl	_bdata
	.globl	_errno
	.globl  _cpuchip
	.globl	_dorte
	.globl	_hadint
_bdata:
_errno:	.long	0
_cpuchip:
	.long	68000
_dorte:	.long	0
_hadint:
	.long	0
#ifdef	BOOT
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
_howto:	.long	0
_devtp:	.long	0
_sboot: .long	0

imem:	.asciz	"Initialize all memory ...\r\n"

siotab:	.byte	0x18		/* WW0 Channel Reset			*/
	.byte	0x14		/* WW0 Reset Ext Status, Select WW4	*/
	.byte	0x44		/* WW4 X16 Clock, 1 Stop bit/char	*/
	.byte	0x13		/* WW0 Reset Ext Status, Select WW3	*/
	.byte	0xC1		/* WW3 Rx 8 bits/char, enable		*/
	.byte	0x15		/* WW0 Reset Ext Status, Select WW5	*/
	.byte	0xEA		/* WW5 Tx DTR, 8 bits/char, enable, RTS	*/
	.byte	0x11		/* WW0 Reset Ext Status, Select WW1	*/
	.byte	0x00		/* WW1 No interupts			*/
	.byte	0x00		/* WW0 Null code			*/

/* 
 * CTCTAB: Note that 1200 and 300 have the same entries in ctctab; they are 
 * distinguished by the baud rate divider in SIODVTAB. 
 */
ctctab:	
/*	.byte	13			/*  8MHz	9600	*/
	.byte  	16			/* 10MHz	9600	*/
	.byte	19			/* 12MHz		*/
	.byte	0
	.byte	0
/*	.byte	6			/*  8MHz	?????	*/
	.byte	8			/* 10MHz	19200	*/
	.byte	9			/* 12MHz	?????	*/
	.byte	0
	.byte	0
/*	.byte	104			/*  8MHz	1200	*/
	.byte	128			/* 10MHz	1200	*/
	.byte	151			/* 12MHz		*/
	.byte	0
	.byte	0
/*	.byte	104			/*  8MHz	300	*/
	.byte	128			/* 10MHz	300	*/
	.byte	151			/* 12MHz		*/
	.byte	0
	.byte	0
siodvtab:	
/*	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz	9600	*/
	.byte  	SIOW4_X16+SIOW4_1STOP	/* 10MHz	9600	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	0
	.byte	0
/*	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz	19200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	19200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	0
	.byte	0
/*	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz	1200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	1200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	0
	.byte	0
/*	.byte	SIOW4_X64+SIOW4_1STOP	/*  8MHz	300	*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 10MHz	300	*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 12MHz		*/
	.byte	0
	.byte	0
#endif	BOOT
