#include "vb.h"
#if NVB > 0  ||  Nvb > 0
#ifndef	NVB
#define	NVB	Nvb
#endif	NVB
#include "enetfilter.h"

/*
 * Integrated Solutions VME bus interprocessor communications driver
 *  (an ethernet driver without the coax)
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/protosw.h"
#include "../h/ioctl.h"
#include "../h/socket.h"
#include "../h/vmmac.h"
#include "../h/errno.h"
#include "../h/time.h"
#include "../h/kernel.h"
#include "../h/uio.h"
#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#include "../netpup/pup.h"
#if	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kif/enet.h"
#endif	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kdev/qbvar.h"
#include "../machine/reg.h"
#include "../h/Wipc.h"
#include "../is68kif/if_ring.h"

/*#define	VBDEBUG	1	/* */

extern	char vb[];
#define VBADDR0	(&vb[1024*1024])
#define VBADDR1	(&vb[0])
#define	VBPHYS	0xE00000	/* physical address */
u_short	*vbstd[] = { (u_short *)VBADDR0, (u_short *)VBADDR1, 0 };
/*
 * possible graphics processor address tuples
 */
struct gp_addr_tuple {
	ushort		*dm;		/* display memory */
	ushort 		*addr;		/* gip address */
} static gp_addrs[8] = {
#ifdef	M68020
	{(ushort *)0xE00000, (ushort *)0xFFC000},
	{(ushort *)0xD00000, (ushort *)0xFF8000},
	{(ushort *)0xC00000, (ushort *)0xFF4000},
	{(ushort *)0xB00000, (ushort *)0xFF0000},
	{(ushort *)0xA00000, (ushort *)0xFEC000},
	{(ushort *)0x900000, (ushort *)0xFE8000},
	{(ushort *)0x800000, (ushort *)0xFE4000},
	{(ushort *)0x700000, (ushort *)0xFE0000},
#else	M68020
	{(ushort *)0xE00000, (ushort *)0x7FC000},
	{(ushort *)0xD00000, (ushort *)0x7F8000},
	{(ushort *)0xC00000, (ushort *)0x7F4000},
	{(ushort *)0xB00000, (ushort *)0x7F0000},
	{(ushort *)0xA00000, (ushort *)0x7EC000},
	{(ushort *)0x900000, (ushort *)0x7E8000},
	{(ushort *)0x800000, (ushort *)0x7E4000},
	{(ushort *)0x700000, (ushort *)0x7E0000},
#endif	M68020
};
struct  qb_device *vbinfo[NVB];
#define	BCBBUFSIZ	((8 * 1024) + 128)
extern	int vbnum;

int     vbprobe(), vbattach(), vbintr(), vbslave();
struct  qb_driver VBdriver = {
	vbprobe, vbslave, vbattach, vbstd, "vb", vbinfo, "VB"
};

int     vbinit(),vbioctl(),vboutput(),vbreset();
struct  mbuf *vbget();
extern  struct ifnet loif;

#define	NCPU	9	/* number of input rings to initialize */
#define	MAXCPU	32	/* known elsewhere -- don't change! */
struct	icpu {
	unsigned char		ic_active[MAXCPU];
	short			ic_ncpu;
	struct ether_addr	ic_ethaddr;	
	struct ring		*ic_freeringp;
	struct ring		*ic_inputringp[MAXCPU];
	unsigned short		*ic_intrinfo[MAXCPU];
};
#define	ICPUX(p) (((struct ether_header *)(p))->ether_dhost.ether_addr_octet[5])
#define	INTR_VB(x,p)		{ if (x != vbnum  &&  p) *p = 0; }
#define	ItoKval(p,type,base)	((type)((int)(p) + (int)(base)))
#define	KtoIval(p,type,base)	((type)((int)(p) - (int)(base)))
#define	ItoK(p,type,base)	((p) = ItoKval(p,type,base))
#define	KtoI(p,type,base)	((p) = KtoIval(p,type,base))
#ifdef	M68020
#define	INTADDR(i)	((unsigned short *)(0xFCC000 + (2 * i)))
#else	not M68020
#define	INTADDR(i)	0
#endif	not M68020

/*
 * Net software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * vs_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface, its address, ...
 */
struct  vb_softc {
	struct		arpcom vs_ac;	/* common ethernet structures */
	int		vs_size;
	unsigned char	vs_state;
	struct icpu	*vs_icpup;
	struct ring	*vs_freeringp;
	struct ring	*vs_inputringp;
#if	NENETFILTER > 0 || Nenetfilter > 0
	short		vs_enetunit;	/* unit number for enet filtering */
	short		vs_enetinit;	/* enet interface is initialized */
#endif	NENETFILTER > 0 || Nenetfilter > 0
} vb_softc[NVB];
#define vs_if           vs_ac.ac_if     /* network-visible interface */
#define vs_enaddr       vs_ac.ac_enaddr /* hardware ethernet address */

#define	MINPKTSIZE	60

/*
 * Probe for device.
 */

vbprobe(reg, unit)
  caddr_t reg;
  int unit;
  {
	register int i, n;
	struct vb_softc *vs = &vb_softc[unit];
	extern int cvec;
	register struct gp_addr_tuple *gpp;
	caddr_t vbphys;

	/*
	 * First see if the specified address even exists.
	 */
	if (badaddr(reg, 2))
		return 0;

	/*
	 * Make sure it's not actually a graphics frame buffer.
	 */
	vbphys = (caddr_t)VBPHYS + (reg - (caddr_t)vb);
	for (gpp = gp_addrs;  gpp < &gp_addrs[8];  gpp += 1)
		if (vbphys >= (caddr_t)gpp->dm  &&
		    vbphys < (caddr_t)gpp->dm + 0x100000  &&
		    !badaddr(gpp->addr, 2) && badaddr(gpp->addr + 1, 1))
			return 0;

	/*
	 * For now, icpu region cannot extend across a megabyte boundry.
	 */
	n = 0x100000 - ((int)VBPHYS & 0x0FFFFF);

	/*
	 * See just how much memory is really there.
	 */
	vs->vs_icpup = (struct icpu *)reg;
	for (i = 0;  i < n;  i += 4096, reg += 4096) {
		if (badaddr(reg, 2))
			break;
	}
	cvec = 0;
	/*
	 * Return the amount of memory we found.
	 */
	return vs->vs_size = i;
}

vbslave()
  {
	return 1;
}

/*
 * Interface exists: make available by filling in network interface
 * record.  System will initialize the interface when it is ready
 * to accept packets. 
 */
vbattach(md)
  register struct qb_device *md;
  {
	struct vb_softc *vs = &vb_softc[md->qi_unit];
	register struct ifnet *ifp = &vs->vs_if;
	struct sockaddr_in *sin;
	int icpux;
	extern short fastclock;
	int s;

	if ((icpux = vbconnect(md->qi_unit)) < 0)
		return;
	s = spl7();
	vs->vs_freeringp = vs->vs_icpup->ic_freeringp;
	ItoK(vs->vs_freeringp, struct ring *, vs->vs_icpup);
	vs->vs_inputringp = vs->vs_icpup->ic_inputringp[icpux];
	ItoK(vs->vs_inputringp, struct ring *, vs->vs_icpup);
	splx(s);
#ifndef	M68020
	fastclock = 3;
#endif	M68020
	vbgetaddr(md->qi_unit, icpux);
	printf("	(%d.%d.%d.%d.%d.%d)",
		vs->vs_enaddr.ether_addr_octet[0],
		vs->vs_enaddr.ether_addr_octet[1],
		vs->vs_enaddr.ether_addr_octet[2],
		vs->vs_enaddr.ether_addr_octet[3],
		vs->vs_enaddr.ether_addr_octet[4],
		vs->vs_enaddr.ether_addr_octet[5]);
	printf("    %mM @ 0x%x\n", vs->vs_size, svtop(vs->vs_icpup));
	ifp->if_unit = md->qi_unit;
	ifp->if_name = "vb";
	ifp->if_mtu = BCBBUFSIZ;		/* was ETHERMTU */
	sin = (struct sockaddr_in *)&ifp->if_addr;
	sin->sin_family = AF_INET;
	ifp->if_init = vbinit;
	ifp->if_ioctl = vbioctl;
	ifp->if_output = vboutput;
	ifp->if_reset = vbreset;
	if_attach(ifp);
}

vbreboot()	/* mark a vb inactive; called from reboot and panic */
  {
	register struct vb_softc *vs = vb_softc;
	register struct bcb *bcbp;

	if (vbnum) {
		if ( vs->vs_icpup ) {
		    vs->vs_icpup->ic_active[vbnum] = 0;
		    if (vs->vs_inputringp)
			while(bcbp = (struct bcb *)ringget(vs->vs_inputringp))
				ringput(vs->vs_freeringp, bcbp);
		}
	}
}

/*
 * Reset of interface after completion of initialization or bus reset.
 */
vbreset(unit)
  int unit;
  {
	register struct qb_device *md;

	if (unit >= NVB || (md = vbinfo[unit]) == 0 || md->qi_alive == 0)
		return;
	vbinit(unit);
}

/*
 * Initialization of interface: clear pending operations.
 */
vbinit(unit)
  int unit;
  {
	struct vb_softc *vs = &vb_softc[unit];
	struct ifnet *ifp = &vs->vs_if;
	struct sockaddr_in *sin = (struct sockaddr_in *)&ifp->if_addr;

	if ((vs->vs_if.if_flags & IFF_RUNNING) == 0)
		vs->vs_if.if_flags |= IFF_UP | IFF_RUNNING;
#ifdef	WIPC
	if (sin->sin_addr.s_addr == 0)		/* address still unknown */
		return;
#endif	WIPC
#if	NENETFILTER > 0 || Nenetfilter > 0
	if ((vs->vs_if.if_flags & IFF_UP)  &&  !vs->vs_enetinit) {
	    	struct endevp enp;
	    
		vs->vs_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(vs->vs_enaddr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		*((struct ether_addr *)enp.end_addr) = vs->vs_enaddr;
		*((struct ether_addr *)enp.end_broadaddr) = etherbroadcastaddr;
	    	vs->vs_enetunit = enetattach(&vs->vs_if, &enp);
	}
#endif	NENETFILTER > 0 || Nenetfilter > 0
	if_rtinit(&vs->vs_if, RTF_UP);
	arpwhohas(&vs->vs_ac, &sin->sin_addr);
}

vbcheck()
  {
	register int unit;
	register struct vb_softc *vs = vb_softc;
	struct qb_device **vb = vbinfo;

	for (unit = 0;  unit < NVB;  unit += 1, vs += 1, vb += 1) {
		register struct bcb *bcbp;

		if (*vb == 0  ||  vs->vs_inputringp == NULL)
			continue;
/*		if ((vs->vs_if.if_flags & IFF_UP) == 0)	/* */
/*			continue;			/* */
		if(!ringempty(vs->vs_inputringp)) {
			setsoftnet();
			return 1;
		}
	}
	return 0;
}

/*
 * Interface interrupt.
 */
vbintr()
  {
	register int unit;
	register struct vb_softc *vs = vb_softc;
	struct qb_device **vb = vbinfo;
	int s;

	for (unit = 0;  unit < NVB;  unit += 1, vs += 1, vb += 1) {
		register struct bcb *bcbp;

		if (*vb == 0  ||  vs->vs_inputringp == NULL)
			continue;
/*		if ((vs->vs_if.if_flags & IFF_UP) == 0)	/* */
/*			continue;			/* */
		while(bcbp = (struct bcb *)ringget(vs->vs_inputringp)) {
			ItoK(bcbp, struct bcb *, vs->vs_icpup);
#ifdef	VBDEBUG
printf("vbintr: bcbp=0x%x ringget ", bcbp);
#endif	VBDEBUG
			vbread(vs, bcbp);
#ifdef	VBDEBUG
printf("...vbintr: vbread ");
#endif	VBDEBUG
			KtoI(bcbp, struct bcb *, vs->vs_icpup);
			ringput(vs->vs_freeringp, bcbp);
#ifdef	VBDEBUG
printf("...vbintr: ringput!\n");
#endif	VBDEBUG
		}
	}
}

vbread(vs, bcbp)
  struct vb_softc *vs;
  register struct bcb *bcbp;
  {
	register struct ether_header *vb;
	struct mbuf *m;
	int len, off, resid, vbtype;
	register struct ifqueue *inq;
	unsigned char *bp;

	vs->vs_if.if_ipackets++;
	/*
	 * Get input data length.
	 * Get pointer to ethernet header (in input buffer).
	 * Deal with trailer protocol: if type is PUP trailer
	 * get true type from first 16-bit word past data.
	 * Remember that type was trailer by setting off.
	 */
	len = bcbp->b_len - sizeof(struct ether_header);
	vb = (struct ether_header *)bcbp->b_addr;
	ItoK(vb, struct ether_header *,  vs->vs_icpup);

#define vbdataaddr(vb, off, type)       ((type)(((caddr_t)((vb)+1)+(off))))

	vbtype = vb->ether_type;
	if (vbtype >= ETHERPUP_TRAIL  &&
	    vbtype < ETHERPUP_TRAIL+ETHERPUP_NTRAILER) {
		off = (vbtype - ETHERPUP_TRAIL) * 512;
		if (off >= ETHERMTU)
			return;	/* sanity */
		vbtype = *vbdataaddr(vb, off, u_short *);
		resid = *(vbdataaddr(vb, off+2, u_short *));

		if (off + resid > len)
			return;	/* sanity */
		len = off + resid;
	} else
		off = 0;

	if (len == 0)
		return;

#ifdef	WIPC
	if (((struct sockaddr_in *)&vs->vs_if.if_addr)->sin_addr.s_addr == 0  &&
	    vbtype != ETHERPUP_WIPCTYPE)
		return;
#endif	WIPC

	/*
	 * Pull packet off interface.  Off is nonzero if packet
	 * has trailing header; vbget will then force this header
	 * information to be at the front, but we still have to drop
	 * the type and length which are at the front of any trailer data.
	 */
	bp = (unsigned char *)bcbp->b_addr;
	ItoK(bp, unsigned char *,  vs->vs_icpup);
	m = vbget(bp, len, off);
	if (m == 0)
		return;

	if (off) {
		m->m_off += 2 * sizeof(u_short);
		m->m_len -= 2 * sizeof(u_short);
	}

	switch (vbtype) {
#ifdef INET
	  case ETHERPUP_IPTYPE:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;
	  case ETHERPUP_ARPTYPE:
		arpinput(&vs->vs_ac, m);
		return;
#endif
#ifdef	WIPC
	  case ETHERPUP_WIPCTYPE:
		{
			struct sockaddr sa;

			sa.sa_family = AF_UNSPEC;
			vb->ether_dhost = vb->ether_shost;
			*(struct ether_header *)sa.sa_data = *vb;
			Winput(m, &vs->vs_if, &sa);
			return;
		}
#endif	WIPC
	  default:
#if	NENETFILTER > 0 || Nenetfilter > 0
		if (vs->vs_enetinit && vs->vs_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all.  Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				bcopy((struct ether_header*)&(vb->ether_dhost),
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				mtop->m_next = m;
				enetFilter(vs->vs_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				return;
			}
		}
#endif	NENETFILTER > 0 || Nenetfilter > 0
		m_freem(m);
		return;
	}

	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
		return;
	}
	IF_ENQUEUE(inq, m);
}

/*
 * Net output routine.
 * Encapsulate a packet of type family for the local net.
 * Use trailer local net encapsulation if enough data in first
 * packet leaves a multiple of 512 bytes of data in remainder.
 */
vboutput(ifp, m0, dst)
  struct ifnet *ifp;
  struct mbuf *m0;
  struct sockaddr *dst;
  {
	register struct vb_softc *vs = &vb_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *vb;
	register int off;
	int type, s, error;
	struct ether_addr edst;
	struct in_addr idst;

/*	if ((vs->vs_if.if_flags & IFF_UP) == 0) {	/* not ready yet */
/*		m_freem(m0);				/* */
/*		return 0;				/* */
/*	}						/* */
	switch( dst->sa_family ) {
#ifdef INET
	  case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&vs->vs_ac, m, &idst, &edst))
			return ( 0 );     /* if not yet resolved */

		off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if ((ifp->if_flags & IFF_NOTRAILERS) == 0  &&
		    off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof(u_short)) {
			type = ETHERPUP_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof(u_short);
			m->m_len += 2 * sizeof(u_short);
			*mtod(m, u_short *) = ETHERPUP_IPTYPE;
			*(mtod(m, u_short *) + 1) = m->m_len;
			goto gottrailertype;
		}
		type = ETHERPUP_IPTYPE;
		off = 0;
		goto gottype;
#endif
	  case AF_IMPLINK:
		/* should do some ARP here? */
		vb = mtod(m, struct ether_header *);
		goto gotheader;
	  case AF_UNSPEC:
		vb = (struct ether_header *)dst->sa_data;
		edst = vb->ether_dhost;
		type = vb->ether_type;
		goto gottype;
	  default:
		error = EAFNOSUPPORT;
		goto bad;
	}
  gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet
	 * (control information) to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;
  gottype:
	/*
         * Add local net header.  If no space in first mbuf,
         * allocate another.
         */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof(struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_DATA);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof(struct ether_header);
	} else {
		m->m_off -= sizeof(struct ether_header);
		m->m_len += sizeof(struct ether_header);
	}
	vb = mtod(m, struct ether_header *);
	vb->ether_dhost = edst;
	vb->ether_type = type;
  gotheader:
	vb->ether_shost = vs->vs_enaddr;

	/*
	 * Queue message on interface if possible 
	 */
	if (vbput(ifp->if_unit, m)) {
		error = ENOBUFS;
		m0 = m;
		goto bad;
	}
	vs->vs_if.if_opackets++;
	return 0;

  bad:
	m_freem(m0);
	return error;
}

/*
 * Routine to copy from mbuf chain to shared memory buffer.
 */
vbput(unit, m)
  int unit;
  struct mbuf *m;
  {
	register struct bcb *bcbp;
	register struct icpu *addr = (struct icpu *)vbinfo[unit]->qi_mi->qm_addr;
	register struct mbuf *mp;
	register u_char *bp;
	register unsigned len;

	if ((bcbp = (struct bcb *)ringget(vb_softc[unit].vs_freeringp)) == NULL)
		return 1;
	ItoK(bcbp, struct bcb *, addr);
	bcbp->b_len = 0;
	bp = (u_char *)bcbp->b_addr;
	ItoK(bp, u_char *,  addr);
	for (mp = m; mp; mp = mp->m_next) {
		if((len = mp->m_len) == 0)
			continue;
		bcopy(mtod(mp, u_char *), bp, len);
		bp += len;
		bcbp->b_len += len;
	}
	m_freem(m);
	bcbp->b_len = max(MINPKTSIZE, bcbp->b_len);
	bp = (u_char *)bcbp->b_addr;
	ItoK(bp, u_char *,  addr);
	vbxmit(addr, bcbp, ICPUX(bp));
	return 0;
}

vbxmit(addr, bcbp, x)
  register struct icpu *addr;
  register struct bcb *bcbp;
  register int x;
  {
	register struct ring *freeringp, *inputringp;

#ifdef	VBDEBUG
printf("vbxmit: bcbp=0x%x ", bcbp);
#endif	VBDEBUG
	freeringp = addr->ic_freeringp;
	ItoK(freeringp, struct ring *, addr);
	if (x < 0  ||  x >= MAXCPU) {
		register u_char *bp;

		bp = (u_char *)bcbp->b_addr;
		ItoK(bp, u_char *,  addr);
		for (x = MAXCPU - 1;  x > 0;  x -= 1) {
			register struct bcb *bcbp0;
			register u_char *bp0;

			if (addr->ic_active[x] == 0  ||
			    addr->ic_inputringp[x] == NULL)
				continue;
			if ((bcbp0 = (struct bcb *)ringget(freeringp)) == NULL)
				break;
			ItoK(bcbp0, struct bcb *, addr);
			bp0 = (u_char *)bcbp0->b_addr;
			ItoK(bp0, u_char *,  addr);
			bcbp0->b_len = bcbp->b_len;
			bcopy(bp, bp0, bcbp->b_len);
#ifdef	VBDEBUG
printf("...vbxmit: 0x%x to %d ", bcbp0, x);
#endif	VBDEBUG
			KtoI(bcbp0, struct bcb *, addr);
			inputringp = addr->ic_inputringp[x];
			ItoK(inputringp, struct ring *, addr);
			if (ringput(inputringp, bcbp0) == 1)
				INTR_VB(x, addr->ic_intrinfo[x]);
#ifdef	VBDEBUG
printf("ringput ");
#endif	VBDEBUG
		}
	}
#ifdef	VBDEBUG
printf("...vbxmit: 0x%x to %d ", bcbp, x);
#endif	VBDEBUG
	KtoI(bcbp, struct bcb *, addr);
	inputringp = addr->ic_inputringp[x];
	ItoK(inputringp, struct ring *, addr);
	if (x > 0  &&  addr->ic_active[x] == 0)
		inputringp = freeringp;
	if (ringput(inputringp, bcbp) == 1)
		INTR_VB(x, addr->ic_intrinfo[x]);
#ifdef	VBDEBUG
printf("ringput!\n");
#endif	VBDEBUG
}

/*
 * Routine to copy from shared memory into mbufs.
 */
struct mbuf *
vbget(bp, totlen, off0)
  register unsigned char *bp;
  int totlen, off0;
  {
	register struct mbuf *m;
	register int off = off0;
	register unsigned char *cp = bp + sizeof(struct ether_header);
	struct mbuf *top = 0;
	struct mbuf **mp = &top;
	int len;

	while (totlen > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0)
			goto bad;
		if (off) {
			len = totlen - off;
			cp = bp + sizeof(struct ether_header) + off;
		} else
			len = totlen;
		m->m_len = MIN(MLEN, len);
		m->m_off = MMINOFF;
		len = m->m_len;
		bcopy(cp, mtod(m, u_char *), len);
		cp += len;
		*mp = m;
		mp = &m->m_next;
		if (off == 0) {
			totlen -= len;
			continue;
		}
		off += len;
		if (off == totlen) {
			cp = bp + sizeof(struct ether_header);
			off = 0;
			totlen = off0;
		}
	}
	return top;
bad:
	m_freem(top);
	return (struct mbuf *)0;
}

vb_trfs_xmit(ifp, dst, ip, mp, p, len, seg)
  struct ifnet *ifp;
  struct sockaddr *dst;
  struct ipc *ip;
  struct request *mp;
  register char *p;
  register int len;
  int seg;
  {
	register struct bcb *bcbp;
	register struct ether_header *vb;
	register struct Wrproc *wp;
	register char *bp;
	struct vb_softc *vs = &vb_softc[ifp->if_unit];
	struct icpu *addr = (struct icpu *)vbinfo[ifp->if_unit]->qi_mi->qm_addr;

	if ((bcbp = (struct bcb *)ringget(vs->vs_freeringp)) == 0)
		return 1;
	ItoK(bcbp, struct bcb *, addr);
	vb = (struct ether_header *)bcbp->b_addr;
	ItoK(vb, struct ether_header *,  addr);
	vb->ether_dhost = ((struct ether_header *)dst->sa_data)->ether_dhost;
	vb->ether_shost = vs->vs_enaddr;
	vb->ether_type = ((struct ether_header *)dst->sa_data)->ether_type;
	wp = (struct Wrproc *)&vb[1];
	wp->Wp_next = (struct Wrproc *)0;
	wp->Wp_ipc = *ip;	/* structure assignment */
	if (mp)
		wp->Wp_msg = *mp;	/* structure assignment */
	bp = (char *)&wp[1];
	switch(seg) {
	  case RCODE_USER_SEGMENT:
		copyin(p, bp, len);
		break;
	  case RCODE_KERN_SEGMENT:
		bcopy(p, bp, len);
		break;
	  case RCODE_PHYS_SEGMENT:
		pcopyin(p, bp, len);
		break;
	}
	bcbp->b_len = sizeof *vb + sizeof *wp + len;
	bp = bcbp->b_addr;
	ItoK(bp, char *,  addr);
	vbxmit(addr, bcbp, ICPUX(bp));
}

/*
 * Process an ioctl request.
 *    this can be called via the "socket" route for SIOCSIFADDR or
 *	by the cdev/inode route for SIOCSIFCCFWR/RD
 *
 */
vbioctl(ifp, cmd, data)
  register struct ifnet *ifp;
  int cmd;
  caddr_t data;
  {
	register struct ifreq *ifr = (struct ifreq *)data;
	int s = splimp(), error = 0;
	struct sockaddr_in *sin;
	struct sockaddr *sa;
	struct vb_softc *vs;
	struct icpu *addr;
	struct config_entry *cf;

	switch (cmd) {
	  case SIOCSIFADDR:
		vs = &vb_softc[ifp->if_unit];
		sa = (struct sockaddr *)&ifr->ifr_addr;
		if (sa->sa_family == AF_UNSPEC) {
			if (sa->sa_data[0] & 1) { /*broad or multi-cast*/
				splx(s);
				return EINVAL;
			}
			vs->vs_enaddr = *(struct ether_addr *)sa->sa_data;
			vbinit(ifp->if_unit);
			break;
		}
		sin = (struct sockaddr_in *)&ifr->ifr_addr;
		if (sin->sin_family != AF_INET) {
			splx(s);
			return EINVAL;
		}
		if (ifp->if_flags & IFF_RUNNING)
			if_rtinit(ifp, -1);     /* delete previous route */
		vbsetaddr(ifp, sin);
		vbinit(ifp->if_unit);
		break;
	  default:
		error = EINVAL;
	}
	splx(s);
	return error;
}

vbsetaddr(ifp, sin)
  register struct ifnet *ifp;
  register struct sockaddr_in *sin;
  {

	ifp->if_addr = *(struct sockaddr *)sin;
	ifp->if_net = in_netof(sin->sin_addr);
	ifp->if_host[0] = in_lnaof(sin->sin_addr);
	sin = (struct sockaddr_in *)&ifp->if_broadaddr;
	sin->sin_family = AF_INET;
	sin->sin_addr = if_makeaddr(ifp->if_net, INADDR_ANY);
/*	ifp->if_flags |= IFF_BROADCAST | IFF_NOTRAILERS;	/* WTF */
	ifp->if_flags |= IFF_BROADCAST;
}


/*
 * Get the ethernet addr & put it in vb_softc.
 */
vbgetaddr(unit, x)
  int unit, x;
  {
	register struct vb_softc *vs = &vb_softc[unit];

	vs->vs_enaddr = vs->vs_icpup->ic_ethaddr;
	ICPUX(&vs->vs_enaddr) = x;
}

#define	VB_DELAY	200000

struct bcb *
bcbinit(bcbp, addr, bufsiz)
  register struct bcb *bcbp;
  caddr_t addr;
  int bufsiz;
  {
	bcbp->b_link = (struct bcb *)0;
	bcbp->b_stat = 0;
	bcbp->b_len = bufsiz;
	bcbp->b_addr = addr;
	bcbp->b_msglen = 0;
	bcbp->b_reserved = 0;
	return bcbp;
}

int
vbconnect(unit)
  int unit;
  {
	register struct icpu *icpup = vb_softc[unit].vs_icpup;
	register unsigned char *p = &icpup->ic_active[0];
	register int i;

	*p = 0;
	for (i = VB_DELAY;  i >= 0;  i -= 1)
		if (*p)
			return vbjoin(icpup);
	if (!tas(p))
		return vbjoin(icpup);
	return vbinitialize(unit, icpup, vb_softc[unit].vs_size);
}

int
vbinitialize(unit, icpup, vbsize)
  int unit;
  unsigned long vbsize;
  register struct icpu *icpup;
  {
	register unsigned char *p = &icpup->ic_active[0];
	register caddr_t q;
	register struct ring *freeringp;
	register int i;
	static struct ether_addr proto_addr = { 60, 123, 0, 0, 0, 0 };

	for (i = 1;  i < MAXCPU;  i += 1) {
		p[i] = 0xFF;
		icpup->ic_inputringp[i] = (struct ring *)0;
		icpup->ic_intrinfo[i] = 0;
	}
	icpup->ic_ncpu = NCPU;
	icpup->ic_ethaddr = proto_addr;

	q = (caddr_t)&icpup[1];
	ringinit((freeringp = (struct ring *)q), 256);
	icpup->ic_freeringp = freeringp;
	KtoI(icpup->ic_freeringp, struct ring *, icpup);
	q += sizeof(struct ring256);
	for (i = 0;  i < NCPU;  i += 1) {
		ringinit((icpup->ic_inputringp[i] = (struct ring *)q), 32);
		KtoI(icpup->ic_inputringp[i], struct ring *, icpup);
		q += sizeof(struct ring32);
	}
	while (q + sizeof(struct bcb) + BCBBUFSIZ <= (caddr_t)icpup + vbsize) {
		struct bcb *bcbp = bcbinit(q, q + sizeof *bcbp, BCBBUFSIZ);
		KtoI(bcbp->b_addr, char *, icpup);
		KtoI(bcbp, struct bcb *, icpup);
		ringput(freeringp, bcbp);
		q += sizeof(struct bcb) + BCBBUFSIZ;
	}

	for (i = 1;  i < NCPU;  i += 1)
		p[i] = 0;
	vb_softc[unit].vs_state = 0xFF;
	vbtictoc(hz/60);
	icpup->ic_intrinfo[0] = INTADDR(0);
	return 0;
}

/*
 * Some other processor just changed vbaddr->ic_active[0] to a nonzero value.
 *  This indicates that the icpu region is either initialized or about to
 *  become initialized.  Wait for vbaddr->ic_active[0] to be 0xFF, indicating
 *  that initialization is complete.  Then find and claim an available ring.
 *  Returns processor ring index, or -1.
 */
int
vbjoin(icpup)
  register struct icpu *icpup;
  {
	register unsigned char *p = &icpup->ic_active[0];
	register int i;

	if (vbnum <= 0)
		return -1;
	for (i = VB_DELAY;  i >= 0;  i -= 1) {
		if (*p == 0xFF) {
			if ((i = vbnum) > 0) {
				if (icpup->ic_inputringp[i]) {
					tas(&p[i]);
					icpup->ic_intrinfo[i] = INTADDR(i);
					return i;
				}
				return -1;
			}
			for (i = 1;  i < MAXCPU;  i++)
				if (icpup->ic_inputringp[i]  &&  tas(&p[i])) {
					icpup->ic_intrinfo[i] = INTADDR(i);
					return i;
				}
			return -1;	/* no ring available */
		}
	}
	return -1;	/* didn't get initialized */
}

/*
 * vbtictoc -- called every tic-th clock interrupt.
 *  For each active icpu, sets ic_active[0] to vs_state.
 *  This routine is executed by the major processor only,
 *  and is used to allow other processors to detect that the
 *  corresponding icpu region has been initialized.
 */
vbtictoc(tic)
  register int tic;
  {
	register struct vb_softc *vs;

	for (vs = vb_softc;  vs < &vb_softc[NVB];  vs += 1)
		if (vs->vs_icpup)
			vs->vs_icpup->ic_active[0] = vs->vs_state;
	timeout(vbtictoc, tic, tic);
}

#endif
