#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/cmap.h"
#include "../h/vmmac.h"
#include "../h/socket.h"

#include "../net/if.h"

#include "../is68kdev/qbvar.h"

struct mbuf *
if_rqbget(ifu, totlen, off0, hlen)
register u_char *ifu;
int totlen, off0, hlen;
{
	register struct mbuf *m;
	struct mbuf *top = 0, **mp = &top;
	register u_char *cp = ifu + hlen;
	register int len;
	register int off = off0;

	while (totlen > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0)
			goto bad;
		if (off) {
			len = totlen - off;
			cp = ifu + hlen + off;
		} else
			len = totlen;
		m->m_len = MIN(MLEN, len);
		m->m_off = MMINOFF;
		bcopy(cp, mtod(m, u_char *), m->m_len);
		cp += m->m_len;
		*mp = m;
		mp = &m->m_next;
		if (off) {
			off += m->m_len;
			if (off == totlen) {
				cp = ifu + hlen;
				off = 0;
				totlen = off0;
			}
		} else
			totlen -= m->m_len;
	}
	return (top);
bad:
	m_freem(top);
	return (0);
}

if_wqbput(ifu, m0)
register u_char *ifu;
register struct mbuf *m0;
{
	register struct mbuf *m = m0;
	register u_char *cp = ifu;

	while (m) {
		bcopy(mtod(m, u_char *), cp, m->m_len);
		cp += m->m_len;
		MFREE(m, m0);
		m = m0;
	}
	if ((int)cp & 1)
		*cp++ = 0;
	return (cp - ifu);
}

struct mbuf *
if_rqbadj(m, totlen, off, hlen)
  struct mbuf *m;
  {
	struct mbuf *m0;

	m_adj(m, hlen);			/* shave hlen bytes off beginning */
	if (off == 0)
		return m;
	if ((m0 = m_copy(m, off, totlen - off)) == NULL) {
		m_freem(m);
		return NULL;
	}
	m_adj(m, -off);
	m0->m_next = m;
	return m0;
}
