/*#define ILDEBUG 1	/* */
#ifdef ILDEBUG
int ildebug = ILDEBUG;
#endif ILDEBUG

/*	if_il.c	6.4	84/03/22	*/

#include "il.h"
#include "enetfilter.h"

#if	NIL > 0 || Nil > 0 
/*
 * Interlan Ethernet Communications Controller interface
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/protosw.h"
#include "../h/socket.h"
#include "../h/vmmac.h"
#include "../h/ioctl.h"
#include "../h/errno.h"

#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#include "../netpup/pup.h"

#include "../is68kif/if_qb.h"
#include "../is68kif/if_il.h"
#include "../is68kif/if_ilreg.h"
#if	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kif/enet.h"
#endif	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kdev/qbvar.h"

int	ilprobe(), ilslave(), ilattach(), ilrint(), ilcint();
struct	qb_device *ilinfo[Nil];
u_short *ilstd[] = { (u_short *)0x3fe800, (u_short *)0x3fe810, 
		     (u_short *)0x3fe820, 0 };
struct	qb_driver ILdriver =
	{ ilprobe, ilslave, ilattach, ilstd, "il", ilinfo, "IL"};
#define	ILUNIT(x)	minor(x)
#define ilwait(x)	while ((x->il_csr & IL_CDONE) == 0)
int	ilinit(),iloutput(),ilioctl(),ilreset(),ilwatch();

/*
 * Ethernet software status per interface: Each interface is referenced by a 
 * network interface structure, is_if, which the routing code uses to locate the
 * interface. This structure contains the output queue for the interface, and 
 * its address.
 */
struct	il_softc {
	struct	arpcom is_ac;		/* Ethernet common part */
#define	is_if	is_ac.ac_if		/* network-visible interface */
#define	is_addr	is_ac.ac_enaddr		/* hardware Ethernet address */
	int	is_flags;
#define	ILF_OACTIVE	0x1		/* output is active */
#define	ILF_RCVPENDING	0x2		/* start rcv in ilcint */
#define	ILF_STATPENDING	0x4		/* stat cmd pending */
	short	is_lastcmd;		/* can't read csr, so must save it */
	short	is_scaninterval;	/* interval of stat collection */
#define	ILWATCHINTERVAL	60		/* once every 60 seconds */
	struct	il_stats is_stats;	/* holds on-board statistics */
	struct	il_stats is_sum;	/* summation over time */
	char	il_rbuf[ETHERMTU+50];	/* rec buffer */
	char	il_tbuf[ETHERMTU+50];	/* xmit buffer */
#if	NENETFILTER > 0 || Nenetfilter > 0
	short	is_enetunit;		/* unit number for enet filtering */
	short	is_enetinit;		/* enet inetrface is initialized */
#endif	NENETFILTER > 0 || Nenetfilter > 0
} il_softc[Nil];

ilprobe(iladdr)
struct ildevice *iladdr;
{
	extern int cvec;
	register int i, cv;

	if (iladdr->il_csr == 0)
		return (0);
	cv = cvec;
	iladdr->il_csr = ILC_OFFLINE|IL_CIE;
	DELAY(20000);				/* wait for interupt */
	i = iladdr->il_csr;			/* clear CDONE */
	if (cvec != cv)
		cvec -= 4;
	return (sizeof(struct ildevice));
}

ilslave(qi)
struct qb_device *qi;
{
	return (1);
}

/*
 * Interface exists: make available by filling in network interface record.  
 * System will initialize the interface when it is ready to accept packets.  
 * A STATUS command is done to get the ethernet address and other interesting 
 * data.
 */
ilattach(qi)
struct qb_device *qi;
{
	register struct il_softc *is = &il_softc[qi->qi_unit];
	register struct ifnet *ifp = &is->is_if;
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	struct sockaddr_in *sin;
	int i;

	ifp->if_unit = qi->qi_unit;
	ifp->if_name = "il";
	ifp->if_mtu = ETHERMTU;

	/*
	 * Reset the board and map the statistics buffer onto the Unibus.
	 */
	iladdr->il_csr = ILC_RESET;
	ilwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il%d: reset failed, csr=%b\n", qi->qi_unit,
			iladdr->il_csr, IL_BITS);
	i = (int)&is->is_stats;
	iladdr->il_bar = loword(i);
	iladdr->il_bcr = sizeof (struct il_stats);
	iladdr->il_bae = hiword(i);
	iladdr->il_csr = ILC_STAT;
	ilwait(iladdr);
	if (iladdr->il_csr&IL_STATUS)
		printf("il%d: status failed, csr=%b\n", qi->qi_unit,
			iladdr->il_csr, IL_BITS);
	byterev(&is->is_stats, sizeof(struct il_stats));
	printf("	(%d.%d.%d.%d.%d.%d)",
		is->is_stats.ils_addr.ether_addr_octet[0],
		is->is_stats.ils_addr.ether_addr_octet[1],
		is->is_stats.ils_addr.ether_addr_octet[2],
		is->is_stats.ils_addr.ether_addr_octet[3],
		is->is_stats.ils_addr.ether_addr_octet[4],
		is->is_stats.ils_addr.ether_addr_octet[5]);
	is->is_addr = is->is_stats.ils_addr;
	sin = (struct sockaddr_in *)&ifp->if_addr;
	sin->sin_family = AF_INET;
	ifp->if_init = ilinit;
	ifp->if_output = iloutput;
	ifp->if_ioctl = ilioctl;
	ifp->if_reset = ilreset;
	if_attach(ifp);
}

/*
 * Reset of interface after reset. 
 */
ilreset(unit)
int unit;
{
	register struct qb_device *qi;

	if (unit >= Nil || (qi = ilinfo[unit]) == 0 || qi->qi_alive == 0 )
		return;
	printf(" il%d", unit);
	ilinit(unit);
}

/*
 * Initialization of interface; clear recorded pending operations.
 */
ilinit(unit)
int unit;
{
	register struct il_softc *is = &il_softc[unit];
	register struct qb_device *qi = ilinfo[unit];
	register struct ildevice *iladdr;
	register struct ifnet *ifp = &is->is_if;
	register struct sockaddr_in *sin;
	int s;
	int i;

	sin = (struct sockaddr_in *)&ifp->if_addr;
	if (sin->sin_addr.s_addr == 0)		/* address still unknown */
		return;
	if (ifp->if_flags & IFF_RUNNING)
		goto justarp;
	ifp->if_watchdog = ilwatch;
	is->is_scaninterval = ILWATCHINTERVAL;
	ifp->if_timer = is->is_scaninterval;
	iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	/*
	 * Turn off source address insertion (it's faster this way), and set 
	 * board online.
	 */
	s = splimp();
	iladdr->il_csr = ILC_OFFLINE;
	ilwait(iladdr);
	iladdr->il_csr = ILC_CISA;
	ilwait(iladdr);
	iladdr->il_csr = ILC_ONLINE;
	ilwait(iladdr);
	/*
	 * Hang receive buffer and start any pending writes by faking a transmit
	 * complete. Receive bcr is not a muliple of 4 so buffer chaining can't
	 * happen.
	 */
	i = (int)is->il_rbuf;
	iladdr->il_bar = loword(i);
	iladdr->il_bcr = sizeof(struct il_rheader) + ETHERMTU + 6;
	iladdr->il_bae = hiword(i);
	iladdr->il_csr = ILC_RCV|IL_RIE;
	ilwait(iladdr);
	is->is_flags = ILF_OACTIVE;
	is->is_if.if_flags |= IFF_UP|IFF_RUNNING;
	is->is_lastcmd = 0;
	ilcint(unit);
	splx(s);
#if	NENETFILTER > 0 || Nenetfilter > 0
	if (!is->is_enetinit) {
	    	struct endevp enp;
	    
		is->is_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(is->is_addr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		*((struct ether_addr *)enp.end_addr) = is->is_addr;
		*((struct ether_addr *)enp.end_broadaddr) = etherbroadcastaddr;
	    	is->is_enetunit = enetattach(&is->is_if, &enp);
	}
#endif	NENETFILTER > 0 || Nenetfilter > 0
justarp:
	if_rtinit(&is->is_if, RTF_UP);
	arpwhohas(&is->is_ac, &sin->sin_addr);
}

/*
 * Start output on interface. Get another datagram to send off of the interface
 * queue, and map it to the interface before starting the output.
 */
ilstart(dev)
dev_t dev;
{
        int unit = ILUNIT(dev), len;
	struct qb_device *qi = ilinfo[unit];
	register struct il_softc *is = &il_softc[unit];
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	struct mbuf *m;
	short csr;
	int i;

	IF_DEQUEUE(&is->is_if.if_snd, m);
	if (m == 0) {
		if ((is->is_flags & ILF_STATPENDING) == 0)
			return;
		i = (int)&is->is_stats;
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof (struct il_stats);
		iladdr->il_bae = hiword(i);
		csr = ILC_STAT|IL_RIE|IL_CIE;
		is->is_flags &= ~ILF_STATPENDING;
		goto startcmd;
	}
	len = if_wqbput(is->il_tbuf, m);
#ifdef	ILDEBUG
	if (ildebug) {
		char *s,*sd=(char *)&is->il_tbuf[0],
			*ss=(char *)&is->il_tbuf[6];int i,j;
		printf("%x ",*((short *)&is->il_tbuf[12]));
		printf("X ");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",ss[i]&0xFF);
		printf("	to	");
		for (i=0 ; i < 6 ; i++ ) 
			printf("%x ",sd[i]&0xFF);
		printf(" len = %x\n",len);
		s = (char *)&is->il_tbuf[14];
		j = /*MIN(36,*/len-14/*)*/;
		for (i = 0 ; i < j ; i++)
			printf("%x ",s[i]&0xFF);
		printf("\n");
	}
#endif	ILDEBUG
	byterev(is->il_tbuf, len);
	/*
	 * Ensure minimum packet length. This makes the safe assumption that 
	 * there are no virtual holes after the data. For security, it might be
	 * wise to zero out the added bytes, but we're mainly interested in 
	 * speed at the moment.
	 */
	if (len - sizeof(struct ether_header) < ETHERMIN)
		len = ETHERMIN + sizeof(struct ether_header);
	i = (int)is->il_tbuf;
	iladdr->il_bar = loword(i);
	iladdr->il_bcr = len;
	iladdr->il_bae = hiword(i);
	csr = ILC_XMIT|IL_CIE|IL_RIE;
startcmd:
	is->is_lastcmd = csr & IL_CMD;
	iladdr->il_csr = csr;
	is->is_flags |= ILF_OACTIVE;
}

/*
 * Command done interrupt.
 */
ilcint(unit)
int unit;
{
	register struct il_softc *is = &il_softc[unit];
	struct qb_device *qi = ilinfo[unit];
	register struct ildevice *iladdr = (struct ildevice *)qi->qi_mi->qm_addr;
	short csr;
	int i;

	if ((is->is_flags & ILF_OACTIVE) == 0) {
		printf("il%d: stray xmit interrupt, csr=%b\n", unit,
			iladdr->il_csr, IL_BITS);
		return;
	}
	spl6();				/* KLUDGE, I dont understand this */
	csr = iladdr->il_csr;
	/*
	 * Hang receive buffer if it couldn't be done earlier (in ilrint).
	 */
	if (is->is_flags & ILF_RCVPENDING) {
		i = (int)is->il_rbuf;
		iladdr->il_bar = loword(i);
		iladdr->il_bcr = sizeof(struct il_rheader) + ETHERMTU + 6;
		iladdr->il_bae = hiword(i);
		iladdr->il_csr = ILC_RCV|IL_RIE;
		ilwait(iladdr);
		is->is_flags &= ~ILF_RCVPENDING;
	}
	is->is_flags &= ~ILF_OACTIVE;
	csr &= IL_STATUS;
	switch (is->is_lastcmd) {
	    case ILC_XMIT:
		is->is_if.if_opackets++;
		if (csr > ILERR_RETRIES) {
			is->is_if.if_oerrors++;
			if ((is->is_if.if_oerrors%100) == 0)
				printf("il%d: 100 transmit errors\n",unit);
		}
		break;

	    case ILC_STAT:
		byterev(&is->is_stats, sizeof (struct il_stats));
		if (csr == ILERR_SUCCESS)
			iltotal(is);
		break;
	}
	ilstart(unit);
}

/*
 * Ethernet interface receiver interrupt. If input error just drop packet.
 * Otherwise purge input buffered data path and examine packet to determine 
 * type. If can't determine length from type, then have to drop packet. 
 * Othewise decapsulate packet based on type and pass to type specific 
 * higher-level input routine.
 */
ilrint(unit)
int unit;
{
	register struct il_softc *is = &il_softc[unit];
	struct ildevice *iladdr = (struct ildevice *)ilinfo[unit]->qi_mi->qm_addr;
	register struct il_rheader *il;
    	struct mbuf *m;
	int len, off, resid, s;
	register struct ifqueue *inq;
	int i;

	is->is_if.if_ipackets++;
	il = (struct il_rheader *)is->il_rbuf;
	len = il->ilr_length - sizeof(struct il_rheader);
	if ((il->ilr_status&(ILFSTAT_A|ILFSTAT_C)) || len < 46 ||
	    len > ETHERMTU) {
		is->is_if.if_ierrors++;
		if ((is->is_if.if_ierrors%100) == 0)
			printf("il%d: 100 receive errors\n",unit);
		goto setup;
	}
	byterev(&il->ilr_dhost, il->ilr_length);

	il->ilr_type = ntohs((u_short)il->ilr_type);
#define	ildataaddr(il, off, type)	((type)(((caddr_t)((il)+1)+(off))))

	/*
	 * Deal with trailer protocol: if type is PUP trailer get true type from
	 * first 16-bit word past data. Remember that type was trailer by 
	 * setting off.
	 */
#ifdef	ILDEBUG
	if (ildebug) {
		char *s, *sd=(char *)il->ilr_dhost, 
			*ss=(char *)il->ilr_shost;int i,j;
		printf("%x ",il->ilr_type);
		printf("R ");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",sd[i]&0xFF);
		printf("	from	");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",ss[i]&0xFF);
		printf(" len = %x\n",il->ilr_length);
		s = (char *)&is->il_rbuf[18];
		j = /*MIN(36,*/il->ilr_length-18/*)*/;
		for (i = 0 ; i < j ; i++)
			printf("%x ",s[i]&0xFF);
		printf("\n");
	}
#endif	ILDEBUG
	if (il->ilr_type >= ETHERPUP_TRAIL &&
	    il->ilr_type < ETHERPUP_TRAIL+ETHERPUP_NTRAILER) {
		off = (il->ilr_type - ETHERPUP_TRAIL) * 512;
		if (off >= ETHERMTU)
			goto setup;		/* sanity */
		il->ilr_type = ntohs(*ildataaddr(il, off, u_short *));
		resid = ntohs(*(ildataaddr(il, off+2, u_short *)));
		if (off + resid > len)
			goto setup;		/* sanity */
		len = off + resid;
	} else
		off = 0;
	if (len == 0)
		goto setup;
	/*
	 * Pull packet off interface.  Off is nonzero if packet has trailing 
	 * header; ilget will then force this header information to be at the 
	 * front, but we still have to drop the type and length which are at 
	 * the front of any trailer data.
	 */
	m = (struct mbuf *)if_rqbget(is->il_rbuf, len, off,
						sizeof(struct il_rheader));
	if (m == 0)
		goto setup;
	if (off) {
		m->m_off += 2 * sizeof (u_short);
		m->m_len -= 2 * sizeof (u_short);
	}
	switch (il->ilr_type) {
#ifdef	INET
	    case ETHERPUP_IPTYPE:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;

	    case ETHERPUP_ARPTYPE:
		arpinput(&is->is_ac, m);
		goto setup;
#endif	INET
#ifdef	WIPC
	    case ETHERPUP_WIPCTYPE:
		{
			struct sockaddr sa;

			sa.sa_family = AF_UNSPEC;
			il->ilr_dhost = il->ilr_shost;
			*(struct ether_header *)sa.sa_data =
					*(struct ether_header *)&il->ilr_dhost;
			Winput(m, &is->is_if, &sa);
		}
		goto setup;
#endif

	default:
#if	NENETFILTER > 0 || Nenetfilter > 0
		if (is->is_enetinit && is->is_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all.  Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				/* undo the swap done earlier */
				il->ilr_type = htons((u_short)il->ilr_type);
				/*
				 * the il_rheader pointed to by "il" contains 
				 * the received ether header.
				 */
				bcopy((struct ether_header*)&(il->ilr_dhost),
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				mtop->m_next = m;
				enetFilter(is->is_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				goto setup;
			}
		}
#endif	NENETFILTER > 0 || Nenetfilter > 0
		m_freem(m);
		goto setup;
	}

	s = splimp();
	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
	} else
		IF_ENQUEUE(inq, m);
	splx(s);

setup:
	/*
	 * Reset for next packet if possible. If waiting for transmit command 
	 * completion, set flag and wait until command completes.
	 */
	if (is->is_flags & ILF_OACTIVE) {
		is->is_flags |= ILF_RCVPENDING;
		return;
	}
	i = (int)is->il_rbuf;
	iladdr->il_bar = loword(i);
	iladdr->il_bcr = sizeof(struct il_rheader) + ETHERMTU +
						sizeof(struct ether_addr);
	iladdr->il_bae = hiword(i);
	iladdr->il_csr = ILC_RCV|IL_RIE;
	ilwait(iladdr);
}

/*
 * Ethernet output routine. Encapsulate a packet of type family for the local 
 * net. Use trailer local net encapsulation if enough data in first packet 
 * leaves a multiple of 512 bytes of data in remainder.
 */
iloutput(ifp, m0, dst)
struct ifnet *ifp;
struct mbuf *m0;
struct sockaddr *dst;
{
	int type, s, error;
	struct ether_addr edst;
	struct in_addr idst;
	register struct il_softc *is = &il_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *il;
	register int off;

	switch (dst->sa_family) {
#ifdef	INET
	    case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&is->is_ac, m, &idst, &edst))
			return (0);	/* if not yet resolved */
		off = ntohs((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		/* need per host negotiation */
		if ((ifp->if_flags & IFF_NOTRAILERS) == 0 && 
		    off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERPUP_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof (u_short);
			m->m_len += 2 * sizeof (u_short);
			*mtod(m, u_short *) = htons((u_short)ETHERPUP_IPTYPE);
			*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
			goto gottrailertype;
		}
		type = ETHERPUP_IPTYPE;
		off = 0;
		goto gottype;
#endif	INET
	    case AF_IMPLINK:
		/* should do some ARP here? */
		il = mtod(m, struct ether_header *);
		goto gotheader;

	    case AF_UNSPEC:
		il = (struct ether_header *)dst->sa_data;
		edst = il->ether_dhost;
		type = il->ether_type;
		goto gottype;

	    default:
		printf("il%d: can't handle af%d\n", ifp->if_unit,
			dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet (control information)
	 * to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;
gottype:
	/*
	 * Add local net header.  If no space in first mbuf, allocate another.
	 */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof (struct ether_header);
	} else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	il = mtod(m, struct ether_header *);
	il->ether_type = htons((u_short)type);
	il->ether_dhost = edst;

  gotheader:
	il->ether_shost = is->is_addr;

	/*
	 * Queue message on interface, and start output if interface not yet 
	 * active.
	 */
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	if ((is->is_flags & ILF_OACTIVE) == 0)
		ilstart(ifp->if_unit);
	splx(s);
	return (0);
bad:
	m_freem(m0);
	return (error);
}

/*
 * Watchdog routine, request statistics from board.
 */
ilwatch(unit)
int unit;
{
	register struct il_softc *is = &il_softc[unit];
	register struct ifnet *ifp = &is->is_if;
	int s;

	if (is->is_flags & ILF_STATPENDING) {
		ifp->if_timer = is->is_scaninterval;
		return;
	}
	s = spl7();
	is->is_flags |= ILF_STATPENDING;
	if ((is->is_flags & ILF_OACTIVE) == 0)
		ilstart(ifp->if_unit);
	splx(s);
	ifp->if_timer = is->is_scaninterval;
}

/*
 * Total up the on-board statistics.
 */
iltotal(is)
register struct il_softc *is;
{
	register u_short *interval, *sum, *end;

	interval = &is->is_stats.ils_frames;
	sum = &is->is_sum.ils_frames;
	end = is->is_sum.ils_fill2;
	while (sum < end)
		*sum++ += *interval++;
	is->is_if.if_collisions = is->is_sum.ils_collis;
}

/*
 * Process an ioctl request.
 */
ilioctl(ifp, cmd, data)
register struct ifnet *ifp;
int cmd;
caddr_t data;
{
	register struct ifreq *ifr = (struct ifreq *)data;
	int s = splimp(), error = 0;

	switch (cmd) {
	    case SIOCSIFADDR:
		if (ifp->if_flags & IFF_RUNNING)
			if_rtinit(ifp, -1);	/* delete previous route */
		ilsetaddr(ifp, (struct sockaddr_in *)&ifr->ifr_addr);
		ilinit(ifp->if_unit);
		break;

	    default:
		error = EINVAL;
	}
	splx(s);
	return (error);
}

ilsetaddr(ifp, sin)
register struct ifnet *ifp;
register struct sockaddr_in *sin;
{
	ifp->if_addr = *(struct sockaddr *)sin;
	ifp->if_net = in_netof(sin->sin_addr);
	ifp->if_host[0] = in_lnaof(sin->sin_addr);
	sin = (struct sockaddr_in *)&ifp->if_broadaddr;
	sin->sin_family = AF_INET;
	sin->sin_addr = if_makeaddr(ifp->if_net, INADDR_ANY);
	ifp->if_flags |= IFF_BROADCAST;
}
#endif	NIL > 0 || Nil > 0 
