/*#define EXDEBUG /**/
/*#define NEWEX	/* fragment support version */ /* 020KLUDGE */
/*	if_ex.c	6.1	84/03/22	*/

#include "ex.h"
#include "enetfilter.h"

#if	NEX > 0 || Nex > 0 
/*
 * Excelan EXOS 202(VME) & 203(QBUS) Link Level Ethernet Interface Drivers
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/protosw.h"
#include "../h/socket.h"
#include "../h/vmmac.h"
#include "../h/ioctl.h"
#include "../h/errno.h"

#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#include "../netpup/pup.h"

#include "../is68kif/if_qb.h"
#include "../is68kif/if_exreg.h"
#if	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kif/enet.h"
#endif	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kdev/qbvar.h"

#define	NH2X 4			/* Host to eXcelan request buffers */
#ifdef 	QBUS
#define	ONE_REPLY_BUF
#endif 	QBUS

#ifdef	ONE_REPLY_BUF
#define	NX2H 1			/* eXcelan to Host reply buffers */
#else	ONE_REPLY_BUF
#define	NX2H 4			/* eXcelan to Host reply buffers */
#endif	ONE_REPLY_BUF

#define EXWATCHINTVL	20	/* call exwatch every x secs */

int	exprobe(), exslave(), exattach(), exintr();
struct	qb_device *exinfo[NEX];
u_short *exstd[] = { 
#ifdef	QBUS
		(u_short *)0x3FE800,
		(u_short *)0x3FE810,
		(u_short *)0x3FE820,
#else	QBUS
#ifdef	M68020
		(u_short *)0xFF0000,
		(u_short *)0xFE0000,
#else	M68020
		(u_short *)0x7F0000,
		(u_short *)0x7E0000,
#endif	M68020
#endif	QBUS
		0 };

struct	qb_driver EXdriver =
	{ exprobe, exslave, exattach, exstd, "ex", exinfo, "EX"};
int	exinit(),exoutput(),exioctl(),exreset(),exwatch();
struct	ex_msg *exgetcbuf();
int	ex_ncall = 0;			/* counts calls to exprobe */
u_long	busoff;

/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure, xs_if, which 
 * the routing code uses to locate the interface.  This structure contains the 
 * output queue for the interface, its address, ... NOTE: To configure multiple
 * controllers, the sizeof this structure must be a multiple of 16 (xs_h2xhdr).
 */
struct	ex_softc {
	struct		arpcom xs_ac;	/* Ethernet common part */
#define	xs_if		xs_ac.ac_if	/* network-visible interface */
#define	xs_addr		xs_ac.ac_enaddr	/* hardware Ethernet address */
	int		xs_flags;	/* private flags */
#define	EX_XPENDING	1		/* xmit rqst pending on EXOS */
#define	EX_STATPENDING	2		/* stats rqst pending on EXOS */
	int		xs_cvec;	/* probe stores cvec here */
#if	NENETFILTER > 0 || Nenetfilter > 0
	short		xs_enetunit;	/* unit number for enet filtering */
	short		xs_enetinit;	/* enet inetrface is initialized */
#endif	NENETFILTER > 0 || Nenetfilter > 0
	struct	ex_msg	*xs_h2xnext;	/* host pointer to request queue */
	struct	ex_msg 	*xs_x2hnext;	/* host pointer to reply queue */
	u_long		xs_qbaddr;	/* map info for structs below */
#ifdef	QBUS
#define	BUSADDR(x)	(((u_long)(x)&0x3FFFFF) + busoff)
#define	P_BUSADDR(x)	(((u_long)(x)&0x3FFFF0) + busoff)
#else	QBUS
#define	BUSADDR(x)	((0x3D000000 | ((u_long)(x)&0x7FFFFF)) + busoff)
#define	P_BUSADDR(x)	((0x3D000000 | ((u_long)(x)&0x7FFFF0)) + busoff)
#endif	QBUS
	/* the following structures are always mapped in */
#define	INCORE_BASE(p)	(((u_long)(&(p)->xs_h2xhdr)) & 0xFFFFFFF0)
#define	RVAL_OFF(n)	((u_long)(&(ex_softc[0].n)) - INCORE_BASE(&ex_softc[0]))
#define	LVAL_OFF(n)	((u_long)(ex_softc[0].n) - INCORE_BASE(&ex_softc[0]))
	u_short		xs_h2xhdr;	/* EXOS's request queue header */
#define	H2XHDR_OFFSET	RVAL_OFF(xs_h2xhdr)
	u_short		xs_x2hhdr;	/* EXOS's reply queue header */
#define	X2HHDR_OFFSET	RVAL_OFF(xs_x2hhdr)
	struct ex_msg 	xs_h2xent[NH2X];/* request msg buffers */
#define	H2XENT_OFFSET	LVAL_OFF(xs_h2xent)
	struct ex_msg 	xs_x2hent[NX2H];/* reply msg buffers */
#define	X2HENT_OFFSET	LVAL_OFF(xs_x2hent)
	struct confmsg	xs_cm;		/* configuration message */
#define	CM_OFFSET	RVAL_OFF(xs_cm)
	struct stat_array xs_xsa;	/* EXOS writes stats here */
#define	SA_OFFSET	RVAL_OFF(xs_xsa)
	/* end mapped area */
	char	ex_rbuf[ETHERMTU+50];
	char	ex_tbuf[ETHERMTU+50];
#ifdef	ONE_REPLY_BUF
	char	pad[30];		/* make BUSADDR macros */
#else	ONE_REPLY_BUF
	char	pad[10];		/* make BUSADDR macros */
#endif	ONE_REPLY_BUF
} ex_softc[NEX];

exprobe(exaddr)
register struct exdevice *exaddr;
{
	extern int	cvec;
	register int	i;

#ifdef	QBUS
	/* read porta (does nothing), INTERLAN board will have IL_CDONE set */
	if (exaddr->ex_porta)
		return(0);
#endif	QBUS
	/*
	 * Reset EXOS and run self-test (should complete within 2 seconds).
	 */
	exaddr->ex_porta = EX_RESET;
	i = 1000000;
	while (((exaddr->ex_portb & EX_TESTOK) == 0) && --i) ;
	if ((exaddr->ex_portb & EX_TESTOK) == 0)
		return 0;
	cvec = freevec();
	ex_softc[ex_ncall++].xs_cvec = cvec;
	return (sizeof(struct exdevice));
}

exslave()
{
	return 1;
}

/*
 * Interface exists: make available by filling in network interface record.  
 * System will initialize the interface when it is ready to accept packets.  
 * A NET_ADDRS command is done to get the ethernet address.
 */
exattach(qi)
struct qb_device	*qi;
{
	register struct ex_softc *xs = &ex_softc[qi->qi_unit];
	register struct ifnet *ifp = &xs->xs_if;
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	struct sockaddr_in *sin;
	register struct ex_msg *bp;

	ifp->if_unit = qi->qi_unit;
	ifp->if_name = "ex";
	ifp->if_mtu = ETHERMTU;

	/*
	 * Temporarily map queues in order to configure EXOS
	 */
	xs->xs_qbaddr = INCORE_BASE(xs);
	exconfig(qi, 0);			/* without interrupts */
	if (xs->xs_cm.cm_cc)
		return;				/* bad conf */
	/*
	 * Get Ethernet address.
	 */
	bp = exgetcbuf(xs);
	bp->mb_rqst = LLNET_ADDRS;
	bp->mb_na.na_mask = READ_OBJ;
	bp->mb_na.na_slot = PHYSSLOT;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS) ;	/* poll for reply */
	printf("	(%d.%d.%d.%d.%d.%d) HW %c.%c NX %c.%c",
		bp->mb_na.na_addrs[0], bp->mb_na.na_addrs[1],
		bp->mb_na.na_addrs[2], bp->mb_na.na_addrs[3],
		bp->mb_na.na_addrs[4], bp->mb_na.na_addrs[5],
		xs->xs_cm.cm_vc[2], xs->xs_cm.cm_vc[3],
		xs->xs_cm.cm_vc[0], xs->xs_cm.cm_vc[1]);
	bcopy((caddr_t)&bp->mb_na.na_addrs[0], (caddr_t)&xs->xs_addr,
		sizeof(xs->xs_addr));
	sin = (struct sockaddr_in *)&ifp->if_addr;
	sin->sin_family = AF_INET;
	ifp->if_init = exinit;
	ifp->if_output = exoutput;
	ifp->if_ioctl = exioctl;
	ifp->if_reset = exreset;
	if_attach(ifp);
}

/*
 * Reset of interface after BUS reset. If interface is on specified qb, 
 * reset its state.
 */
exreset(unit)
int unit;
{
	register struct qb_device *qi;

	if (unit >= Nex || (qi = exinfo[unit]) == 0 || qi->qi_alive == 0)
		return;
	printf(" ex%d", unit);
	exinit(unit);
}

/*
 * Initialization of interface; clear recorded pending operations, and 
 * reinitialize BUS usage. Called at boot time, and at ifconfig time via 
 * exioctl, with interrupts disabled.
 */
exinit(unit)
int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct qb_device *qi = exinfo[unit];
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	register struct ifnet *ifp = &xs->xs_if;
	register struct sockaddr_in *sin;
	register struct ex_msg 	*bp;
	int 			s;

	sin = (struct sockaddr_in *)&ifp->if_addr;
#ifndef	WIPC
	if (sin->sin_addr.s_addr == 0)		/* address still unknown */
		return;
#endif	WIPC
	if (ifp->if_flags & IFF_RUNNING)
		goto justarp;

	xs->xs_qbaddr = INCORE_BASE(xs);
	exconfig(qi, 4);		/* with vectored interrupts*/

	/*
	 * Put EXOS on the Ethernet, using NET_MODE command
	 */
	bp = exgetcbuf(xs);
	bp->mb_rqst = LLNET_MODE;
	bp->mb_nm.nm_mask = WRITE_OBJ;
	bp->mb_nm.nm_optn = 0;
	bp->mb_nm.nm_mode = MODE_PERF;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS)	/* poll for reply */
		;
	bp->mb_length = MBDATALEN;
	bp->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs->xs_x2hnext = xs->xs_x2hnext->mb_next;

	ifp->if_watchdog = exwatch;
	ifp->if_timer = EXWATCHINTVL;
	s = splimp();		/* are interrupts disabled here, anyway? */
	exhangrcv(unit);			/* hang receive request */
	exstart(unit);				/* start transmits */
	xs->xs_if.if_flags |= IFF_UP|IFF_RUNNING;
	splx(s);		/* are interrupts disabled here, anyway? */

justarp:
#ifdef	WIPC
	if (sin->sin_addr.s_addr == 0)		/* address still unknown */
		return;
#endif	WIPC

#if	NENETFILTER > 0 || Nenetfilter > 0
	if (!xs->xs_enetinit) {
	    	struct endevp enp;
	    
		xs->xs_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(xs->xs_addr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		*((struct ether_addr *)enp.end_addr) = xs->xs_addr;
		*((struct ether_addr *)enp.end_broadaddr) = etherbroadcastaddr;
	    	xs->xs_enetunit = enetattach(&xs->xs_if, &enp);
	}
#endif	NENETFILTER > 0 || Nenetfilter > 0
	if_rtinit(&xs->xs_if, RTF_UP);
	arpwhohas(&xs->xs_ac, &sin->sin_addr);
}

/*
 * Reset, test, and configure EXOS.  It is called by exinit, and exattach.
 * Returns 0 if successful, 1 if self-test failed.
 */
exconfig(qi, itype)
struct	qb_device *qi;
int itype;
{
	register int unit = qi->qi_unit;
	register struct ex_softc *xs = &ex_softc[unit];
	register struct exdevice *exaddr = (struct exdevice *) qi->qi_mi->qm_addr;
	register struct confmsg *cm = &xs->xs_cm;
	register struct ex_msg 	*bp;
	int 	i;
	u_long 	shiftreg;
	static	u_char	cmaddr[8] = {0xFF, 0xFF, 0, 0};

	xs->xs_flags = 0;
	/*
	 * Reset EXOS, wait for self-test to complete
	 */
	exaddr->ex_porta = EX_RESET;
	while ((exaddr->ex_portb & EX_TESTOK) == 0) 
		;
	/*
	 * Set up configuration message.
	 */
	cm->cm_1rsrv = 1;
	cm->cm_cc = 0xFF;
	cm->cm_opmode = 0;		/* link-level controller mode */
	cm->cm_dfo = 0x0101;		/* enable host data order conversion */
	cm->cm_dcn1 = 1;
	cm->cm_2rsrv[0] = cm->cm_2rsrv[1] = 0;
	cm->cm_ham = 3;			/* absolute address mode */
	cm->cm_3rsrv = 0;
	cm->cm_mapsiz = 0;
	cm->cm_byteptrn[0] = 0x01;	/* EXOS deduces data order of host */
	cm->cm_byteptrn[1] = 0x03;	/*  by looking at this pattern */
	cm->cm_byteptrn[2] = 0x07;
	cm->cm_byteptrn[3] = 0x0F;
	cm->cm_wordptrn[0] = 0x0103;
	cm->cm_wordptrn[1] = 0x070F;
	cm->cm_lwordptrn = 0x0103070F;
	for (i=0; i<20; i++) cm->cm_rsrvd[i] = 0;
	cm->cm_mba = 0xFFFFFFFF;
	cm->cm_nproc = 0xFF;
	cm->cm_nmbox = 0xFF;
	cm->cm_nmcast = 0xFF;
	cm->cm_nhost = 1;
	cm->cm_h2xba = P_BUSADDR(xs->xs_qbaddr);
	cm->cm_h2xhdr = H2XHDR_OFFSET;
	cm->cm_h2xtyp = 0;		/* should never wait for rqst buffer */
	cm->cm_x2hba = cm->cm_h2xba;
	cm->cm_x2hhdr = X2HHDR_OFFSET;
	cm->cm_x2htyp = itype;		/* 0 for none, 4 for vectored */
	cm->cm_x2haddr = xs->xs_cvec;	/* ivec allocated in exprobe */

	/*
	 * Set up message queues and headers: first the request queue
	 */
	for (bp = &xs->xs_h2xent[0]; bp < &xs->xs_h2xent[NH2X]; bp++) {
		bp->mb_link = (u_short)((char *)(bp+1)-INCORE_BASE(xs));
		bp->mb_rsrv = 0;
		bp->mb_length = MBDATALEN;
		bp->mb_status = MH_HOST;
		bp->mb_next = bp+1;
	}
	xs->xs_h2xhdr = xs->xs_h2xent[NH2X-1].mb_link = (u_short)H2XENT_OFFSET;
	xs->xs_h2xnext = xs->xs_h2xent[NH2X-1].mb_next = xs->xs_h2xent;

	/* now the reply queue */
	for (bp = &xs->xs_x2hent[0]; bp < &xs->xs_x2hent[NX2H]; bp++) {
		bp->mb_link = (u_short)((char *)(bp+1)-INCORE_BASE(xs));
		bp->mb_rsrv = 0;
		bp->mb_length = MBDATALEN;
		bp->mb_status = MH_EXOS;
		bp->mb_next = bp+1;
	}
	xs->xs_x2hhdr = xs->xs_x2hent[NX2H-1].mb_link = (u_short)X2HENT_OFFSET;
	xs->xs_x2hnext = xs->xs_x2hent[NX2H-1].mb_next = xs->xs_x2hent;

	/*
	 * Write config msg address to EXOS and wait for configuration to 
	 * complete (guaranteed response within 2 seconds).
	 */
	shiftreg = P_BUSADDR(xs->xs_qbaddr) + CM_OFFSET;
	for (i = 4; i < 8; i++) {
		cmaddr[i] = (u_char)(shiftreg & 0xFF);
		shiftreg >>= 8;
	}
	for (i = 0; i < 8; i++) {
		while (exaddr->ex_portb & EX_UNREADY) 
			;
		DELAY(200);
		exaddr->ex_portb = cmaddr[i];
	}
	for (i = 100000; (cm->cm_cc == 0xFF) && i; --i) DELAY(10);
	if (cm->cm_cc)
		printf("ex%d: configuration failed; cc=%x\n", unit, cm->cm_cc);
}

/*
 * Start or re-start output on interface. Get another datagram to send off of 
 * the interface queue, and map it to the interface before starting the output.
 * This routine is called by exinit(), exoutput(), and excdint().  In all cases,
 * interrupts by EXOS are disabled.
 */
exstart(unit)
	int unit;
{
	struct qb_device *qi = exinfo[unit];
	register struct ex_softc *xs = &ex_softc[unit];
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	register struct ex_msg *bp;
	register struct mbuf *m;
        int len;
#ifdef	NEWEX
	struct mbuf *m0;
	register int nb, tlen;
	int addr;
#endif	NEWEX

	IF_DEQUEUE(&xs->xs_if.if_snd, m);
	if (m == 0)
		return;
	/*
	 * Get a transmit request.
	 */
	bp = exgetcbuf(xs);
	bp->mb_rqst = LLRTRANSMIT;
#ifdef	NEWEX
	nb = 0; tlen = 0; m0 = 0;

	bp->mb_mid = (int)m;	/* save mbuf pointer to free them when done */

	/*
	 * point directly to the first group of mbufs to be transmitted. The
	 * hardware can only support NFRAGMENTS descriptors.
	 */
	while (m && ((nb < NFRAGMENTS-1) || (m->m_next == 0)) ) {
		addr = svtop(mtod(m, char *));
		bp->mb_et.et_blks[nb].bb_len = (u_short)m->m_len;
		*(u_long *)bp->mb_et.et_blks[nb].bb_addr = BUSADDR(addr);
		tlen += m->m_len;
		m0 = m;
		m = m->m_next;
		nb++;
	}

	/* null end of chain pointed to by mb_mid, to be freed when xmit done */
	if (m0)
		m0->m_next = 0;

	/*
	 * if not all of the descriptors would fit then merge remaining data
	 * into the transmit buffer, and point to it.  Note: the mbufs are freed
	 * during the merge, they do not have to be freed when we get the 
	 * transmit interrupt.
	 */
	if (m) {
		len = if_wqbput(xs->ex_tbuf, m);
		bp->mb_et.et_blks[nb].bb_len = (u_short)len;
		*(u_long *)bp->mb_et.et_blks[nb].bb_addr=BUSADDR(xs->ex_tbuf);
		tlen += len;
		nb++;
	}

	/*
	 * If the total length of the packet is too small, pad the last frag
	 */
	if (tlen - sizeof(struct ether_header) < ETHERMIN) {
		len = (ETHERMIN + sizeof(struct ether_header)) - tlen;
		bp->mb_et.et_blks[nb-1].bb_len += (u_short)len;
		tlen += len;
	}

	/* set number of fragments in descriptor */
	bp->mb_et.et_nblock = nb;
#else	NEWEX
	len = if_wqbput(xs->ex_tbuf, m);
#ifdef	EXDEBUG
	{
		char *s,*sd=(char *)&xs->ex_tbuf[0],
			*ss=(char *)&xs->ex_tbuf[6];int i,j;
		printf("%x ",*((short *)&xs->ex_tbuf[12]));
		printf("X ");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",ss[i]&0xFF);
		printf("	to	");
		for (i=0 ; i < 6 ; i++ ) 
			printf("%x ",sd[i]&0xFF);
		printf(" dlen = %x\n        ",len - sizeof(struct ether_header));
		s = (char *)&xs->ex_tbuf[sizeof(struct ether_header)];
		j = /*MIN(36,*/len-sizeof(struct ether_header)/*)*/;
		for (i = 0 ; i < j ; i++)
			printf("%x ",s[i]&0xFF);
	}
#endif	EXDEBUG
	if (len - sizeof(struct ether_header) < ETHERMIN) {
		len = ETHERMIN + sizeof(struct ether_header);
#ifdef	EXDEBUG
		printf("*** PAD to %x", len - sizeof(struct ether_header));
#endif 	EXDEBUG
	}
#ifdef 	EXDEBUG
	printf("\n");
#endif 	EXDEBUG
	/*
	 * Place a transmit request.
	 */
	bp->mb_et.et_nblock = 1;
	bp->mb_et.et_blks[0].bb_len = (u_short)len;
	*(u_long *)bp->mb_et.et_blks[0].bb_addr = BUSADDR(xs->ex_tbuf);
#endif	NEWEX
	xs->xs_flags |= EX_XPENDING;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
}

/*
 * interrupt service routine.
 */
exintr(unit)
	int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp = xs->xs_x2hnext;
	struct qb_device *qi = exinfo[unit];
	struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;

	while ((bp->mb_status & MH_OWNER) == MH_HOST) {
		switch (bp->mb_rqst) {
		    case LLRECEIVE:
			exrecv(unit, bp);
			exhangrcv(unit);
			break;

		    case LLTRANSMIT:
		    case LLRTRANSMIT:
			if ((xs->xs_flags & EX_XPENDING) == 0)
				panic("exxmit: no xmit pending");
			xs->xs_flags &= ~EX_XPENDING;
			xs->xs_if.if_opackets++;
			if (bp->mb_rply == LL_OK)
				;
			else if (bp->mb_rply & LLXM_1RTRY)
				xs->xs_if.if_collisions++;
			else if (bp->mb_rply & LLXM_RTRYS)
				xs->xs_if.if_collisions += 2;	/* guess */
			else if (bp->mb_rply & LLXM_ERROR)
				if (xs->xs_if.if_oerrors++ % 100 == 0)
					printf("ex%d: 100 transmit errors=%b\n",
						unit, bp->mb_rply, XMIT_BITS);
#ifdef	NEWEX
			if (bp->mb_mid)
				m_freem((struct mbuf *)bp->mb_mid);
#endif	NEWEX
			exstart(unit);
			break;

		    case LLNET_STSTCS:
			xs->xs_if.if_ierrors += xs->xs_xsa.sa_crc;
			xs->xs_flags &= ~EX_STATPENDING;
			break;

		    default:
			printf("ex%d: unknown reply 0x%x", unit, bp->mb_rqst);
		}
		bp->mb_length = MBDATALEN;
		bp->mb_status |= MH_EXOS;	/* free up buffer */
		exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
		bp = bp->mb_next;
	}
	xs->xs_x2hnext = bp;
}

/*
 * Get a request buffer, fill in standard values, advance pointer.
 */
struct ex_msg *
exgetcbuf(xs)
struct ex_softc *xs;
{
	register struct ex_msg *bp = xs->xs_h2xnext;

	bp->mb_1rsrv = 0;
	bp->mb_length = MBDATALEN;
	xs->xs_h2xnext = xs->xs_h2xnext->mb_next;
	return bp;
}

/*
 * Process Ethernet receive completion:  If input error just drop packet, 
 * otherwise examine packet to determine type.  If can't determine length from 
 * type, then have to drop packet, otherwise decapsulate packet based on type 
 * and pass to type-specific higher-level input routine.
 */
exrecv(unit, bp)
int unit;
register struct ex_msg *bp;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ether_header *eh;
    	register struct mbuf *m;
	int len, off, resid;
	register struct ifqueue *inq;
	int s;

	xs->xs_if.if_ipackets++;
	/*     total length               - header                      - crc */
	len = bp->mb_er.er_blks[0].bb_len - sizeof(struct ether_header) - 4;
	if (bp->mb_rply != LL_OK) {
		if (xs->xs_if.if_ierrors++ % 100 == 0)
			printf("ex%d: 100 receive errors=%b\n",
				unit, bp->mb_rply, RECV_BITS);
		return;
	}
	eh = (struct ether_header *)(xs->ex_rbuf);

	/*
	 * Deal with trailer protocol: if type is PUP trailer get true type from
	 * first 16-bit word past data.  Remember that type was trailer by 
	 * setting off.
	 */
	eh->ether_type = ntohs((u_short)eh->ether_type);
#ifdef 	EXDEBUG
	{
		char *s, *sd=(char *)&eh->ether_dhost, 
			*ss=(char *)&eh->ether_shost;int i,j;
		printf("%x ",eh->ether_type);
		printf("R ");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",sd[i]&0xFF);
		printf("	from	");
		for (i=0 ; i < 6 ; i++ )
			printf("%x ",ss[i]&0xFF);
		printf(" dlen = %x\n        ",len);
		s = (char *)&xs->ex_rbuf[sizeof(struct ether_header)];
		j = /*MIN(36,*/len/*)*/;
		for (i = 0 ; i < j ; i++)
			printf("%x ",s[i]&0xFF);
		printf("\n");
	}
#endif 	EXDEBUG
#define	exdataaddr(eh, off, type)	((type)(((caddr_t)((eh)+1)+(off))))
	if (eh->ether_type >= ETHERPUP_TRAIL &&
	    eh->ether_type < ETHERPUP_TRAIL+ETHERPUP_NTRAILER) {
		off = (eh->ether_type - ETHERPUP_TRAIL) * 512;
		if (off >= ETHERMTU)
			return;			/* sanity */
		eh->ether_type = ntohs(*exdataaddr(eh, off, u_short *));
		resid = ntohs(*(exdataaddr(eh, off+2, u_short *)));
		if (off + resid > len)
			return;			/* sanity */
		len = off + resid;
	} else
		off = 0;
	if (len == 0)
		return;

#ifdef	WIPC
	if (((struct sockaddr_in *)&xs->xs_if.if_addr)->sin_addr.s_addr == 0  &&
	    eh->ether_type != ETHERPUP_WIPCTYPE)
		return;
#endif	WIPC

	/*
	 * Pull packet off interface.  Off is nonzero if packet has trailing 
	 * header; if_rqbget will then force this header information to be at 
	 * the front, but we still have to drop the type and length which are 
	 * at the front of any trailer data.
	 */
	m = if_rqbget(xs->ex_rbuf, len, off, sizeof(struct ether_header));
	if (m == 0)
		return;
	if (off) {
		m->m_off += 2 * sizeof (u_short);
		m->m_len -= 2 * sizeof (u_short);
	}
	switch (eh->ether_type) {
#ifdef INET
	    case ETHERPUP_IPTYPE:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;

	    case ETHERPUP_ARPTYPE:
		arpinput(&xs->xs_ac, m);
		return;
#endif
#ifdef	WIPC
	    case ETHERPUP_WIPCTYPE:
		{
			struct sockaddr sa;

			sa.sa_family = AF_UNSPEC;
			eh->ether_dhost = eh->ether_shost;
			*(struct ether_header *)sa.sa_data = *eh;
			Winput(m, &xs->xs_if, &sa);
			return;
		}
#endif	WIPC
	    default:
#if	NENETFILTER > 0 || Nenetfilter > 0
		if (xs->xs_enetinit && xs->xs_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all.  Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				/* undo the swap done earlier */
				eh->ether_type = htons((u_short)eh->ether_type);
				bcopy((struct ether_header*)&(eh->ether_dhost),
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				mtop->m_next = m;
				enetFilter(xs->xs_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				return;
			}
		}
#endif	NENETFILTER > 0 || Nenetfilter > 0
		m_freem(m);
		return;
	}

	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
	} else
		IF_ENQUEUE(inq, m);
}

/*
 * Hang a receive request. This routine is called by exinit and excdint,
 * with interrupts disabled in both cases.
 */
exhangrcv(unit)
	int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp = exgetcbuf(xs);
	struct exdevice *exaddr = (struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	
	bp->mb_rqst = LLRECEIVE;
	bp->mb_er.er_nblock = 1;
	bp->mb_er.er_blks[0].bb_len = EXMAXRBUF;
	*(u_long *)bp->mb_er.er_blks[0].bb_addr = BUSADDR(xs->ex_rbuf);
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
}

/*
 * Ethernet output routine. Encapsulate a packet of type family for the local 
 * net.  Use trailer local net encapsulation if enough data in first packet 
 * leaves a multiple of 512 bytes of data in remainder.
 */
exoutput(ifp, m0, dst)
register struct ifnet *ifp;
struct mbuf *m0;
struct sockaddr *dst;
{
	int type, s, error;
	struct ether_addr edst;
	struct in_addr idst;
	register struct ex_softc *xs = &ex_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *eh;
	register int off;

	switch (dst->sa_family) {
#ifdef INET
	    case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&xs->xs_ac, m, &idst, &edst))
			return (0);	/* if not yet resolved */
		off = ntohs((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		/* need per host negotiation */
		if ((ifp->if_flags & IFF_NOTRAILERS) == 0 &&
		    off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERPUP_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof (u_short);
			m->m_len += 2 * sizeof (u_short);
			*mtod(m, u_short *) = htons((u_short)ETHERPUP_IPTYPE);
			*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
			goto gottrailertype;
		}
		type = ETHERPUP_IPTYPE;
		off = 0;
		goto gottype;
#endif
	    case AF_IMPLINK:
		/* should do some ARP here? */
		eh = mtod(m, struct ether_header *);
		goto gotheader;

	    case AF_UNSPEC:
		eh = (struct ether_header *)dst->sa_data;
		edst = eh->ether_dhost;
		type = eh->ether_type;
		goto gottype;

	    default:
		printf("ex%d: can't handle af%d\n", ifp->if_unit,
			dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet (control information)
	 * to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;

gottype:
	/*
	 * Add local net header.  If no space in first mbuf, allocate another.
	 */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof (struct ether_header);
	} else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	eh = mtod(m, struct ether_header *);
	eh->ether_type = htons((u_short)type);
	eh->ether_dhost = edst;

  gotheader:
	eh->ether_shost = xs->xs_addr;

	/*
	 * Queue message on interface, and start output if interface not yet 
	 * active.
	 */
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);

	/*
	 * If transmit request not already pending, then kick the back end.
	 */
	if ((xs->xs_flags & EX_XPENDING) == 0)
		exstart(ifp->if_unit);
	splx(s);
	return (0);

bad:
	m_freem(m0);
	return (error);
}

/*
 * Watchdog routine (currently not used). Might use this to get stats from EXOS.
 */
exwatch(unit)
int unit;
{
	struct exdevice *exaddr = (struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp;
	int s = spl7();

	if (xs->xs_flags & EX_STATPENDING)
		goto exspnd;
	bp = exgetcbuf(xs);
	xs->xs_flags |= EX_STATPENDING;
	bp->mb_rqst = LLNET_STSTCS;
	bp->mb_ns.ns_mask = READ_OBJ;
	bp->mb_ns.ns_rsrv = 0;
	bp->mb_ns.ns_nobj = 8;
	bp->mb_ns.ns_xobj = 0;
	bp->mb_ns.ns_bufp = P_BUSADDR(xs->xs_qbaddr) + SA_OFFSET;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
exspnd:	splx(s);
	xs->xs_if.if_timer = EXWATCHINTVL;
}

/*
 * Process an ioctl request.
 */
exioctl(ifp, cmd, data)
register struct ifnet *ifp;
int cmd;
caddr_t data;
{
	register struct ifreq *ifr = (struct ifreq *)data;
	int s = splimp(), error = 0;

	switch (cmd) {
	    case SIOCSIFADDR:
		if (ifp->if_flags & IFF_RUNNING)
			if_rtinit(ifp, -1);	/* delete previous route */
		exsetaddr(ifp, (struct sockaddr_in *)&ifr->ifr_addr);
		exinit(ifp->if_unit);
		break;

	    default:
		error = EINVAL;
	}
	splx(s);
	return (error);
}

exsetaddr(ifp, sin)
register struct ifnet *ifp;
register struct sockaddr_in *sin;
{
	ifp->if_addr = *(struct sockaddr *)sin;
	ifp->if_net = in_netof(sin->sin_addr);
	ifp->if_host[0] = in_lnaof(sin->sin_addr);
	sin = (struct sockaddr_in *)&ifp->if_broadaddr;
	sin->sin_family = AF_INET;
	sin->sin_addr = if_makeaddr(ifp->if_net, INADDR_ANY);
	ifp->if_flags |= IFF_BROADCAST;
}
#endif	NEX > 0 || Nex > 0 
