#include "enp.h"
#include "enetfilter.h"
#if NENP > 0
/*
 * Modified 3 Com Ethernet Controller interface
 * enp modifications added S. F. Holmgren
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/protosw.h"
#include "../h/ioctl.h"
#include "../h/socket.h"
#include "../h/vmmac.h"
#include "../h/errno.h"
#include "../h/time.h"
#include "../h/kernel.h"
#include "../h/uio.h"
#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#include "../netpup/pup.h"
#if	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kif/enet.h"
#endif	NENETFILTER > 0 || Nenetfilter > 0
#include "../is68kdev/qbvar.h"
#include "../is68kif/if_enp.h"
#include "../machine/reg.h"
#include "../h/Wipc.h"

extern	short enp[];
#define ENPVIRTADDR	enp		/* kernel virtual address */
#define ENPPHYSADDR	0xF80000	/* board physical base addr */
#define ENPSTART	0xF02000	/* standard enp start addr */

u_short	*enpstd[] = { (u_short *)ENPVIRTADDR,0 };
struct  qb_device *enpinfo[ NENP ];

int     enpprobe(), enpattach(), enpintr(), enpslave();
struct  qb_driver ENPdriver = {
	enpprobe, enpslave, enpattach, enpstd, "enp", enpinfo, "ENP"
};

int     enpinit(),enpioctl(),enpoutput(),enpreset();
struct  mbuf *enpget();
extern  struct ifnet loif;

/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * es_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface, its address, ...
 */
struct  enp_softc {
	struct  arpcom es_ac;           /* common ethernet structures */
	struct	ether_addr es_boardaddr;/* board ethernet address */
#if	NENETFILTER > 0 || Nenetfilter > 0
	short		es_enetunit;	/* unit number for enet filtering */
	short		es_enetinit;	/* enet inetrface is initialized */
#endif	NENETFILTER > 0 || Nenetfilter > 0
} 
enp_softc[NENP];

#define es_if           es_ac.ac_if     /* network-visible interface */
#define es_enaddr       es_ac.ac_enaddr /* hardware ethernet address */


/*
 * Probe for device.
 */
enpprobe(reg, unit)
  caddr_t reg;
  int unit;
  {
	register ENPDEVICE *addr = (ENPDEVICE *)reg;
	extern int cvec;

#ifdef	notdef
	if( (badaddr( addr, 1 ) ) || (badaddr( &addr->enp_ram[0], 1 ) ) )
		return( 0 );
#else
	if( (badaddr( enp, 1 ) ) )
		return( 0 );
#endif	notdef
	cvec = 0xC1;
	return( ENPSIZE );
}

enpslave()
  {
	return ( 1 );
}

/*
 * Interface exists: make available by filling in network interface
 * record.  System will initialize the interface when it is ready
 * to accept packets. 
 */
enpattach(md)
  register struct qb_device *md;
  {
	struct enp_softc *es = &enp_softc[md->qi_unit];
	register struct ifnet *ifp = &es->es_if;
	struct sockaddr_in *sin;

	enpgetaddr( md->qi_unit );
	bcopy(&es->es_boardaddr, &es->es_enaddr, sizeof (es->es_enaddr));
	printf("	(%d.%d.%d.%d.%d.%d)",
		es->es_enaddr.ether_addr_octet[0],
		es->es_enaddr.ether_addr_octet[1],
		es->es_enaddr.ether_addr_octet[2],
		es->es_enaddr.ether_addr_octet[3],
		es->es_enaddr.ether_addr_octet[4],
		es->es_enaddr.ether_addr_octet[5]);

	ifp->if_unit = md->qi_unit;
	ifp->if_name = "enp";
	ifp->if_mtu = ETHERMTU;

	sin = (struct sockaddr_in *)&ifp->if_addr;
	sin->sin_family = AF_INET;

	ifp->if_init = enpinit;
	ifp->if_ioctl = enpioctl;
	ifp->if_output = enpoutput;
	ifp->if_reset = enpreset;
	if_attach(ifp);
}


/*
 * Reset of interface after UNIBUS reset.
 */
enpreset(unit)
  int unit;
  {
	register struct qb_device *md;

	if (unit >= NENP || (md = enpinfo[unit]) == 0 || md->qi_alive == 0)
		return;
	enpinit(unit);
}

/*
 * Initialization of interface; clear pending
 * operations.
 */
enpinit(unit)
  int unit;
  {
	struct enp_softc *es = &enp_softc[unit];
	struct ifnet *ifp = &es->es_if;
	struct sockaddr_in *sin = (struct sockaddr_in *)&ifp->if_addr;

	enpgetaddr(unit);
	bcopy(&es->es_boardaddr, &es->es_enaddr, sizeof(es->es_enaddr));
	es->es_if.if_flags |= IFF_RUNNING;	/* open for business*/
#ifdef	WIPC
	if (sin->sin_addr.s_addr == 0)		/* address still unknown */
		return;
#endif	WIPC
#if	NENETFILTER > 0 || Nenetfilter > 0
	if ((es->es_if.if_flags & IFF_UP)  &&  !es->es_enetinit) {
	    	struct endevp enp;	/* don't let the name fool ya */
	    
		es->es_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(es->es_enaddr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		*((struct ether_addr *)enp.end_addr) = es->es_enaddr;
		*((struct ether_addr *)enp.end_broadaddr) = etherbroadcastaddr;
	    	es->es_enetunit = enetattach(&es->es_if, &enp);
	}
#endif	NENETFILTER > 0 || Nenetfilter > 0
	if_rtinit( &es->es_if,RTF_UP );
	arpwhohas(&es->es_ac, &sin->sin_addr);
}


/*
 * Ethernet interface interrupt.
 */
enpintr(reg)
  {
	register int unit;

	for (unit = 0; unit < NENP; unit++) {
		register struct enp_softc *es = &enp_softc[unit];
		register struct qb_device *md = enpinfo[unit];
		register ENPDEVICE *addr;
		register BCB *bcbp;

		if ((es->es_if.if_flags & IFF_UP) == 0  ||  md == 0)
			continue;
		addr = (ENPDEVICE *)md->qi_mi->qm_addr;
		while( (bcbp = (BCB *)ringget( &addr->enp_tohost )) != 0 ) {
			enpread(es, bcbp);
			ringput(&addr->enp_enpfree, bcbp);
		}
	}
}


enpread(es, bcbp)
  struct enp_softc *es;
  register BCB *bcbp;
  {
	register struct ether_header *enp;
	struct mbuf *m;
	int len, off, resid, enptype;
	register struct ifqueue *inq;

	es->es_if.if_ipackets++;

	/*
	 * Get input data length.
	 * Get pointer to ethernet header (in input buffer).
	 * Deal with trailer protocol: if type is PUP trailer
	 * get true type from first 16-bit word past data.
	 * Remember that type was trailer by setting off.
	 */

	len = bcbp->b_msglen - sizeof(struct ether_header) - 4;
	enp = (struct ether_header *)bcbp->b_addr;

#define enpdataaddr(enp, off, type)       ((type)(((caddr_t)((enp)+1)+(off))))

	enptype = enp->ether_type;
	if (enptype >= ETHERPUP_TRAIL  &&
	    enptype < ETHERPUP_TRAIL+ETHERPUP_NTRAILER) {
		off = (enptype - ETHERPUP_TRAIL) * 512;
		if (off >= ETHERMTU)
			return(0);         /* sanity */
		enptype = *enpdataaddr(enp, off, u_short *);
		resid = *(enpdataaddr(enp, off+2, u_short *));

		if (off + resid > len)
			return(0);         /* sanity */
		len = off + resid;
	} else
		off = 0;

	if( len == 0 )
		return(0);

#ifdef	WIPC
	if (((struct sockaddr_in *)&es->es_if.if_addr)->sin_addr.s_addr == 0  &&
	    enptype != ETHERPUP_WIPCTYPE)
		return;
#endif	WIPC

	/*
	 * Pull packet off interface.  Off is nonzero if packet
	 * has trailing header; enpget will then force this header
	 * information to be at the front, but we still have to drop
	 * the type and length which are at the front of any trailer data.
	 */
	m = enpget(bcbp, len, off);
	if( m == 0 )
		return( 0 );

	if( off ) {
		m->m_off += 2 * sizeof (u_short);
		m->m_len -= 2 * sizeof (u_short);
	}

	switch (enptype) {
#ifdef INET
	  case ETHERPUP_IPTYPE:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;

	  case ETHERPUP_ARPTYPE:
		arpinput(&es->es_ac, m);
		return(0);
#endif
#ifdef	WIPC
	  case ETHERPUP_WIPCTYPE:
		{
			struct sockaddr sa;

			sa.sa_family = AF_UNSPEC;
			enp->ether_dhost = enp->ether_shost;
			*(struct ether_header *)sa.sa_data = *enp;
			Winput(m, &es->es_if, &sa);
			return;
		}
#endif	WIPC
	  default:
#if	NENETFILTER > 0 || Nenetfilter > 0
		if (es->es_enetinit && es->es_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all.  Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				bcopy((struct ether_header*)&(enp->ether_dhost),
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				mtop->m_next = m;
				enetFilter(es->es_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				return;
			}
		}
#endif	NENETFILTER > 0 || Nenetfilter > 0
		m_freem(m);
		return(0);
	}

	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
		return(0);
	}
	IF_ENQUEUE(inq, m);
	return( 0 );
}

/*
 * Ethernet output routine. (called by user)
 * Encapsulate a packet of type family for the local net.
 * Use trailer local net encapsulation if enough data in first
 * packet leaves a multiple of 512 bytes of data in remainder.
 * If destination is this address or broadcast, send packet to
 * loop device to kludge around the fact that 3com interfaces can't
 * talk to themselves.
 */
enpoutput(ifp, m0, dst)
  struct ifnet *ifp;
  struct mbuf *m0;
  struct sockaddr *dst;
  {
	register struct enp_softc *es = &enp_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *enp;
	register int off, i;
	int type, s, error;
	struct ether_addr edst;
	struct in_addr idst;
	struct mbuf *mcopy = (struct mbuf *)0;
	int unit = ifp->if_unit;

	if ((es->es_if.if_flags & IFF_UP) == 0)
		return 0;
	switch( dst->sa_family ) {
#ifdef INET
	  case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&es->es_ac, m, &idst, &edst))
			return ( 0 );     /* if not yet resolved */

		if (in_lnaof(idst) == INADDR_ANY)
			mcopy = m_copy(m, 0, M_COPYALL);
		off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if ((ifp->if_flags & IFF_NOTRAILERS) == 0  &&
		    off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERPUP_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof (u_short);
			m->m_len += 2 * sizeof (u_short);
			*mtod(m, u_short *) = ETHERPUP_IPTYPE;
			*(mtod(m, u_short *) + 1) = m->m_len;
			goto gottrailertype;
		}
		type = ETHERPUP_IPTYPE;
		off = 0;
		goto gottype;
#endif
	    case AF_IMPLINK:
		/* should do some ARP here? */
		enp = mtod(m, struct ether_header *);
		goto gotheader;

	  case AF_UNSPEC:
		enp = (struct ether_header *)dst->sa_data;
		edst = enp->ether_dhost;
		type = enp->ether_type;
		goto gottype;
	  default:
		error = EAFNOSUPPORT;
		goto bad;
	}

  gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet
	 * (control information) to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;

  gottype:
	/*
         * Add local net header.  If no space in first mbuf,
         * allocate another.
         */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_DATA);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof (struct ether_header);
	} else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	enp = mtod(m, struct ether_header *);
	enp->ether_dhost = edst;
	enp->ether_type = type;
  gotheader:
	enp->ether_shost = es->es_enaddr;

	/*
	 * Queue message on interface if possible 
	 */

	s = splimp();
	if( enpput( unit,m ) ) {
		error = ENOBUFS;
		goto qfull;
	}
	es->es_if.if_opackets++;
	splx( s );

  gotlocal:
	return(mcopy ? looutput(&loif, mcopy, dst) : 0);

  qfull:
	splx( s );
	printf("enpoutput: enpput failed\n");
	m0 = m;
  bad:
	m_freem(m0);
	m_freem(mcopy);
	return(error);
}


/*
 * Routine to copy from mbuf chain to transmitter
 * buffer in Multibus memory.
 */
enpput( unit,m )
  int unit;
  struct mbuf *m;
  {
	register BCB *bcbp;
	register ENPDEVICE *addr = (ENPDEVICE *)enpinfo[ unit ]->qi_mi->qm_addr;
	register struct mbuf *mp;
	register u_char *bp;
	int i;

	if ((bcbp = (BCB *)ringget( &addr->enp_hostfree )) == 0)
		return 1;
	bcbp->b_len = 0;
	bp = (u_char *)bcbp->b_addr;
	for (mp = m; mp; mp = mp->m_next) {
		register unsigned len;
		u_char *mcp;

		len = mp->m_len;
		if( len == 0 )
			continue;
		mcp = mtod( mp,u_char * );
		bcopy( mcp,bp,len );
		bp += len;
		bcbp->b_len += len;
	}
	bcbp->b_len = max( MINPKTSIZE,bcbp->b_len );
	if( (i = ringput( &addr->enp_toenp,bcbp )) == 1 )
		INTR_ENP( addr );
	m_freem(m);
	return( 0 );
}

/*
 * Routine to copy from Multibus memory into mbufs.
 *
 * Warning: This makes the fairly safe assumption that
 * mbufs have even lengths.
 */
struct mbuf *
enpget( bcbp, totlen, off0 )
  register BCB *bcbp;
  int totlen, off0;
  {
	register struct mbuf *m;
	register int off = off0;
	register unsigned char *cp =
		(unsigned char *)bcbp->b_addr + sizeof( struct ether_header );
	struct mbuf *top = 0;
	struct mbuf **mp = &top;
	int len;

	while( totlen > 0 ) {
		u_char *mcp;

		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0)
			goto bad;
		if( off ) {
			len = totlen - off;
			cp = (unsigned char *)bcbp->b_addr + 
				sizeof( struct ether_header ) + off;
		} else
			len = totlen;
		m->m_len = MIN(MLEN,len);
		m->m_off = MMINOFF;
		len = m->m_len;
		mcp = mtod(m, u_char *);
		bcopy(cp, mcp, len);
		cp += len;
		*mp = m;
		mp = &m->m_next;
		if (off == 0) {
			totlen -= len;
			continue;
		}
		off += len;
		if (off == totlen) {
			cp = (unsigned char *)bcbp->b_addr + sizeof( struct ether_header );
			off = 0;
			totlen = off0;
		}
	}
	return (top);
bad:
	m_freem(top);
	return (0);
}


enp_trfs_xmit(ifp, dst, ip, mp, p, len, seg)
  struct ifnet *ifp;
  struct sockaddr *dst;
  struct ipc *ip;
  struct request *mp;
  register char *p;
  register int len;
  int seg;
  {
	register BCB *bcbp;
	register struct ether_header *enp;
	register struct Wrproc *wp;
	register char *bp;
	struct enp_softc *es = &enp_softc[ifp->if_unit];
	ENPDEVICE *addr = (ENPDEVICE *)enpinfo[ifp->if_unit]->qi_mi->qm_addr;

	if ((bcbp = (BCB *)ringget( &addr->enp_hostfree )) == 0)
		return 1;
	enp = (struct ether_header *)bcbp->b_addr;
	enp->ether_dhost = ((struct ether_header *)dst->sa_data)->ether_dhost;
	enp->ether_shost = es->es_enaddr;
	enp->ether_type = ((struct ether_header *)dst->sa_data)->ether_type;
	wp = (struct Wrproc *)&enp[1];
	wp->Wp_next = (struct Wrproc *)0;
	wp->Wp_ipc = *ip;	/* structure assignment */
	if (mp)
		wp->Wp_msg = *mp;	/* structure assignment */
	bp = (char *)&wp[1];
	switch(seg) {
	  case RCODE_USER_SEGMENT:
		copyin(p, bp, len);
		break;
	  case RCODE_KERN_SEGMENT:
		bcopy(p, bp, len);
		break;
	  case RCODE_PHYS_SEGMENT:
		pcopyin(p, bp, len);
		break;
	}
	bcbp->b_len = sizeof *enp + sizeof *wp + len;
	if(ringput(&addr->enp_toenp, bcbp) == 1)
		INTR_ENP(addr);
}

/*
 * Process an ioctl request.
 *    this can be called via the "socket" route for SIOCSIFADDR or
 *	by the cdev/inode route for SIOCSIFCCFWR/RD
 *
 */
enpioctl(ifp, cmd, data)
  register struct ifnet *ifp;
  int cmd;
  caddr_t data;
  {
	register struct ifreq *ifr = (struct ifreq *)data;
	int s = splimp(), error = 0;
	struct sockaddr_in *sin;
	struct sockaddr *sa;
	struct enp_softc *es;
	ENPDEVICE *addr;
	struct config_entry *cf;

	switch (cmd) {
	  case SIOCSIFADDR:
		es = &enp_softc[ ifp->if_unit ];
		sa = (struct sockaddr *)&ifr->ifr_addr;
		if (sa->sa_family == AF_UNSPEC ) {
			if (sa->sa_data[0] & 1) { /*broad or multi-cast*/
				splx( s );
				return( EINVAL );
			}
			es->es_enaddr = *(struct ether_addr *)sa->sa_data;
			enpinit( ifp->if_unit);
			break;
		}
		sin = (struct sockaddr_in *)&ifr->ifr_addr;
		if (sin->sin_family != AF_INET) {
			splx( s );
			return( EINVAL );
		}
		if (ifp->if_flags & IFF_RUNNING)
			if_rtinit(ifp, -1);     /* delete previous route */
		enpsetaddr(ifp, sin);
		enpinit(ifp->if_unit);
		break;
	  default:
		error = EINVAL;
	}
	splx(s);
	return(error);
}

enpsetaddr(ifp, sin)
  register struct ifnet *ifp;
  register struct sockaddr_in *sin;
  {

	ifp->if_addr = *(struct sockaddr *)sin;
	ifp->if_net = in_netof(sin->sin_addr);
	ifp->if_host[0] = in_lnaof(sin->sin_addr);
	sin = (struct sockaddr_in *)&ifp->if_broadaddr;
	sin->sin_family = AF_INET;
	sin->sin_addr = if_makeaddr(ifp->if_net, INADDR_ANY);
	ifp->if_flags |= IFF_BROADCAST | IFF_NOTRAILERS;
}


/*
 * Get the ethernet addr, store it and print it
 * Read the ethernet address off the board, one byte at a time.
 *	put it in enp_softc
 */
enpgetaddr( unit )
  int unit;
  {
	register u_char *cp, *cx, *ap;
	int i;
	struct enp_softc	*es = &enp_softc[unit];
	ENPDEVICE *addr =(ENPDEVICE *)enpinfo[unit]->qi_mi->qm_addr;
	
	es->es_boardaddr = addr->enp_addr.e_baseaddr;
	return( 1 );
}

/*
 * enpram device
 *
 */
enpr_read( dev,uio )
  int dev;
  register struct uio *uio;
  {
	register ENPDEVICE *addr;
	register struct iovec *iov;

	addr = (ENPDEVICE *)enpinfo[ minor( dev ) ]->qi_mi->qm_addr;
	iov  = uio->uio_iov;
	copyout( &addr->enp_ram[ uio->uio_offset ], iov->iov_base,
		 iov->iov_len );
	uio->uio_resid -= iov->iov_len;
	iov->iov_len = 0;
	return( 0 );
}

enpr_write( dev,uio )
  int dev;
  register struct uio *uio;
  {
	register ENPDEVICE *addr;
	register struct iovec *iov;

	addr = (ENPDEVICE *)enpinfo[ minor( dev ) ]->qi_mi->qm_addr;
	iov  = uio->uio_iov;
	copyin( iov->iov_base, &addr->enp_ram[ uio->uio_offset ],
		iov->iov_len );
	uio->uio_resid -= iov->iov_len;
	iov->iov_len = 0;
	return( 0 );
}

enpr_ioctl( dev,cmd,arg,fflag )
  dev_t dev;
  caddr_t *arg;
  {
	register ENPDEVICE *addr =
		(ENPDEVICE *)enpinfo[ dev = minor( dev ) ]->qi_mi->qm_addr;

	switch( cmd ) {
	  case ENPIOGO:
/* not needed if prom based version */
		addr->enp_base = (int)addr;
		ENP_GO( addr,ENPSTART );
		DELAY( 300000 );
		enp_softc[dev].es_if.if_flags |= IFF_UP;
		enpinit( dev );
/* end of not needed */
		break;
	  case ENPIORESET:
		RESET_ENP( addr );
		break;
	}
	return( 0 );
}

#endif
