/*	smreg.h 6.1	83/07/29	*/

struct device {
	unsigned short	sm_csr;		/* control & status reg */
	unsigned short	sm_dbr;		/* data buffer reg */
};

		/* Drive Commands, extended mode */
#define SM_SEEK	   000<<1     /* seek */
#define SM_FORMFL  001<<1     /* format floppy */
#define SM_WRITED  002<<1     /* write direct */
#define SM_READD   003<<1     /* read direct */
#define SM_SETMOD  004<<1     /* set mode */
#define SM_RDSTAT  005<<1     /* read drive status */
#define SM_WDDD	   006<<1     /* write deleted data direct (flop only) */
#define SM_READES  007<<1     /* read extended status */
#define SM_READID  010<<1     /* read id */
#define SM_WWID	   011<<1     /* write winchester id */
#define SM_WRITEFM 012<<1     /* write flaw map */
#define SM_READFM  013<<1     /* read flaw map */

		/* csr bits */
#define SM_ER	   0100000	   /* error present */
#define SM_IN	   0040000	   /* initialize */
#define SM_AV	   0004000	   /* available */
#define SM_XA	   0001000	   /* extended addressing (22-bit) */
#define SM_SR	   0000400	   /* status read */
#define SM_TR	   0000200	   /* transmit (to dbr) ok */
#define SM_IE	   0000100	   /* int. ena. */
#define SM_DN	   0000040	   /* done */
#define SM_GO	   0000001	   /* go bit */

		/* unit designator bits */
#define PA	0100000		/* physical address */
#define WIN	02		/* winchester */

		/* status bits from dbr */
#define sm_UN(x)	(x & 01)		/* unit number */
#define sm_DT(x)	((x & 02) >> 1)		/* device type */
#define sm_ND(x)	((x & 04) >> 2)		/* new diskette */
#define sm_DD(x)	((x & 0x8) >> 3)	/* deleted data AM */
#define sm_DR(x)	((x & 0x10) >> 4)	/* drive ready */
#define sm_RF(x)	((x & 0x20) >> 5)	/* retry flag */
#define sm_WP(x)	((x & 0x40) >> 6)	/* write protect */
#define sm_TS(x)	((x & 0x80) >> 7)	/* two sided */
#define sm_EC(x)	((x & 0x3f00) >> 8)	/* error code */
#define sm_T0(x)	((x & 0x4000) >> 14)	/* track 0 */
#define sm_SC(x)	((x & 0x8000) >> 15)	/* seek completed */

