/*	sky.c	6.1	83/07/29	*/

/*
 * SKY fp device driver/system call
 */
#define NSKY	1
#define Nsky	1

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/skyreg.h"

int	skyprobe(),	skyslave(),	skyattach(),	skyint();
struct	qb_ctlr		*skycinfo[NSKY];
struct	qb_device	*skydinfo[Nsky];

u_short *SKYstd[] = { 
#ifdef	QBUS
		(u_short *)0x3fe280,
#else	QBUS
#ifdef	M68020
		(u_short *)0xFF8100, 
		(u_short *)0xFF8280, 
		(u_short *)0xFF8010,
#else	M68020
		(u_short *)0x7F8100, 
		(u_short *)0x7F8280,
		(u_short *)0x7F8010,
#endif	M68020
#endif	QBUS
		0 };

/*
 * SKY/sky controler/device driver structure
 */
struct	qb_driver SKdriver =
	{ skyprobe, skyslave, skyattach, SKYstd, "sk", skydinfo, "SK", skycinfo };

struct skydevice *skybase, *physkybase;

#ifdef	VBUS
skyinit()
{
	extern int vbnum;

	if (vbnum > 0) {
#ifdef	M68020
		SKYstd[0] = (u_short *)(0xFF8100 + (0x10 * vbnum));
#else	M68020
		SKYstd[0] = (u_short *)(0x7F8100 + (0x10 * vbnum));
#endif	M68020
		SKYstd[1] = (u_short *)0;
	}
}
#endif	VBUS

/* 
 * Check that controller exists
 */
skyprobe(skyaddr)
register struct skydevice	*skyaddr;
{
	extern int cvec;

	skybase = skyaddr;
#ifdef	M68020
	physkybase = skybase;
#else	M68020
	physkybase = (struct skydevice *)svtop(skybase);
#endif	M68020

	/*
	 * cause sky board to interrupt
	 */
	skyaddr->stcreg = 0x0000;		/* halt the FFP */
#ifdef	BOZO
	skyaddr->comreg = ??????;		/* load ucode to interrupt */
	skyaddr->mc1reg = ??????;
	skyaddr->mc1reg = ??????;

	skyaddr->stcreg = 0x0080;		/* reset */
	skyaddr->comreg = 0x1000;		/* init */
	skyaddr->comreg = 0x1000;		/* init */
	skyaddr->comreg = 0x1000;		/* establist communications */
	skyaddr->stcreg = 0x0040;		/* run FFP */
	DELAY(1000);				/* wait for interrupt */
	skyaddr->stcreg = 0x0000;		/* halt the FFP */
#else	BOZO
	cvec = 0;				/* no vector */
#endif	BOZO
	return (sizeof (struct skydevice));
}

skyslave(qi, skyaddr)
register struct qb_device	*qi;
register struct skydevice	*skyaddr;
{
	return (1);
}

skyattach(qi)
register struct qb_device	*qi;
{
	printf("	SKY Fast Floating-Point Processor");
}

skyint()
{
	printf("sk0: unexpected interrupt\n");
}

#ifdef	VBUS
/* defunct sky system call */
sky()
{
}
#endif	VBUS

/* 
 * sky system call - map the sky board into user address space
 */
skymap()
{
	register struct pte *pte;
	register int v;

	/*
	 * verify existance of sky FFP
	 */
	if (skybase == 0) {
		u.u_error = ENODEV;
		return;
	}

	/*
	 * expand the data area by one page
	 */
	if (ctob(u.u_dsize+1) > u.u_rlimit[RLIMIT_DATA].rlim_cur) {
		u.u_error = ENOMEM;
		return;
	}
	if (chksize((u_int)u.u_tsize, (u_int)u.u_dsize+1, (u_int)u.u_ssize))
		return;
	if (swpexpand(u.u_dsize+1, u.u_ssize, &u.u_dmap, &u.u_smap)==0)
		return;
	expand(1, 0);

	/*
	 * return any memory associated with one page
	 */
	pte = dptopte(u.u_procp, u.u_dsize-1);
	v = dptov(u.u_procp, u.u_dsize-1);
	u.u_procp->p_rssize -= vmemfree(pte, 1);

	/*
	 * map the page out to the sky board
	 */
	*(int *)pte = PG_V | PG_UW | PG_FOD | btoc((int)physkybase & ~PGOFSET);
	newptes(pte, v, 1);

	/*
	 * mark process as using sky board, and first restore as a noop
	 */
/*	skybase->stcreg = 0x0080;	/* reset */
/*	skybase->comreg = 0x1000;	/* init */
/*	skybase->comreg = 0x1000;	/* init */
/*	skybase->comreg = 0x1001;	/* establist communications */
/*	skybase->stcreg = 0x0040;	/* run FFP */
	u.u_sky = 0x1063;		/* sky ffp noop opcode */
	u.u_procp->p_flag |= SSKY;

	/*
	 * return the user virtual address of the sky board
	 */
	u.u_r.r_val1 = ctob(v) | ((int)skybase & PGOFSET);
/*printf("base=%x phybase=%x uvirt=%x\n",skybase,physkybase,u.u_r.r_val1);/**/
}
