#define	NSIO		2

/*
 * Signetics 2681 Duart device registers.
 */
#define NCHAN		2

#define S2681_ADDR	0x58000000

#ifndef LOCORE
/*
 * S2681 device registers
 */
struct s2681device {
	u_char	s2681_mr1_a,	_00;	
#define		s2681_mr1	s2681_mr1_a
#define		s2681_mr2_a	s2681_mr1_a
#define		s2681_mr2	s2681_mr2_a
	u_char	s2681_r_sr_a,	_01;	
#define		s2681_r_sr	s2681_r_sr_a
#define		s2681_w_csr_a	s2681_r_sr_a
#define		s2681_w_csr	s2681_w_csr_a
	u_char	s2681_w_cr_a,	_02;	
#define		s2681_w_cr	s2681_w_cr_a
	u_char	s2681_r_rhr_a,	_03;	
#define		s2681_r_rhr	s2681_r_rhr_a
#define		s2681_w_thr_a	s2681_r_rhr_a
#define		s2681_w_thr	s2681_w_thr_a
	u_char	s2681_r_ipcr,	_04;	
#define		s2681_w_acr	s2681_r_ipcr
	u_char	s2681_r_isr,	_05;	
#define		s2681_w_imr	s2681_r_isr
	u_char	s2681_r_ctu,	_06;	
	u_char	s2681_r_ctl,	_07;	

	u_char	s2681_mr1_b,	_10;	
#define		s2681_mr2_b	s2681_mr1_b
	u_char	s2681_r_sr_b,	_11;	
#define		s2681_w_csr_b	s2681_r_sr_b
	u_char	s2681_w_cr_b,	_12;	
	u_char	s2681_r_rhr_b,	_13;	
#define		s2681_w_thr_b	s2681_r_rhr_b
	u_char	s2681_resrved,	_14;	
	u_char	s2681_r_opcr,	_15;	
#define		s2681_w_inp	s2681_r_opcr
	u_char	s2681_r_sopbc,	_16;	
#define		s2681_w_startc	s2681_r_sopbc
	u_char	s2681_r_ropbc,	_17;	
#define		s2681_w_stopc	s2681_r_ropbc
};
#else
#define S2681_MR1_A	0x58000000
#define S2681_MR2_A	S2681_MR1_A
#define S2681_R_SR_A	0x58000002
#define S2681_W_CSR_A	S2681_R_SR_A
#define S2681_W_CR_A	0x58000004
#define S2681_R_RHR_A	0x58000006
#define S2681_W_THR_A	S2681_R_RHR_A
#define S2681_R_IPCR	0x58000008
#define S2681_W_ACR	S2681_R_IPCR
#define S2681_R_ISR	0x5800000A
#define S2681_W_IMR	S2681_R_ISR
#define S2681_CTU	0x5800000C
#define S2681_CTL	0x5800000E

#define S2681_MR1_B	0x58000010
#define S2681_MR2_B	S2681_MR1_B
#define S2681_R_SR_B	0x58000012
#define S2681_W_CSR_B	S2681_R_SR_B
#define S2681_W_CR_B	0x58000014
#define S2681_R_RHR_B	0x58000016
#define S2681_W_THR_B	S2681_R_RHR_B
#define S2681_R_OPCR	0x58000018
#define S2681_W_INP	S2681_R_OPCR
#define S2681_R_SOPBC	0x5800001C
#define S2681_W_STARTC	S2681_R_SOPBC
#define S2681_R_ROPBC	0x5800001E
#define S2681_W_STOPC	S2681_R_ROPBC
#endif LOCORE

/* 		s2681_{rw}_mr1 mode register definitions: */
#define	MR1_RX_RTS_YES		0x80
#define	MR1_RX_INT_FULL		0x40
#define	MR1_ERR_BMODE		0x20
#define	MR1_PAR_MULTIDRP	0x18
#define	MR1_PAR_NONE		0x10
#define	MR1_PAR_FORCE		0x08
#define	MR1_PAR_WITH		0x00
#define	MR1_PAR_ODD		0x04
#define	MR1_PAR_EVEN		0x00
#define	MR1_8_BIT		0x03
#define	MR1_7_BIT		0x02
#define	MR1_6_BIT		0x01
#define	MR1_5_BIT		0x00

/*		s2681_{rw}_mr2 mode register definitions: */
#define	MR2_CM_NORM		0x00
#define	MR2_CM_AUTOECHO		0x40
#define	MR2_CM_L_LOOP		0x80
#define	MR2_CM_R_LOOP		0xC0
#define	MR2_TX_RTS		0x20
#define	MR2_TX_CTS		0x10
#define	MR2_1_STOP		0x07
#define	MR2_15_STOP		0x08
#define	MR2_2_STOP		0x0F

/*		s2681_r_sr status register definitions: */
#define	SR_RCVED_BRK		0x80
#define	SR_FRAME_ERR		0x40
#define	SR_PARITY_ERR		0x20
#define	SR_OVERRUN_ERR		0x10
#define	SR_TXEMT		0x08
#define	SR_TXRDY		0x04
#define	SR_FFULL		0x02
#define	SR_RXRDY		0x01

/*		s2681_w_cr command register definitions: */
#define	CR_CMD_RST_MR		0x10
#define	CR_CMD_RST_RX		0x20
#define	CR_CMD_RST_TX		0x30
#define	CR_CMD_RST_ERR		0x40
#define	CR_CMD_RST_BRK		0x50
#define	CR_CMD_START_BRK	0x60
#define	CR_CMD_STOP_BRK		0x70
#define	CR_DISABLE_TX		0x08
#define	CR_ENABLE_TX		0x04
#define	CR_DISABLE_RX		0x02
#define	CR_ENABLE_RX		0x01

/*		s2681_w_acr Aux control register definitions: */
#define	ACR_BRGS		0x80
