#define MONITOR	0x1F    	/* */
/*#define PORT1PRINTF     	/**/
/*	sio.c	6.1	83/07/29	*/

/*
 * sio driver
 */
#include "../machine/pte.h"
#include "../machine/psl.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../is68kdev/sioreg.h"
#include "../is68kdev/pdma.h"

#include "../machine/board.h"

#ifdef	GWS
#include "../is68kdev/gpreg.h"
#endif	GWS
#define	TTY_NODELAY

#define SIOCONSOLE	((struct s2681device *)S2681_ADDR)
#define SIOPORT1	((struct s2681device *)(S2681_ADDR+0x10))

int			monitor_debug;
int			sio_ispeed;

/*
 * There is no driver information for auto-configuration.  It is assumed that
 * you always have two sio ports, and their major number is 0.
 */
struct tty		sio_tty[NSIO];
struct pdma		sio_pdma[NSIO];
struct s2681device 	*sio_addr[NSIO] =
			{ SIOCONSOLE, SIOPORT1};

int	siostart(),	sioxint();
int	ttrstrt();
u_char	s2681_imr = 0;

#define IFLAGS	(EVENP|ODDP|ECHO|XTABS|CRMOD)

/*
 * baud rate conversion	:                           1  1  2  4  9  1  3
 *			          1  1  1  2  3  6  2  8  4  8  6  9  8
 *			    5  7  1  3  5  0  0  0  0  0  0  0  0  .  .
 *			 0  0  5  0  4  0  0  0  0  0  0  0  0  0  2  4 */
/* NOTE: ACR7 is set in the PROMS */
char sio_bconv[16]= {	 0, 0, 0, 1, 2, 3, 4, 4, 5, 6,10, 8, 9,11,12,15, };
/*char sio_bconv[16]= {	 0, 0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 8, 9,11,11,12, };*/

/*
 * Sio initialization, called from startup().
 */
sioinit()
{
	register int i, j, s;
	static int sio_init = 0;
	
	/* only initialize the sio once ... */
	if (sio_init)
		return;
	sio_init = 1;
	switch (*BSR & BSR_BAUD) {	/* KLUDGE CPU SWITCHES */
	    case BSR_BAUD_9600:
		sio_ispeed = B9600;
		break;
	    case BSR_BAUD_19200:
		sio_ispeed = EXTA;
		break;
	    case BSR_BAUD_1200:
		sio_ispeed = B1200;
		break;
	    case BSR_BAUD_300:
		sio_ispeed = B300;
		break;
	}

	/*
	 * set up pseudo dma structures 
	 */
	for (i = 0 ; i < NSIO ; i++) {
		sio_pdma[i].p_addr = (int)sio_addr[i];
		sio_pdma[i].p_arg = (int)&sio_tty[i];
		sio_pdma[i].p_fcn = sioxint;
	}
}

sioopen(dev, flag)
dev_t	dev;
{
	register int unit = minor(dev);
	register struct tty *tp = &sio_tty[unit];
	int s;
#ifdef	GWS
	if (gpaddr && unit == 1)	/* with graphics, dont open mouse! */
		return (EBUSY);
#endif	GWS

	if (unit >= NSIO)
		return (ENXIO);
	tp->t_addr = (caddr_t)&sio_pdma[unit];
	tp->t_oproc = siostart;
	tp->t_state |= TS_WOPEN;
	if ((tp->t_state&TS_ISOPEN) == 0) {
		ttychars(tp);
		tp->t_ospeed = tp->t_ispeed = sio_ispeed;
		tp->t_flags = IFLAGS;
		sioparam(unit);
	} else if ((tp->t_state&TS_XCLUDE) && u.u_uid != 0)
		return (EBUSY);

	/*
	 * If someone already has the device open for exclusive access,
	 * and we are legit child of pid #1 (init), return with error EBUSY.
	 * Init should have been modified to know how to deal
	 * with this situation.
	 */
	if ((tp->t_state & TS_XCLUDE)  &&  (u.u_procp->p_flag & SLOGIN))
		return (EBUSY);

	s = spl6();
	if (siomdm(unit, 1))
		tp->t_state |= TS_CARR_ON;
#ifdef TTY_NODELAY
	if ((flag & FNDELAY) == 0)
#endif
	while ((tp->t_state & TS_CARR_ON) == 0) {
		tp->t_state |= TS_WOPEN;
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
		if ((tp->t_state & TS_XCLUDE) && (u.u_procp->p_flag & SLOGIN)) {
			splx(s);
			return (EBUSY);
		}
	}
	splx(s);
	return ((*linesw[tp->t_line].l_open)(dev, tp));
}

sioclose(dev, flag)
dev_t	dev;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	(*linesw[tp->t_line].l_close)(tp);
	/* should send a break */
	if (tp->t_state&(TS_HUPCLS|TS_WOPEN) || (tp->t_state&TS_ISOPEN)==0)
		siomdm(minor(dev), 0);
#ifdef	NOMDM
	tp->t_flags &= ~NOMDM;
#endif	NOMDM
	ttyclose(tp);
}

sioread(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	return((*linesw[tp->t_line].l_read)(tp, uio));
}

siowrite(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	return((*linesw[tp->t_line].l_write)(tp, uio));
}

/*
 * ioctl
 */
sioioctl(dev, cmd, addr, flag)
dev_t	dev;
caddr_t	addr;
{
	register int error, unit;
	register struct tty *tp;

	tp = &sio_tty[(unit = minor(dev))];
	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, addr, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, addr, flag);
	if (error >= 0) {
		if (cmd == TIOCSETP || cmd == TIOCSETN ||
		    cmd == TIOCLSET || cmd == TIOCLBIS || cmd == TIOCLBIC)
			sioparam(unit);
		return (error);
	} 
	switch (cmd) {
/* should add break stuff
	    case TIOCSBRK:
		break;

	    case TIOCCBRK:
		break;
*/

	    case TIOCSDTR:
		siomdm(tp->t_addr, 1);
		break;

	    case TIOCCDTR:
		siomdm(tp->t_addr, 0);
		break;

	    default:
		return (ENOTTY);
	}
	return (0);
}

/*
 * param: program a channel
 */
sioparam(unit)
register int unit;
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];
	u_char mr1, mr2, csr;
	int s;

	if ((tp->t_ispeed)==0) {
		tp->t_state |= TS_HUPCLS;
	/*	siomdm(tp->t_addr, 0); will close line before sioclose() BN*/
		return;
	}
	if (tp->t_ispeed == B134)
		mr1 = MR1_6_BIT|MR1_PAR_WITH;
	else if (tp->t_flags & (RAW|LITOUT))
		mr1 = MR1_8_BIT|MR1_PAR_NONE;
	else
		mr1 = MR1_7_BIT|MR1_PAR_WITH;
	if ((tp->t_flags & EVENP) && (tp->t_flags & ODDP))
		mr1 = MR1_8_BIT|MR1_PAR_NONE;
	else if (tp->t_flags & EVENP)
		mr1 |= MR1_PAR_EVEN;
	else
		mr1 |= MR1_PAR_ODD;
	if (tp->t_ispeed == B110)
		mr2 = MR2_2_STOP;
	else
		mr2 = MR2_1_STOP;
	csr = (sio_bconv[tp->t_ispeed] << 4) | sio_bconv[tp->t_ospeed];

	s = spl6();
	/* if already enabled, wait for transimitter to go empty */
	if (s2681_imr & (0x02<<(unit*4)))
	    while ((sioaddr->s2681_r_sr&SR_TXEMT) == 0)
		;
	sioaddr->s2681_w_cr = CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX;
	sioaddr->s2681_mr1 = mr1;
	sioaddr->s2681_mr2 = mr2;
	sioaddr->s2681_w_csr = csr;
	if (unit == 0)
		s2681_imr |= 0x02;
	else
		s2681_imr |= 0x20;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
	sioaddr->s2681_w_cr = CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX;
	splx(s);
}

/*
 * siostart:
 */
siostart(tp)
register struct tty *tp;
{
	struct pdma *dp = (struct pdma *)tp->t_addr;
	register struct s2681device *sioaddr = (struct s2681device *)dp->p_addr;
	register int c;
	int s;
 
	s = spl6();
	if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	tp->t_state |= TS_BUSY;
	c = getc(&tp->t_outq);
	sioaddr->s2681_w_thr = c;
	if (sioaddr == SIOCONSOLE)
		s2681_imr |= 0x01;
	else
		s2681_imr |= 0x10;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
out:	splx(s);
}

siostop(tp, flag)
	register struct tty *tp;
{
	register int s;

	s = spl6();
	if (tp->t_state & TS_BUSY) {
		if ((tp->t_state&TS_TTSTOP)==0)
			tp->t_state |= TS_FLUSH;
	}
	splx(s);
}

sioint()
{
	register u_char isr = SIOCONSOLE->s2681_r_isr & s2681_imr;

	if (isr & 0x20)
		siorint(1);
	if (isr & 0x10)
		siotint(1);
	if (isr & 0x02)
		siorint(0);
	if (isr & 0x01)
		siotint(0);
}

siorint(unit)
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];
	register u_char c, sr;

	while (1) {
		sr = sioaddr->s2681_r_sr;
		if ((sr&SR_RXRDY) == 0)
			return;
		c = sioaddr->s2681_r_rhr;
/* TODO -- look at sr in detail */
#ifdef	MONITOR
		if (unit == 0) {
			static short mon_on = 0;
			if ((c & 0x7F) == MONITOR && monitor_debug) {
				mon_on = !mon_on;
				continue;
			}
			if (mon_on) {
				c &= 0x7F;
				monitor(c,
				    *(unsigned short *)((char *)(&unit) + 26),
				    *(long *)((char *)(&unit) + 28));
				mon_on = 0;
				continue;
			}
		}
#endif	MONITOR

		if ((tp->t_state & (TS_ISOPEN|TS_WOPEN))
#ifdef	GWS
			|| (tp->t_line == KYBDDISC)
#endif	GWS
								)

#if NBK > 0 || Nbk > 0
			if (tp->t_line == NETLDISC) {
				c &= 0177;
				BKINPUT(c, tp);
			} else
#endif
				(*linesw[tp->t_line].l_rint)(c, tp);
	}
}

siotint(unit)
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];
	int s;

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	s = spl6();
	tp->t_state &= ~TS_BUSY;
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	if (unit == 0)
		s2681_imr &= ~0x01;
	else
		s2681_imr &= ~0x10;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		siostart(tp);
	splx(s);
}

/* 
 * pseudo dma interupt
 */
sioxint(tp)
register struct tty *tp;
{
	register struct pdma *dp = (struct pdma *)tp->t_addr;
	register int	s;

printf("sioxint: ");
	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	s = spl6();
	tp->t_state &= ~TS_BUSY;
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	else {
		ndflush(&tp->t_outq, dp->p_mem-tp->t_outq.c_cf);
		dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	}
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		siostart(tp);
}

siomdm(unit, onoff)
{
	return (1);
}

/*
 * Print a character on the SIO port 0.
 */
sioputchar(c)
register c;
{
	while ((SIOCONSOLE->s2681_r_sr & SR_TXRDY) == 0)
		;
	SIOCONSOLE->s2681_w_thr = c;
#ifdef	PORT1PRINTF
	if (c != '\r') {
		while ((SIOPORT1->s2681_r_sr & SR_TXRDY) == 0)
			;
		SIOPORT1->s2681_w_thr = c;	/* other port too ! */
		DELAY(10000);
	} else
		DELAY(1000000);
#endif	PORT1PRINTF
	if (c == '\n')
		sioputchar('\r');
}

siogetchar()
{
	while ((SIOCONSOLE->s2681_r_sr & SR_RXRDY) == 0)
		;
	return(SIOCONSOLE->s2681_r_rhr & 0177);
}

#ifdef	MONITOR
monitor(c, sr, pc)
char c;
unsigned short sr;
long pc;
{
	static short ns = 0;
	static short nm = 0;
#ifndef QBUS
	extern short usegp;		/* enable/disable gip */
#endif	QBUS

	printf("MONITOR: pid=%d sr=0x%x pc=0x%x\n", u.u_procp->p_pid, sr, pc);
	switch(c) {
	  case 'C':
		prcmap();
		break;
	  case 'S':
		sleeptrace(ns%5);
		ns++;
		break;
	  case 'B':
		bufertrace();
		break;
	}
}
#endif	MONITOR
