#define MONITOR	0x1f	/* */
/*#define PORT1PRINTF /* */
/*#define XTRASLOW /* */
#ifndef	QBUS
#endif	QBUS
/*	sio.c	6.1	83/07/29	*/

/*
 * sio driver
 */
#include "../machine/pte.h"
#include "../machine/psl.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../machine/board.h"
#include "../is68kdev/sioreg.h"
#include "../is68kdev/ctcreg.h"
#include "../is68kdev/pdma.h"

#ifdef	GWS
#include "../is68kdev/gpreg.h"
#endif	GWS
#define	TTY_NODELAY

int			monitor_debug;
int	 		cpuspeed;
int			sio_ispeed;
int			ctc_div = 4;

/*
 * There is no driver information for auto-configuration.  It is assumed that
 * you always have two sio ports, and their major number is 0.
 */
struct tty		sio_tty[NSIO];
struct pdma		sio_pdma[NSIO];
static u_short		sio_w5[NSIO];
struct ctcdevice 	*ctc_addr[NSIO] =
		 	{ (struct ctcdevice *)CTC0_ADR,
			  (struct ctcdevice *)CTC1_ADR	};
struct siodevice 	*sio_addr[NSIO] =
			{ (struct siodevice *)SIO0_ADR,
			  (struct siodevice *)SIO1_ADR	};
#define PORTA(x)	((struct siodevice *)(((int)(x) & 0xCFFFF8)+1))

int	siostart(),	sioxint(),	siodma();
int	ttrstrt();

struct siospeed {
	u_short	ctc_tc;
	u_short	sio_dv;
};

/* Hardware divide by four before ctc */
struct siospeed	siospeed_d4[BSR_NSPEEDS][NSPEEDS] = {
#ifdef BSR_CPUSPEED10
				/* 10.0000 MHz / 4 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	0,	0,		/* 110 (NOT SUPPORTED) */
	0,	0,		/* 134.5 (ibm) */
	0,	0,		/* 150 (NOT SUPPORTED) */
	195,	SIOW4_X64,	/* 200  */
	130,	SIOW4_X64,	/* 300  */
	65,	SIOW4_X64,	/* 600  */
	130,	SIOW4_X16,	/* 1200 (-0.1% error) */
	87,	SIOW4_X16,	/* 1800 ( 0.3% error) */
	65,	SIOW4_X16,	/* 2400 (-0.1% error) */
	33,	SIOW4_X16,	/* 4800 ( 1.4% error) */
	16,	SIOW4_X16,	/* 9600 (-1.7% error) */
	8,	SIOW4_X16,	/* 19200 (-1.7% error) */
	4,	SIOW4_X16,	/* 38400 (-1.7% error) */
#endif BSR_CPUSPEED10
#ifdef BSR_CPUSPEED12
				/* 11.5920 MHz / 4 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	0,	0,		/* 110 (NOT SUPPORTED) */
	0,	0,		/* 134.5 (ibm) */
	0,	0,		/* 150 (NOT SUPPORTED) */
	226,	SIOW4_X64,	/* 200  */
	151,	SIOW4_X64,	/* 300 ( 0.3% error) */
	75,	SIOW4_X64,	/* 600 (-0.5% error) */
	151,	SIOW4_X16,	/* 1200 ( 0.1% error) */
	101,	SIOW4_X16,	/* 1800 ( 0.4% error) */
	75,	SIOW4_X16,	/* 2400 (-0.6% error) */
	38,	SIOW4_X16,	/* 4800 ( 0.7% error) */
	19,	SIOW4_X16,	/* 9600 ( 0.7% error) */
	9,	SIOW4_X16,	/* 19200 (-4.8% error) */
	5,	SIOW4_X16,	/* 38400 ( 5.7% error) */
#endif BSR_CPUSPEED12
#ifdef BSR_CPUSPEED11
				/* 11.0592 MHz / 4 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	0,	0,		/* 110 (NOT SUPPORTED) */
	0,	0,		/* 134.5 (ibm) */
	0,	0,		/* 150 (NOT SUPPORTED) */
	216,	SIOW4_X64,	/* 200  */
	144,	SIOW4_X64,	/* 300  */
	72,	SIOW4_X64,	/* 600  */
	144,	SIOW4_X16,	/* 1200  */
	96,	SIOW4_X16,	/* 1800  */
	72,	SIOW4_X16,	/* 2400  */
	36,	SIOW4_X16,	/* 4800  */
	18,	SIOW4_X16,	/* 9600  */
	9,	SIOW4_X16,	/* 19200  */
	4,	SIOW4_X16,	/* 38400 (-12.5% error) */
#endif BSR_CPUSPEED11
#ifdef BSR_CPUSPEED8
				/* 8.0000 MHz / 4 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	0,	0,		/* 110 (NOT SUPPORTED) */
	232,	SIOW4_X64,	/* 134.5 (ibm) */
	208,	SIOW4_X64,	/* 150  */
	156,	SIOW4_X64,	/* 200  */
	104,	SIOW4_X64,	/* 300  */
	208,	SIOW4_X16,	/* 600  */
	104,	SIOW4_X16,	/* 1200 (-0.1% error) */
	69,	SIOW4_X16,	/* 1800 (-0.6% error) */
	52,	SIOW4_X16,	/* 2400 (-0.1% error) */
	26,	SIOW4_X16,	/* 4800 (-0.1% error) */
	13,	SIOW4_X16,	/* 9600 (-0.2% error) */
	7,	SIOW4_X16,	/* 19200 ( 7.0% error) */
	3,	SIOW4_X16,	/* 38400 (-8.5% error) */
#endif BSR_CPUSPEED8
};

#ifdef	QBUS
/* Hardware divide by eight before ctc */
struct siospeed	siospeed_d8[BSR_NSPEEDS][NSPEEDS] = {
#ifdef BSR_CPUSPEED10
				/* 10.0000 MHz / 8 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	178,	SIOW4_X64,	/* 110 ( 0.9% error) */
	142,	SIOW4_X64,	/* 134.5 (ibm) */
	130,	SIOW4_X64,	/* 150  */
	98,	SIOW4_X64,	/* 200 ( 0.5% error) */
	65,	SIOW4_X64,	/* 300  */
	130,	SIOW4_X16,	/* 600  */
	65,	SIOW4_X16,	/* 1200 (-0.1% error) */
	43,	SIOW4_X16,	/* 1800 (-0.9% error) */
	33,	SIOW4_X16,	/* 2400 ( 1.4% error) */
	16,	SIOW4_X16,	/* 4800 (-1.7% error) */
	8,	SIOW4_X16,	/* 9600 (-1.7% error) */
	4,	SIOW4_X16,	/* 19200 (-1.7% error) */
	2,	SIOW4_X16,	/* 38400 (-1.7% error) */
#endif BSR_CPUSPEED10
#ifdef BSR_CPUSPEED12
				/* 11.5920 MHz / 8 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	206,	SIOW4_X64,	/* 110 ( 0.9% error) */
	168,	SIOW4_X64,	/* 134.5 (ibm) */
	151,	SIOW4_X64,	/* 150 ( 0.7% error) */
	113,	SIOW4_X64,	/* 200  */
	75,	SIOW4_X64,	/* 300 (-0.3% error) */
	151,	SIOW4_X16,	/* 600 ( 0.2% error) */
	75,	SIOW4_X16,	/* 1200 (-0.6% error) */
	50,	SIOW4_X16,	/* 1800 (-0.6% error) */
	38,	SIOW4_X16,	/* 2400 ( 0.7% error) */
	19,	SIOW4_X16,	/* 4800 ( 0.7% error) */
	9,	SIOW4_X16,	/* 9600 (-4.8% error) */
	5,	SIOW4_X16,	/* 19200 ( 5.7% error) */
	2,	SIOW4_X16,	/* 38400 (-17.9% error) */
#endif BSR_CPUSPEED12
#ifdef BSR_CPUSPEED11
				/* 11.0592 MHz / 8 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	0,	0,		/* 75 (NOT SUPPORTED) */
	196,	SIOW4_X64,	/* 110  */
	161,	SIOW4_X64,	/* 134.5 (ibm) */
	144,	SIOW4_X64,	/* 150  */
	108,	SIOW4_X64,	/* 200  */
	72,	SIOW4_X64,	/* 300  */
	144,	SIOW4_X16,	/* 600  */
	72,	SIOW4_X16,	/* 1200  */
	48,	SIOW4_X16,	/* 1800  */
	36,	SIOW4_X16,	/* 2400  */
	18,	SIOW4_X16,	/* 4800  */
	9,	SIOW4_X16,	/* 9600  */
	4,	SIOW4_X16,	/* 19200 (-12.5% error) */
	2,	SIOW4_X16,	/* 38400 (-12.5% error) */
#endif BSR_CPUSPEED11
#ifdef BSR_CPUSPEED8
				/* 8.0000 MHz / 8 */
	0,	0,		/* HUP */
	0,	0,		/* 50 (NOT SUPPORTED) */
	208,	SIOW4_X64,	/* 75  */
	142,	SIOW4_X64,	/* 110  */
	116,	SIOW4_X64,	/* 134.5 (ibm) */
	104,	SIOW4_X64,	/* 150  */
	78,	SIOW4_X64,	/* 200  */
	208,	SIOW4_X16,	/* 300  */
	104,	SIOW4_X16,	/* 600  */
	52,	SIOW4_X16,	/* 1200 (-0.1% error) */
	35,	SIOW4_X16,	/* 1800 ( 0.8% error) */
	26,	SIOW4_X16,	/* 2400 (-0.1% error) */
	13,	SIOW4_X16,	/* 4800 (-0.1% error) */
	7,	SIOW4_X16,	/* 9600 ( 7.0% error) */
	3,	SIOW4_X16,	/* 19200 (-8.5% error) */
	2,	SIOW4_X16,	/* 38400 (18.6% error) */
#endif BSR_CPUSPEED8
};
#endif

/*
 * initialization table. 
 */
static char sioitab[] = {
	SIOW0_REXT | 						0,	/* 0 */
		SIOW0_RESET,						/* 1 */
	SIOW0_REXT | 						4,	/* 2 */
		SIOW4_X16|SIOW4_1STOP,					/* 3 */
	SIOW0_REXT | 						3,	/* 4 */
		SIOW3_8BITS|SIOW3_RXENBL,				/* 5 */
	SIOW0_REXT | 						5,	/* 6 */
		SIOW5_DTR|SIOW5_TXENBL|SIOW5_8BITS|SIOW5_RTS,		/* 7 */
	SIOW0_REXT | 						2,	/* 8 */
		64,		 /* KLUDGE interupt vector */		/* 9 */
	SIOW0_REXT | 						1,	/* 10 */
		SIOW1_EXTINT|SIOW1_TXINT|SIOW1_RXALL|SIOW1_STATVEC	/* 11 */
};

#define	W1ITAB	11	/* index for write reg 1 data */
#define	W3ITAB	5	/* index for write reg 3 data */
#define	W4ITAB	3	/* index for write reg 4 data */
#define	W5ITAB	7	/* index for write reg 5 data */

#define IFLAGS	(EVENP|ODDP|ECHO|XTABS|CRMOD)

/*
 * Sio initialization, called from startup().
 */
sioinit()
{
	register int i, j, s;
	static int sio_init = 0;
	
	/* only initialize the sio once ... */
	if (sio_init)
		return;
	sio_init = 1;
#ifdef	QBUS
	cpuspeed = *BSR & BSR_CPUSPEED;
#else	QBUS
	cpuspeed = ((~(*BSR)) & BSR_CPUSPEED) >> 4;
#endif	QBUS
	switch (*BSR & BSR_BAUD) {
	    case BSR_BAUD_9600:
		sio_ispeed = ((ctc_div == 4) ? B9600 : B4800);
		break;
	    case BSR_BAUD_19200:
		sio_ispeed = ((ctc_div == 4) ? EXTA : B9600);
		break;
	    case BSR_BAUD_1200:
		sio_ispeed = ((ctc_div == 4) ? B1200 : B600);
		break;
	    case BSR_BAUD_300:
		sio_ispeed = ((ctc_div == 4) ? B300 : B150);
		break;
	}
	s = spl6();
	DELAY(10000);				/* let I/O settle down */
	sioitab[W4ITAB] &= ~SIOW4_XMASK;
#ifdef	QBUS
	if (ctc_div == 8)
		sioitab[W4ITAB] |= siospeed_d8[cpuspeed][sio_ispeed].sio_dv;
	else
#endif	QBUS
		sioitab[W4ITAB] |= siospeed_d4[cpuspeed][sio_ispeed].sio_dv;
	/*
	 * Program the ctc, the sio, and set up pseudo dma structures 
	 */
	for (i = 0 ; i < NSIO ; i++) {
		ctc_addr[i]->ctc_ctrl = CTC_CTRL | CTC_TCF | CTC_CNT;
#ifdef	QBUS
		if (ctc_div == 8)
			ctc_addr[i]->ctc_ctrl = 
				siospeed_d8[cpuspeed][sio_ispeed].ctc_tc;
		else
#endif	QBUS
			ctc_addr[i]->ctc_ctrl = 
				siospeed_d4[cpuspeed][sio_ispeed].ctc_tc;
		for (j=0; j<sizeof(sioitab); j++)
			sio_addr[i]->sio_ctrl = sioitab[j];
		/* the console gets DTR asserted on initial programming */
#ifndef	PORT1PRINTF
		sioitab[W5ITAB] &= ~SIOW5_DTR;
#endif	PORT1PRINTF
		sio_pdma[i].p_addr = (int)sio_addr[i];
		sio_pdma[i].p_arg = (int)&sio_tty[i];
		sio_pdma[i].p_fcn = sioxint;
	}
	splx(s);
}

sioopen(dev, flag)
dev_t	dev;
{
	register int unit = minor(dev);
	register struct tty *tp = &sio_tty[unit];
	int s;
#ifdef	GWS
	if (gpaddr && unit == 1)	/* with graphics, dont open mouse! */
		return (EBUSY);
#endif	GWS

	if (unit >= NSIO)
		return (ENXIO);
	tp->t_addr = (caddr_t)&sio_pdma[unit];
	tp->t_oproc = siostart;
	tp->t_state |= TS_WOPEN;
	if ((tp->t_state&TS_ISOPEN) == 0) {
		ttychars(tp);
		tp->t_ospeed = tp->t_ispeed = sio_ispeed;
		tp->t_flags = IFLAGS;
		sioparam(unit);
	} else if ((tp->t_state&TS_XCLUDE) && u.u_uid != 0)
		return (EBUSY);

	/*
	 * If someone already has the device open for exclusive access,
	 * and we are legit child of pid #1 (init), return with error EBUSY.
	 * Init should have been modified to know how to deal
	 * with this situation.
	 */
	if ((tp->t_state & TS_XCLUDE)  &&  (u.u_procp->p_flag & SLOGIN))
		return (EBUSY);

	s = spl6();
	if (siomdm(unit, 1))
		tp->t_state |= TS_CARR_ON;
#ifdef TTY_NODELAY
	if ((flag & FNDELAY) == 0)
#endif
	while ((tp->t_state & TS_CARR_ON) == 0) {
		tp->t_state |= TS_WOPEN;
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
		if ((tp->t_state & TS_XCLUDE) && (u.u_procp->p_flag & SLOGIN)) {
			splx(s);
			return (EBUSY);
		}
	}
	splx(s);
	return ((*linesw[tp->t_line].l_open)(dev, tp));
}

sioclose(dev, flag)
dev_t	dev;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	(*linesw[tp->t_line].l_close)(tp);
	/* should send a break */
	if (tp->t_state&(TS_HUPCLS|TS_WOPEN) || (tp->t_state&TS_ISOPEN)==0)
		siomdm(minor(dev), 0);
#ifdef	NOMDM
	tp->t_flags &= ~NOMDM;
#endif	NOMDM
	ttyclose(tp);
}

sioread(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	return((*linesw[tp->t_line].l_read)(tp, uio));
}

siowrite(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

	return((*linesw[tp->t_line].l_write)(tp, uio));
}

/* 
 * recv intr
 */
siorint(unit)
{
	register int c;
	register struct siodevice *sioaddr = sio_addr[unit];
	register struct tty *tp = &sio_tty[unit];

	do {
		c = sioaddr->sio_data;

#ifdef	MONITOR
		if (unit == 0) {
			static short mon_on = 0;
			if ((c & 0x7F) == MONITOR && monitor_debug) {
				mon_on = !mon_on;
				continue;
			}
			if (mon_on) {
				c &= 0x7F;
				monitor(c,
				    *(unsigned short *)((char *)(&unit) + 26),
				    *(long *)((char *)(&unit) + 28));
				mon_on = 0;
				continue;
			}
		}
#endif

		if ((tp->t_state & (TS_ISOPEN|TS_WOPEN))
#ifdef	GWS
					|| tp->t_line == KYBDDISC)
#else	GWS
					)
#endif	GWS

#if NBK > 0 || Nbk > 0
			if (tp->t_line == NETLDISC) {
				c &= 0177;
				BKINPUT(c, tp);
			} else
#endif
				(*linesw[tp->t_line].l_rint)(c, tp);
	} while (sioaddr->sio_ctrl & SIOR0_RXRDY);
	PORTA(sioaddr)->sio_ctrl = SIOW0_RETINT;
}

/*
 * ioctl
 */
sioioctl(dev, cmd, addr, flag)
dev_t	dev;
caddr_t	addr;
{
	register int error, unit;
	register struct tty *tp;

	tp = &sio_tty[(unit = minor(dev))];
	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, addr, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, addr, flag);
	if (error >= 0) {
		if (cmd == TIOCSETP || cmd == TIOCSETN ||
		    cmd == TIOCLSET || cmd == TIOCLBIS || cmd == TIOCLBIC)
			sioparam(unit);
		return (error);
	} 
	switch (cmd) {
/* should add break stuff
	    case TIOCSBRK:
		((struct cpdevice *)(tp->t_addr))->cp_brk |= 1<<line;
		break;

	    case TIOCCBRK:
		((struct cpdevice *)(tp->t_addr))->cp_brk &= ~(1<<line);
		break;
*/

	    case TIOCSDTR:
		siomdm(tp->t_addr, 1);
		break;

	    case TIOCCDTR:
		siomdm(tp->t_addr, 0);
		break;

	    default:
		return (ENOTTY);
	}
	return (0);
}

/*
 * param: program a channel
 */
sioparam(unit)
register int unit;
{
	register struct tty *tp = &sio_tty[unit];
	register struct siodevice *sioaddr = sio_addr[unit];
	register struct ctcdevice *ctcaddr = ctc_addr[unit];
	register int flags = tp->t_flags, s;
	char w1, w3, w4, w5, tc;

	if ((tp->t_ispeed)==0) {
		tp->t_state |= TS_HUPCLS;
	/*	siomdm(tp->t_addr, 0); will close line before sioclose()  BN*/
		return;
	}
/*	DELAY(10000); /**/
#ifdef	QBUS
	if (ctc_div == 8)
		tc = siospeed_d8[cpuspeed][tp->t_ispeed].ctc_tc;
	else
#endif	QBUS
		tc = siospeed_d4[cpuspeed][tp->t_ispeed].ctc_tc;
	if (tc == 0) {
		if (tp->t_ispeed == 0)
			tp->t_state |= TS_HUPCLS;
		else
			u.u_error = ENXIO;
		return;
	}
	w1 = sioitab[W1ITAB] & ~SIOW1_RXMASK;
	w3 = sioitab[W3ITAB] & ~SIOW3_BMASK;
#ifdef	QBUS
	if (ctc_div == 8)
		w4 = siospeed_d8[cpuspeed][tp->t_ispeed].sio_dv;
	else
#endif	QBUS
		w4 = siospeed_d4[cpuspeed][tp->t_ispeed].sio_dv;
	w5 = (sioitab[W5ITAB] & ~SIOW5_BMASK) | 
		(sio_w5[unit] & (SIOW5_DTR | SIOW5_BREAK));
	if (tp->t_ispeed == B134) {
		w3 |= SIOW3_6BITS;
		w4 |= SIOW4_PENBL;
		w5 |= SIOW5_6BITS;
	} else if (flags & (RAW|LITOUT)) {
		w3 |= SIOW3_8BITS;
		w5 |= SIOW5_8BITS;
	} else {
		w3 |= SIOW3_7BITS;
		w4 |= SIOW4_PENBL;
		w5 |= SIOW5_7BITS;
	}
	if ((flags & EVENP ) && (flags & ODDP))
		w1 |= SIOW1_RXALL;
	else
		w1 |= SIOW1_RXALLPV;
	if (flags & EVENP)
		w4 |= SIOW4_PEVEN;
	if (tp->t_ispeed == B110)
		w4 |= SIOW4_2STOP;
	else
		w4 |= SIOW4_1STOP;
	s = spl6();
	ctcaddr->ctc_ctrl = CTC_CTRL | CTC_TCF | CTC_CNT;
	ctcaddr->ctc_ctrl = tc;
	sioaddr->sio_ctrl = SIOW0_NULL | 4;
	sioaddr->sio_ctrl = w4;
	sioaddr->sio_ctrl = SIOW0_NULL | 3;
	sioaddr->sio_ctrl = w3;
	sioaddr->sio_ctrl = SIOW0_NULL | 5;
	sioaddr->sio_ctrl = sio_w5[unit] = w5;
	sioaddr->sio_ctrl = SIOW0_NULL | 1;
	sioaddr->sio_ctrl = w1;
	splx(s);
/*	DELAY(10000); /**/
}

/* 
 * pseudo dma interupt
 */
sioxint(tp)
register struct tty *tp;
{
	register struct pdma *dp = (struct pdma *)tp->t_addr;
	register int	s;

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	s = spl6();
	tp->t_state &= ~TS_BUSY;
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	else {
		ndflush(&tp->t_outq, dp->p_mem-tp->t_outq.c_cf);
		dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	}
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		siostart(tp);
}

/*
 * siostart:
 */
siostart(tp)
register struct tty *tp;
{
	register struct pdma *dp = (struct pdma *)tp->t_addr;
	register struct siodevice *sioaddr = (struct siodevice *)dp->p_addr;
	register int cc, c;
	int s, sio, unit;
 
	s = spl6();
	if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags & (RAW|LITOUT))
		cc = ndqb(&tp->t_outq, 0);
	else {
		cc = ndqb(&tp->t_outq, 0200);

		if (cc == 0) {
			cc = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (cc&0x7f) + 6);
			tp->t_state |= TS_TIMEOUT;
			goto out;
		}
	}
	tp->t_state |= TS_BUSY;
	c = getc(&tp->t_outq);
	dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	dp->p_end += cc - 1;
	((struct siodevice *)dp->p_addr)->sio_data = c;
out:	splx(s);
}

siostop(tp, flag)
	register struct tty *tp;
{
	register struct pdma *dp = (struct pdma *)tp->t_addr;
	register int s;

	s = spl5();
	if (tp->t_state & TS_BUSY) {
		dp->p_end = dp->p_mem;
		if ((tp->t_state&TS_TTSTOP)==0)
			tp->t_state |= TS_FLUSH;
	}
	splx(s);
}

/* 
 * externel status intr
 */
sioeint(unit)	
{
	register struct siodevice 	*sioaddr = sio_addr[unit];
	register struct tty	*tp = &sio_tty[unit];

	if (sioaddr->sio_ctrl & SIOR0_DCD) {
		if ((tp->t_state&TS_CARR_ON) == 0) {
			tp->t_state |= TS_CARR_ON;
			wakeup((caddr_t)&tp->t_rawq);
		}
	} else {
		if (tp->t_state&TS_CARR_ON && tp->t_state&TS_ISOPEN) {
			gsignal(tp->t_pgrp, SIGHUP);
			gsignal(tp->t_pgrp, SIGCONT);
			siomdm(unit, 0);	/* drop DTR */
			ttyflush(tp, FREAD|FWRITE);
		}
		tp->t_state &= ~TS_CARR_ON;
	}
	sioaddr->sio_ctrl = SIOW0_REXT;
	PORTA(sioaddr)->sio_ctrl = SIOW0_RETINT;
}

/* 
 * special recieve intr
 */
siosint(unit)
{
	register struct siodevice 	*sioaddr = sio_addr[unit];
	register struct tty *tp = &sio_tty[unit];
	register int c,rr1;

	sioaddr->sio_ctrl = 1;
	rr1 = sioaddr->sio_ctrl;
	sioaddr->sio_ctrl = SIOW0_RERR;
	c = sioaddr->sio_data;
	PORTA(sioaddr)->sio_ctrl = SIOW0_RETINT;
}

siomdm(unit, onoff)
{
	register struct siodevice 	*sioaddr = sio_addr[unit];
	int x;

	x = spl6();
	sioaddr->sio_ctrl = SIOW0_NULL | 5;
	if (onoff)
		sioaddr->sio_ctrl = (sio_w5[unit] |= SIOW5_DTR);
	else
		sioaddr->sio_ctrl = (sio_w5[unit] &= ~SIOW5_DTR);
	sioaddr->sio_ctrl = SIOW0_NULL | 0;
	splx(x);
	return (sioaddr->sio_ctrl & SIOR0_DCD);
}

/*
 * Print a character on the SIO port 0.
 */
sioputchar(c)
register c;
{
	register struct siodevice *sioaddr = sio_addr[0];
	register int s, timo;

	s = splx(PSL_IPL7&~PSL_T);
	timo = 80000;
	if (c == 0)
		return;
	while ((sioaddr->sio_ctrl & SIOR0_TXRDY)==0 && --timo)
		;
	sioaddr->sio_data = c;
#ifdef XTRASLOW
	DELAY(10000);
#endif XTRASLOW
#ifdef PORT1PRINTF
	DELAY(1000);
	if (c != '\r')
		sio_addr[1]->sio_data = c;  /* put out to port 1 too !!!!! */
#endif PORT1PRINTF
	if (c == '\n') {
		sioputchar('\r');
#ifdef PORT1PRINTF
		DELAY(10000);
#else  PORT1PRINTF
		DELAY(1000);
#endif PORT1PRINTF
	}
	sioputchar(0);
	splx(s);
}

siogetchar()
{
	register struct siodevice *sioaddr = sio_addr[0];
	register int c, s;

	s = spl7();
	while ((sioaddr->sio_ctrl & SIOR0_RXRDY)==0)
		;
	sioputchar(c = sioaddr->sio_data);
	splx(s);
	return (c);
}

#ifdef	MONITOR
monitor(c, sr, pc)
char c;
unsigned short sr;
long pc;
{
	static short ns = 0;
	static short nm = 0;
#ifndef QBUS
	extern short usegp;		/* enable/disable gip */
#endif	QBUS

	printf("MONITOR: pid=%d sr=0x%x pc=0x%x\n", u.u_procp->p_pid, sr, pc);
	switch(c) {
	  case 'C':
		prcmap();
		break;
	  case 'S':
		sleeptrace(ns%5);
		ns++;
		break;
	  case 'U':
		prmmu(1);
		break;
	  case 'M':
		prmmu(nm%2);		/* mod number of contexts used... */
		nm++;
		break;
	  case 'B':
		bufertrace();
		break;
#ifndef	QBUS
	  case 'G':
		printf("Graphics processor is %s\n", (usegp ^= 1)?"on":"off");
		break;
#endif	QBUS
	}
}
#endif	MONITOR
