
/*	sdreg.h	6.1	83/07/29	*/

struct sddevice {
	u_short		sdcs;		/* control status */
	u_short		sdda;		/* disk address register */
	u_short		sdba;		/* bus address register */
	u_short		sdwc;		/* word count register */
	u_short		sdae;		/* disk and bus address extension */
	u_short		sdsw[3];	/* sense words */
};

/* rlcs */
/* commands */
#define	SD_FORMAT	0x0000		/* format and read bad track map */
#define	SD_0002		0x0002		/* N/A */
#define	SD_SIZE		0x0004		/* size disk */
#define	SD_SEEK		0x0006		/* seek */
#define	SD_0008		0x0008		/* N/A */
#define	SD_WRITE	0x000A		/* write data with implicit seek */
#define	SD_READ		0x000C		/* read data with implicit seek */
#define	SD_000E		0x000E		/* N/A */

#define	SD_DRDY		0x0001		/* When set indicates device is ready */
#define	SD_IE		0x0040		/* interrupt enable */
#define	SD_CBSY		0x0080		/* controller busy */
#define	SD_DS0		0x0100		/* drive ssdect 0 */
#define	SD_DS1		0x0200		/* drive ssdect 1 */
#define SD_EF_MASK	0x3c00		/* error field mask */
#define SD_EF_SHFT	10		/* error field shift */
#define	SD_DB		0x4000		/* selected drive busy */
#define	SD_ERR		0x8000		/* composite error */

#define	SD_DCRDY	(SD_DRDY | SD_CRDY)

#define	SDCS_BITS \
"\20\20ERR\17DB\16NXM\15HCK\14TCK\13OPI\12DS1\11DS0\10CBSY\7IE\1DRDY"
