#include "rd.h"
#if NRD > 0 || Nrd > 0

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#define	SWAPBLKS	66880

#define	SWAPRPID(mid)	((mid << 24) + 0xFFFF)

static short inited = 0;

rdopen(dev, mode)
  dev_t dev;
  int mode;
  {
	return /*REMswapinit(SWAPRPID(minor(dev)), mode, SWAPBLKS)*/0;
}

rdstrategy(bp)
  register struct buf *bp;
  {
	int err;
int a, b, c, d, e, f;
	int retry = 5;

/*	err = REMswap(rpid, rw, remdevx, blkno, bcount, addr);	*/
	if (!inited) {
		inited = 1;
		if (REMswapinit(SWAPRPID(minor(bp->b_dev)), 0, SWAPBLKS)) {
			inited = 0;
			bp->b_flags |= B_ERROR;
			iodone(bp);
printf("rdstrategy: REMswapinit failed\n");
			return;
		}
	}
  tryagain:
	if (err = REMswap(a=SWAPRPID(minor(bp->b_dev)), b=bp->b_flags & B_READ,
			c=bp->b_blkno >> 24, d=bp->b_blkno & 0xFFFFFF,
			e=bp->b_bcount, f=qbaddr(bp))) {
printf("REMswap(0x%x %d %d 0x%x 0x%x 0x%x) rtnd %d... ", a, b, c, d, e, f, err);
			if (--retry) {
printf("retrying\n");
				goto tryagain;
			}
	}
	if (err) {
printf("fatal error\n");
		bp->b_flags |= B_ERROR;
	}
	iodone(bp);
}

rdsize(dev)
  dev_t dev;
  {
	return SWAPBLKS;
}

rdread()
  {
	printf("rdread unimp\n");
}

rdwrite()
  {
	printf("rdwrite unimp\n");
}

rdreset()
  {
	printf("rdreset unimp\n");
}

rddump()
  {
	printf("rddump unimp\n");
}

#endif
