/*	qbvar.h	6.1	83/08/13	*/

/*
 * This file contains definitions related to the kernel structures for dealing 
 * with the q-bus.
 * 	Each qbus controller has a qb_ctlr structure.
 * 	Each qbus device has a qb_device structure.
 */

/*
 * Allow notational aid in converting UNIBUS drivers to work on qbus
 */
#define QBUBMAP

struct ivecvec {
	short	iv_offs;
	int	(*iv_intr)();
};

/*
 * Per ``controller'' structure: (E.g. one for each disk and tape controller, 
 * and other things which use and release buffered data paths.)  If a controller
 * has devices attached, then there are cross-referenced uba_drive structures.
 * This structure is the one which is queued in qbus resource wait, and saves 
 * the information about qbus resources which are used. The queue of devices 
 * waiting to transfer is also attached here.
 */
struct qb_ctlr {
	struct	qb_driver 	*qm_driver;
	short			qm_ctlr;	/* ctlr index in driver */
	short			qm_alive;	/* ctlr exists */
	u_short			*qm_addr;	/* overide ctlr i/o space adr */
	struct ivecvec		*qm_intr;	/* interrupt handler(s) */
	int			qm_psl;		/* psl to mask interrupts */
	struct	buf 		qm_tab;		/* device queue for ctlr */
};
#ifdef QBUBMAP
#define	um_driver	qm_driver
#define	um_ctlr		qm_ctlr
#define	um_alive	qm_alive
#define	um_addr		qm_addr
#define	um_intr		qm_intr
#define	um_tab		qm_tab
#endif QBUBMAP

/*
 * Per ``device'' structure: (A controller has devices or uses and releases 
 * buffered data paths). (Everything else is a ``device''.)  If a controller has
 * many drives attached, then there will be several qb_device structures 
 * associated with a single qb_ctlr structure.  This structure contains all the
 * information necessary to run a qbus device such as a dz or a dh.  It also 
 * contains information for slaves of qbus controllers as to which device on the
 * slave this is.  A flags field here can also be given in the system 
 * specification and is used to tell which dz lines are hard wired or other 
 * device specific parameters.
 * THE 'DNC' DESIGNATED FIELDS MAY BE REMOVED IF IT IS DETERMINED THAT WE WILL
 * NEVER HAVE A DEVICE WITHOUT A CONTROLER (ALL DRIVERS WOULD HAVE TO GET THIS
 * INFORMATION FROM THE CONTROLLER STRUCTURE).
 */
struct qb_device {
	struct	qb_driver 	*qi_driver;
	short			qi_unit;	/* unit number on the system */
	short			qi_ctlr;	/* mass ctlr number; -1 none */
	short			qi_slave;	/* slave on controller */
	short			qi_dk;		/* set to number for iostat */
	int			qi_flags;	/* parameter from system spec */
	short			qi_alive;	/* device exists */
	short			qi_type;	/* driver specific type */
	struct	qb_ctlr 	*qi_mi;		/* pointer to controler */
};
#ifdef QBUBMAP
#define	ui_driver	qi_driver
#define	ui_unit		qi_unit
#define	ui_ctlr		qi_ctlr
#define	ui_slave	qi_slave
#define	ui_dk		qi_dk
#define	ui_flags	qi_flags
#define	ui_alive	qi_alive
#define	ui_type		qi_type
#define	ui_mi		qi_mi
#endif QBUBMAP

/*
 * Per-driver structure.
 *
 * Each qbus driver defines entries for a set of routines as well as an array 
 * of device address which are acceptable to it. These are used at boot time 
 * by the configuration program.
 */
struct qb_driver {
	int			(*qd_probe)();	/* see if controler is there */
	int			(*qd_slave)();	/* see if a unit is there */
	int			(*qd_attach)();	/* setup driver for a slave */
	u_short			**qd_addr;	/* possible i/o base addresss */
	char			*qd_dname;	/* name of a device */
	struct 	qb_device 	**qd_dinfo;	/* links to qb_device structs */
	char			*qd_mname;	/* name of a controller */
	struct	qb_ctlr 	**qd_minfo;	/* links to qb_ctrl structs */
};
#ifdef QBUBMAP
#define	ud_probe	qd_probe
#define	ud_slave	qd_slave
#define	ud_attach	qd_attach
#define	ud_addr		qd_addr
#define	ud_dname	qd_dname
#define	ud_dinfo	qd_dinfo
#define	ud_mname	qd_mname
#define	ud_minfo	qd_minfo
#endif QBUBMAP

/*
 * qbcinit and qbdinit initialize device tables specifying possible devices. 
 * They are defined in "ioconf.c" which is generated by running 'config'.
 */
#ifdef KERNEL
extern	struct	qb_ctlr 	qbcinit[];
extern	struct	qb_device 	qbdinit[];
#endif KERNEL
