#define DO144		/* */
/*#define BAD144DEBUG	/* */
/*	qb.c	6.1	83/07/29	*/

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/dk.h"
#include "../h/cmap.h"
#include "../h/dkbad.h"
#include "../h/uio.h"
#include "../h/kernel.h"
#include "../h/proc.h"

#include "../is68kdev/qbvar.h"
#include "../machine/board.h"

/*
 * return the BUS physical address for the dma associated with a kernel buffer.
 */
qbaddr(bp)
register struct buf *bp;
{
#ifdef	QBUS
	register unsigned p;

	p = qbaddrmap(bp);
	if ((bdevsw[major(bp->b_dev)].d_flags&B_18BIT) && 
		((p+bp->b_bcount) > 0x40000) )
			panic("buffer not addressable");
	return (p);
#else	QBUS
	return(qbaddrmap(bp));
#endif	QBUS
}

qbaddrmap(bp)
register struct buf *bp;
{
	register unsigned v;
	register struct pte *pte;
	register struct proc *rp;
	register int o;

#ifdef	M68010
	if ((bp->b_flags & B_PHYS) == 0)
		return((unsigned int)bp->b_un.b_addr);
	v = btop(bp->b_un.b_addr);
#else	M68010
	v = btop(((int)bp->b_un.b_addr) & NONT_MASK);
#endif	M68010
	o = (int)bp->b_un.b_addr & PGOFSET;
	rp = (bp->b_flags&B_DIRTY) ? &proc[2] : bp->b_proc;
#ifdef	M68020
	if ((bp->b_flags & B_PHYS) == 0)
		pte = &Sysmap[v];
	else
#endif	M68020
	if (bp->b_flags & B_UAREA)
		pte = &rp->p_addr[v];
	else if (bp->b_flags & B_PAGET)
		pte = &Usrptmap[btokmx((struct pte *)bp->b_un.b_addr)];
	else
		pte = vtopte(rp, v);
	if (pte->pg_pfnum == 0) {
		printf("b_flags=0x%x b_addr=0x%x\n", bp->b_flags, bp->b_un.b_addr);
		printf("bp=0x%x swbuf=0x%x bp-swbuf=%d\n", bp, swbuf, bp - swbuf);
		panic("uba zero uentry");
	}
	return ((pte->pg_pfnum << PGSHIFT) | o);
}

badstrat(qi, bp, bad, strat, nspt, ntpc, ncpd, coff)
register struct buf *bp;
register struct qb_device *qi;
register struct dkbad *bad;
int (*strat)();
{
	int s, i, hadbad = 0, len = bp->b_bcount, error;
	daddr_t blkno;
	register int sbn = dkblock(bp) + (coff*nspt*ntpc);
	register int lbn = sbn + ((len+511) >> DEV_BSHIFT) - 1;
	register int bbn, nbs;
	static struct buf badbuf;
	register struct buf *bbp = &badbuf;
#define SAVE_BFLAGS	(B_WRITE|B_READ|B_BUSY|B_PHYS|B_AGE|B_DELWRI| \
			B_TAPE|B_UAREA|B_PAGET|B_DIRTY|B_PGIN|B_CACHE| \
			B_INVAL|B_LOCKED|B_HEAD|B_BAD|B_QUALIFY)

#ifdef	DO144
	/*
	 * if the bad sector map has not yet been read in then read it in
	 * and convert from DEC-144 (cyl/trk/sec) to block number.
	 */
  retry:
	if (bad->bt_csn == 0) {
		s = spl6();
		if (bbp->b_flags & B_BUSY) {
			bbp->b_flags |= B_WANTED;
			sleep((caddr_t)bbp, PRIBIO);
			splx(s);
			goto retry;
		}
		nbs = 0;
		bbp->b_flags = B_READ|B_BUSY;
		bbp->b_dev = (bp->b_dev&~7) | 2; /* partition C of drive */
/*		bbp->b_dev = makedev(major(bp->b_dev), 2); */
		bbp->b_bcount = sizeof (struct dkbad);
		bbp->b_un.b_addr = (caddr_t) bad;
		bbp->b_blkno = blkno = ncpd * nspt * ntpc - nspt;
		(*strat)(qi, bbp);
		error = u.u_error;
		biowait(bbp);
		u.u_error = error;
		error = bbp->b_flags & B_ERROR;
		if (bbp->b_flags & B_WANTED)
			wakeup((caddr_t)bbp);
		bbp->b_flags = 0;
		if (error) {
			printf("%s%d: cannot read bad sector map\n",
				qi->qi_driver->qd_dname, qi->qi_unit);
		    	bad->bt_csn = -1;
			goto done;	/* so we'll keep trying */
		}
#ifdef	BAD144DEBUG
		printf("%s%d: read bad144 map from block %d\n",
			qi->qi_driver->qd_dname, qi->qi_unit, blkno);
#endif	BAD144DEBUG
		if (bad->bt_csn != 0) {
		    for (i = 0; i < 126; i++) {
		   	if (bad->bt_bad[i].bt_cyl == 0xFFFF)
	    		    bad->bt_bad[i].bt_bn = -1;
		    	else if ((bad->bt_bad[i].bt_cyl > ncpd) ||
		            (((bad->bt_bad[i].bt_trksec>>8)&0xff)>ntpc)||
		            ((bad->bt_bad[i].bt_trksec&0xff) > nspt) ) {
				printf("%s%d: bad bad144 map\n",
					qi->qi_driver->qd_dname, qi->qi_unit);
				bad->bt_csn = -1;
				break;
		        } else {
#ifdef	BAD144DEBUG
				printf("%s%d:(cyl %d,trk %d,sec %d)",
				    qi->qi_driver->qd_dname, qi->qi_unit,
				    bad->bt_bad[i].bt_cyl,
				    (bad->bt_bad[i].bt_trksec>>8) & 0xff,
		            	    bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG
	    	    		bad->bt_bad[i].bt_bn = 
				    (((bad->bt_bad[i].bt_cyl * ntpc) +
				    ((bad->bt_bad[i].bt_trksec>>8)&0xff))
				    *nspt)+
				    (bad->bt_bad[i].bt_trksec&0xff);
				nbs++;
#ifdef	BAD144DEBUG
				printf("[blk %d] remapped to %d\n",
				    bad->bt_bad[i].bt_bn, blkno - nbs);
#endif	BAD144DEBUG
				
		        }
			
		    }
		    if (nbs != 0)
			    printf("%s%d: %d remapped sectors\n",
				qi->qi_driver->qd_dname, qi->qi_unit, nbs);
		    bad->bt_csn = 1;
		    bad->bt_mbz = nbs;
		} else
		    bad->bt_csn = -1;
	}
	/*
	 * search the bad sector map for remapped sectors 
	 */
	if (bad->bt_csn == 1) {
	    for (i=0; i < bad->bt_mbz; i++) {
		if ((bbn = bad->bt_bad[i].bt_bn) > lbn)
			break;
		if (bbn == -1)
			break;
		if (sbn <= bbn && bbn <= lbn) {
#ifdef	BAD144DEBUG
		printf("REMAP ");
		printf("dev=%x blk=%x cnt=%x baddr=%x bbn=%x sbn=%x lbn=%x ",
			bp->b_dev, bp->b_blkno, bp->b_bcount, 
			bp->b_un.b_addr, bbn, sbn, lbn);
#endif	BAD144DEBUG
			if (!hadbad) {
				hadbad++;
				s = spl6();
				while (bbp->b_flags & B_BUSY) {
					bbp->b_flags |= B_WANTED;
					sleep((caddr_t)bbp, PRIBIO);
				}
				splx(s);
				*bbp = *bp;
				bbp->b_flags &= SAVE_BFLAGS;
				bbp->b_dev = (bp->b_dev&~7) | 2;
/*				bbp->b_dev = makedev(major(bp->b_dev), 2); */
			}
			/* 
			 * transfer from sbn to bad block bbn
			 */
			if (sbn < bbn) {
				bbp->b_blkno = sbn;
				bbp->b_bcount = min(len,(bbn - sbn) * 512);
				bbp->b_flags &= SAVE_BFLAGS;
#ifdef	BAD144DEBUG
				printf("do up to bad block addr=%x count=%x ",
					bbp->b_un.b_addr,bbp->b_bcount);
#endif	BAD144DEBUG
				(*strat)(qi, bbp);
				biowait(bbp);
				bbp->b_un.b_addr += bbp->b_bcount;
#ifdef	BAD144DEBUG
				printf("count=%x resid=%x ",
					bbp->b_bcount,bbp->b_resid);
#endif	BAD144DEBUG
				len -= bbp->b_bcount-bbp->b_resid;
				if (bbp->b_flags & B_ERROR)
					goto error;
			}
			/* 
			 * transfer remapped bbn
			 */
			bbp->b_blkno = (ncpd*ntpc*nspt) - (nspt+1) - i;
			bbp->b_bcount = min(len, 512);
			bbp->b_flags &= SAVE_BFLAGS;
#ifdef	BAD144DEBUG
			printf("remap bad sector to %d addr=%x count=%x ",
				bbp->b_blkno,bbp->b_un.b_addr,bbp->b_bcount);
#endif	BAD144DEBUG
			(*strat)(qi, bbp);
			biowait(bbp);
			bbp->b_un.b_addr += bbp->b_bcount;
#ifdef	BAD144DEBUG
			printf("count=%x resid=%x ",bbp->b_bcount,bbp->b_resid);
#endif	BAD144DEBUG
			len -= bbp->b_bcount-bbp->b_resid;
			sbn = bbn+1;
			if (bbp->b_flags & B_ERROR)
				goto error;
		}
	    }
	    if (hadbad) {
		/* 
		 * transfer from sbn to lbn
		 */
		if (sbn <= lbn  &&  (bbp->b_flags & B_ERROR) == 0) {
			bbp->b_blkno = sbn;
			bbp->b_bcount = len;
			bbp->b_flags &= SAVE_BFLAGS;
#ifdef	BAD144DEBUG
			printf("do bad block to end addr=%x count=%x ",
				bbp->b_un.b_addr,bbp->b_bcount);
#endif	BAD144DEBUG
			(*strat)(qi, bbp);
			biowait(bbp);
#ifdef	BAD144DEBUG
			printf("count=%x resid=%x ",bbp->b_bcount,bbp->b_resid);
#endif	BAD144DEBUG
			len -= bbp->b_bcount-bbp->b_resid;
		}
error:
		bp->b_resid = len;
		if (bbp->b_flags & B_ERROR) {
			bp->b_flags |= B_ERROR;
			bp->b_error = bbp->b_error;
		}
		if (bbp->b_flags & B_WANTED)
			wakeup((caddr_t)bbp);
		bbp->b_flags = 0;
		iodone(bp);
#ifdef	BAD144DEBUG
		printf("done REMAP\n");
#endif	BAD144DEBUG
		return;
	    }
	}
done:
#endif	DO144
		(*strat)(qi, bp);
}
