/*	lp.c	6.1	83/07/29	*/

#include "lp.h"
#if NLP > 0 || Nlp > 0
#ifndef NLP
#define NLP	Nlp
#endif  NLP
#ifndef Nlp
#define Nlp	NLP
#endif  Nlp
/*
 * LP-11 Line printer driver
 *
 * This driver has been modified to work on printers where
 * leaving IENABLE set would cause continuous interrupts.
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/buf.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/uio.h"
#include "../h/tty.h"
#include "../h/kernel.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/lpreg.h"

#define	LPPRI	(PZERO+8)

struct lp_softc {
	struct	clist sc_outq;
	int	sc_state;
	int	sc_physcol;
	int	sc_logcol;
	int	sc_physline;
	char	sc_flags;
	short	sc_maxcol;
	int	sc_lpchar;
	struct	buf *sc_inbuf;
} lp_softc[NLP];

struct qb_device *lpinfo[NLP];

int lpprobe(), lpslave(), lpattach(), lptout();
u_short *lpstd[] = { (u_short *)0x3FFF4C, 0 };
struct qb_driver LPdriver =
	{ lpprobe, lpslave, lpattach, lpstd, "lp", lpinfo, "LP" };

/* bits for state */
#define	OPEN		1	/* device is open */
#define	TOUT		2	/* timeout is active */
#define	MOD		4	/* device state has been modified */
#define	ASLP		8	/* awaiting draining of printer */

int	lptout();

lpprobe(lpaddr)
register struct lpdevice *lpaddr;
{
	extern int cvec;

	lpaddr->lp_csr = IENABLE;
	DELAY(1000);
	lpaddr->lp_csr = 0;
	return (sizeof (struct lpdevice));
}

lpslave(qi)
struct qb_device *qi;
{
	return (1);
}

lpattach(qi)
struct qb_device *qi;
{
	register struct lp_softc *sc;

	sc = &lp_softc[qi->qi_unit];
	sc->sc_lpchar = -1;
	if (qi->qi_flags)
		sc->sc_maxcol = qi->qi_flags;
	else
		sc->sc_maxcol = MAXCOL;
	printf("	(%d columns)",sc->sc_maxcol);
}

lpopen(dev, flag)
dev_t dev;
int flag;
{
	register int unit;
	register struct lpdevice *lpaddr;
	register struct lp_softc *sc;
	register struct qb_device *qi;
	int s;

	if ((unit = LPUNIT(dev)) >= NLP ||
	    (sc = &lp_softc[unit])->sc_state&OPEN ||
	    (qi = lpinfo[unit]) == 0 || qi->qi_alive == 0)
		return (ENXIO);
	lpaddr = (struct lpdevice *)qi->qi_mi->qm_addr;
	if (lpaddr->lp_csr&ERROR)
		return (EIO);
	sc->sc_state |= OPEN;
	sc->sc_inbuf = geteblk(512);
	sc->sc_flags = LPCANON(dev);
	s = splx(qi->qi_mi->qm_psl);
	if ((sc->sc_state&TOUT) == 0) {
		sc->sc_state |= TOUT;
		timeout(lptout, (caddr_t)dev, 10*hz);
	}
	splx(s);
	lpcanon(dev, '\f');
	return (0);
}

lpclose(dev, flag)
dev_t dev;
int flag;
{
	register struct lp_softc *sc = &lp_softc[LPUNIT(dev)];
	int s;

	lpcanon(dev, '\f');
	if (sc->sc_flags&RAW) {
		s = splx(lpinfo[LPUNIT(dev)]->qi_mi->qm_psl);
		lpint(LPUNIT(dev));
		splx(s);
	}
	brelse(sc->sc_inbuf);
	sc->sc_state &= ~OPEN;
}

lpwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	register unsigned n;
	register char *cp;
	register struct lp_softc *sc = &lp_softc[LPUNIT(dev)];
	int error;

	while (n = min(512, (unsigned)uio->uio_resid)) {
		cp = sc->sc_inbuf->b_un.b_addr;
		error = uiomove(cp, (int)n, UIO_WRITE, uio);
		if (error)
			return (error);
		do
			lpcanon(dev, *cp++);
		while (--n);
	}
	return (0);
}

lpcanon(dev, c)
dev_t dev;
register int c;
{
	register int logcol, physcol;
	register struct lp_softc *sc = &lp_softc[LPUNIT(dev)];
	int s;

	if (sc->sc_flags&RAW) {
		lpoutput(dev, c);
		return;
	} else if (sc->sc_flags&CAP) {
		register c2;

		if (c>='a' && c<='z')
			c += 'A'-'a'; else
		switch (c) {

		case '{':
			c2 = '(';
			goto esc;

		case '}':
			c2 = ')';
			goto esc;

		case '`':
			c2 = '\'';
			goto esc;

		case '|':
			c2 = '!';
			goto esc;

		case '~':
			c2 = '^';

		esc:
			lpcanon(dev, c2);
			sc->sc_logcol--;
			c = '-';
		}
	}
	logcol = sc->sc_logcol;
	physcol = sc->sc_physcol;
	if (c == ' ')
		logcol++;
	else switch(c) {

	case '\t':
		logcol = (logcol+8) & ~7;
		break;

	case '\f':
		if (sc->sc_physline == 0 && physcol == 0)
			break;
		/* fall into ... */

	case '\n':
		lpoutput(dev, c);
		if (c == '\f')
			sc->sc_physline = 0;
		else
			sc->sc_physline++;
		physcol = 0;
		/* fall into ... */

	case '\r':
		logcol = 0;
		s = splx(lpinfo[LPUNIT(dev)]->qi_mi->qm_psl);
		lpint(LPUNIT(dev));
		splx(s);
		break;

	case '\b':
		if (logcol > 0)
			logcol--;
		break;

	default:
		if (logcol < physcol) {
			lpoutput(dev, '\r');
			physcol = 0;
		}
		if (logcol < sc->sc_maxcol) {
			while (logcol > physcol) {
				lpoutput(dev, ' ');
				physcol++;
			}
			lpoutput(dev, c);
			physcol++;
		}
		logcol++;
	}
	if (logcol > 1000)	/* ignore long lines  */
		logcol = 1000;
	sc->sc_logcol = logcol;
	sc->sc_physcol = physcol;
}

lpoutput(dev, c)
dev_t dev;
int c;
{
	register struct lp_softc *sc = &lp_softc[LPUNIT(dev)];
	int s;

	if (sc->sc_outq.c_cc >= LPHWAT) {
		s = splx(lpinfo[LPUNIT(dev)]->qi_mi->qm_psl);
		lpint(LPUNIT(dev));				/* unchoke */
		while (sc->sc_outq.c_cc >= LPHWAT) {
			sc->sc_state |= ASLP;		/* must be ERROR */
			sleep((caddr_t)sc, LPPRI);
		}
		splx(s);
	}
	while (putc(c, &sc->sc_outq))
		sleep((caddr_t)&lbolt, LPPRI);
}

lpint(lp11)
	int lp11;
{
	register int n;
	register struct lp_softc *sc = &lp_softc[lp11];
	register struct qb_device *qi = lpinfo[lp11];
	register struct lpdevice *lpaddr = (struct lpdevice *)qi->qi_mi->qm_addr;

	/* if busy and not done then wait on timeout when DONE */
	if ((lpaddr->lp_csr&BUSY) && (lpaddr->lp_csr&DONE)==0)
		return;
	lpaddr->lp_csr &= ~IENABLE;
	n = sc->sc_outq.c_cc;
	if (sc->sc_lpchar < 0)
		sc->sc_lpchar = getc(&sc->sc_outq);
	while ((lpaddr->lp_csr&DONE) && sc->sc_lpchar >= 0) {
		lpaddr->lp_dbr = sc->sc_lpchar;
		sc->sc_lpchar = getc(&sc->sc_outq);
	}
	sc->sc_state |= MOD;
	if (sc->sc_outq.c_cc > 0 && (lpaddr->lp_csr&ERROR)==0)
		lpaddr->lp_csr |= IENABLE;	/* ok and more to do later */
	if (n>LPLWAT && sc->sc_outq.c_cc<=LPLWAT && sc->sc_state&ASLP) {
		sc->sc_state &= ~ASLP;
		wakeup((caddr_t)sc);		/* top half should go on */
	}
}

lptout(dev)
	dev_t dev;
{
	register struct lp_softc *sc;
	register struct qb_device *qi;
	register struct lpdevice *lpaddr;

	sc = &lp_softc[LPUNIT(dev)];
	qi = lpinfo[LPUNIT(dev)];
	lpaddr = (struct lpdevice *) qi->qi_mi->qm_addr;
	if (sc->sc_state&MOD) {
		sc->sc_state &= ~MOD;		/* something happened */
		timeout(lptout, (caddr_t)dev, 2*hz);	/* so don't sweat */
		return;
	}
	if ((sc->sc_state&OPEN) == 0) {
		sc->sc_state &= ~TOUT;		/* no longer open */
		lpaddr->lp_csr = 0;
		return;
	}
	if (sc->sc_outq.c_cc && (lpaddr->lp_csr&DONE) && 
		(lpaddr->lp_csr&ERROR)==0)
			lpint(LPUNIT(dev));		/* ready to go */
	timeout(lptout, (caddr_t)dev, 10*hz);
}

lpreset()
{
	register struct qb_device *qi;
	register struct lpdevice *lpaddr;
	register int unit;

	for (unit = 0; unit < NLP; unit++) {
		if ((qi = lpinfo[unit]) == 0 || qi->qi_alive == 0)
			continue;
		printf(" lp%d", unit);
		lpaddr = (struct lpdevice *)qi->qi_mi->qm_addr;
		lpaddr->lp_csr |= IENABLE;
	}
}
#endif
