
/*	ldreg.h	1.0	11/16/85	*/

struct	lddevice	{
	u_short		ld_cmd[5];	/* command window (byte swaped) */
	u_short		ld_ba[2];	/* vme address (byte swaped) */
	u_short		ld_cs;		/* control and status word */
};

/* macros to aid in byte swapping */
#define	byte0(x)	(((u_char *)&x)[0])
#define	byte1(x)	(((u_char *)&x)[1])
#define	byte2(x)	(((u_char *)&x)[2])
#define	byte3(x)	(((u_char *)&x)[3])
#define	byteswap(x, y)	(((y&0xFF)<<8) | (x&0xFF))
#define	ldcommand(x, x0, x1, x2, x3, x4, x5, x6, x7, x8, x9)	{	\
	x[0]=byteswap(x0, x1); x[1]=byteswap(x2, x3); x[2]=byteswap(x4, x5);\
	x[3]=byteswap(x6, x7); x[4]=byteswap(x8, x9); }

/* macros to interprit minor device number */
#define UNIT(dev)	(minor(dev)>>3)
#define TARGET(dev)	((minor(dev)>>3)&0x1)	/* 2 Targets per controller */
#define CONTROLLER(dev)	((minor(dev)>>4))	/* 16 Controllers */

/* hard-wired disk geometry */
#define	LD_CYL		32000		/* # of cylinders */
#define	LD_TRACK	1		/* # of tracks (heads) */
#define	LD_SPT		32		/* # of sectors per track */
#define	LD_SEC_SIZE	1024		/* # bytes per sector */
#define	LD_SEC_MASK	0x3FF
#define	LD_SEC_SHIFT	10

/* ld_cs status bits READ */
#define	LDCS_SCSI_OK	0x0000		/* SCSI good status */
#define	LDCS_SCSI_CHK	0x0002		/* SCSI check condition */
#define	LDCS_SCSI_TBSY	0x0008		/* SCSI target busy */
#define	LDCS_HA_INTERR	0x0100		/* Host Adaptor interrupt error */
#define	LDCS_HA_PHASER	0x0200		/* Host Adaptor phase change error */
#define	LDCS_HA_NXMER	0x1000		/* Host Adaptor bus error */
#define	LDCS_HA_TARER	0x2000		/* Host Adaptor target select error */
#define	LDCS_HA_SNS	0x4000		/* 8 byte sense exsits automatically*/
#define	LDCS_HA_OK	0x8000		/* cmd complete */
#define	LDCS_HA_OK_8	0x8100		/* cmd compl. & 8 bytes returned */
#define	LDCS_HA_OK_16	0x8200		/* cmd compl. & 16 bytes returned */
#define	LDCS_OK_MASK	(LDCS_HA_OK|0xFF)
#define	LDCS_OK		(LDCS_SCSI_OK|LDCS_HA_OK)
#define	LDCS_BUSY		0xFFFF		/* controller busy */

/* ld_cs command bits WRITE */
#define	LDCS_TID	0x00E0		/* target id field */
#define	LDCS_TID_SHIFT	5		/* target id shift */
#define	LDCS_IE		0x0010		/* interrupt enable */
#define	LDCS_GO		0x0004		/* go bit */

/* SCSI commands, group 0 */
#define	LD_TSTRDY	0x00		/* test ready */
#define	LD_RZRO		0x01		/* rezero */
#define	LD_SENSE	0x03		/* request sense */
#define	LD_READ		0x08		/* read */
#define	LD_WRITE	0x0a		/* write */
#define	LD_SEEK		0x0b		/* seek */
#define	LD_SEARCH	0x0c		/* search for empty blocks */
#define	LD_INQ		0x12		/* inquiry command */
#define	LD_MSEL		0x15		/* mode select command */
#define	LD_RESERVE	0x16		/* reserve */
#define	LD_RLS		0x17		/* release reservation */
#define	LD_COPY		0x18
#define	LD_SLVG		0x19		/* salvage */
#define	LD_MDSN		0x1a		/* mode select command */
#define	LD_STSP		0x1b		/* start/stop command */
#define	LD_RDIAG	0x1c		/* recieve diagnostic information */
#define	LD_SDIAG	0x1d		/* send diagnostic */
/* SCSI commands, group 1 */
#define	LD_RCAP		0x25		/* read capacity */
#define	LD_EXREAD	0x28		/* extended read */
#define	LD_EXWRITE	0x2a		/* extended write */
#define	LD_EXSEEK	0x2b		/* extended seek */
#define	LD_WRT_VER	0x2e		/* write verify */
/* HOST ADAPTOR commands */
#define	LD_FOLOUP	0xf0		/* followup, get rest of status */
#define	LD_STAT		0xf1		/* KLUDGE: driver pseudo command */
#define	LD_VRSN		0xfe		/* get firmware version */
#define	LD_RST		0xff		/* reset */

/* ld ioctl commands */
#define	LD_IOC_TSTRDY	_IO(	l,	LD_TSTRDY)
#define	LD_IOC_RZRO	_IO(	l,	LD_RZRO)
#define	LD_IOC_SENSE	_IOR(	l,	LD_SENSE,	char [19+8])
#define	LD_IOC_SEEK	_IO(	l,	LD_SEEK)
#define	LD_IOC_INQ	_IOR(	l,	LD_INQ,		char [8])
#define	LD_IOC_MSEL	_IOW(	l,	LD_MSEL,	char [16])
#define	LD_IOC_MDSN	_IOR(	l,	LD_MDSN,	char [16])
#define	LD_IOC_STSP	_IO(	l,	LD_STSP)
#define	LD_IOC_RDIAG	_IOR(	l,	LD_RDIAG,	char [8])
#define	LD_IOC_SDIAG	_IO(	l,	LD_SDIAG)
#define	LD_IOC_RCAP	_IOR(	l,	LD_RCAP,	char [8])
#define	LD_IOC_FOLOUP	_IOR(	l,	LD_FOLOUP,	char [8])
#define	LD_IOC_STAT	_IOR(	l,	LD_STAT,	struct lddevice)
#define	LD_IOC_VRSN	_IOR(	l,	LD_VRSN,	char [16])
#define	LD_IOC_RST	_IO(	l,	LD_RST)
