/*	hp.c	6.1	83/07/29	*/

#include "hp.h"
#if NHP > 0 || Nhp > 0
/*
 * QBUS disk driver with:
 *	overlapped seeks,
 *	ECC recovery, and
 *	bad sector forwarding.
 *
 * TODO:
 *	Check that offset recovery code works
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../machine/board.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/hpreg.h"

struct	hp_softc {
	int	HP_softas;
	int	HP_ndrive;
	int	HP_wticks;
	int	HP_recal;
	int	HP_18bit;
} hp_softc[NHP];

struct	size {
	daddr_t	nblocks;
	int	cyloff;
};

#define	MAX_hp_HP	8

int	hpprobe(), hpslave(), hpattach(), hpdgo(), hpintr();
int	hpstrat(),	hpminphys();
struct	qb_ctlr *hpcinfo[NHP];
struct	qb_device *hpdinfo[Nhp];
struct	qb_device *hpip[NHP][MAX_hp_HP]; 

u_short	*hpstd[] = { (u_short *)0x3FFDC0, (u_short *)0x3FFCC0, 0 };

struct	qb_driver HPdriver =
    { hpprobe, hpslave, hpattach, hpstd, "hp", hpdinfo, "HP", hpcinfo };

struct	buf	hputab[Nhp];
char hpinit[Nhp];

struct	hpst {
	short	nspt;		/* # sectors/track */
	short	ntpc;		/* # tracks/cylinder */
	short	nspc;		/* # sectors/cylinder */
	short	ncpd;		/* # cylinders */
	short	sdist;		/* seek distance metric */
	short	rdist;		/* rotational distance metric */
	struct	size sizes[8];	/* partition table */
} hpst[Nhp];

struct hpstdt {
	short	dt;		/* drive type */
	short	nspt;		/* # sectors/track */
	short	ntpc;		/* # tracks/cylinder */
	short	ncpd;		/* # cylinders */
	short	sdist;		/* seek distance metric */
	short	rdist;		/* rotational distance metric */
	char	*str;		/* string describing drive type */
} hpstdt[] = {
	{HPDT_RM02,	32,	5,	823,	3,	4,	"RM02"},
	{HPDT_RM03,	32,	5,	823,	3,	4,	"RM03"},
	{HPDT_RM05,	32,	19,	823,	3,	4,	"RM05"},
	{HPDT_RP06,	22,	19,	815,	3,	4,	"RP06"},
	{HPDT_RM80,	31,	14, 	559,	3,	4,	"RM80"},
	{HPDT_RP04,	22,	19,	411,	3,	4,	"RP04"},
	{HPDT_RP05,	22,	19,	411,	3,	4,	"RP05"},
	{HPDT_RP07,	50,	32,	630,	7,	8,	"RP07"},
	{0,		0,	0,	0,	0,	0}
};

u_char	hp_offset[16] = {
	HPOF_P400, HPOF_M400, HPOF_P400, HPOF_M400,
	HPOF_P800, HPOF_M800, HPOF_P800, HPOF_M800, 
	HPOF_P1200, HPOF_M1200, HPOF_P1200, HPOF_M1200,
	0, 0, 0, 0
};

struct	buf	rhpbuf[Nhp];
struct 	buf	bhpbuf[Nhp];
struct	dkbad	hpbad[Nhp];

#define	b_cylin b_resid

#ifdef INTRLVE
daddr_t dkblock();
#endif INTRLVE

int	hpwstart, hpwatch();			/* Have started guardian */
int	hpseek;
int	hpwaitdry;

hpprobe(hpaddr)
register struct hpdevice *hpaddr;
{
	if (badaddr(&hpaddr->hpec2, 2))		/* dont confuse with RK */
		return (0);
	hpaddr->hpcs1 = HP_IE|HP_RDY;		/* causes interupt */
	DELAY(1000);
	hpaddr->hpcs1 = 0;
	return (sizeof (struct hpdevice));
}

hpslave(qi, hpaddr)
struct qb_device *qi;
struct hpdevice *hpaddr;
{
	hpaddr->hpcs1 = 0;			/* conservative */
	hpaddr->hpcs2 = qi->qi_slave;
	hpaddr->hpcs1 = HP_TRE|HP_NOP|HP_GO;
	if (hpaddr->hpcs2&HPCS2_NED) {
		hpaddr->hpcs1 = HP_TRE|HP_DCLR|HP_GO;
		return (0);
	}
	return (1);
}

hpattach(qi)
register struct qb_device *qi;
{

	if (hpwstart == 0) {
		timeout(hpwatch, (caddr_t)0, hz);
		hpwstart++;
	}
	if (qi->qi_dk >= 0)
		dk_mspw[qi->qi_dk] = .0000020345;
	hpip[qi->qi_ctlr][qi->qi_slave] = qi;
	hp_softc[qi->qi_ctlr].HP_ndrive++;
	printf("	");
	if (badaddr(&((struct hpdevice *)qi->qi_mi->qm_addr)->hpbae, 2)) {
		hp_softc[qi->qi_ctlr].HP_18bit++;
		printf("18bit ");
	}
	hpmaptype(qi);
}

hpmaptype(qi)
register struct qb_device *qi;
{
	register struct hpdevice *hpaddr = (struct hpdevice *)qi->qi_mi->qm_addr;
	register struct hpst *st = &hpst[qi->qi_unit];
	register struct hpstdt *stdt;
	int dt;

	hpaddr->hpcs1 = 0;
	hpaddr->hpcs2 = qi->qi_slave;
	if ( (*BSR & BSR_DISK ) == BSR_DISK_EHP) {
		printf("EMULEX ");
		hpaddr->hpof = HPOF_FMT16;	/* 16 bit words for sizeing */
		hpaddr->hphr = HPHR_MAXSECT;
		st->nspt = hpaddr->hphr + 1;
		hpaddr->hphr = HPHR_MAXTRAK;
		st->ntpc = hpaddr->hphr + 1;
		st->nspc = st->nspt * st->ntpc;
		hpaddr->hphr = HPHR_MAXCYL;
		st->ncpd = hpaddr->hphr + 1;
		st->sdist = 3;			/* KLUDGE */
		st->rdist = 4;
	} else {
		dt = hpaddr->hpdt & 0x3F;
		for (stdt = hpstdt; stdt->dt != 0; stdt++)
			if (dt == stdt->dt) {
				st->nspt = stdt->nspt;
				st->ntpc = stdt->ntpc;
				st->nspc = stdt->nspt * stdt->ntpc;
				st->ncpd = stdt->ncpd;
				st->sdist = stdt->sdist;
				st->rdist = stdt->rdist;
				break;
			}
		if (stdt->dt == 0)
			printf("unknown drive type ");
		else
			printf("%s ",stdt->str);
	}
	hpaddr->hpcs2 = HPCS2_CLR;
	printf("	%mM (%d x %d x %d) ",
		st->nspt * st->ntpc * st->ncpd * 512,
		st->nspt, st->ntpc, st->ncpd);
	diskpart(hpst[qi->qi_unit].sizes, st->nspt, st->ntpc, st->ncpd);
}
 
hpopen(dev)
dev_t dev;
{
	register int unit = minor(dev) >> 3;
	register struct qb_device *qi;

	if (unit >= Nhp || (qi = hpdinfo[unit]) == 0 || qi->qi_alive == 0)
		return (ENXIO);
	return (0);
}

hpstrategy(bp)
register struct buf *bp;
{
	register struct qb_device *qi;
	register struct hpst *st;
	register int unit;
	int partition = minor(bp->b_dev) & 07;
	long bn, sz;

	sz = (bp->b_bcount+511) >> DEV_BSHIFT;
	unit = dkunit(bp);
	if (unit >= Nhp)
		goto bad;
	qi = hpdinfo[unit];
	if (qi == 0 || qi->qi_alive == 0)
		goto bad;
	st = &hpst[qi->qi_unit];
	if (bp->b_blkno < 0 || 
		(bn = dkblock(bp))+sz > st->sizes[partition].nblocks)
			goto bad;
	badstrat(qi, bp, &hpbad[qi->qi_unit], hpstrat, 
		st->nspt, st->ntpc, st->ncpd, st->sizes[partition].cyloff);
	return;
bad:
	bp->b_flags |= B_ERROR;
	iodone(bp);
	return;
}

hpstrat(qi, bp)
register struct qb_device *qi;
register struct buf *bp;
{
	register struct buf *dp = &hputab[qi->qi_unit];
	register struct hpst *st = &hpst[qi->qi_unit];
	int partition = minor(bp->b_dev) & 07;
	int s;

	bp->b_cylin = dkblock(bp)/st->nspc + st->sizes[partition].cyloff;
	s = splx(qi->qi_mi->qm_psl);
	disksort(dp, bp);
	if (dp->b_active == 0) {
		(void) hpustart(qi);
		bp = &qi->qi_mi->qm_tab;
		if (bp->b_actf && bp->b_active == 0)
			(void) hpstart(qi->qi_mi);
	}
	splx(s);
}

/*
 * Unit start routine. Seek the drive to be where the data is and then generate
 * another interrupt to actually start the transfer. If there is only one drive
 * on the controller, or we are very close to the data, don't bother with the 
 * search.  If called after searching once, don't bother to look where we are, 
 * just queue for transfer (to avoid positioning forever without transferrring.)
 */
hpustart(qi)
register struct qb_device *qi;
{
	register struct buf *bp, *dp;
	register struct qb_ctlr *qm;
	register struct hpdevice *hpaddr;
	register struct hpst *st;
	daddr_t bn;
	int sn, csn;
	int didie = 0;

	if (qi == 0)
		goto out;
	qm = qi->qi_mi;
	dk_busy &= ~(1<<qi->qi_dk);
	dp = &hputab[qi->qi_unit];
	if ((bp = dp->b_actf) == NULL)
		goto out;
	/*
	 * If the controller is active, just remember that this device would 
	 * like to be positioned...
	 */
	if (qm->qm_tab.b_active) {
		hp_softc[qm->qm_ctlr].HP_softas |= 1<<qi->qi_slave;
		goto out;
	}
	/*
	 * If we already positioned drive, then just put it on the ready queue.
	 */
	if (dp->b_active)
		goto done;
	dp->b_active = 1;
	hpaddr = (struct hpdevice *)qm->qm_addr;
	hpaddr->hpcs2 = qi->qi_slave;
	/*
	 * If drive has just come up, setup the pack, and read in bad sector map
	 */
	if ((hpaddr->hpds & HPDS_VV) == 0 || hpinit[qi->qi_unit] == 0) {
		struct buf *bbp = &bhpbuf[qi->qi_unit];

		/* SHOULD WARN SYSTEM THAT THIS HAPPENED */
		hpinit[qi->qi_unit] = 1;
		hpaddr->hpcs1 = HP_DCLR|HP_GO;
		hpaddr->hpcs1 = HP_IE|HP_PRESET|HP_GO;
		hpaddr->hpof = HPOF_FMT16;
		didie = 1;
/*
 * KLUDGE: to read the bad sector map off a newly mounted pack, we assume that
 * the first access has no bad sectors, and will pick up the map before the
 * second access.
 */
#ifdef	orig144
		st = &hpst[qi->qi_unit];
		bbp->b_flags = B_READ|B_BUSY;
		bbp->b_dev = bp->b_dev;
		bbp->b_bcount = 512;
		bbp->b_un.b_addr = (caddr_t)&hpbad[qi->qi_unit];
		bbp->b_blkno = st->ncpd * st->nspc - st->nspt;
		bbp->b_cylin = st->ncpd - 1;
		dp->b_actf = bbp;
		bbp->av_forw = bp;
		bp = bbp;
#else	orig144
		hpbad[qi->qi_unit].bt_csn = 0;
#endif	orig144
	}
	/*
	 * If drive is offline, forget about positioning.
	 */
	if ((hpaddr->hpds & (HPDS_DPR|HPDS_MOL)) != (HPDS_DPR|HPDS_MOL))
		goto done;
	/*
	 * If there is only one drive, dont bother searching.
	 */
	if (hp_softc[qm->qm_ctlr].HP_ndrive == 1)
		goto done;
	/*
	 * Figure out where this transfer is going to and see if we are close 
	 * enough to justify not searching.
	 */
	st = &hpst[qi->qi_unit];
	bn = dkblock(bp);
	sn = bn%st->nspc;
	sn = (sn + st->nspt - st->sdist) % st->nspt;
	if (bp->b_cylin - hpaddr->hpdc)
		goto search;		/* Not on-cylinder */
	else if (hpseek)
		goto done;		/* Ok just to be on-cylinder */
	csn = (hpaddr->hpla>>6) - sn - 1;
	if (csn < 0)
		csn += st->nspt;
	if (csn > st->nspt - st->rdist)
		goto done;
search:
	hpaddr->hpdc = bp->b_cylin;
	/*
	 * Not on cylinder at correct position, seek/search.
	 */
	if (hpseek)
		hpaddr->hpcs1 = HP_IE|HP_SEEK|HP_GO;
	else {
		hpaddr->hpda = sn;
		hpaddr->hpcs1 = HP_IE|HP_SEARCH|HP_GO;
	}
	didie = 1;
	/*
	 * Mark unit busy for iostat.
	 */
	if (qi->qi_dk >= 0) {
		dk_busy |= 1<<qi->qi_dk;
		dk_seek[qi->qi_dk]++;
	}
	goto out;
done:
	/*
	 * Device is ready to go. Put it on the ready queue for the controller
	 * (unless its already there.)
	 */
	if (dp->b_active != 2) {
		dp->b_forw = NULL;
		if (qm->qm_tab.b_actf == NULL)
			qm->qm_tab.b_actf = dp;
		else
			qm->qm_tab.b_actl->b_forw = dp;
		qm->qm_tab.b_actl = dp;
		dp->b_active = 2;
	}
out:
	return (didie);
}

/*
 * Start up a transfer on a drive.
 */
hpstart(qm)
register struct qb_ctlr *qm;
{
	register struct buf *bp, *dp;
	register struct qb_device *qi;
	register struct hpdevice *hpaddr;
	struct hpst *st;
	daddr_t bn;
	int dn, sn, tn, cmd, waitdry;
	int ioaddr;

loop:
	/*
	 * Pull a request off the controller queue
	 */
	if ((dp = qm->qm_tab.b_actf) == NULL)
		return (0);
	if ((bp = dp->b_actf) == NULL) {
		qm->qm_tab.b_actf = dp->b_forw;
		goto loop;
	}
	/*
	 * Mark controller busy, and determine destination of this request.
	 */
	qm->qm_tab.b_active++;
	qi = hpdinfo[dkunit(bp)];
	bn = dkblock(bp);
	dn = qi->qi_slave;
	st = &hpst[qi->qi_unit];
	sn = bn%st->nspc;
	tn = sn/st->nspt;
	sn %= st->nspt;
	hpaddr = (struct hpdevice *)qi->qi_mi->qm_addr;
	/*
	 * Select drive if not selected already.
	 */
	if ((hpaddr->hpcs2&07) != dn)
		hpaddr->hpcs2 = dn;
	/*
	 * Check that it is ready and online
	 */
	waitdry = 0;
	while ((hpaddr->hpds&HPDS_DRY) == 0) {
		printf("hp%d: ds wait ds=%x\n",dkunit(bp),hpaddr->hpds);
		if (++waitdry > 512)
			break;
		hpwaitdry++;
	}
	if ((hpaddr->hpds & HPDS_DREADY) != HPDS_DREADY) {
		printf("hp%d: not ready", dkunit(bp));
		if ((hpaddr->hpds & HPDS_DREADY) != HPDS_DREADY) {
			printf("\n");
			qm->qm_tab.b_active = 0;
			qm->qm_tab.b_errcnt = 0;
			dp->b_actf = bp->av_forw;
			dp->b_active = 0;
			bp->b_flags |= B_ERROR;
			iodone(bp);
			goto loop;
		}
		/*
		 * Oh, well, sometimes this happens, for reasons unknown.
		 */
		printf(" (flakey)\n");
	}
	/*
	 * Setup for the transfer, and get in the UNIBUS adaptor queue.
	 */
	ioaddr = qbaddr(bp);
	hpaddr->hpdc = bp->b_cylin;
	hpaddr->hpda = (tn << 8) | sn;
	hpaddr->hpba = loword(ioaddr);
	if (!hp_softc[qi->qi_ctlr].HP_18bit)
		hpaddr->hpbae = hiword(ioaddr);
	hpaddr->hpwc = -bp->b_bcount / sizeof (short);
	if (bp->b_flags & B_READ)
		cmd = HP_IE|HP_RCOM|HP_GO;
	else
		cmd = HP_IE|HP_WCOM|HP_GO;
	qm->qm_tab.b_active = 2;
	hpaddr->hpcs1 = cmd | ((hiword(ioaddr) & 0x03)  <<  8);
	if (qi->qi_dk >= 0) {
		dk_busy |= 1 << qi->qi_dk;
		dk_xfer[qi->qi_dk]++;
		dk_wds[qi->qi_dk] += bp->b_bcount >> 6;
	}
	return (1);
}

/*
 * Handle a disk interrupt.
 */
hpintr(ctlr)
	register ctlr;
{
	register struct buf *bp, *dp;
	register struct qb_ctlr *qm = hpcinfo[ctlr];
	register struct qb_device *qi;
	register struct hpdevice *hpaddr = (struct hpdevice *)qm->qm_addr;
	register unit;
	struct hp_softc *sc = &hp_softc[qm->qm_ctlr];
	int as = (hpaddr->hpas & 0377) | sc->HP_softas;
	int needie = 1, waitdry;

	sc->HP_wticks = 0;
	sc->HP_softas = 0;
	/*
	 * If controller wasn't transferring, then this is an interrupt for 
	 * attention status on seeking drives. Just service them.
	 */
	if (qm->qm_tab.b_active != 2 && !sc->HP_recal) {
		if (hpaddr->hpcs1 & HP_TRE)
			hpaddr->hpcs1 = HP_TRE;
		goto doattn;
	}
	qm->qm_tab.b_active = 1;
	/*
	 * Get device and block structures, and a pointer to the qb_device for 
	 * the drive.  Select the drive.
	 */
	dp = qm->qm_tab.b_actf;
	bp = dp->b_actf;
	qi = hpdinfo[dkunit(bp)];
	dk_busy &= ~(1 << qi->qi_dk);
	if ((hpaddr->hpcs2&07) != qi->qi_slave)
		hpaddr->hpcs2 = qi->qi_slave;
	if (bp->b_flags&B_BAD) {
		if (hpecc(qi, CONT))
			return;
	}
	/*
	 * Check for and process errors on either the drive or the controller.
	 */
	if ((hpaddr->hpds&HPDS_ERR) || (hpaddr->hpcs1&HP_TRE)) {
#ifdef	BOZO
printf("hp ctlr %d hpaddr %x\n",ctlr,hpaddr);
printf("cn=%d tn=%d sn=%d \ncs1=%x cs2=%b ds=%b er1=%b er2=%b ec1=%x ec2=%x\n",
hpaddr->hpdc, ((hpaddr->hpda)>>8)&077, (hpaddr->hpda)&037,
hpaddr->hpcs1,
hpaddr->hpcs2, HPCS2_BITS,
hpaddr->hpds, HPDS_BITS,
hpaddr->hper1, HPER1_BITS,
hpaddr->hper2, HPER2_BITS,
hpaddr->hpec1, hpaddr->hpec2);
#endif	BOZO
		waitdry = 0;
		while ((hpaddr->hpds & HPDS_DRY) == 0) {
			if (++waitdry > 512)
				break;
			hpwaitdry++;
		}
		if (hpaddr->hper1&HPER1_WLE) {
			/*
			 * Give up on write locked devices immediately.
			 */
			printf("hp%d: write locked\n", dkunit(bp));
			bp->b_flags |= B_ERROR;
		} else if (++qm->qm_tab.b_errcnt > 27) {
			/*
			 * After 28 retries (16 without offset, and 12 with 
			 * offset positioning) give up. If the error was header
			 * CRC, the header is screwed up, and the sector may in
			 * fact exist in the bad sector table, better check...
			 */
#ifdef	orig144
			if (hpaddr->hper1&HPER1_HCRC) {
				if (hpecc(qi, BSE))
					return;
			}
#endif	orig144
hard:
			harderr(bp, "hp");
printf("bc=%x ",bp->b_bcount);
			printf("cn=%d tn=%d sn=%d cs2=%b er1=%b er2=%b\n",
			        hpaddr->hpdc, ((hpaddr->hpda)>>8)&077,
			        (hpaddr->hpda)&037,
				hpaddr->hpcs2, HPCS2_BITS,
				hpaddr->hper1, HPER1_BITS,
				hpaddr->hper2, HPER2_BITS);
			bp->b_flags |= B_ERROR;
		} else if (hpaddr->hper2 & HPER2_BSE) {
#ifdef	orig144
			if (hpecc(qi, BSE))
				return;
			else
#endif	orig144
				goto hard;
		} else {
			/*
			 * Retriable error. If a soft ecc, correct it continuing
			 * by returning if necessary. Otherwise fall through and
			 * retry the transfer
			 */
			if ((hpaddr->hper1&(HPER1_DCK|HPER1_ECH))==HPER1_DCK) {
				if (hpecc(qi, ECC))
					return;
			} else
				qm->qm_tab.b_active = 0; /* force retry */
		}
		/*
		 * Clear drive error and, every eight attempts, (starting with 
		 * the fourth) recalibrate to clear the slate.
		 */
		hpaddr->hpcs1 = HP_TRE|HP_IE|HP_DCLR|HP_GO;
		needie = 0;
		if ((qm->qm_tab.b_errcnt&07) == 4 && qm->qm_tab.b_active == 0) {
			hpaddr->hpcs1 = HP_RECAL|HP_IE|HP_GO;
			sc->HP_recal = 0;
			goto nextrecal;
		}
	}
	/*
	 * If recalibrate in progress advance recalibration finite state machine
	 *	RECAL;	SEEK;	OFFSET (optional);	RETRY
	 */
	switch (sc->HP_recal) {
	case 1:
		hpaddr->hpdc = bp->b_cylin;
		hpaddr->hpcs1 = HP_SEEK|HP_IE|HP_GO;
		goto nextrecal;
	case 2:
		if (qm->qm_tab.b_errcnt < 16 || (bp->b_flags&B_READ) == 0)
			goto donerecal;
		hpaddr->hpof = hp_offset[qm->qm_tab.b_errcnt & 017] | HPOF_FMT16;
		hpaddr->hpcs1 = HP_IE|HP_OFFSET|HP_GO;
		goto nextrecal;
	nextrecal:
		sc->HP_recal++;
		qm->qm_tab.b_active = 1;
		return;
	donerecal:
	case 3:
		sc->HP_recal = 0;
		qm->qm_tab.b_active = 0;
		break;
	}
	/*
	 * If still ``active'', then don't need any more retries.
	 */
	if (qm->qm_tab.b_active) {
		/*
		 * If we were offset positioning, return to centerline.
		 */
		if (qm->qm_tab.b_errcnt >= 16) {
			hpaddr->hpof = HPOF_FMT16;
			hpaddr->hpcs1 = HP_RTC|HP_GO|HP_IE;
			while (hpaddr->hpds & HPDS_PIP)
				DELAY(25);
			needie = 0;
		}
		qm->qm_tab.b_active = 0;
		qm->qm_tab.b_errcnt = 0;
		qm->qm_tab.b_actf = dp->b_forw;
		dp->b_active = 0;
		dp->b_errcnt = 0;
		dp->b_actf = bp->av_forw;
		bp->b_resid = (-hpaddr->hpwc * sizeof(short));
		iodone(bp);
		/*
		 * If this unit has more work, then start it up right away.
		 */
		if (dp->b_actf)
			if (hpustart(qi))
				needie = 0;
	}
	as &= ~(1<<qi->qi_slave);
doattn:
	/*
	 * Process other units which need attention. For each unit which needs 
	 * attention, call the unit start routine to place the slave on the 
	 * controller device queue.
	 */
	while (unit = ffs(as)) {
		unit--;		/* was 1 origin */
		as &= ~(1<<unit);
		hpaddr->hpas = 1<<unit;
		if (unit < MAX_hp_HP && hpustart(hpip[ctlr][unit]))
			needie = 0;
	}
	/*
	 * If the controller is not transferring, but there are devices ready 
	 * to transfer, start the controller.
	 */
	if (qm->qm_tab.b_actf && qm->qm_tab.b_active == 0)
		if (hpstart(qm))
			needie = 0;
	if (needie)
		hpaddr->hpcs1 = HP_IE;
}

hpread(dev, uio)
dev_t dev;
struct uio *uio;
{
	register int unit = minor(dev) >> 3;

	if (unit >= Nhp)
		return (ENXIO);
	return (physio(hpstrategy, &rhpbuf[unit], dev, B_READ, hpminphys, uio));
}

hpwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	register int unit = minor(dev) >> 3;

	if (unit >= Nhp)
		return (ENXIO);
	return (physio(hpstrategy, &rhpbuf[unit], dev, B_WRITE, hpminphys, uio));
}

hpioctl(dev, cmd, data, flag)
dev_t dev;
int cmd;
caddr_t data;
int flag;
{
	return (ENXIO);
}

/*
 * Correct an ECC error, and restart the i/o to complete the transfer if 
 * necessary. 
 */
hpecc(qi, flag)
register struct qb_device *qi;
int flag;
{
	register struct buf *bp = hputab[qi->qi_unit].b_actf;
	register struct qb_ctlr *qm = qi->qi_mi;
	register struct hpdevice *hpaddr = (struct hpdevice *)qm->qm_addr;
	register struct hpst *st;
	int bit, npf, mask, cmd, ioaddr, lval;
	int bn, cn, tn, sn;

	/*
	 * Npf is the number of sectors transferred before the sector containing
	 * the ECC error.
	 */
	if (flag == CONT)
		npf = bp->b_error;
	else
		npf = ((hpaddr->hpwc*sizeof(short))+bp->b_bcount) >> DEV_BSHIFT;
	bn = dkblock(bp);
	st = &hpst[qi->qi_unit];
	cn = bp->b_cylin;
	sn = bn%st->nspc + npf;
	tn = sn/st->nspt;
	sn %= st->nspt;
	cn += tn/st->ntpc;
	tn %= st->ntpc;
	qm->qm_tab.b_active=2;
	/*
	 * action taken depends on the flag
	 */
	switch(flag) {
	    case ECC:
		printf("hp%d%c: soft ecc sn%d\n", dkunit(bp),
			'a'+(minor(bp->b_dev)&07), bp->b_blkno + npf + 1);
		ioaddr = hpaddr->hpec1 - 1;	/* -1 makes 0 origin */
		mask = hpaddr->hpec2 << (ioaddr&0xF);
		mask = loword(mask)<<16 | hiword(mask);
		ioaddr = qbaddr(bp) + ((npf-1)<<DEV_BSHIFT) + ((ioaddr&~0xF)>>3);
		putmeml(ioaddr, getmeml(ioaddr)^mask);
		break;
#ifdef	BOZO
	    case BSE:
		/*
		 * if not in bad sector table, return 0
		 */
		if ((bn = isbad(&hpbad[qi->qi_unit], cn, tn, sn)) < 0)
			return(0);
		/*
		 * flag this one as bad
		 */
		bp->b_flags |= B_BAD;
		bp->b_error = npf + 1;
#ifdef HPECCDEBUG
		printf("BSE: restart at %d\n",npf+1);
#endif HPECCDEBUG
		bn = st->ncpd * st->nspc -st->nspt - 1 - bn;
		cn = bn / st->nspc;
		sn = bn % st->nspc;
		tn = sn / st->nspt;
		sn %= st->nspt;
		hpaddr->hpwc = -(512 / sizeof (short));
#ifdef HPECCDEBUG
		printf("revector to cn %d tn %d sn %d\n", cn, tn, sn);
#endif HPECCDEBUG
		break;
	    case CONT:
#ifdef HPECCDEBUG
		printf("hpecc, CONT: bn %d cn %d tn %d sn %d\n", bn, cn, tn, sn);
#endif HPECCDEBUG
		bp->b_flags &= ~B_BAD;
		hpaddr->hpwc = -((bp->b_bcount - (int)ptob(npf)) / sizeof(short));
		break;
#endif	BOZO
	}
	if (hpaddr->hpwc == 0) {
		qm->qm_tab.b_active = 0;
		return (0);
	}
	/*
	 * Have to continue the transfer... clear the drive, and compute the 
	 * position where the transfer is to continue. 
	 */
#ifdef notdef
	hpaddr->hper1 = 0;
	hpaddr->hpcs1 |= HP_GO;
#else  notdef
	hpaddr->hpcs1 = HP_TRE|HP_IE|HP_DCLR|HP_GO;
	hpaddr->hpdc = cn;
	hpaddr->hpda = (tn << 8) | sn;
	ioaddr = qbaddr(bp) + (npf << DEV_BSHIFT);
	hpaddr->hpba = ioaddr;
	if (!hp_softc[qi->qi_ctlr].HP_18bit)
		hpaddr->hpbae = hiword(ioaddr);
	cmd = (ioaddr >> 8) & 0x300;
	cmd |= ((bp->b_flags&B_READ)?HP_RCOM:HP_WCOM)|HP_IE|HP_GO;
	qm->qm_tab.b_errcnt = 0;
	hpaddr->hpcs1 = cmd;
#endif notdef
	return (1);
}

/*
 * Reset driver after lost init. Cancel software state of all pending transfers
 * and restart all units and the controller.
 */
hpreset()
{
	register struct qb_ctlr *qm;
	register struct qb_device *qi;
	register ctlr, unit;

	for (ctlr = 0; ctlr < NHP; ctlr++) {
		if ((qm = hpcinfo[ctlr]) == 0 || qm->qm_alive == 0)
			continue;
		printf(" HP%d", ctlr);
		qm->qm_tab.b_active = 0;
		qm->qm_tab.b_actf = qm->qm_tab.b_actl = 0;
		hp_softc[ctlr].HP_recal = 0;
		hp_softc[ctlr].HP_wticks = 0;
		((struct hpdevice *)(qm->qm_addr))->hpcs2 = HPCS2_CLR;
		for (unit = 0; unit < Nhp; unit++) {
			if ((qi = hpdinfo[unit]) == 0)
				continue;
			if (qi->qi_alive == 0 || qi->qi_mi != qm)
				continue;
			hputab[unit].b_active = 0;
			(void) hpustart(qi);
		}
		(void) hpstart(qm);
	}
}

/*
 * Wake hp every second and if an interrupt is pending but nothing has happened
 * increment a counter. If nothing happens for 20 seconds, reset the controler
 * and begin anew.
 */
hpwatch()
{
	register struct qb_ctlr *qm;
	register ctlr, unit;
	register struct hp_softc *sc;

	timeout(hpwatch, (caddr_t)0, hz);
	for (ctlr = 0; ctlr < NHP; ctlr++) {
		qm = hpcinfo[ctlr];
		if (qm == 0 || qm->qm_alive == 0)
			continue;
		sc = &hp_softc[ctlr];
		if (qm->qm_tab.b_active == 0) {
			for (unit = 0; unit < Nhp; unit++)
				if (hputab[unit].b_active &&
				    hpdinfo[unit]->qi_mi == qm)
					goto active;
			sc->HP_wticks = 0;
			continue;
		}
active:
		sc->HP_wticks++;
		if (sc->HP_wticks >= 20) {
			sc->HP_wticks = 0;
			printf("HP%d: lost interrupt\n", ctlr);
			hpreset();
		}
	}
}

#define	DBSIZE	20

hpdump(dev)
dev_t dev;
{
#ifdef BOZO
	struct hpdevice *hpaddr;
	char *start;
	int num, blk, unit;
	struct size *sizes;
	register struct qb_regs *qb;
	register struct qb_device *qi;
	register short *rp;
	struct hpst *st;
	register int retry;

	unit = minor(dev) >> 3;
	if (unit >= Nhp)
		return (ENXIO);
#define	phys(cast, addr) ((cast)((int)addr & 0x7fffffff))
	qi = phys(struct qb_device *, hpdinfo[unit]);
	if (qi->qi_alive == 0)
		return (ENXIO);
	qb = phys(struct qb_hd *, qi->qi_hd)->uh_physqb;
	qbinit(qb);
	hpaddr = (struct hpdevice *)qi->qi_physaddr;
	DELAY(5000000);
	num = maxfree;
	hpaddr->hpcs2 = unit;
	DELAY(100);
	hpaddr->hpcs1 = HP_DCLR|HP_GO;
	hpaddr->hpcs1 = HP_PRESET|HP_GO;
	hpaddr->hpof = HPOF_FMT16;
	retry = 0;
	do {
		DELAY(25);
		if (++retry > 527)
			break;
	} while ((hpaddr->hpds & HP_RDY) == 0);
	if ((hpaddr->hpds & HPDS_DREADY) != HPDS_DREADY)
		return (EFAULT);
	start = 0;
	st = &hpst[qi->qi_unit];
	sizes = phys(struct size *, st->sizes);
	if (dumplo < 0 || dumplo + num >= sizes[minor(dev)&07].nblocks)
		return (EINVAL);
	while (num > 0) {
		register struct pte *io;
		register int i;
		int cn, sn, tn;
		daddr_t bn;

		blk = num > DBSIZE ? DBSIZE : num;
		io = qb->qb_map;
		for (i = 0; i < blk; i++)
			*(int *)io++ = (btop(start)+i) | (1<<21) | UBAMR_MRV;
		*(int *)io = 0;
		bn = dumplo + btop(start);
		cn = bn/st->nspc + sizes[minor(dev)&07].cyloff;
		sn = bn%st->nspc;
		tn = sn/st->nspt;
		sn = sn%st->nspt;
		hpaddr->hpdc = cn;
		rp = (short *) &hpaddr->hpda;
		*rp = (tn << 8) + sn;
		*--rp = 0;
		*--rp = -blk*NBPG / sizeof (short);
		*--rp = HP_GO|HP_WCOM;
		retry = 0;
		do {
			DELAY(25);
			if (++retry > 527)
				break;
		} while ((hpaddr->hpcs1 & HP_RDY) == 0);
		if ((hpaddr->hpds & HPDS_DREADY) != HPDS_DREADY) {
			printf("hp%d: not ready", unit);
			if ((hpaddr->hpds & HPDS_DREADY) != HPDS_DREADY) {
				printf("\n");
				return (EIO);
			}
			printf(" (flakey)\n");
		}
		if (hpaddr->hpds&HPDS_ERR)
			return (EIO);
		start += blk*NBPG;
		num -= blk;
	}
	return (0);
#else  BOZO
printf("hp: dump not yet implemented\n");
#endif BOZO
}

hpsize(dev)
dev_t dev;
{
	int unit = minor(dev) >> 3;
	struct qb_device *qi;
	struct hpst *st;

	if (unit >= Nhp || (qi = hpdinfo[unit]) == 0 || qi->qi_alive == 0)
		return (-1);
	st = &hpst[qi->qi_unit];
	return (st->sizes[minor(dev) & 07].nblocks);
}

hpminphys(bp)
	struct buf *bp;
{
	bp->b_bcount = min(bp->b_bcount, 0xFFF0); /* KLUDGE */
}
#endif
