/* graphics processor addresses */
#ifndef	ASSEMBLY
	struct gpdevice {
		unsigned short gp_fifo;
		unsigned short gp_snake;
		unsigned short gp_shift;
		unsigned short gp_reset;
	};
	extern struct gpdevice	*gpaddr;
	extern unsigned short	*gpwcs;
#else	ASSEMBLY
	/* offsets from gpaddr to registers */
#	define GPFIFO	 	0
#	define GPSNAKE		2
#	define GPSHIFT		4
#	define GPRESET		6
#endif	ASSEMBLY

/* offset from display memory to writable control store */
#	define GPWCS		0x1000

#define GPFIFOEMPTY	7		/* fifo read busy bit */
#define GPILEVEL	3		/* interrupt level */

/*
 * GP micro code general/specific enables: comment to disable
 */
#define UCODE /**/
#ifdef UCODE
#	define UCODE_ALU	/**/
#	define UCODE_PITCH	/**/
#	define UCODE_BOX	/**/
#	define UCODE_BOXC	/**/
/* #	define UCODE_BOXP	/**/
#	define UCODE_PAINT	/**/
#	define UCODE_VECT	/**/
#	define UCODE_CLIP	/**/
#endif UCODE


/*
 * GIP micro-code opcode definitions
 */
#define GP_ALUC		0x8001          /* alu_clear */
#define GP_ALUS		0x8002          /* alu_set */
#define GP_ALUT		0x8003          /* alu_toggle */
#define GP_BOX		0x8004          /* box */
#define GP_BOXC		0x8005          /* box_copy */
#define GP_BOXP		0x8006          /* box_pattern */
#define GP_CLIP		0x8007          /* clip */
#define GP_CLIPON	0x8008          /* clip_on */
#define GP_CLIPOF	0x8009          /* clip_off */
#define GP_INIT		0x800A          /* init */
#define GP_INTON	0x800B          /* interrupt_on */
#define GP_INTOF	0x800C          /* interrupt_off */
#define GP_PAINT	0x800D          /* paint */
#define GP_PGSEL	0x800E          /* page_select */
#define GP_PGSF		0x800F          /* page_select_fill */
#define GP_SPTCH	0x8010          /* source_pitch */
#define GP_DPTCH	0x8011          /* destination_pitch */
#define GP_TEXT		0x8012          /* text */
#define GP_VECT		0x8013          /* vector */


#define BXMAX           1280 
#define BYMAX           1024

#ifdef	UNIX
#define DISPM_START  0x000000		/* virtual address of display */
#define DISPM_END    0x080000
#else	UNIX
#define DISPM_START  0x400000		/* physical address of display */
#define DISPM_END    0x480000
#endif	UNIX

#define	SCREEN0		DISPM_START
/* last visible address, used for fonts in display memory (NBI) */
#define SCREEN0END	DISPM_START + ((BXMAX*BYMAX)/8)
#define	LASTVA		SCREEN0END


/* time out values */
#define	GP_FIFOBSYWAIT	50			/* ~ 100 usec */
#define	GP_FIFOTIMEO	100			/* ~ 1.6 sec */

#define	GP_TIMEO	100			/* ~ 1.6 sec */

/* sleep priorities */
#define	GP_FIFOPRI	15			/* fifo sleep priority */
#define	GP_PRI		16			/* gip sleep priority */
#define	GP_INTONPRI	10			/* intrupt on sleep priority */
#define	GP_FLUSHVTPRI	4

#define	GP_CPUDISP	0			/* cpu last access */
#define	GP_GIPDISP	1			/* gip last access */
