/*	gp.c	6.1	83/07/29	*/

#include "gp.h"

#if NGP > 0 || Ngp > 0
/*
 * Integrated Solutions GIP graphics controler
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
/*#include "../machine/defs.h" /**/
#include "../vt/vt_hdrs.h"
#include "../vt/vt_output.h"
#include "../vt/vt_kernel.h"
#include "../vt/vt_key.h"

#include "../machine/board.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/gpreg.h"

int	gpprobe(),	gpslave(),	gpattach(),	gpintr();
struct	qb_ctlr		*gpcinfo[NGP];
struct	qb_device	*gpdinfo[Ngp];

/* 
 * GP controler addresses 
 */
u_short *GPstd[] = { (u_short *)0x0, 0 };

/*
 * GP/gp controler/device driver structure
 */
struct	qb_driver GPdriver =
	{ gpprobe, gpslave, gpattach, GPstd, "gp", gpdinfo, "GP", gpcinfo };

/*
 * possible graphics processor address tuples
 */
struct gp_addr_tuple {
	ushort		*dm;		/* display memory */
	struct gpdevice	*addr;		/* gip address */
} gp_addrs[8] = {
#ifdef	M68020
	{(ushort *)0xE00000, (struct gpdevice *)0xFFC000},
	{(ushort *)0xD00000, (struct gpdevice *)0xFF8000},
	{(ushort *)0xC00000, (struct gpdevice *)0xFF4000},
	{(ushort *)0xB00000, (struct gpdevice *)0xFF0000},
	{(ushort *)0xA00000, (struct gpdevice *)0xFEC000},
	{(ushort *)0x900000, (struct gpdevice *)0xFE8000},
	{(ushort *)0x800000, (struct gpdevice *)0xFE4000},
	{(ushort *)0x700000, (struct gpdevice *)0xFE0000},
#else	M68020
	{(ushort *)0xE00000, (struct gpdevice *)0x7FC000},
	{(ushort *)0xD00000, (struct gpdevice *)0x7F8000},
	{(ushort *)0xC00000, (struct gpdevice *)0x7F4000},
	{(ushort *)0xB00000, (struct gpdevice *)0x7F0000},
	{(ushort *)0xA00000, (struct gpdevice *)0x7EC000},
	{(ushort *)0x900000, (struct gpdevice *)0x7E8000},
	{(ushort *)0x800000, (struct gpdevice *)0x7E4000},
	{(ushort *)0x700000, (struct gpdevice *)0x7E0000},
#endif	M68020
};

extern char *initi;			/* pointer to icode "init" */
extern short vidbuf[];			/* virtual address for display memory */
extern int rrtimeslice;			/* nth of sec round robin time slice */
ushort *gpdm;				/* physical address of display memory */
#ifdef	M68010
extern u_char shortio[];		/* virtual address of short io memory */
#endif	M68010
char *vtpool;

/*
 * This routine is called early in kernel start to set up the graphics system:
 *
 *	o	determine existance of gip. 
 *	o	define gpaddr to point to the gip device registers.
 *	o	set init file to "/etc/Init"
 *	o	map the display memory into kernel address space.
 *	o	initialize the gip.
 */
GP_initialize(top_of_mem, fa)
ushort *top_of_mem;
{
#ifdef	GWS
	register int i;
	extern int vbnum;

	/*
	 * Find the first chunk of memory above unix memory that has a gip fifo
	 */ 
	for (i = 0, gpaddr = 0 ; i < 8 ; i++) {
	    if ((gp_addrs[i].dm > top_of_mem) && 
#ifndef	M68020
		(gp_addrs[i].dm > (ushort *)svtop(&shortio[0xFFFF])) &&
#endif	M68020
		!badaddr(gp_addrs[i].addr, 2) &&
		/* 
		 * KLUDGE: This is to distinguish GIP from Excelan board 
		 * however, some early GIP boards supported byte accesses, so 
		 * we also look to see if the upper byte is FF -- if so we 
		 * assume it is an Excelan board.		CTH
		 */
		(badaddr((int)gp_addrs[i].addr + 1, 1) ||
		((gp_addrs[i].addr->gp_fifo & 0xFF00) != 0xFF00))) {
#ifdef	M68020
		if (badaddr(gp_addrs[i].dm, 2))
			continue;
#endif	M68020
		if (vbnum >= 0  &&  i != vbnum)
			continue;
		mapin(vidbufmap, btop(vidbuf), btop(gp_addrs[i].dm), 1,
			PG_V|PG_FOD|PG_KW);
		if (badaddr(vidbuf, 2))
			continue;
		gpaddr = gp_addrs[i].addr;
		gpdm = gp_addrs[i].dm;
		GPstd[0] = ((ushort *)gpaddr);
		mapin(vidbufmap, btop(vidbuf), btop(gp_addrs[i].dm),
#ifdef	COLOR
			8*32,
#else	COLOR
			4*32,
#endif	COLOR
				PG_V|PG_FOD|PG_KW);
		*initi = 'I';
#ifdef	M68020
		rrtimeslice *= 2;
#endif	M68020
		gpwcs = (ushort *)gpaddr + (GPWCS / sizeof (short));

		vtpool = (char *)ptob(fa);
		for (i = 0; i < btoc(VTSIZE); i++)
			*(int *)(&Sysmap[fa + i]) = PG_V | PG_KW | (fa + i);
		newptes(&Sysmap[fa], fa, btoc(VTSIZE));

    		load_wcs();
    		InitializeBlock();
    		InitializeCursor();
    		InitializeWindow();
		FontInit();
		vt_cninit();
		return (btoc(VTSIZE));
	    }
	}
	printf("***  NOTICE:  Configured graphics processor not found  ***\n");
	return (0);
#endif	GWS
}

/*
 * if we have graphics, 
 *	fork off a kernel process to handle typeahead
 */
GP_fork()
{
#ifdef	GWS
	extern flushvtecho();
	extern char flushvtok, markneeded;

	if (gpaddr) {
	    if (newproc(0)) {
		spl0();
		u.u_procp->p_flag |= SLOAD|SSYS;
#ifdef	M68020
		setctx(u.u_procp->p_context = CTX_SYS);
#endif	M68020
		strcpy(u.u_comm, "gpdaemon");
		while(1) {
			sleep(flushvtecho, GP_FLUSHVTPRI);
			if (flushvtok)
				flushvtecho();
			if (markneeded)
				mark_daemon();
		}
	    }
	}
#endif	GWS
}

gpprobe(gp_addr)
struct gpdevice *gp_addr;
{
	if (gp_addr != gpaddr)
		return(0);
#ifdef	INTERRUPT
	gpaddr->gp_fifo = GP_INTON;
	DELAY(1000);
	gpaddr->gp_fifo = GP_INTOFF;
#else	INTERRUPT
	{
		extern int cvec;
		cvec = 128;
	}
#endif	INTERRUPT
	return(sizeof(struct gpdevice));
}

gpslave(qi, gp_addr)
register struct qb_device	*qi;
register struct gpdevice	*gp_addr;
{
	return(1);
}

gpattach(qi)
register struct qb_device	*qi;
{
	short	n, ncol, i;

	printf("\tdisplay memory at 0x%x/0%o\n", gpdm, gpdm);
	printf("\t\tterminal emulators:\t");
	ncol = 8*5;
	for(i=0; i<nterms; i++){
		n = strlen(termsw[i].name)+1;
		if((80-ncol) < (n+1)){
			printf("\n\t\t\t\t\t");
			ncol = 8*5;
		}
		ncol += n;
		printf("%s%c ", termsw[i].name, (i==nterms-1)?'.':',');
	}
}

gpintr(ctlr)
int ctlr;
{
	printf("gp%x: unexpected interrupt\n",ctlr);
}
#else
GP_initialize(top_of_mem) {gpaddr = 0; return(0)};
GP_fork() {};
#endif
