/*	dl.c	6.1	83/07/29	*/

#include "dl.h"
#if NDL > 0  ||  Ndl > 0
#ifndef	NDL
#define	NDL	Ndl
#endif

/*
 * DLV11-J Driver: This driver mimics dh.c.
 *
 * TODO:
 *  	This driver does not support the paper tape reader on an LT33.
 */
#include "bk.h"

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/vm.h"
#include "../h/conf.h"
#include "../h/bk.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../is68kdev/pdma.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/dlreg.h"

int	dlprobe(), dlslave(), dlattach(), dlrint();
struct	qb_device *dlinfo[NDL];
u_short	*dlstd[] = { (u_short *)0x3FFD40, (u_short *)0x3FFD48,
		     (u_short *)0x3FFD50, (u_short *)0x3FFD58,
		     (u_short *)0x3FFD60, (u_short *)0x3FFD68,
		     (u_short *)0x3FFD70, (u_short *)0x3FFD78,
		     0 };
struct	qb_driver DLdriver =
	{ dlprobe, dlslave, dlattach, dlstd, "dl", dlinfo, "DL" };

int	dlstart(), dlxint(), dldma();
int	ttrstrt();
struct	tty dl_tty[NDL];
struct	pdma dlpdma[NDL];
int	dl_cnt;

dlprobe(dladdr)
	register struct dldevice	*dladdr;
{
	extern int	cvec;

	dladdr->dl_xcsr |= DL_XCSR_XIE;
	DELAY(2000);
	dladdr->dl_xcsr &= ~DL_XCSR_XIE;
	if (cvec && cvec != 0x100)
		cvec -= 4;
	return (sizeof (struct dldevice));
}

dlslave(dladdr)
	register struct dldevice	*dladdr;
{
	return (1);
}

dlattach(qi)
	register struct qb_device	*qi;
{
	register struct pdma	*pdp = &dlpdma[dl_cnt];
	register struct tty	*tp = &dl_tty[dl_cnt];

	pdp->p_addr = (int)qi->qi_mi->qm_addr;
	pdp->p_arg = (int)tp;
	pdp->p_fcn = dlxint;
	dl_cnt++;
}

dlopen(dev, flag)
	dev_t	dev;
	int	flag;
{
	register int	dl = minor(dev);
	register struct tty	*tp = &dl_tty[dl];
	register struct dldevice *dladdr = (struct dldevice *)dlpdma[dl].p_addr;
 
	if (dl >= dl_cnt || dlpdma[dl].p_addr == 0)
		return (ENXIO);
	tp->t_addr = (caddr_t)&dlpdma[dl];
	tp->t_oproc = dlstart;
	if ((tp->t_state & TS_ISOPEN) == 0) {
		ttychars(tp);
		tp->t_ospeed = tp->t_ispeed = B9600;
		tp->t_flags = EVENP | ODDP | ECHO;
		tp->t_state = TS_ISOPEN | TS_CARR_ON;
		dladdr->dl_rcsr |= DL_RCSR_RCVIE;
	} else if (tp->t_state&TS_XCLUDE && u.u_uid != 0)
		return (EBUSY);
	return ((*linesw[tp->t_line].l_open)(dev, tp));
}

dlclose(dev)
	dev_t	dev;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

	(*linesw[tp->t_line].l_close)(tp);
	ttyclose(tp);
}

dlread(dev, uio)
	dev_t	dev;
	struct uio	*uio;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

	return ((*linesw[tp->t_line].l_read)(tp, uio));
}

dlwrite(dev, uio)
	dev_t	dev;
	struct uio	*uio;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

	return ((*linesw[tp->t_line].l_write)(tp,uio));
}

dlrint(dl)
	int dl;
{
	register struct dldevice *dladdr = (struct dldevice *)dlpdma[dl].p_addr;
	register struct tty	*tp = &dl_tty[dl];
	register int	c, err;
	int	overrun = 0;

	do {
		c = (err = dladdr->dl_rbuf) & DL_RBUF_DMASK;
		if (err & DL_RBUF_FRERR) {
			if (tp->t_flags & RAW)
				c = 0;
			else
				c = tp->t_intrc;
		}
		if (err & DL_RBUF_OVRNERR) {
			printf("dl%d: overflow\n",dl);
			overrun++;
		}
		if (err & DL_RBUF_PERR) {
			if (((tp->t_flags & (EVENP|ODDP)) == EVENP)
			  || ((tp->t_flags & (EVENP|ODDP)) == ODDP))
				continue;
		}
		(*linesw[tp->t_line].l_rint)(c, tp);
	} while (dladdr->dl_rcsr & DL_RCSR_RCVDONE);
}

dlioctl(dev, cmd, data, flag)
	dev_t	dev;
	caddr_t	data;
{
	register int	error;
	register int	dl = minor(dev);
	register struct tty	*tp = &dl_tty[dl];

	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	else
		return (ENOTTY);
}

dlxint(tp)
	register struct tty *tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register int	s;

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	tp->t_state &= ~TS_BUSY;
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	else {
		ndflush(&tp->t_outq, dp->p_mem-tp->t_outq.c_cf);
		dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	}
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		dlstart(tp);
}

dlstart(tp)
	register struct tty *tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register struct dldevice *dladdr = (struct dldevice *)dp->p_addr;
	register int	cc, s;
 
	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags & (RAW|LITOUT))
		cc = ndqb(&tp->t_outq, 0);
	else {
		cc = ndqb(&tp->t_outq, 0200);

		if (cc == 0) {
			cc = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (cc&0x7f) + 6);
			tp->t_state |= TS_TIMEOUT;
			goto out;
		}
	}
	tp->t_state |= TS_BUSY;
	dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	dp->p_end += cc;
	dladdr->dl_xcsr |= DL_XCSR_XIE;
out:	splx(s);
}

dlstop(tp, flag)
	register struct tty	*tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register int	s;

	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	if (tp->t_state & TS_BUSY) {
		dp->p_end = dp->p_mem;
		if ((tp->t_state&TS_TTSTOP)==0)
			tp->t_state |= TS_FLUSH;
	}
	splx(s);
}
#endif
