/*	dh.c	6.3	84/03/15	*/

/*
 * NOTE: There is a bug with the EMULEX CS01 such that writing bits 0-7 of
 * the SCR register will effect bits 8-15 of that register.  This problem
 * has been partialy masked by changing all byte accesses to the SCR to 
 * word accesses and making an attempt to preserve the TI bit. There is
 * still a race condition, however, between the time the CSR is read to 
 * preserve its sense and when it is writen. The result of this race is that 
 * an interupt may be lost, causing a line to hang.  There is an additional
 * problem with the CS01 in that clearing TI in the transmit interupt routine
 * does not always work the first time.			Chris 5/15/84
 */
#define CS01BUGS /**/

#include "dh.h"
#if NDH > 0 || Ndh > 0
/*
 * DH-11/DM-11 driver
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/vm.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/dhreg.h"

#include "../h/bk.h"
#include "../h/clist.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#define	TTY_NODELAY

/*
 * Definition of the driver for the auto-configuration program. There is one 
 * definition for the dh and one for the dm.
 */
int	dhprobe(), dhslave(), dhattach(), dhrint(), dhxint(), dhtimer();
struct	qb_device *dhinfo[NDH];
u_short	*dhstd[] = {	(u_short *)0x3fe010, (u_short *)0x3fe020,
			(u_short *)0x3fe030, (u_short *)0x3fe040,
			(u_short *)0x3fe050, (u_short *)0x3fe060,
			(u_short *)0x3fe070, (u_short *)0x3fe080, 0 };
struct	qb_driver DHdriver =
	{ dhprobe, dhslave, dhattach, dhstd, "dh", dhinfo, "DH" };

int	dmprobe(), dmslave(), dmattach(), dmintr();
struct	qb_device *dminfo[NDH];
u_short	*dmstd[] = {	(u_short *)0x3ff140, (u_short *)0x3ff148,
			(u_short *)0x3ff150, (u_short *)0x3ff158,
			(u_short *)0x3ff160, (u_short *)0x3ff168,
			(u_short *)0x3ff170, (u_short *)0x3ff178, 0 };
struct	qb_driver DMdriver =
	{ dmprobe, dmslave, dmattach, dmstd, "dm", dminfo, "DM" };

#ifndef	PORTSELECTOR
#define	ISPEED	B9600
#define	IFLAGS	(EVENP|ODDP|ECHO|CRMOD) /* KLUDGE CRMOD temporary */
#else
#define	ISPEED	B4800
#define	IFLAGS	(EVENP|ODDP)
#endif

#define	FASTTIMER	(hz/30)		/* scan rate with silos on */

/*
 * Local variables for the driver
 */
short	dhsbar[NDH];			/* software copy of last bar */
short	dhsoftCAR[NDH];

struct	tty dh_tty[NDH*16];
short	dh_nch[NDH*16];			/* number of characters xmiting */
extern  char dh_buf[NDH*16][CBSIZE];
int	ndh_tty	= NDH*16;
int	dhact;				/* mask of active dh's */
int	dhsilos;			/* mask of dh's with silo in use */
int	dhchars[NDH];			/* recent input count */
int	dhrate[NDH];			/* smoothed input count */
int	dhhighrate = 100;		/* silo on if dhchars > dhhighrate */
int	dhlowrate = 75;			/* silo off if dhrate < dhlowrate */
static	short timerstarted;
int	dhstart(), ttrstrt();

/*
 * Routine for configuration to force a dh to interrupt. Set to transmit at 9600
 * baud, and cause a transmitter interrupt.
 */
dhprobe(dhaddr)
	register struct dhdevice *dhaddr;
{
	extern int cvec;

	dhaddr->un.dhcsr = 4;		/* dont confuse a dz with a dh */
	DELAY(100);
	if ((dhaddr->un.dhcsr & 4) == 0)
		return (0);
	dhaddr->un.dhcsr = DH_TI | DH_TIE;
	DELAY(2000);

#ifdef	CS01BUGS
# define MAXLOOP 10
	{
		register int count = MAXLOOP;

		while ((dhaddr->un.dhcsr & DH_TI) == 0 && count--) {
			dhaddr->un.dhcsr = DH_TI | DH_TIE;
			DELAY(10000);
		}
	}
#endif	CS01BUGS

	dhaddr->un.dhcsr = 0;

#ifdef	CS01BUGS
	{
		register int count = MAXLOOP;

		while ((dhaddr->un.dhcsr & DH_TI) && count--) {
			dhaddr->un.dhcsr = 0;
			DELAY(10000);
		}
	}
#endif	CS01BUGS
	if (cvec && cvec != 0x100)
		cvec -= 4;	/* transmit -> receive */
	return (sizeof (struct dhdevice));
}

/*
 * Routine called to slave a dh.
 */
dhslave(qi)
	struct qb_device *qi;
{
	return (1);
}

/*
 * Routine called to attach a dh.
 */
dhattach(qi)
	struct qb_device *qi;
{
	dhsoftCAR[qi->qi_unit] = qi->qi_flags;
}

/*
 * Configuration routine to cause a dm to interrupt.
 */
dmprobe(dmaddr)
	register struct dmdevice *dmaddr;
{
	dmaddr->dmcsr = DM_IE | DM_DONE;
	DELAY(100);
	dmaddr->dmcsr = 0;
	return (1);
}

dmslave(qi)
	struct qb_device *qi;
{
	return (1);
}

dmattach(qi)
	struct qb_device *qi;
{
}

/*
 * Open a DH11 line. Turn on this dh if this is the first use of it.  Also do 
 * a dmopen to wait for carrier.
 */
dhopen(dev, flag)
	dev_t dev;
{
	register struct tty *tp;
	register int unit, dh;
	register struct dhdevice *dhaddr;
	register struct qb_device *qi;
	int s;

	unit = minor(dev);
	dh = unit >> 4;
	if (unit >= NDH*16 || (qi = dhinfo[dh])== 0 || qi->qi_alive == 0)
		return (ENXIO);
	tp = &dh_tty[unit];
	if (tp->t_state&TS_XCLUDE && u.u_uid!=0)
		return (EBUSY);
	dhaddr = (struct dhdevice *)qi->qi_mi->qm_addr;
	tp->t_addr = (caddr_t)dhaddr;
	tp->t_oproc = dhstart;
	tp->t_state |= TS_WOPEN;
	/*
	 * While setting up state block resets which can clear the state.
	 */
	s = splx(qi->qi_mi->qm_psl);
	if (timerstarted == 0) {
		timerstarted++;
		timeout(dhtimer, (caddr_t) 0, hz);
	}
	if ((dhact&(1<<dh)) == 0) {
		dhaddr->un.dhcsr |= DH_IE;
		dhact |= (1<<dh);
		dhaddr->dhsilo = 0;
	}
	splx(s);
	/*
	 * If this is first open, initialze tty state to default.
	 */
	if ((tp->t_state&TS_ISOPEN) == 0) {
		ttychars(tp);
#ifndef PORTSELECTOR
		if (tp->t_ispeed == 0) {
#endif	PORTSELECTOR
			tp->t_ispeed = ISPEED;
			tp->t_ospeed = ISPEED;
			tp->t_flags = IFLAGS;
#ifndef PORTSELECTOR
		}
#endif	PORTSELECTOR
		dhparam(unit);
	}

	/*
	 * If someone already has the device open for exclusive access,
	 * and we are legit child of pid #1 (init), return with error EBUSY.
	 * Init should have been modified to know how to deal
	 * with this situation.
	 */
	if ((tp->t_state & TS_XCLUDE)  &&  (u.u_procp->p_flag & SLOGIN))
		return (EBUSY);

	/*
	 * Wait for carrier, then process line discipline specific open.
	 */
	dmopen(dev, flag);

	/*
	 * Check again, now that we're no longer hung waiting for carrier.
	 */
	if ((tp->t_state & TS_XCLUDE)  &&  (u.u_procp->p_flag & SLOGIN))
		return (EBUSY);

	return ((*linesw[tp->t_line].l_open)(dev, tp));
}

/*
 * Close a DH11 line, turning off the DM11.
 */
dhclose(dev, flag)
	dev_t dev;
	int flag;
{
	register struct tty *tp;
	register unit;

	unit = minor(dev);
	tp = &dh_tty[unit];
	(*linesw[tp->t_line].l_close)(tp);
	((struct dhdevice *)(tp->t_addr))->dhbreak &= ~(1<<(unit&017));
	if (tp->t_state&TS_HUPCLS || (tp->t_state&TS_ISOPEN)==0)
		dmctl(unit, DML_OFF, DMSET);
#ifdef NOMDM
	tp->t_flags &= ~NOMDM;
#endif
	ttyclose(tp);
}

dhread(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	register struct tty *tp = &dh_tty[minor(dev)];

	return ((*linesw[tp->t_line].l_read)(tp, uio));
}

dhwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	register struct tty *tp = &dh_tty[minor(dev)];

	return ((*linesw[tp->t_line].l_write)(tp, uio));
}

/*
 * DH11 receiver interrupt.
 */
dhrint(dh)
	int dh;
{
	register struct tty *tp;
	register c;
	register struct dhdevice *dhaddr;
	register struct tty *tp0;
	register struct qb_device *qi;
	int overrun = 0;

	qi = dhinfo[dh];
	if (qi == 0 || qi->qi_alive == 0)
		return;
	dhaddr = (struct dhdevice *)qi->qi_mi->qm_addr;
	tp0 = &dh_tty[dh<<4];
	/*
	 * Loop fetching characters from the silo for this dh.
	 */
	while ((c = dhaddr->dhrcr) < 0) {
		dhchars[dh]++;
		tp = tp0 + ((c>>8)&0xf);
#ifndef PORTSELECTOR
		if ((tp->t_state&TS_ISOPEN)==0)
#else	PORTSELECTOR
		if ((tp->t_state&(TS_ISOPEN|TS_WOPEN))==0)
#endif	PORTSELECTOR
		{
			wakeup((caddr_t)tp);
			continue;
		}
		if (c & DH_PE)
			if ((tp->t_flags&(EVENP|ODDP))==EVENP
			 || (tp->t_flags&(EVENP|ODDP))==ODDP )
				continue;
		if ((c & DH_DO) && overrun == 0) {
			printf("dh%d: silo overflow\n", dh);
			overrun = 1;
		}
		if (c & DH_FE)
			/*
			 * At framing error (break) generate null (in raw mode,
			 * for getty), or interrupt (cooked/cbreak mode)
			 */
			if (tp->t_flags&RAW)
				c = 0;
			else
				c = tp->t_intrc;
#if NBK > 0 || Nbk > 0
		if (tp->t_line == NETLDISC) {
			c &= 0177;
			BKINPUT(c, tp);
		} else
#endif
			(*linesw[tp->t_line].l_rint)(c, tp);
	}
}

/*
 * Ioctl for DH11.
 */
dhioctl(dev, cmd, data, flag)
	caddr_t data;
{
	register struct tty *tp;
	register int unit = minor(dev);
	int error;

	tp = &dh_tty[unit];
	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, data, flag);
	if (error >= 0) {
		if (cmd == TIOCSETP || cmd == TIOCSETN ||
		  cmd == TIOCLSET || cmd == TIOCLBIS || cmd == TIOCLBIC)
			dhparam(unit);
		return (error);
	}
	switch (cmd) {
	    case TIOCSBRK:
		((struct dhdevice *)(tp->t_addr))->dhbreak |= 1<<(unit&017);
		break;

	    case TIOCCBRK:
		((struct dhdevice *)(tp->t_addr))->dhbreak &= ~(1<<(unit&017));
		break;

	    case TIOCSDTR:
		dmctl(unit, DML_DTR|DML_RTS, DMBIS);
		break;

	    case TIOCCDTR:
		dmctl(unit, DML_DTR|DML_RTS, DMBIC);
		break;

	    default:
		return (ENOTTY);
	}
	return (0);
}

/*
 * Set parameters from open or stty into the DH hardware registers.
 */
dhparam(unit)
	register int unit;
{
	register struct tty *tp;
	register struct dhdevice *dhaddr;
	register int lpar;
	int s;

	tp = &dh_tty[unit];
	dhaddr = (struct dhdevice *)tp->t_addr;
	/*
	 * Block interrupts so parameters will be set before line interrupts.
	 */
	s = spl6();
	s = splx(dhinfo[unit>>4]->qi_mi->qm_psl);
#ifdef	CS01BUGS
	dhaddr->un.dhcsr = (dhaddr->un.dhcsr&DH_TI) | (unit&0xf) | DH_IE;
#else	CS01BUGS
	dhaddr->un.dhcsrhl[DH_CSRL] = (unit&0xf) | DH_RIE;
#endif	CS01BUGS
	if ((tp->t_ispeed)==0) {
		tp->t_state |= TS_HUPCLS;
		dmctl(unit, DML_OFF, DMSET);
		splx(s);
		return;
	}
	lpar = ((tp->t_ospeed)<<10) | ((tp->t_ispeed)<<6);
	if ((tp->t_ispeed) == B134)
		lpar |= BITS6|PENABLE|HDUPLX;
	else if (tp->t_flags & (RAW|LITOUT))
		lpar |= BITS8;
	else
		lpar |= BITS7|PENABLE;
	if ((tp->t_flags&EVENP) == 0)
		lpar |= OPAR;
	if ((tp->t_ospeed) == B110)
		lpar |= TWOSB;
	dhaddr->dhlpr = lpar;
	splx(s);
}

/*
 * DH11 transmitter interrupt. Restart each line which used to be active but has
 * terminated transmission since the last interrupt.
 */
dhxint(dh)
	int dh;
{
	register struct tty *tp;
	register struct dhdevice *dhaddr;
	short ttybit, bar, *sbar;
	register struct qb_device *qi;
	register int unit;
	u_short cntr;

	qi = dhinfo[dh];
	dhaddr = (struct dhdevice *)qi->qi_mi->qm_addr;
	if (dhaddr->un.dhcsr & DH_NXM) {
		dhaddr->un.dhcsr |= DH_CNI;
		printf("dh%d: NXM\n", dh);
	}
	sbar = &dhsbar[dh];
	bar = *sbar & ~dhaddr->dhbar;
	unit = dh * 16; 
	ttybit = 1;
#ifdef	CS01BUGS
	while (dhaddr->un.dhcsr & DH_TI)
#endif	CS01BUGS
	dhaddr->un.dhcsr &= ~DH_TI;
	for (; bar; unit++, ttybit <<= 1) {
		if (bar & ttybit) {
			*sbar &= ~ttybit;
			bar &= ~ttybit;
			tp = &dh_tty[unit];
			tp->t_state &= ~TS_BUSY;
			if (tp->t_state&TS_FLUSH)
				tp->t_state &= ~TS_FLUSH;
			else {
#ifdef	CS01BUGS
				dhaddr->un.dhcsr = (dhaddr->un.dhcsr&DH_TI)|
					(unit&0xf)|DH_IE;
#else	CS01BUGS
				dhaddr->un.dhcsrhl[DH_CSRL] = (unit&0xf)|DH_RIE;
#endif	CS01BUGS
				cntr = dhaddr->dhcar - (u_short)dh_buf[unit];
				ndflush(&tp->t_outq, (int)cntr);
			}
			if (tp->t_line)
				(*linesw[tp->t_line].l_start)(tp);
			else
				dhstart(tp);
		}
	}
}

/*
 * Start (restart) transmission on the given DH11 line.
 */
dhstart(tp)
	register struct tty *tp;
{
	register struct dhdevice *dhaddr;
	register int car, dh, unit, nch;
	short word;
	int s;

	unit = minor(tp->t_dev);
	dh = unit >> 4;
	dhaddr = (struct dhdevice *)tp->t_addr;

	/*
	 * Must hold interrupts in following code to prevent state of the tp 
	 * from changing.
	 */
	s = splx(dhinfo[dh]->qi_mi->qm_psl);
	/*
	 * If it's currently active, or delaying, no need to do anything.
	 */
	if (tp->t_state&(TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	/*
	 * If there are sleepers, and output has drained below low water mark, 
	 * wake up the sleepers.
	 */
	if (tp->t_outq.c_cc<=TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	/*
	 * Now restart transmission unless the output queue is empty.
	 */
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags & (RAW|LITOUT))
		nch = ndqb(&tp->t_outq, 0);
	else {
		nch = ndqb(&tp->t_outq, 0200);
		/*
		 * If first thing on queue is a delay process it.
		 */
		if (nch == 0) {
			nch = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (nch&0x7f)+6);
			tp->t_state |= TS_TIMEOUT;
			goto out;
		}
	}
	/*
	 * If characters to transmit, restart transmission.
	 */
	if (nch) {
		tp->t_state |= TS_BUSY;
		car = (int)dh_buf[unit];
		dh_nch[unit] = nch;
		bcopy(tp->t_outq.c_cf, car, nch);
		byterev(car, nch);
#ifdef	CS01BUGS
		dhaddr->un.dhcsr = (dhaddr->un.dhcsr&DH_TI)|
			(unit&0xf)|((car>>12)&0x30)|DH_IE;
#else	CS01BUGS
		dhaddr->un.dhcsrhl[DH_CSRL]=(unit&0xf)|((car>>12)&0x30)|DH_RIE;
#endif	CS01BUGS
		word = 1 << (unit&0xf);
		dhsbar[dh] |= word;
		dhaddr->dhcar = car;
		dhaddr->dhbcr = -nch;
		dhaddr->dhbar |= word;
	}
out:
	splx(s);
}

/*
 * Stop output on a line, e.g. for ^S/^Q or output flush.
 */
dhstop(tp, flag)
	register struct tty *tp;
{
	register struct dhdevice *dhaddr;
	register int unit, s;

	dhaddr = (struct dhdevice *)tp->t_addr;
	/*
	 * Block input/output interrupts while messing with state.
	 */
	s = splx(dhinfo[minor(tp->t_dev)>>4]->qi_mi->qm_psl);
	if (tp->t_state & TS_BUSY) {
		/*
		 * Device is transmitting; stop output by selecting the line and
		 * setting the byte count to -1.  We will clean up later by 
		 * examining the address where the dh stopped.
		 */
		unit = minor(tp->t_dev);
#ifdef	CS01BUGS
		dhaddr->un.dhcsr = (dhaddr->un.dhcsr&DH_TI)|(unit&0xf)|DH_IE;
#else	CS01BUGS
		dhaddr->un.dhcsrhl[DH_CSRL] = (unit&0xf)|DH_RIE;
#endif	CS01BUGS
		if ((tp->t_state&TS_TTSTOP)==0)
			tp->t_state |= TS_FLUSH;
		dhaddr->dhbcr = -1;
	}
	splx(s);
}

/*
 * Reset state of driver if UBA reset was necessary.
 * Reset the csrhl[DH_CSRL] and lpr registers on open lines, and
 * restart transmitters.
 */
dhreset()
{
	register int dh, unit;
	register struct tty *tp;
	register struct qb_device *qi;
	int i;

	dh = 0;
	for (dh = 0; dh < NDH; dh++) {
		qi = dhinfo[dh];
		if (qi == 0 || qi->qi_alive == 0)
			continue;
		printf(" dh%d", dh);
		((struct dhdevice *)qi->qi_mi->qm_addr)->un.dhcsr |= DH_IE;
		((struct dhdevice *)qi->qi_mi->qm_addr)->dhsilo = 0;
		unit = dh * 16;
		for (i = 0; i < 16; i++) {
			tp = &dh_tty[unit];
			if (tp->t_state & (TS_ISOPEN|TS_WOPEN)) {
				dhparam(unit);
				dmctl(unit, DML_ON, DMSET);
				tp->t_state &= ~TS_BUSY;
				dhstart(tp);
			}
			unit++;
		}
	}
	dhsilos = 0;
}

/*int dhtransitions, dhslowtimers, dhfasttimers;		/*DEBUG*/
/*
 * At software clock interrupt time, check status. Empty all the dh silos that 
 * are in use, and decide whether to turn any silos off or on.
 */
dhtimer()
{
	register int dh, s;
	static int timercalls;

	if (dhsilos) {
/*		dhfasttimers++;		/*DEBUG*/
		timercalls++;
		s = spl5();
		for (dh = 0; dh < NDH; dh++)
			if (dhsilos & (1 << dh))
				dhrint(dh);
		splx(s);
	}
	if ((dhsilos == 0) || ((timercalls += FASTTIMER) >= hz)) {
/*		dhslowtimers++;		/*DEBUG*/
		timercalls = 0;
		for (dh = 0; dh < NDH; dh++) {
		    ave(dhrate[dh], dhchars[dh], 8);
		    if ((dhchars[dh] > dhhighrate) &&
		      ((dhsilos & (1 << dh)) == 0)) {
			((struct dhdevice *)(dhinfo[dh]->qi_mi->qm_addr))->dhsilo =
			    (dhchars[dh] > 500? 32 : 16);
			dhsilos |= (1 << dh);
/*			dhtransitions++;		/*DEBUG*/
		    } else if ((dhsilos & (1 << dh)) &&
		      (dhrate[dh] < dhlowrate)) {
			((struct dhdevice *)(dhinfo[dh]->qi_mi->qm_addr))->dhsilo = 0;
			dhsilos &= ~(1 << dh);
		    }
		    dhchars[dh] = 0;
		}
	}
	timeout(dhtimer, (caddr_t) 0, dhsilos? FASTTIMER: hz);
}

/*
 * Turn on the line associated with dh dev.
 */
dmopen(dev, flag)
	dev_t dev;
{
	register struct tty *tp;
	register struct dmdevice *dmaddr;
	register struct qb_device *qi;
	register int unit;
	register int dm;
	int s;

	unit = minor(dev);
	dm = unit >> 4;
	tp = &dh_tty[unit];
	unit &= 0xf;
	if (dm >= NDH || (qi = dminfo[dm]) == 0 || qi->qi_alive == 0 ||
	    (dhsoftCAR[dm]&(1<<unit))) {
		tp->t_state |= TS_CARR_ON;
		return;
	}
	dmaddr = (struct dmdevice *)qi->qi_mi->qm_addr;
	s = splx(qi->qi_mi->qm_psl);
	dmaddr->dmcsr &= ~DM_SE;
	while (dmaddr->dmcsr & DM_BUSY)
		;
	dmaddr->dmcsr = unit;
	dmaddr->dmlstat = DML_ON;
	DELAY(100);
	if (dmaddr->dmlstat&DML_CAR)
		tp->t_state |= TS_CARR_ON;
	dmaddr->dmcsr = DM_IE|DM_SE;
#ifdef TTY_NODELAY
	if ((flag & FNDELAY) == 0)
#endif
	while ((tp->t_state&TS_CARR_ON)==0) {
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
		if ((tp->t_state & TS_XCLUDE)  &&  (u.u_procp->p_flag & SLOGIN))
			break;
	}
	splx(s);
}

/*
 * Dump control bits into the DM registers.
 */
dmctl(dev, bits, how)
	dev_t dev;
	int bits, how;
{
	register struct qb_device *qi;
	register struct dmdevice *dmaddr;
	register int unit, s;
	int dm;

	unit = minor(dev);
	dm = unit >> 4;
	if ((qi = dminfo[dm]) == 0 || qi->qi_alive == 0)
		return;
	dmaddr = (struct dmdevice *)qi->qi_mi->qm_addr;
	s = splx(dminfo[dm]->qi_mi->qm_psl);
	dmaddr->dmcsr &= ~DM_SE;
	while (dmaddr->dmcsr & DM_BUSY)
		;
	dmaddr->dmcsr = unit & 0xf;
	switch(how) {
	case DMSET:
		dmaddr->dmlstat = bits;
		break;
	case DMBIS:
		dmaddr->dmlstat |= bits;
		break;
	case DMBIC:
		dmaddr->dmlstat &= ~bits;
		break;
	}
	dmaddr->dmcsr = DM_IE|DM_SE;
	splx(s);
}

/*
 * DM11 interrupt; deal with carrier transitions.
 */
dmintr(dm)
	register int dm;
{
	register struct qb_device *qi;
	register struct tty *tp;
	register struct dmdevice *dmaddr;

	qi = dminfo[dm];
	if (qi == 0)
		return;
	dmaddr = (struct dmdevice *)qi->qi_mi->qm_addr;
	if (dmaddr->dmcsr&DM_DONE) {
		if (dmaddr->dmcsr&DM_CF) {
			tp = &dh_tty[(dm<<4)+(dmaddr->dmcsr&0xf)];
			wakeup((caddr_t)&tp->t_rawq);
			if ((tp->t_state&TS_WOPEN) == 0 &&
			    (tp->t_flags & MDMBUF)) {
				if (dmaddr->dmlstat & DML_CAR) {
					tp->t_state &= ~TS_TTSTOP;
					ttstart(tp);
				} else if ((tp->t_state&TS_TTSTOP) == 0) {
					tp->t_state |= TS_TTSTOP;
					dhstop(tp, 0);
				}
#ifdef NOMDM			/* INTEGRATED SOLUTIONS addition to ioctl.h */
			} else if (tp->t_flags&NOMDM) {
				tp->t_state |= TS_CARR_ON;
#endif
			} else if ((dmaddr->dmlstat&DML_CAR)==0) {
				if ((tp->t_state&TS_WOPEN)==0 &&
				    (tp->t_flags & NOHANG) == 0) {
					gsignal(tp->t_pgrp, SIGHUP);
					gsignal(tp->t_pgrp, SIGCONT);
					dmaddr->dmlstat = 0;
					ttyflush(tp, FREAD|FWRITE);
				}
				tp->t_state &= ~TS_CARR_ON;
			} else
				tp->t_state |= TS_CARR_ON;
		}
		dmaddr->dmcsr = DM_IE|DM_SE;
	}
}
dhdebug()
{
}
#endif
