/*
 * IBUDP- Interface Bus Utility Driver Program.  Allows the experienced
 *	user more flexibility in programming the GPIB, as direct
 *	calls to the driver are made.  The utility program (IBUP)
 *	makes one or more calls to this routine for each instruction.
 *
 * Copyright 1980 National Instruments
 * REV C:  01/01/82
 *
 * 16mar82- Software received and compiled. -M.Nurmi
 *
 * 27jun83- Cleaned up code. -M.Nurmi
 */
#include <sgtty.h>		/* needed for stty calls */

#define OK      1
#define EIO     5
#define ENOFUN  -7
#define ELOOKU  -100

#define	SECS	4	/* gpib timeout in seconds */

static	int	ibfd = -1, timo = SECS;
static	char	rmd = -1, eod = 0, wmd = -1;
static	short	spfn[3];
extern	int	errno;
char	*dev_file = "/dev/ib0";	/* Global added for multi bus driver*/

gpib(f,a1,a2,a3,a4)
{
char *sccs_id = "%Z%  Module: %M%    Version: %I%    Date: %G%";
	register int x;
	char * ptr;

	if (ibfd < 0 && (ibfd=open(dev_file,2)) < 0) return geterror();
	spfn[0]= f-2;
	switch(f) {
	case 0: 					/* command */
		spfn[0]= 0;
		if (stty(ibfd,spfn)<0) return geterror();
		goto wt;

	case 1:			 			/* write */
		if (wmd != a3) {
			wmd= a3;
			if (setmodes() < 0) return geterror(); 
		}
wt:     
		if ((x= write(ibfd, a1, a2)) < 0) {
			return geterror();
		}
		return x;

	case 2: 					/* read */
		if (rmd != a3 || (a3&2) && eod != a4) {	
			rmd= a3; 
			eod= a4;
			if (setmodes() < 0) return geterror(); 
		}
		if ((x= read(ibfd, a1, a2)) < 0) return geterror();
		ptr = (char *)(a1+x);
		*ptr = 0;
		return x;

	case 9: 
	case 10:                                /* setstat, monitor */
		spfn[1]= a1;
	case 3: 
	case 4: 
	case 5:                         /* transfer, clear, remote */
	case 6: 
	case 8: 
	case 13:                        /* local, passctrl, testsrq */
		if (stty(ibfd,spfn)<0) return geterror();
		return OK;

	case 7: 
	case 11:                                /* ppoll, readcmd */
		if (stty(ibfd,spfn)<0) return geterror();
		if (gtty(ibfd,spfn)<0) return ELOOKU;
		return spfn[0];

	case 12: 
		timo= a1;                              /* setparam */
		if (setmodes()<0) return geterror();
		return OK;

	case 14: 
		if (close(ibfd)<0) return geterror();   /* finish */
		ibfd= -1;
		timo= SECS; 
		rmd= 0; 
		eod= 0; 
		wmd= 0;
		return OK;

	default: 
		return ENOFUN;
	}       
}

/************************************************************/
static setmodes()
{
	spfn[0]= 10;
	spfn[1]= timo;
	spfn[2]= (wmd&017) | ((rmd&017)<<4) | (eod<<8);
	return stty(ibfd,spfn); 
}

/************************************************************/
static geterror()
{
	if (errno!=EIO || gtty(ibfd,spfn)<0) return ELOOKU;
	return spfn[0]; 
}
