/*	vmparam.h	6.1	83/12/30	*/

/*
 * Machine dependent constants for IS68K
 */
/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the P0 region to the
 * beginning of the text and from the beginning of the P1 region to the
 * beginning of the stack respectively.
 *
 * On the IS68K, the P0 & P1 regions overlap.
 * On the IS68K 68010 boards, the uarea is NOT at the top of the user stack
 */
#define	USRTEXT		0

#ifdef	M68020
#define	P0PAGES		(0x10000)	/* number of pages in P0 region */
#define	USRSTACK	(0x10000000-(UPAGES*NBPG)) /* Start of user stack */
#define	HIGHPAGES	UPAGES
#else	M68020
#ifdef	QBUS
#define	P0PAGES		(64*16)		/* number of pages in P0 region */
#define	USRSTACK	0x400000	/* Start of user stack */
#else	QBUS
#define	P0PAGES		(64*32)		/* number of pages in P0 region */
#define	USRSTACK	0x800000	/* Start of user stack */
#endif	QBUS
#define	HIGHPAGES	0
#endif	M68020

#define	LOWPAGES	0
#define	P1PAGES		P0PAGES		/* number of pages in P1 region */

/*
 * Virtual memory related constants
 */
#define	SLOP		8
#define	MAXTSIZ		(P0PAGES-SLOP)		/* max text size (clicks) */
#ifndef MAXDSIZ
#define	MAXDSIZ		(P0PAGES-8-SLOP)	/* max data size (clicks) */
#endif
#define	MAXSSIZ		(P1PAGES-8-SLOP)	/* max stack size (clicks) */

/*
 * Sizes of the system and user portions of the system page table.
#define	SYSPTSIZE	((20+MAXUSERS)*NPTEPG)	VAX 4.3
#define	USRPTSIZE 	(32*NPTEPG)		VAX 4.3
 */
#ifdef	M68020
#define	SYSPTSIZE	0x400
#define	USRPTSIZE 	0x400
#else	M68020
#ifdef	QBUS
#define	SYSPTSIZE	0x200
#define	USRPTSIZE	0x40
#else	QBUS
#define	SYSPTSIZE	0x200
#define	USRPTSIZE	0x80
#endif	QBUS
/*
#define	SYSPTSIZE	(P0PAGES*1024)/NBPG
#define	USRPTSIZE 	((P0PAGES/4)*1024)/NBPG
*/
#endif	M68020

/*
 * The size of the clock loop.
 */
#define	LOOPPAGES	(maxfree - firstfree)

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time.  You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define	MAXSLP 		20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm.  Basically this says that if you are
 * swapped in you deserve some resources.  We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 * Note that each process has at least UPAGES+CLSIZE pages which are not
 * paged anyways (this is currently 8+2=10 pages or 5k bytes), so this
 * number just means a swapped in process is given around 25k bytes.
 * Just for fun: current memory prices are 4600$ a megabyte on VAX (4/22/81),
 * so we loan each swapped in process memory worth 100$, or just admit
 * that we don't consider it worthwhile and swap it out to disk which costs
 * $30/mb or about $0.75.
 */
#define	SAFERSS		(20*1024)/NBPG	/* nominal ``small'' resident set size
					   protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define	DISKRPM		60

/*
 * Klustering constants.  Klustering is the gathering
 * of pages together for pagein/pageout, while clustering
 * is the treatment of hardware page size as though it were
 * larger than it really is.
 *
 * KLMAX gives maximum cluster size in CLSIZE page (cluster-page)
 * units.  Note that KLMAX*CLSIZE must be <= DMMIN in dmap.h.
 */

#ifdef vax
#define	KLMAX	(32/CLSIZE)
#define	KLSEQL	(16/CLSIZE)		/* in klust if vadvise(VA_SEQL) */
#define	KLIN	(8/CLSIZE)		/* default data/stack in klust */
#define	KLTXT	(4/CLSIZE)		/* default text in klust */
#define	KLOUT	(32/CLSIZE)
#else
#define	KLMAX	(1/CLSIZE)
#define	KLSEQL	(1/CLSIZE)		/* in klust if vadvise(VA_SEQL) */
#define	KLIN	(1/CLSIZE)		/* default data/stack in klust */
#define	KLTXT	(1/CLSIZE)		/* default text in klust */
#define	KLOUT	(1/CLSIZE)
#endif

/*
 * KLSDIST is the advance or retard of the fifo reclaim for sequential
 * processes data space.
 */
#define	KLSDIST	3		/* klusters advance/retard for seq. fifo */

/*
 * Paging thresholds (see vm_sched.c).
 * Strategy of 4/22/81:
 *	lotsfree is 1/4 of memory free.
 *	desfree is 200k bytes, but at most 1/8 of memory
 *	minfree is 64k bytes, but at most 1/2 of desfree
 */
#define	LOTSFREEFRACT	4
#define	DESFREE		(200 * 1024)
#define	DESFREEFRACT	8
#define	MINFREE		(64 * 1024)
#define	MINFREEFRACT	2

/*
 * Believed threshold (in megabytes) for which interleaved
 * swapping area is desirable.
 */
#define	LOTSOFMEM	2
