/*#define PRPTES	/* Print out pte's */
/*#define TBCHK 	/* Print out translation buffer */
/*#define PRCMAP	/* Print out cmap structure */
/*	vm_machdep.c	6.1	83/07/29	*/

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/cmap.h"
#include "../h/mount.h"
#include "../h/vm.h"
#include "../h/text.h"
#include "../h/buf.h"
#include "../machine/board.h"

/*
 * Set a red zone in the kernel stack after the u. area.
 * Can't really do this properly on the IS68K.  Too bad.
 */
setredzone(pte, vaddr)
	register struct pte *pte;
	caddr_t vaddr;
{
#ifdef vax
	pte += (sizeof (struct user) + NBPG - 1) / NBPG;
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= PG_URKR;
	if (vaddr)
		mtpr(TBIS, vaddr + sizeof (struct user));
#endif
}

mapin(pte, v, pfnum, count, prot)
struct pte *pte;
u_int v;
register u_int pfnum;
int count;
register int prot;
{
	register struct pte *rpte = pte;
	register int rcount = count;

	while (--rcount >= 0)
		*(int *)rpte++ = pfnum++ | prot;
	newptes(pte, v, count);
}

#ifdef notdef
/*ARGSUSED*/
mapout(pte, size)
	register struct pte *pte;
	int size;
{

	panic("mapout");
}
#endif

/*
 * Check for valid program size
 */
chksize(ts, ds, ss)
	register unsigned ts, ds, ss;
{
	static int maxdmap = 0;

	ts = stoc(ctos(ts));

	if (ts > MAXTSIZ || ds > MAXDSIZ || ss > MAXSSIZ) {
		u.u_error = ENOMEM;
		return (1);
	}
	/* check for swap map overflow */
	if (maxdmap == 0) {
		register int i, blk;

		blk = dmmin;
		for (i = 0; i < NDMAP; i++) {
			maxdmap += blk;
			if (blk < dmmax)
				blk *= 2;
		}
	}
	if (ctod(ts) > NXDAD * dmtext ||
	    ctod(ds) > maxdmap || ctod(ss) > maxdmap) {
		u.u_error = ENOMEM;
		return (1);
	}
	/*
	 * Make sure the process isn't bigger than our
	 * virtual memory limit.
	 *
	 * THERE SHOULD BE A CONSTANT FOR THIS.
	 */
	if (ts + ds + ss + LOWPAGES + HIGHPAGES > btoc(USRSTACK)) {
		u.u_error = ENOMEM;
		return (1);
	}
	return (0);
}

/*
 * Change protection codes of text segment.
 * Have to flush translation buffer since this could
 * affect virtual memory mapping of current process.
 */
chgprot(addr, tprot)
caddr_t addr;
long tprot;
{
	unsigned v;
	int tp;
	register struct pte *pte;
	register struct cmap *c;

	v = clbase(btop(addr));
	if (!isatsv(u.u_procp, v)) {
		u.u_error = EFAULT;
		return (0);
	}
	tp = vtotp(u.u_procp, v);
	pte = tptopte(u.u_procp, tp);
	if (pte->pg_fod == 0 && pte->pg_pfnum) {
		c = &cmap[pgtocm(pte->pg_pfnum)];
		if (c->c_blkno && c->c_mdev != MSWAPX)
			munhash(mount[c->c_mdev].m_dev,
			    (daddr_t)(u_long)c->c_blkno);
	}
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= tprot;
	distcl(pte);
	refbits();
	newptes(pte, v, CLSIZE);
	return (1);
}

settprot(tprot)
long tprot;
{
	register int *ptaddr, i;
	register struct pte *pte = tptopte(u.u_procp, 0);

	for (i = 0; i < u.u_tsize; i++) {
		*(int *)pte &= ~PG_PROT;
		*(int *)pte |= tprot;
		pte++;
	}
	newptes(tptopte(u.u_procp,0), (u_int)0, u.u_tsize);
}

/*
 * Move pages from one kernel virtual address to another.
 * Both addresses are assumed to reside in the Sysmap,
 * and size must be a multiple of CLSIZE.
 */
pagemove(from, to, size)
register caddr_t from, to;
int size;
{
	register caddr_t rfrom = from, rto = to;
	register rsize = size;
	register struct pte *fpte, *tpte;
	register struct pte *rfpte, *rtpte;

	if (size % CLBYTES)
		panic("pagemove");
	fpte = rfpte = &Sysmap[btop(from - SYSV_BASE)];
	tpte = rtpte = &Sysmap[btop(to - SYSV_BASE)];
	while (rsize > 0) {
		*rtpte++ = *rfpte;
		*(int *)rfpte++ = 0;
		rfrom += NBPG;
		rto += NBPG;
		rsize -= NBPG;
	}
	newptes(fpte, from, size);
	newptes(tpte, to, size);
}

prcmap()
{
#ifdef	PRCMAP
	register struct cmap *c;
	int s;

	s = spl7();
	cprintf("typ trn wnt lck fre gon dev ndx blk hlnk pag prv nxt\n");
	for (c = &cmap[0]; c < ecmap ; c++) {
	cprintf("  %x   %x   %x   %x   %x   %x   %x   %x   %x    %x   %x   %x   %x\n",
		c->c_type, c->c_intrans, c->c_want, c->c_lock, c->c_free,
		c->c_gone, c->c_mdev, c->c_ndx, c->c_blkno, c->c_hlink,
		c->c_page, c->c_prev, c->c_next);
	}
	splx(s);
#endif	PRCMAP
}

prptes(p, n)
int *p;
{
#ifdef	PRPTES
	register int i, last = *p, nrun = 0;

	cprintf("PTES @0x%x %d :",p,n);
	for (i = 0 ; i < n ; i++, p++, nrun++) {
		if (*p != last) {
			if (nrun > 1)
				cprintf("%d-%x, ", nrun, last);
			else
				cprintf("%x, ", last);
			nrun = 0;
			last = *p;
		}
	}
	if (nrun > 1)
		cprintf("%dx%x\n", nrun, last);
	else
		cprintf("%x\n", last);
#endif	PRPTES
}

struct vc_context {
	int		vc_lastaccess;
	struct proc	*vc_occupant;
};
struct vc_context vc_context[NCTX];
int vc_tick;		

/*
 * Allocate a context for the current process. This routine is called from
 * trap after a context fault.  We scan the context table first looking for 
 * an empty context and secondly for the least recently used context.
 * We then setup the context and point the context register at it.
 * If it was stolen from another process, we have to update the status bits in 
 * the old process' page table, and set its p->p_context to unallocated.
 */
ctx_alloc()
{
	register u_short i, lru, oldest;
	register struct vc_context *vc;
	register struct proc *p = u.u_procp;

	if (p->p_flag & SSYS)
		panic("context fault on system process");
	vc_tick++;
	lru = 1;
	oldest = vc->vc_lastaccess;
	for (i = 1; i < (NCTX-1); i++) {
		vc = &vc_context[i];
		if (vc->vc_occupant == 0) {
			lru = i;
			break;
		} else if (vc->vc_lastaccess < oldest) {
			lru = i;
			oldest = vc->vc_lastaccess;
		}
	}
	vc = &vc_context[lru];
	if (vc->vc_occupant)
		ctx_free(vc->vc_occupant);
	vc->vc_occupant = p;
	vc->vc_lastaccess = vc_tick;
	setctx(lru);
	setptp(p);
	p->p_context = lru;
	invutbuf();
}

ctx_free(p)
register struct proc *p;
{
	register struct vc_context *vc;

	if (p->p_context == CTX_INVALID || p->p_context == CTX_SYS)
		return;
	if (u.u_procp == p || p->p_context == ctx)
		invutbuf();
	vc = &vc_context[p->p_context];
	if (vc->vc_occupant != p)
		panic("ctx_free");
	p->p_context = CTX_INVALID;
	vc->vc_occupant = 0;
	vc->vc_lastaccess = 0;
}

#define btoptp(x)	( btop(x) | (((int)x&PTP_LSBMASK) << PTP_LSBSHIFT) )

setptp(p)
register struct proc *p;
{
	register int *ptp = (int *)PTP_BASE;
	register struct pte *ptep;
	register int ptpincr = PTP_INCR/sizeof (int);
	register int i, k, n;

	for (i = 0 ; i < NPTPS ; i++, ptp += ptpincr)
		*ptp = PTP_INVALID;
	ptp = (int *)PTP_BASE;
	ptep = &Usrptmap[btokmx(tptopte(p,0))];
	if (p->p_szpt == 1) {
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(ptob(ptep->pg_pfnum));
		ptp = (int *)(PTP_BASE + (PTP_INCR * (NPTPS-1)) );
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|PTP_LSBMASK));
	} else {
/*	    cprintf("p_szpt=%x p_p0br=%x p_p0lr=%x p_p1br=%x p_p1lr=%x\n",
		u.u_pcb.pcb_szpt,u.u_pcb.pcb_p0br,u.u_pcb.pcb_p0lr,
		u.u_pcb.pcb_p1br,u.u_pcb.pcb_p1lr); /**/
	    n = u.u_pcb.pcb_p0lr&~AST_CLR;
	    for (i=0, k=0 ; i <= n ; i+=(NPTEPG/2), ptp+=ptpincr){
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|k));
/*		cprintf("p0pte@%x=%x ptp@%x=%x i=%x\n",
		    ptep,*(int *)ptep,ptp,*ptp&PTP_MASK,i); /**/
		if (k)
		    ptep++;
		k ^= PTP_LSBMASK;
	    }
	    ptp = (int *)(PTP_BASE + (PTP_INCR * (NPTPS-1)) );
	    ptep = &Usrptmap[btokmx(sptopte(p,0))];
	    for (i=p->p_ssize,k=PTP_LSBMASK; i>0; i-=(NPTEPG/2), ptp-=ptpincr){
		if (ptep->pg_pfnum >= PTP_PG) {
		    printf("pg_pgnum = %x, max = %x\n",ptep->pg_pfnum,PTP_PG);
		    panic("page of pte's too high");
		}
		*ptp = btoptp(((int)(ptob(ptep->pg_pfnum))|k));
/*		cprintf("p1pte@%x=%x ptp@%x=%x i=%x\n",
		    ptep,*(int *)ptep,ptp,*ptp&PTP_MASK,i); /**/
		if (k)
		    ptep--;
		k ^= PTP_LSBMASK;
	    }
	}
}

setctx(i)
{
	register int s = spl7();

	ctx = i;
	ctx_mask &= ~CTX_LED;		/* turn LED DS3 on */
	*CTX = ctx_mask | i;
	ctx_mask |= CTX_LED;		/* and off at next context switch */
	splx(s);
}

#ifdef	C_invutbuf
invutbuf() { 
	register int *tbuf = (int *)TBUF_BASE_USR;
	register int tbufincr = TBUF_INCR/sizeof (int);
	register int i;

	for (i = 0 ; i < NTBUFS ; i++, tbuf += tbufincr)
		*tbuf = TBUF_INVALID;
}
#endif	C_invutbuf

#ifdef	C_newptes
newptes(pte, v, size)
	register struct pte *pte;
	u_int v;
	register int size;
{
	register int *tbuf;
	register int tbufincr = TBUF_INCR/sizeof (int);
	register int i;

	if (size <= 0)
		return;
	if (pte >= Sysmap && pte <= eSysmap)
		tbuf = (int *)TBUF_BASE_SYS;
	else
		tbuf = (int *)TBUF_BASE_USR;

	if ( size > 1 )
		for (i = 0 ; i < NTBUFS ; i++, tbuf += tbufincr)
			*tbuf = TBUF_INVALID;
	else {
		tbuf = (int *)((int)tbuf | ((v<<PGSHIFT)&TBUF_INDEX_MASK));
		while (size > 0) {
			*tbuf = TBUF_INVALID;
			tbuf += tbufincr;
			size--;
		}
	}
}
#endif	C_newptes

refbits() { }

svtop(addr) 
{
	register struct pte *pte;

	switch (addr & MEMR_MASK) {
	    case NONT_BASE:
		return(addr);

	    case SYSV_BASE:
		pte = &Sysmap[btop(addr - SYSV_BASE)];
		if (pte->pg_v)
			return((pte->pg_pfnum << PGSHIFT) | (addr&PGOFSET));

	    default:
		panic("svtop");
	}
}

#ifdef	C_useracc
/*
 * test the accessability of a portion of user address space.  This is
 * better than the locore version because it does not fault in pages until they
 * are needed.
 */
useracc(v, len, acc)
register int len, acc;
{
	register struct pte *pte;

#ifdef	BARF
	if (u.u_Rclient)
		return(Wuseracc());
#endif	BARF

	pte = vtopte(u.u_procp, btop(v));
	while (len > 0) {
		if ((acc == B_WRITE) && (pte->pg_prot == PG_URKR))
			return (0);
		len -= NBPG;
		pte++;
	}
	return(1);
}
#endif	C_useracc

#ifdef	TBCHK
/*
 * check the contents of TBUF_SYS with the Sysmap version looking for
 * inconsistancies.  If there are differences, likely some needed 
 * call to newptes is missing.
 */
tbchk(s)
char *s;
{
	register int tpte = TBUF_BASE_SYS;
	register struct pte *mpte;
	register int i, vp;

	for (i = 0 ; i < NTBUFS ; i++, tpte += TBUF_INCR)
		if ((*(int *)tpte) & TBUF_VALID) {
			vp = (((*(int *)tpte) & TBUF_MATCH_MASK)>>11)|i;
			mpte = &Sysmap[vp];
			if (((*(int *)tpte) & PG_PFNUM) != mpte->pg_pfnum)
				cprintf("%s:vp %x t->%x m->%x\n", s,
					vp, *(int *)tpte, *(int *)mpte);
		}
}
#endif	TBCHK
