/*#define NEWPTEDEBUG 	1/**/
/*#define PTEDEBUGUSR 	/**/
/*#define PRMMU		/**/
/*#define PRPTES	/**/
/*#define PRCMAP	/**/
#ifdef NEWPTEDEBUG
int newptedebug = NEWPTEDEBUG;
#endif NEWPTEDEBUG
/*	vm_machdep.c	6.1	83/07/29	*/

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/cmap.h"
#include "../h/mount.h"
#include "../h/vm.h"
#include "../h/text.h"
#include "../h/buf.h"
#include "../machine/board.h"

/*
 * Set a red zone in the kernel stack after the u. area.
 * Can't really do this properly on the IS68K.  Too bad.
 */
setredzone(pte, vaddr)
	register struct pte *pte;
	caddr_t vaddr;
{
#ifdef vax
	pte += (sizeof (struct user) + NBPG - 1) / NBPG;
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= PG_URKR;
	if (vaddr)
		mtpr(TBIS, vaddr + sizeof (struct user));
#endif
}

mapin(pte, v, pfnum, count, prot)
struct pte *pte;
u_int v;
register u_int pfnum;
int count;
register int prot;
{
	register struct pte *rpte = pte;
	register int rcount = count;

	while (--rcount >= 0)
		*(int *)rpte++ = pfnum++ | prot;
	newptes(pte, v, count);
}

#ifdef notdef
/*ARGSUSED*/
mapout(pte, size)
	register struct pte *pte;
	int size;
{

	panic("mapout");
}
#endif

/*
 * Check for valid program size
 */
chksize(ts, ds, ss)
	register unsigned ts, ds, ss;
{
	static int maxdmap = 0;

#ifdef	QBUS
	if (u.u_procp->p_newimage)
		ts = ctos(ts) * stoc(1);
	else
		ts = ctosold(ts) * stocold(1);
#else	QBUS
	ts = ctos(ts) * stoc(1);
#endif	QBUS

	if (ts > MAXTSIZ || ds > MAXDSIZ || ss > MAXSSIZ) {
		u.u_error = ENOMEM;
		return (1);
	}
	/* check for swap map overflow */
	if (maxdmap == 0) {
		register int i, blk;

		blk = dmmin;
		for (i = 0; i < NDMAP; i++) {
			maxdmap += blk;
			if (blk < dmmax)
				blk *= 2;
		}
	}
	if (ctod(ts) > NXDAD * dmtext ||
	    ctod(ds) > maxdmap || ctod(ss) > maxdmap) {
		u.u_error = ENOMEM;
		return (1);
	}
	/*
	 * Make sure the process isn't bigger than our
	 * virtual memory limit.
	 *
	 * THERE SHOULD BE A CONSTANT FOR THIS.
	 */
	if (ts + ds + ss + LOWPAGES + HIGHPAGES > btoc(USRSTACK)) {
		u.u_error = ENOMEM;
		return (1);
	}
	return (0);
}

#ifdef notdef
/*
 * return negitive number of ptes with same protection if none are valid.
 * return positive number of ptes with same protection if any are valid.
 */
segptes(pte,i)
	register struct pte *pte;
	register int i;
{
	register int prot = pte->pg_prot;
	register int j = 0;
	register int k = 0;

	for (;i>0;i--,j++,pte++) {
		if (pte->pg_prot != prot)
			break;
		if (pte->pg_v)
			k = 1;
	}
	return (k ? j : -j);
}
#endif

#ifdef	C_newptes
newptes(pte, v, size)
	register struct pte *pte;
	u_int v;
	register int size;
{
#ifdef	QBUS
	register short *page;		/* ptrs to hardware page regs */
	register short *seg;		/* ptrs to hardware seg regs */
	register short i, prot, context, po;
	extern int end;
	extern segalloc();
	static char is68k_prot[16] = { /* convert vax prot bits to is68k */
		0, 0, 0x80, 0x40, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40
	};

	if (size <= 0)
		return;
	if (pte >= Sysmap && pte <= eSysmap)
		context = 0;
	else
		context = 1;
	seg = (short *)(0x400000 + (((v & ~15) + context) << 12));
	po = v & 15;
	i =  16 - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i =  segptes(pte, i);
		prot = pte->pg_prot;
		if ( i > 0 || ((*seg & 0xC0) != 0) ) {
			if (i < 0) 
				i = -i;
			if ((*seg & 0xC0) == 0)
				*seg = segalloc(context);
			*seg = is68k_prot[prot] + (*seg & 0x3F);
			page = (short *)(0x800000 + 
				((((*seg & 63) << 4) + po) << 12));
    			while (--i >= 0) {
				*page = pte->pg_v ? (pte->pg_pfnum << 2) : 
							(0x3FC << 2);
/*				if (pte->pg_m)
					*page |= 1;	/**/
				--size;
				page += 0x1000 / sizeof *page;
				pte += 1;
			}
		} else {
			*seg = 0x01;
			size += i;		/* i is negative */
			pte -= i;
		}
		i = ( size < 16 ) ? size : 16;
		po = 0;
		seg += (0x10000 / sizeof *seg);
		if ((pte->pg_prot != prot) && u.u_procp->p_newimage && 
			(int)seg & 0x10000)
			seg += 0x10000 / sizeof *seg;
	}
#else	QBUS
	register short *page;		/* ptrs to hardware page regs */
	register char *seg;		/* ptrs to hardware seg regs */
	register short i, prot, context, po;
	extern int end;
	extern segalloc();
	static char is68k_prot[16] = { /* convert vax prot bits to is68k */
		SEGPROT_NO, SEGPROT_NO, SEGPROT_ALL, SEGPROT_REO, 
		SEGPROT_ALL, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, 
		SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, 
		SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_REO
	};

	if (size <= 0)
		return;
	if (pte >= Sysmap && pte <= eSysmap)
		context = 0;
	else
		context = 1;
	seg = (char *)(SEGREGBASE + 
		((v & ~(NPAGPERSEG-1)) << (SEGREGSHIFT-PAGSEGSHIFT)) + 
		(context << SEGCTXSHIFT));
	po = v & (NPAGPERSEG-1);
	i =  NPAGPERSEG - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i =  segptes(pte, i);
		prot = pte->pg_prot;
		if ( i > 0 || ((*seg & SEGPROTMASK) != SEGPROT_NO)) {
			if (i < 0) 
				i = -i;
			if ((*seg & SEGPROTMASK) == SEGPROT_NO)
				*seg = segalloc(context);
			*seg = is68k_prot[prot] + (*seg & (NPAGBANKS-1));
			page = (short *)(PAGREGBASE + 
				((((*seg & (NPAGBANKS-1)) << PAGSEGSHIFT) + po)
				<< PAGREGSHIFT));
    			while (--i >= 0) {
				*page = pte->pg_v ? pte->pg_pfnum : 
					((1<<PAGINVBIT)|(1<<PAGOUTBIT));
				--size;
				page += (PAGREGINCR / sizeof *page);
				pte += 1;
			}
		} else {
			*seg = SEGPROT_NO | SEGPAGEDOUT;
			size += i;		/* i is negative */
			pte -= i;
		}
		i = ( size < NPAGPERSEG ) ? size : NPAGPERSEG;
		po = 0;
		seg += (SEGREGINCR / sizeof *seg);
	}
#endif	QBUS
}
#endif	C_newptes

segalloc(context)
register context;
{
	register short i, *page;	/* ptrs to hardware page regs */
	register int segnum;
	extern int maxsysseg, minusrseg;
	static int randusrseg;

#ifdef NEWPTEDEBUG
	if (newptedebug)
		printf("	SEGALLOC: ");
#endif NEWPTEDEBUG
	segnum = context == 0 ? ++maxsysseg : --minusrseg;
	if (maxsysseg >= minusrseg) {
		if (context == 0)
			panic("segalloc");
		minusrseg++;
		randusrseg--;
		if (randusrseg <= minusrseg)
			randusrseg = 60;	/* leave bottom few alone */
		segnum = randusrseg;
		segfree(context, segnum);
	}
#ifdef	QBUS
	page = (short *)(0x800000 + (segnum << 16));
	for (i = 16 ; i > 0 ; i--) {
		*page = (0x3FD << 2);
		page += 0x1000 / sizeof *page;
#else	QBUS
	page = (short *)(PAGREGBASE + (segnum << (PAGSEGSHIFT+PAGREGSHIFT)));
	for (i = NPAGPERSEG ; i > 0 ; i--) {
		*page = (1<<PAGINVBIT);
		page += PAGREGINCR / sizeof *page;
#endif	QBUS
	}
	return segnum;
}

segfree (context, segnum)
register segnum;
{
#ifdef	QBUS
	register short i;
	register short *seg;		/* ptrs to hardware seg regs */

	refbits();
	seg = (short *)(0x400000 + (context << 12));
	for (i = 0;  i <= 63;  i++) {
		if ( ((*seg & 63) == segnum) && (*seg&0xC0) ) {
			*seg = 0x01;		/* magic number */
			return;
		}
		seg += 0x10000 / sizeof *seg;
	}
#else	QBUS
	register short i;
	register char *seg;		/* ptrs to hardware seg regs */

	refbits();
	seg = (char *)(SEGREGBASE + (context << SEGCTXSHIFT));
	for (i = 0;  i <= NSEGPERCTX-1;  i++) {
		if ( ((*seg & (NSEGPERCTX-1)) == segnum) &&(*seg&SEGPROTMASK)) {
			*seg = SEGPROT_NO | SEGPAGEDOUT;
			return;
		}
		seg += SEGREGINCR / sizeof *seg;
	}
#endif	QBUS
	panic("segfree");
}

refptes(pte, v, size)
register struct pte *pte;
u_int v;
register int size;
{
#ifdef	QBUS
	register short *seg;		/* ptrs to hardware seg regs */
	register short *page, pg;	/* ptrs to hardware page regs */
	register short i, prot, context, po;
	extern int end;

	if (pte >= Sysmap && pte <= eSysmap)
		panic("refptes: context=0\n");
	else
		context = 1;
	seg = (short *)(0x400000 + (((v & ~15) + context) << 12));
	po = v & 15;
	i = 16 - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i = segptes(pte, i);
		prot = pte->pg_prot;
	    	if (i > 0 && (*seg & 0xC0) != 0) {
		    page = (short *)(0x800000+((((*seg&63) << 4) + po) << 12));
    		    while (--i >= 0)  {	/* check each page reg of segment */
			if ((*(int *)pte & (PG_V|PG_FOD)) == PG_V) {
			if ( ((pg = *page) != 0x3FD) && (pg != 0x3FC)) {
				if (pg & 2)
					pte->pg_r = 1;
				if (pg & 1)
					pte->pg_m = 1;
			}
			}
			--size;
			page += 0x1000 / sizeof *page;
			pte += 1;
		    }
		} else {
			if (i < 0)
				i = -i;
			size -= i;
			pte += i;
		}
		i = (size < 16) ? size : 16;
		po = 0;
		seg += (0x10000 / sizeof *seg);
		if ((pte->pg_prot != prot) && u.u_procp->p_newimage && 
			(int)seg & 0x10000)
			seg += (0x10000 / sizeof *seg);
	}
#else	QBUS
	register char *seg;		/* ptrs to hardware seg regs */
	register short *page, pg;	/* ptrs to hardware page regs */
	register short i, context, po;
	extern int end;

	if (pte >= Sysmap && pte <= eSysmap)
		panic("refptes: context=0\n");
	else
		context = 1;
	seg = (char *)(SEGREGBASE + 
		((v & ~(NPAGPERSEG-1)) << (SEGREGSHIFT-PAGSEGSHIFT)) + 
		(context << SEGCTXSHIFT));
	po = v & (NPAGPERSEG-1);
	i = NPAGPERSEG - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i = segptes(pte, i);
		if ( i > 0 &&  (*seg & SEGPROTMASK) != SEGPROT_NO) {
		    page = (short *)(PAGREGBASE + 
			((((*seg & (NPAGBANKS-1)) << PAGSEGSHIFT) + po) 
			<< PAGREGSHIFT));
    		    while (--i >= 0) {	/* check each page reg of segment */
			if (((pg = *page)&((1<<PAGINVBIT)|(1<<PAGOUTBIT)))==0) {
				if (pg & (1<<PAGREFBIT))
					pte->pg_r = 1;
				if (pg & (1<<PAGMODBIT))
					pte->pg_m = 1;
			}
			--size;
			page += (PAGREGINCR / sizeof *page);
			pte += 1;
		    }
		} else {
			if (i < 0)
				i = -i;
			size -= i;
			pte += i;
		}
		i = (size < NPAGPERSEG) ? size : NPAGPERSEG;
		po = 0;
		seg += SEGREGINCR / sizeof *seg;
	}
#endif	QBUS
}

/*
 * Change protection codes of text segment.
 * Have to flush translation buffer since this could
 * affect virtual memory mapping of current process.
 */
chgprot(addr, tprot)
caddr_t addr;
long tprot;
{
	unsigned v;
	int tp;
	register struct pte *pte;
	register struct cmap *c;

	v = clbase(btop(addr));
	if (!isatsv(u.u_procp, v)) {
		u.u_error = EFAULT;
		return (0);
	}
	tp = vtotp(u.u_procp, v);
	pte = tptopte(u.u_procp, tp);
	if (pte->pg_fod == 0 && pte->pg_pfnum) {
		c = &cmap[pgtocm(pte->pg_pfnum)];
		if (c->c_blkno && c->c_mdev != MSWAPX)
			munhash(mount[c->c_mdev].m_dev,
			    (daddr_t)(u_long)c->c_blkno);
	}
	*(int *)pte &= ~PG_PROT;
	*(int *)pte |= tprot;
	distcl(pte);
	refbits();
	newptes(pte, v, CLSIZE);
	return (1);
}

settprot(tprot)
long tprot;
{
	register int *ptaddr, i;
	register struct pte *pte = u.u_pcb.pcb_p0br;

	for (i = 0; i < u.u_tsize; i++) {
		*(int *)pte &= ~PG_PROT;
		*(int *)pte |= tprot;
		pte++;
	}
	newptes(u.u_pcb.pcb_p0br, (u_int)0, u.u_tsize);
}

/*
 * Move pages from one kernel virtual address to another.
 * Both addresses are assumed to reside in the Sysmap,
 * and size must be a multiple of CLSIZE.
 */
pagemove(from, to, size)
register caddr_t from, to;
int size;
{
	register caddr_t rfrom = from, rto = to;
	register rsize = size;
	register struct pte *fpte, *tpte;
	register struct pte *rfpte, *rtpte;

	if (size % CLBYTES)
		panic("pagemove");
	fpte = rfpte = &Sysmap[btop(from)];
	tpte = rtpte = &Sysmap[btop(to)];
	while (rsize > 0) {
		*rtpte++ = *rfpte;
		*(int *)rfpte++ = 0;
		rfrom += NBPG;
		rto += NBPG;
		rsize -= NBPG;
	}
	newptes(fpte, from, size);
	newptes(tpte, to, size);
}

#ifndef	min
#define	min(a,b)	((a) <= (b) ? (a) : (b))
#endif

bcopyin(uv, kv, bcount)
register long uv, kv;
register long bcount;
{
	register struct pte *pte;
	register char *p;
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	int s;

	if (!useracc(uv, bcount, B_READ))
		return -1;
	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0 + (uv & PGOFSET);
	while (bcount) {
		register long n = min(bcount, 32 * 1024);
		register long i = n;

		u.u_procp->p_flag |= SPHYSIO;
		vslock(uv, n);		/* could block here */
		scr0_sav = SCR0;
		scr1_sav = SCR1;
		do {
#ifdef	QBUS
			SCR0 = pte++->pg_pfnum << 2;
			SCR1 = pte->pg_pfnum << 2;
#else	QBUS
			SCR0 = pte++->pg_pfnum;
			SCR1 = pte->pg_pfnum;
#endif	QBUS
			bcopy(p, kv, min(i, NBPG));
			kv += NBPG;
		} while ((i -= NBPG) > 0);
		SCR1 = scr1_sav;
		SCR0 = scr0_sav;
		s = spl6();
		vsunlock(uv, n, B_WRITE);	/* memory read, device write */
		u.u_procp->p_flag &= ~SPHYSIO;
		splx(s);
		bcount -= n;
		uv += n;
	}
	return 0;
}

bcopyout(kv, uv, bcount)
register long uv, kv;
register long bcount;
{
	register struct pte *pte;
	register char *p;
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	int s;

	if (!useracc(uv, bcount, B_WRITE))
		return -1;
	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0 + (uv & PGOFSET);
	while (bcount) {
		register long n = min(bcount, 32 * 1024);
		register long i = n;

		u.u_procp->p_flag |= SPHYSIO;
		vslock(uv, n);		/* could block here */
		scr0_sav = SCR0;
		scr1_sav = SCR1;
		do {
#ifdef	QBUS
			SCR0 = pte++->pg_pfnum << 2;
			SCR1 = pte->pg_pfnum << 2;
#else	QBUS
			SCR0 = pte++->pg_pfnum;
			SCR1 = pte->pg_pfnum;
#endif	QBUS
			bcopy(kv, p, min(i, NBPG));
			kv += NBPG;
		} while ((i -= NBPG) > 0);
		SCR1 = scr1_sav;
		SCR0 = scr0_sav;
		s = spl6();
		vsunlock(uv, n, B_READ);	/* memory write, device read */
		u.u_procp->p_flag &= ~SPHYSIO;
		splx(s);
		bcount -= n;
		uv += n;
	}
	return 0;
}

bcopyseg(uv, kv)
register long uv, kv;
{
	register struct pte *pte;
	register char *p;
	register short scr0_sav;
	extern short SCR0;
	extern char VSCR0;
	int s;

	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0;
	u.u_procp->p_flag |= SPHYSIO;
	vslock(uv, NBPG);		/* could block here */
	scr0_sav = SCR0;
#ifdef	QBUS
	SCR0 = pte->pg_pfnum << 2;
#else	QBUS
	SCR0 = pte->pg_pfnum;
#endif	QBUS
	qbcopyp(p, kv);
	SCR0 = scr0_sav;
	s = spl6();
	vsunlock(uv, NBPG, B_READ);	/* memory write, device read */
	u.u_procp->p_flag &= ~SPHYSIO;
	splx(s);
}

/* print the mmu translation for context 'ctx' */
prmmu(ctx)
{
#ifdef	PRMMU
#ifdef	QBUS
	short seg, *segp;
	short page, *pagep;
	int pro, vp;
	static char *prot[] = {"no access","read exec","read write","all"};
	static char *rwbits[] = {"-r-w","-r+w","+r-w","+r+w"};
	int i,j,rw;

	segp = (short *)(0x400000|((ctx&0xF) << 12));
	for (i = 0 ; i < 64 ; i++) {
	    seg = *segp;
	    pro = (seg & 0xC0 ) >> 6;
	    seg = seg&0x3F;
	    vp = 16 * i;
	    printf("%s %x-%x bank %x\n",prot[pro],vp,vp+15,seg);
	    if (pro) {
	    	pagep = (short *)(0x800000|(seg<<16));
		for (j = 0 ; j < 16 ; j++) {
			page = *pagep;
			rw = page&0x3;
			page = (page&0xFFC) >> 2;
			printf("   v %x -> p %x	%s\n",vp+j,page,rwbits[rw]);
			pagep += 0x1000/sizeof *pagep;
		}
	    }
	    segp += 0x10000/sizeof *segp;
	}
#else	QBUS
	char seg, *segp;
	short page, *pagep;
	int pro, vp;
	static char *prot[] = {"no access","read exec","read write","all"};
	/*
	 *	+r => referenced	-r => not referenced
	 *	+m => modified		-m => not modified
	 *	+o => paged out		-o => not paged out
	 *	+i => invalid		-i => not invalid
	 */
	static char *rwbits[] = {"-r-m-o-i","-r-m-o+i","-r-m+o-i","-r-m+o+i",
				 "-r+m-o-i","-r+m-o+i","-r+m+o-i","-r+m+o+i",
				 "+r-m-o-i","+r-m-o+i","+r-m+o-i","+r-m+o+i",
				 "+r+m-o-i","+r+m-o+i","+r+m+o-i","+r+m+o+i"};
	int i,j,rw;
	int s;

	s = spl7();
	printf("Memory management for CONTEXT %d\n",ctx);
	printf("___________________________________\n");
	segp = (char *)(SEGREGBASE|((ctx&0xF) << SEGCTXSHIFT));
	for (i = 0 ; i < NSEGPERCTX ; i++) {
	    seg = *segp;
	    pro = (seg & SEGPROTMASK ) >> SEGPROTSHIFT;
	    seg = seg&(NPAGBANKS-1);
	    vp = NPAGPERSEG * i;
	    if (pro == 0) {
		printf("%x-",vp);
    		segp += SEGREGINCR/sizeof *segp;
		while ((((*segp&SEGPROTMASK)>>SEGPROTSHIFT) == pro) &&
		       ((*segp&(NPAGBANKS-1)) == seg) &&
		    i < NSEGPERCTX) {
			i++;
	    		vp = NPAGPERSEG * i;
	    		segp += SEGREGINCR/sizeof *segp;
		}
	    	printf("%x	%s", vp+(NPAGPERSEG-1), prot[pro]);
	        printf("=> bank %x\n",seg);
	    } else {
	    	printf("%x-%x	%s", vp, vp+(NPAGPERSEG-1), prot[pro]);
	        printf("=> bank %x\n",seg);
	    	pagep = (short *)(PAGREGBASE|(seg<<(PAGSEGSHIFT+PAGREGSHIFT)));
		for (j = 0 ; j < NPAGPERSEG ; j++) {
			page = *pagep;
			rw = (page>>12)&0xF;
			page = (page&PAGNUMMASK);
			printf("   v %x -> p %x	%s\n",vp+j,page,rwbits[rw]);
			pagep += PAGREGINCR/sizeof *pagep;
		}
    		segp += SEGREGINCR/sizeof *segp;
	    }
	}
	splx(s);
#endif	QBUS
#endif	PRMMU
}

prcmap()
{
#ifdef	PRCMAP
	register struct cmap *c;
	int s;

	s = spl7();
	printf("typ trn wnt lck fre gon dev ndx blk hlnk pag prv nxt\n");
	for (c = &cmap[0]; c < ecmap ; c++) {
	printf("  %x   %x   %x   %x   %x   %x   %x   %x   %x    %x   %x   %x   %x\n",
		c->c_type, c->c_intrans, c->c_want, c->c_lock, c->c_free,
		c->c_gone, c->c_mdev, c->c_ndx, c->c_blkno, c->c_hlink,
		c->c_page, c->c_prev, c->c_next);
	}
	splx(s);
#endif	PRCMAP
}

prptes(p, n)
int *p;
{
#ifdef	PRPTES
	register int i, last = *p, nrun = 0;

	printf("PTES @0x%x %d :",p,n);
	for (i = 0 ; i < n ; i++, p++, nrun++) {
		if (*p != last) {
			if (nrun > 1)
				printf("%x x %d, ", last, nrun);
			else
				printf("%x, ", last);
			nrun = 0;
			last = *p;
		}
	}
	if (nrun > 1)
		printf("%x x %d\n", last, nrun);
	else
		printf("%x\n", last);
#endif	PRPTES
}

#ifdef	QBUS
#else	QBUS
svtop(x)
long x;
{
	long ret;
	ret = ((long)((*(short *)(((long)((*(u_char *)
	  (SEGREGBASE|(x&0x7E0000))&(NSEGPERCTX-1))<<6)|
	  ((x&0x1F000)>>11)|PAGREGBASE))&PAGNUMMASK))<<PGSHIFT)|(x&(NBPG-1));
}
#endif	QBUS

pcopyin(p, k, bcount)
  register char *p, *k;
  register int bcount;
  {
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	register unsigned pfnum;
	register int n;

	if (bcount <= 0)
		return;
	pfnum = (unsigned long)p >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	do {
		n = min(bcount, NBPG);
#ifdef	QBUS
		SCR0 = pfnum++ << 2;
		SCR1 = pfnum << 2;
#else	QBUS
		SCR0 = pfnum++;
		SCR1 = pfnum;
#endif	QBUS
		bcopy(p, k, n);
		k += n;
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
}

pcopyout(k, p, bcount)
  register char *k, *p;
  register int bcount;
  {
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	register unsigned pfnum;
	register int n;

	if (bcount <= 0)
		return;
	pfnum = (unsigned long)p >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	do {
		n = min(bcount, NBPG);
#ifdef	QBUS
		SCR0 = pfnum++ << 2;
		SCR1 = pfnum << 2;
#else	QBUS
		SCR0 = pfnum++;
		SCR1 = pfnum;
#endif	QBUS
		bcopy(k, p, n);
		k += n;
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
}

pcopy(p, q, bcount)
  register char *p, *q;
  register int bcount;
  {
	short scr0_sav, scr1_sav;
	short scr2_sav, scr3_sav;
	extern short SCR0, SCR1;
	extern short SCR2, SCR3;
	extern char VSCR0;
	extern char VSCR2;
	register unsigned spfnum, dpfnum;
	register int n;

	if (bcount <= 0)
		return;
	spfnum = (unsigned long)p >> PGSHIFT;
	dpfnum = (unsigned long)q >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	q = &VSCR2 + ((unsigned long)q & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	scr2_sav = SCR2;
	scr3_sav = SCR3;
	do {
		n = min(bcount, NBPG);
#ifdef	QBUS
		SCR0 = spfnum++ << 2;
		SCR1 = spfnum << 2;
		SCR2 = dpfnum++ << 2;
		SCR3 = dpfnum << 2;
#else	QBUS
		SCR0 = spfnum++;
		SCR1 = spfnum;
		SCR2 = dpfnum++;
		SCR3 = dpfnum;
#endif	QBUS
		bcopy(p, q, n);
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
	SCR2 = scr2_sav;
	SCR3 = scr3_sav;
}
