/*	ufs_machdep.c	6.1	83/07/29	*/

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/proc.h"
#include "../h/seg.h"
#include "../h/vm.h"

/*
 * Machine dependent handling of the buffer cache.
 */

/*
 * Expand or contract the actual memory allocated to a buffer. If no memory is 
 * available, release buffer and take error exit
 */
allocbuf(tp, size)
	register struct buf *tp;
	int size;
{
	register struct buf *bp, *ep;
	int sizealloc, take;
	register char *a;
	struct map *map;
	int osize;

	sizealloc = roundup(size, BUFALLOCSIZE);
	/*
	 * Buffer size does not change
	 */
	if (sizealloc == tp->b_bufsize)
		goto out;
#ifdef	QBUS
	map = tp->b_flags & B_18BIT ? buffermap18 : buffermap;
#else	QBUS
	map = buffermap;
#endif	QBUS
	/*
	 * Buffer size is shrinking, Just put the tail end back in the map
	 */
	if (sizealloc < tp->b_bufsize) {
		rmfree(map, (long)(tp->b_bufsize - sizealloc),
			(long)(tp->b_un.b_addr + sizealloc));
		tp->b_bufsize = sizealloc;
		goto out;
	}
	/*
	 * Buffer is being expanded or created. If being expanded, attempt to 
	 * get contiguous section, otherwise get a new chunk and copy. If no 
	 * space, free up a buffer on the AGE list and try again.
	 */
	do {
		if ((osize = tp->b_bufsize)) {
			a = (char *)rmget(map, (long)(sizealloc-osize),
				(long)(tp->b_un.b_addr + osize));
			if (a == 0) {
				a = (char *)rmalloc(map, (long)sizealloc);
				if (a != 0) {
#ifdef	BUFCHECK
					printf("!");
#endif	BUFCHECK
					bcopy(tp->b_un.b_addr, a, osize);
					rmfree(map, (long)osize, 
						(long)tp->b_un.b_addr);
					tp->b_un.b_addr = a;
				}
			}
		} else {
			a = (char *)rmalloc(map, (long)sizealloc);
			if (a != 0)
				tp->b_un.b_addr = a;
		}
	} while (a == 0 && bfreemem(tp->b_flags & B_QUALIFY));
	if (a == 0) {
		brelse(tp);
		return (0);
	}
	tp->b_bufsize = sizealloc;
out:
	tp->b_bcount = size;
	return (1);
}

/*
 * Release space associated with a buffer.
 */
bfree(bp)
	struct buf *bp;
{
	if (bp->b_bufsize) {
#ifdef	QBUS
		rmfree(bp->b_flags & B_18BIT ? buffermap18 : buffermap,
			(long)bp->b_bufsize, (long)bp->b_un.b_addr);
#else	QBUS
		rmfree(buffermap, (long)bp->b_bufsize, (long)bp->b_un.b_addr);
#endif	QBUS
		bp->b_bufsize = 0;
	}
	bp->b_bcount = 0;
}

/*
 * Attempt to free up buffer space by flushing something in the free list.
 * Don't wait for something , that could cause deadlocks.  We start with
 * BQ_AGE because we know that BQ_EMPTY takes no memory.
 */
bfreemem(flags)
{
	register struct buf *bp, *dp;
	int s;

loop1:
	s = spl6();
	dp = &bfreelist[BQ_AGE];
loop2:
	for (; dp > bfreelist ; dp--)
		if (dp->av_forw != dp)
			break;
	if (dp == bfreelist ) {
		dp->b_flags |= B_WANTED;
		sleep((caddr_t)dp, PRIBIO+1);
		splx(s);
		return (0);
	}
	for (bp = dp->av_forw; bp != dp ; bp=bp->av_forw)
		if ((bp->b_flags & flags) == flags)
			break;
	if (dp == bp) {
		dp--;
		goto loop2;
	}
	notavail(bp);
	splx(s);
	if (bp->b_flags & B_DELWRI) {
		bp->b_flags |= B_ASYNC;
		bwrite(bp);
		goto loop1;
	}
	bp->b_flags &= (B_QUALIFY | B_BUSY);
	bp->b_flags |= B_BUSY | B_INVAL;
	bfree(bp);
	bremhash(bp);
	binshash(bp, &bfreelist[BQ_EMPTY]);
	bp->b_dev = (dev_t)NODEV;
	bp->b_error = 0;
	brelse(bp);
	return(1);
}
