/*#define UTRACE            	/* enable user bus error trace */
/*#define NOFAULT 	1	/* enable NOFAULT TRACE */
/*#define SYSCALLTRACE	1	/* enable and min pid for SYSCALLTRACE */
/*#define TRAPTRACE	1	/* enable and initial value of TRAPTRACE */
/*#define SCTRACENMI 		/* use NMI to toggle syscall trace */
/*#define TRAPTRACENMI 		/* use NMI to toggle trap trace */
#define	tprintf	printf
/*	trap.c	6.1	83/11/30	*/
#define	TRAP_TYPE		/* used in "trap.h" include file */

#include "../machine/psl.h"
#include "../machine/reg.h"
#include "../machine/pte.h"
#include "../machine/vmparam.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "assym.s"
#include "../h/proc.h"
#include "../h/seg.h"
#include "../machine/trap.h"
#include "../machine/scb.h"
#include "../machine/board.h"
#include "../h/acct.h"
#include "../h/kernel.h"

#ifdef	SYSCALLTRACE
#include "../sys/syscalls.c"
int	syscalltrace = SYSCALLTRACE;
#endif	SYSCALLTRACE

#ifdef	TRAPTRACE
int	traptrace = TRAPTRACE;
#endif	TRAPTRACE

struct	sysent	sysent[];
int		nsysent;
int		halt_tick();
static int	haltreboot = 0;
extern int	cvec;
extern int	clev;
extern caddr_t	nofault;

/*
 * The arguments and local variables within trap and syscall have been declared
 * in such a way as to cause d2-d7 & a2-a5 to be saved.  Furthermore, there
 * can be no local non-register variables within these routines, nor can the
 * compiler allocate any space for intermediate temporaries within the frames.
 * If this is violated, trapcheck will print a message as the kernel is booted.
 */

/*
 * Called from the trap handler when a processor trap occurs.
 */
/*ARGSUSED*/
trap(exsf)	/* args passed as a structure because some are 16 bitters */
	struct {
		int		xsf_sp;		/* user stack pointer */
		int		xsf_regs[4];	/* saved temp registers */
		ushort		xsf_code;	/* trap code (trap dependent) */
		ushort		xsf_type;	/* trap type (see trap.h) */
		union xsf	xsf;
	} exsf;
#	define	sp	exsf.xsf_sp
#	define	type	exsf.xsf_type
#	define	code	exsf.xsf_code
#	define	pc	exsf.xsf.xf0.xsf_pc
#	define	psl	exsf.xsf.xf0.xsf_psl
#	define	vec	exsf.xsf.xf0.xsf_vec
#	define	ssw	exsf.xsf.xfa.xsf_ssw
#	define	faddr	exsf.xsf.xfa.xsf_faddr
{
	register int		*locr0 = ((int *)&psl)-PS;
	register int		i, a, x;
	register caddr_t	nf;
	register struct proc 	*p;
	register long 		syst_tv_sec, syst_tv_usec;
	register unsigned int	utype = type;

	syst_tv_sec = u.u_ru.ru_stime.tv_sec;
	syst_tv_usec = u.u_ru.ru_stime.tv_usec;

	if (USERMODE(locr0[PS])) {
		utype |= USER;
		u.u_ar0 = locr0;
	}
#ifdef	TRAPTRACE
	if (traptrace && utype != T_ASTFLT+USER /* && type != T_PAGEFLT */) {
	    x = spl7();
	    if ((type < NTRAP_TYPES) && (type >= 0))
		tprintf("%s %s:",utype&USER ? "USR" : "SYS",
			trap_type[type]);
	    else
		tprintf("TRAP %x:",utype);
	    tprintf("(%s)pc=%x psl=%x vec=%x",
		u.u_comm, pc, psl, (vec >> 2) & 0xFF);
	    a = vec&ESF_FMTMSK;
	    if (a == ESF_FMT8 || a == ESF_FMTA || a == ESF_FMTB)
		tprintf(" adr=%x ssw=%x esr=%x ctx=%x", faddr, ssw, *ESR, ctx);
	    tprintf("\n");
	    splx(x);
	}
#endif	TRAPTRACE

	switch (utype) {
	    case T_BUSERR:
	    case T_PROTFLT:
	    case T_ADDERR:
		if (nofault) {
	rcvrnofault:
		    	pc = (int)nofault;
			nofault = 0;
		    	vec |= ESF_SOFT;
		    	ssw &= ESF_SSW_SOFTMSK;	/* inhibit rerun of bus cycle */
#ifdef	NOFAULT
			x = spl7();
			tprintf("NOFAULT: new pc=%x, new ssw=%x\n",nofault,ssw);
			splx(x);
#endif	NOFAULT
			return;
		}
		/* fall thru */

	    default:
		x = spl7();
	        if ((type < NTRAP_TYPES) && (type >= 0))
		    tprintf("%s %s:",utype&USER ? "USR" : "SYS",
			trap_type[type]);
	        else
			tprintf("TRAP %x:",utype);
	        tprintf("(%s)pc=%x psl=%x vec=%x",
			u.u_comm, pc, psl, (vec >> 2) & 0xFF);
	        a = vec&ESF_FMTMSK;
	        if (a == ESF_FMT8 || a == ESF_FMTA || a == ESF_FMTB)
			tprintf(" adr=%x ssw=%x esr=%x ctx=%x\n", faddr, ssw, *ESR, ctx);
	        tprintf("\n");
		splx(x);
		if (type < NTRAP_TYPES)
			panic(trap_type[type]);
		panic("?? trap");

	    case T_BUSERR+USER:
	    case T_PROTFLT+USER:
	    case T_ADDERR+USER:
		i = SIGBUS;
		break;

	    case T_CNTXFLT+USER:
	    case T_CNTXFLT:
		a = faddr;
		if (((a&MEMR_MASK) == USRV_BASE) && (utype == type))
		    a = a&NONT_MASK;
		if (a&MEMR_MASK) {
    		    printf("Trap %x:(%s)pc=%x adr=%x psl=%x ssw=%x esr=%x ctx=%x\n",
		    	utype,u.u_comm,pc,faddr,psl,ssw,*ESR,ctx);
		    panic("ctxfault");
		}
		ctx_alloc();
		return;

	case T_SEGVIO+USER:
	case T_SEGVIO:
		a = faddr;
		if (((a&MEMR_MASK) == USRV_BASE) && (utype == type))
			a = a&NONT_MASK;
		if ((a&MEMR_MASK)) {
    		    if (nofault)
			goto rcvrnofault;
    		    printf("Trap %x:(%s)pc=%x adr=%x psl=%x ssw=%x esr=%x ctx=%x\n",
		    	utype,u.u_comm,pc,faddr,psl,ssw,*ESR,ctx);
		    panic("segvio");
		}
#define	SPURSEG /* Recover from spuroius segment faults */
#ifdef	SPURSEG
x = 0;
#endif	SPURSEG
    segvio:	if (grow((unsigned)locr0[SP]) || grow(a)) {
			if (utype&USER)
				goto out;
			return;
		}
#ifdef	SPURSEG
if (x == 0)
goto pagflt;
#endif	SPURSEG
    		if (nofault)
			goto rcvrnofault;
		i = SIGSEGV;
		break;

	    case T_PAGEFLT:			/* page faults in kernel mode */
	    case T_PAGEFLT+USER:		/* page fault */
		a = faddr;
		if (((a&MEMR_MASK) == USRV_BASE) && (utype == type))
		    a = a&NONT_MASK;
		if (a & MEMR_MASK) {
    		    if (nofault)
			goto rcvrnofault;
    		    printf("Trap %x:(%s)pc=%x adr=%x psl=%x ssw=%x esr=%x ctx=%x\n",
		    	utype,u.u_comm,pc,faddr,psl,ssw,*ESR,ctx);
		    panic("pageflt");
		}
#ifdef	SPURSEG
x = 1;
pagflt:
#endif	SPURSEG
		i = u.u_error;
		nf = nofault;
		nofault = 0;
		if (pagein(a, 0) == 0) {
		    nofault = nf;
		    u.u_error = i;
#ifdef	SPURSEG
x = 1;
#endif	SPURSEG
		    goto segvio;		/* can't page in */
		}
		nofault = nf;
		u.u_error = i;
#ifdef	SPURSEG
if (x == 0)
;
/*tprintf("Spurious segment violation %x\n",*ESR); /**/
#endif	SPURSEG
		if (utype&USER)
			goto out;
		return;

	    case T_PRIVINFLT+USER:
	    case T_RESADFLT+USER:
	    case T_RESOPFLT+USER:
	    case T_COPROC+USER:			/* no 68881 */
		u.u_code = type;
		i = SIGILL;
		break;

	    case T_ASTFLT+USER:
		astoff();
		if ((u.u_procp->p_flag & SOWEUPC) && u.u_prof.pr_scale) {
			addupc(pc, &u.u_prof, 1);
			u.u_procp->p_flag &= ~SOWEUPC;
		}
		goto out;

	    case T_FPE+USER:
		u.u_code = code;	/* KLUDGE, code should map to VAX */
		i = SIGFPE;
		break;

	    case T_ZERODIV+USER:
		u.u_code = FPE_INTDIV_TRAP;
		i = SIGFPE;
		break;

	    case T_CHK+USER:
		u.u_code = FPE_SUBRNG_TRAP;
		i = SIGFPE;
		break;

	    case T_TRAPV+USER:
		u.u_code = FPE_INTOVF_TRAP;
		i = SIGFPE;
		break;

	    case T_L1010EM+USER:
	    case T_L1111EM+USER:
		u.u_code = fuword(pc - 2) & 0xFFFF;
		i = SIGEMT;
		break;

	    case T_TRCTRAP:			/* trace trap in system mode*/
		locr0[PS] &= ~PSL_T;
		return;

	    case T_BPTFLT+USER:			/* breakpoint trap */
		locr0[PC] -= 2;
	    case T_TRCTRAP+USER:		/* trace trap */
		locr0[PS] &= ~PSL_T;
		u.u_code = 0;
		i = SIGTRAP;
		break;

	    case T_NMI:				/* nonmaskable interrupt */
	    case T_NMI+USER:
#ifdef	SCTRACENMI
		syscalltrace ^= 1;
#endif	SCTRACENMI
#ifdef	TRAPTRACENMI
		traptrace ^= 1;
#endif	TRAPTRACENMI
		i = *ESR;
		if ((i&ESR_PARITY_OK) == 0)
			printf ("Parity Error");
		if ((i&ESR_AC_OK) == 0) {
			printf ("Halt or Power Fail");
			if (haltreboot == 0)
				timeout(halt_tick, (caddr_t)0, hz);
			haltreboot++;
		}

		printf(" NMI:type=%x code=%x pc=%x vec=%x psl=%x esr=%x\n",
			utype, code, pc, (vec >> 2) & 0xFF, psl, i);
		return;

	    case T_TRAP+USER:
		u.u_code = code;
		i = SIGEMT;
		break;

	    case T_STRAY:
	    case T_STRAY+USER:
		i = (vec >> 2) & 0xFF;
		/* 
		 * If we are doing 'autoconf' then cvec will be NSCBVEC, and 
		 * should be modified to be the vector at which a controler
		 * interrupted at.
		 */
		if (cvec == NSCBVEC) {
		    cvec = i;
		    clev = (spl() & PSL_HIGH) >> 8;
		} else
		    printf("Stray interrupt/trap thru vector 0x%x\n", i);
		return;
	}
#ifdef	UTRACE
	if (i == SIGBUS || i == SIGSEGV) {
		x = spl7();
	        if ((type < NTRAP_TYPES) && (type >= 0))
		    tprintf("UTRACE:%s %s:",utype&USER ? "USR" : "SYS",
			trap_type[type]);
	        else
			tprintf("UTRACE %x:",utype);
	        tprintf("(%s):pc=%x psl=%x vec=%x",
			u.u_comm, pc, psl, (vec >> 2) & 0xFF);
	        a = vec&ESF_FMTMSK;
	        if (a == ESF_FMT8 || a == ESF_FMTA || a == ESF_FMTB)
			tprintf(" adr=%x ssw=%x esr=%x ctx=%x\n", 
			    faddr, ssw, *ESR, ctx);
	        tprintf("\n");
/*
tbchk("---");
panic("---");
/**/
		splx(x);
	}
#endif	UTRACE
	psignal(u.u_procp, i);

out:	p = u.u_procp;
	if (p->p_cursig || ISSIG(p))
		psig();
	p->p_pri = p->p_usrpri;
	if (runrun) {
		/*
		 * Since we are u.u_procp, clock will normally just change
		 * our priority without moving us from one queue to another
		 * (since the running process is not on a queue.)
		 * If that happened after we setrq ourselves but before we
		 * swtch()'ed, we might not be on the queue indicated by
		 * our priority.
		 */
		(void) spl6();
		setrq(p);
		u.u_ru.ru_nivcsw++;
		swtch();
	}
	if (u.u_prof.pr_scale) {
		register struct timeval *tv = &u.u_ru.ru_stime;

		i = (tv->tv_sec - syst_tv_sec) * 1000;  /* dont generate tmps */
		a = (tv->tv_usec - syst_tv_usec) / 1000;
		i = i + a;
		a = tick / 1000;
		i = i / a;
		if (i)
			addupc(locr0[PC], &u.u_prof, i);
	}
	curpri = p->p_pri;
}

halt_tick()
{
	if (haltreboot >= 3)
		panic("three NMI's within one second\n");
	else
		haltreboot = 0;
}

/*
 * Called from the trap handler when a system call occurs
 */
/*ARGSUSED*/
syscall(exsf)	/* args passed as a structure because some are 16 bitters */
	struct {
		int	xsf_sp;		/* user stack pointer */
		int	xsf_regs[4];	/* saved temp registers */
		short	xsf_code;	/* system call number */
		short	xsf_type;
		union	xsf	xsf;
	} exsf;
#	define	sp	exsf.xsf_sp
#	define	type	exsf.xsf_type
#	define	code	exsf.xsf_code
#	define	pc	exsf.xsf.xf0.xsf_pc
#	define	psl	exsf.xsf.xf0.xsf_psl
{
	register int *locr0 = ((int *)&psl)-PS;
	register struct sysent *callp;
	register struct proc *p;
	register int i, opc;
	register long syst_tv_sec, syst_tv_usec;
	register int dummy0, dummy1;

	syst_tv_sec = u.u_ru.ru_stime.tv_sec;
	syst_tv_usec = u.u_ru.ru_stime.tv_usec;
	if (!USERMODE(locr0[PS])) {
		panic("syscall");
		dummy0 = dummy1 = 0;
	}

#ifdef	SYSCALLTRACE
	if (u.u_procp->p_pid < SYSCALLTRACE)
		syscalltrace=0;
	else
		syscalltrace=1;

	if (syscalltrace)
		tprintf("PID%d:%s:%x: ",u.u_procp->p_pid,u.u_comm,pc);
#endif	SYSCALLTRACE
	u.u_ar0 = locr0;

	if (code < 0) {
		sigcleanup(code);
		goto done;
	}

	u.u_error = 0;
	opc = pc - 2;
	callp = (code >= nsysent || code < 0) ? &sysent[63] : &sysent[code];
	u.u_ap = u.u_arg;
	u.u_dirp = (caddr_t)u.u_arg[0];
	u.u_r.r_val1 = 0;
	u.u_r.r_val2 = locr0[R1];
	if (setjmp(&u.u_qsave)) {
		if (u.u_error == 0 && u.u_eosys == JUSTRETURN)
			u.u_error = EINTR;
	} else {
		u.u_eosys = JUSTRETURN;
#ifdef	SYSCALLTRACE
		if (syscalltrace) {
			register char *cp;

			if (code >= nsysent || code < 0)
				tprintf("%x", code);
			else
				tprintf("%s", syscallnames[code]);
			cp = "(";
			for (i= 0; i < callp->sy_narg; i++) {
				tprintf("%s%x", cp, u.u_arg[i]);
				cp = ", ";
			}
			if (i)
				tprintf(")");
		}
#endif	SYSCALLTRACE
		(*(callp->sy_call))();
	}
	if (u.u_eosys == RESTARTSYS)
		pc = opc;
#ifdef	notdef
	else if (u.u_eosys == SIMULATERTI)
		dorti();
#endif
	else if (u.u_error) {
		locr0[R0] = u.u_error;
		locr0[PS] |= PSL_C;		/* carry bit */
	} else {
		locr0[PS] &= ~PSL_C;
		locr0[R0] = u.u_r.r_val1;
		locr0[R1] = u.u_r.r_val2;
	}
done:
	p = u.u_procp;
	if (p->p_cursig || ISSIG(p))
		psig();
	p->p_pri = p->p_usrpri;
	if (runrun) {
		/*
		 * Since we are u.u_procp, clock will normally just change
		 * our priority without moving us from one queue to another
		 * (since the running process is not on a queue.)
		 * If that happened after we setrq ourselves but before we
		 * swtch()'ed, we might not be on the queue indicated by
		 * our priority.
		 */
		(void) spl6();
		setrq(p);
		u.u_ru.ru_nivcsw++;
		swtch();
	}
	if (u.u_prof.pr_scale) {
		register struct timeval *tv = &u.u_ru.ru_stime;

		i = (tv->tv_sec - syst_tv_sec) * 1000;  /* dont generate tmps */
		i += (tv->tv_usec - syst_tv_usec) / 1000;
		dummy0 = tick / 1000;
		i /= dummy0;
		if (i)
			addupc(locr0[PC], &u.u_prof, i);
	}
	curpri = p->p_pri;
#ifdef	SYSCALLTRACE
	if (syscalltrace)
		tprintf(" :%x:PID%d\n",pc,u.u_procp->p_pid);
#endif	SYSCALLTRACE
}

/*
 * nonexistent system call-- signal process (may want to handle it)
 * flag error if process won't see signal immediately
 * Q: should we do that all the time ??
 */
nosys()
{
	if (u.u_signal[SIGSYS] == SIG_IGN || u.u_signal[SIGSYS] == SIG_HOLD)
		u.u_error = EINVAL;
	psignal(u.u_procp, SIGSYS);
}

/*
 * Verify trap and syscall local variable and save mask requirements have not 
 * been violated; both functions should start with: 
 *	link fp,#0xffd8; movml #0x3cfc,sp@
 * If the warnings below occur then adb, dbx, ...  will not work correctly.
 */
trapcheck()
{
	if (((ushort *)trap)[1]!=0xffd8 || ((ushort *)trap)[3]!=0x3cfc)
		printf("***  WARNING:  Argument violation in trap ***\n");
	if (((ushort *)syscall)[1]!=0xffd8 || ((ushort *)syscall)[3]!=0x3cfc)
		printf("***  WARNING:  Argument violation in syscall ***\n");
}
