/*#define PTEDEBUGNMI		/* turn on ptedebug with nmi */
/*#define USERTRACE		/* enable user bus error trace */
/*#define NOFAULT		/* enable NOFAULT TRACE */
/*#define CAPTURE		1	/* enable vector frame capture */
/*#define SYSCALLTRACE	1	/* enable and initial value of SYSCALLTRACE */
/*#define TRAPTRACE	1	/* enable and initial value of TRAPTRACE */
/*#define SCTRACENMI 		/* use NMI to toggle syscall trace */
/*#define TRAPTRACENMI 		/* use NMI to toggle trap trace */
/*#define SCTRACE4 		/* Trace all but first shell */
/*	trap.c	6.1	83/11/30	*/
#define	TRAP_TYPE		/* for include file "trap.h" */

#include "../machine/psl.h"
#include "../machine/reg.h"
#include "../machine/pte.h"
#include "../machine/vmparam.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "assym.s"
#include "../h/proc.h"
#include "../h/seg.h"
#include "../machine/trap.h"
#include "../machine/scb.h"
#include "../machine/board.h"
#include "../h/acct.h"
#include "../h/kernel.h"

#ifdef	SYSCALLTRACE
#include "../sys/syscalls.c"
int	syscalltrace = SYSCALLTRACE;
#endif	SYSCALLTRACE

#ifdef	TRAPTRACE
int	traptrace = TRAPTRACE;
#endif	TRAPTRACE

#ifdef	PTEDEBUGNMI
extern int newptedebug;
#endif	PTEDEBUGNMI

struct	sysent	sysent[];
int		nsysent;
int		halt_tick();
static int	haltreboot = 0;

#ifdef	CAPTURE
#define NSAVFRAMES	64
/*
 * capture the last NSAVFRAMES of asynchronous events for debugging.  Must
 * also enable in locore.s.
 */
struct xframe {
	int	f_regs[4];
	ushort	f_code;
	short	f_type;
	int	f_psl;
	int	f_pc;
	ushort	f_vector;
	ushort	f_ssw;
	int	f_faddr;
	int	f_spaddr;
};
struct xframe	sav_frames[NSAVFRAMES];
int		sav_framei = 0;
int		do_capture = CAPTURE;
capture(frame)
struct xframe frame;
{
	int s;

	if (do_capture == 0)
		return;
	s = spl7();
/*
	sav_frames[sav_framei].f_regs[0] = frame.f_regs[0];
	sav_frames[sav_framei].f_regs[1] = frame.f_regs[1];
	sav_frames[sav_framei].f_regs[2] = frame.f_regs[2];
	sav_frames[sav_framei].f_regs[3] = frame.f_regs[3];
*/
	sav_frames[sav_framei].f_code = frame.f_code;
	sav_frames[sav_framei].f_type = frame.f_type;
	sav_frames[sav_framei].f_psl = frame.f_psl;
	sav_frames[sav_framei].f_pc = frame.f_pc;
	sav_frames[sav_framei].f_vector = frame.f_vector;
	if (frame.f_vector & 0x8000) {
		sav_frames[sav_framei].f_ssw = frame.f_ssw;
		sav_frames[sav_framei].f_faddr = frame.f_faddr;
	} else {
		sav_frames[sav_framei].f_ssw = 0;
		sav_frames[sav_framei].f_faddr = 0;
	}
	sav_frames[sav_framei].f_spaddr = (int)(&frame.f_psl)+2;  /* soft */
	sav_framei = (++sav_framei) % NSAVFRAMES;
	splx(s);
}

pcapture()
{
	register struct xframe *f;
	register int i;
	int s = spl7();

	i = sav_framei;
	f = &sav_frames[i];
	printf(        "VEC	COD/TYP	PC	PSL	SP 	SSW	FADDR\n");
	do {
		printf("%x	%x %x	%x	%x	%x	%x	%x\n",
		    (f->f_vector >> 2) & 0x3FF, f->f_code, f->f_type, f->f_pc,
		    f->f_psl&0xFFFF, f->f_spaddr, f->f_ssw, f->f_faddr);
		i = (++i) % NSAVFRAMES;
		f = &sav_frames[i];
	} while ( i != sav_framei );
	splx(s);
}
#endif	CAPTURE


/*
 * The arguments and local variables within trap and syscall have been declared
 * in such a way as to cause d2-d7 & a2-a5 to be saved.  Furthermore, there
 * can be no local non-register variables within these routines, nor can the
 * compiler allocate any space for intermediate temporaries within the frames.
 * If this is violated, trapcheck will print a message as the kernel is booted.
 */

/*
 * Called from the trap handler when a processor trap occurs.
 */
/*ARGSUSED*/
trap(exsf)	/* args passed as a structure because some are 16 bitters */
	struct {
		int	exsf_sp;	/* user stack pointer */
		int	exsf_regs[4];	/* saved temp registers */
		ushort	exsf_code;	/* trap code (trap dependent) */
		short	exsf_type;	/* trap type (see trap.h) */

		int	exsf_psl;	/* processor status longword */
		int	exsf_pc;	/* program counter */
		ushort	exsf_vector;	/* frame format & vector offset */

		ushort	exsf_ssw;	/* bus error special status word */
		int	exsf_faddr;	/* bus error fault address */
		ushort	exsf_unused0;
		ushort	exsf_dob;
		ushort	exsf_unused1;
		ushort	exsf_dib;
		ushort	exsf_unused2;
		ushort	exsf_iib;
	} exsf;
#	define	sp	exsf.exsf_sp
#	define	type	exsf.exsf_type
#	define	code	exsf.exsf_code
#	define	pc	exsf.exsf_pc
#	define	psl	exsf.exsf_psl
#	define	ssw	exsf.exsf_ssw
#	define	vector	exsf.exsf_vector
#	define	faddr	exsf.exsf_faddr
#	define	ireg	exsf.exsf_iib
{
	register int *locr0 = ((int *)&psl)-PS;
	register int i;
	register struct proc *p;
	register long syst_tv_sec, syst_tv_usec;
	register caddr_t nf;
	register short caddr2;
	register int dummy1;
	register int dummy0;
	extern int cvec;
	extern int clev;
	extern caddr_t nofault;

	syst_tv_sec = u.u_ru.ru_stime.tv_sec;
	syst_tv_usec = u.u_ru.ru_stime.tv_usec;

	if (USERMODE(locr0[PS])) {
		type |= USER;
		u.u_ar0 = locr0;
	}
#ifdef TRAPTRACE
	if (traptrace && type != T_ASTFLT+USER /*&& 
		type != T_PAGEFLT && type != T_PAGEFLT+USER &&
		type != T_SEGFLT && type != T_SEGFLT+USER*/) {
	i = spl7();
	if ( ((unsigned)(type&~USER) < NTRAP_TYPES) &&
	     ((unsigned)(type&~USER) >= 0) )
		printf("TRAP:%s %d:%s: ",type & USER ? "USER" : "SYS",
			type&~USER,trap_type[type&~USER]);
	else
		printf("TRAP %d: ",type);
	printf("code=0x%x pc=0x%x vec=0x%x psl=0x%x cx=0x%x",
		code & 0xFFFF, pc, (vector >> 2) & 0xFF,
		psl, (*CXR & 0xFF));
	if ((vector & 0xF000) == 0x8000)
		printf(" ireg=0x%x ssw=0x%x faddr=(0x%x,0x%x)",
			(ireg & 0xFFFF), (ssw & 0xFFFF), faddr, svtop(faddr));
	printf("\n");
	splx(i);
	}
#endif TRAPTRACE

#ifdef	QBUS
#define	CADDR2	(*(short *)(0x800000 + (int)&u - (2 * NBPG)))
#else	QBUS
#define	CADDR2	(*((short *)(PAGREGBASE + \
			(((int)&u - (2 * NBPG)) >> (PGSHIFT-PAGREGSHIFT)))))
#endif	QBUS
	switch (type) {
	case T_BUSERR:
	case T_PROTFLT:
	case T_ADDERR:
		if (nofault) {
			pc = (int)nofault;
			vector |= 0x4000;
			ssw |= 0x8000;	/* inhibit rerun of bus cycle */
#ifdef NOFAULT
			i = spl7();
			printf("NOFAULT: new pc=%x, new ssw=%x\n",nofault,ssw);
			splx(i);
#endif NOFAULT
			nofault = 0;
			return;
		}
		/* fall thru */

	  default:
		i = spl7();
		printf(
    "TRAP%d: code=0x%x pc=0x%x vector=0x%x psl=0x%x cx=0x%x",
			type & 0xFFFF, code & 0xFFFF, pc, (vector >> 2) & 0xFF,
			psl, (*CXR & 0xFF));
		if ((vector & 0xF000) == 0x8000)
			printf(" ireg=0x%x ssw=0x%x faddr=0x(%x,%x)",
			    (ireg & 0xFFFF), ssw & 0xFFFF, faddr, svtop(faddr));
		printf("\n");
/*		stacktrace(); /**/
/*
{unsigned short *xp; int xj;
xp = &sp;
printf("usp @0x%x\n",xp);
for (xj = 0 , xp += (9*8); xj < 12 ; xj++, xp = xp - 8)
printf("%x:	%x	%x	%x	%x	%x	%x	%x	%x\n",
xp, *xp, *(xp-1), *(xp-2), *(xp-3), *(xp-4), *(xp-5), *(xp-6), *(xp-7));
pcapture();
}
*/
		splx(i);
		type &= ~USER;
		if ((unsigned)type < NTRAP_TYPES)
			panic(trap_type[type]);
		panic("?? trap");
		dummy0 = dummy1 = 0;

	case T_BUSERR+USER:
#ifdef 	USERTRACE
		i = spl7();
		printf(
   "user mode buserr! (%s) pc=0x%x vector=0x%x faddr=0x(%x,%x) psl=0x%x\n",
		    u.u_comm,pc,(vector>>2)&0xFF,faddr,svtop(faddr),psl);
		/* prmmu(1); /**/
		splx(i);
#endif 	USERTRACE
		i = SIGBUS;
		break;

	case T_PROTFLT+USER:	/* protection fault */
#ifdef 	USERTRACE
		i = spl7();
		printf(
   "user mode proerr! (%s) pc=0x%x vector=0x%x faddr=0x(%x,%x) psl=0x%x\n",
		    u.u_comm,pc,(vector>>2)&0xFF,faddr,svtop(faddr),psl);
		/* prmmu(1); /**/
		splx(i);
#endif 	USERTRACE
		i = SIGBUS;
		break;

	/*
	 * If the user SP is above the stack segment, grow the stack 
	 * automatically.  If the stack did not grow, try to page in the
	 * violation, and if that fails then call it a segvio.  Valid non-mapped
	 * pages will be caught as a SEGVIO if a previous page in the segment 
	 * was faulted in and, in doing that, a page bank had to be freed 
	 * (segfree). All the other pages in that bank are marked invalid by 
	 * newptes even though they may be valid. We try to fault those pages in
	 * here.  NOTE: should this be done for system mode SEGVIO's?  CTH
	 */
	case T_SEGVIO+USER:
	case T_SEGVIO:
		if (faddr+1 >= USRSTACK)	/* out of range */
			goto usegvio;
		if (grow((unsigned)locr0[SP]) || grow(faddr)) {
		    if (type&USER)
			goto out;
		    else
			return;
		}
		goto pagflt;

	usegvio:if (nofault) {
			pc = (int)nofault;
			vector |= 0x4000;
			ssw |= 0x8000;	/* inhibit rerun of bus cycle */
#ifdef NOFAULT
			i = spl7();
			printf("NOFAULT: new pc=%x, new ssw=%x\n",nofault,ssw);
			splx(i);
#endif NOFAULT
			nofault = 0;
			return;
		}
#ifdef	USERTRACE
		i = spl7();
		printf(
    "user mode segvio! (%s) pc=0x%x vector=0x%x faddr=0x(%x,%x) psl=0x%x\n",
		    u.u_comm,pc,(vector>>2)&0xFF,faddr,svtop(faddr),psl);
		/* prmmu(1); /**/
		splx(i);
#endif	USERTRACE
		i = SIGSEGV;
		if (type&USER)
			break;
		return;

	case T_PAGEFLT:		/* allow page faults in kernel mode */
	case T_SEGFLT:		/* allow seg faults in kernel mode */
	case T_PAGEFLT+USER:	/* page fault */
	case T_SEGFLT+USER:	/* segment fault */
	pagflt:	i = u.u_error;
		nf = nofault;
		nofault = 0;
		caddr2 = CADDR2;
		if (!pagein(faddr, 0)) {
			CADDR2 = caddr2;
			nofault = nf;
			u.u_error = i;
			goto usegvio;	/* can't page in */
		}
		CADDR2 = caddr2;
		nofault = nf;
		u.u_error = i;
		if (type&USER)
			goto out;
		return;

	case T_PRIVINFLT+USER:	/* privileged instruction fault */
	case T_RESADFLT+USER:	/* reserved addressing fault */
	case T_RESOPFLT+USER:	/* reserved operand fault */
		u.u_code = type & ~USER;
		i = SIGILL;
		break;

	case T_ASTFLT+USER:
		astoff();
		if ((u.u_procp->p_flag & SOWEUPC) && u.u_prof.pr_scale) {
			addupc(pc, &u.u_prof, 1);
			u.u_procp->p_flag &= ~SOWEUPC;
		}
		goto out;

	case T_ADDERR+USER:
#ifdef	USERTRACE
		i = spl7();
		printf(
    "user mode adderr! (%s) pc=0x%x vector=0x%x faddr=0x(%x,%x) psl=0x%x\n",
		    u.u_comm,pc,(vector>>2)&0xFF,faddr,svtop(faddr),psl);
		/* prmmu(1); /**/
		splx(i);
#endif	USERTRACE
		i = SIGBUS;
		break;

	case T_ZERODIV+USER:
		u.u_code = FPE_INTDIV_TRAP;
		i = SIGFPE;
		break;

	case T_CHK+USER:
		u.u_code = FPE_SUBRNG_TRAP;
		i = SIGFPE;
		break;

	case T_TRAPV+USER:
		u.u_code = FPE_INTOVF_TRAP;
		i = SIGFPE;
		break;

	case T_L1010EM+USER:	/* line 1010 emulation */
	case T_L1111EM+USER:	/* line 1111 emulation */
		u.u_code = fuword(pc - 2) & 0xFFFF;
		i = SIGEMT;
		break;

	case T_TRCTRAP:		/* trace trap in system mode*/
		locr0[PS] &= ~PSL_T;
		return;

	case T_BPTFLT+USER:	/* breakpoint trap */
		locr0[PC] -= 2;
	case T_TRCTRAP+USER:	/* trace trap */
		locr0[PS] &= ~PSL_T;
		u.u_code = 0;
		i = SIGTRAP;
		break;

	case T_NMI:		/* nonmaskable interrupt */
	case T_NMI+USER:
#ifdef SCTRACENMI
		syscalltrace ^= 1;
#endif SCTRACENMI
#ifdef TRAPTRACENMI
		traptrace ^= 1;
#endif TRAPTRACENMI
#ifdef PTEDEBUGNMI
		newptedebug ^= 1;
#endif PTEDEBUGNMI
		i = spl7();
#ifdef	QBUS
		if (code & BSR_POWERFAIL)
			printf ("power fail ");
		if (code & BSR_BUSPARITY)
			printf ("bus parity error ");
		if (code & BSR_LOCALPARITY)
			printf ("local bus parity error ");
		if (code & BSR_HALT) 
			printf ("halt ");
		printf("\n");
#else	QBUS
		printf ("parity error or power fail\n");
#endif	QBUS
		if (haltreboot == 0)
			timeout(halt_tick, (caddr_t)0, hz);
		haltreboot++;

/*		sleeptrace(0); /**/
/*		bufertrace(); /**/
		printf("NMI:type=%d code=%x pc=%x vector=%x psl=%x cx=%x",
			type & 0xFFFF, code & 0xFFFF, pc, (vector >> 2) & 0xFF,
			psl, (*CXR & 0xFF));
		if ((vector & 0xF000) == 0x8000)
			printf(" ssw=0x%x faddr=0x(%x,%x)", 
				(ssw & 0xFFFF), faddr, svtop(faddr));
		printf("\n");
		splx(i);
		return;

	case T_TRAP+USER:
		u.u_code = code;
		i = SIGEMT;
		break;

	case T_STRAY:
	case T_STRAY+USER:
		i = (vector >> 2) & 0xFF;
		/* 
		 * If we are doing 'autoconf' then cvec will be NSCBVEC, and 
		 * should be modified to be the vector at which a controler
		 * interrupted at.
		 */
		if (cvec == NSCBVEC) {
		    cvec = i;
		    clev = (spl() & PSL_HIGH) >> 8;
		} else
		    printf("Stray interrupt/trap thru vector 0x%x\n", i);
		return;
	}
	psignal(u.u_procp, i);
out:
	p = u.u_procp;
	if (p->p_cursig || ISSIG(p))
		psig();
	p->p_pri = p->p_usrpri;
	if (runrun) {
		/*
		 * Since we are u.u_procp, clock will normally just change
		 * our priority without moving us from one queue to another
		 * (since the running process is not on a queue.)
		 * If that happened after we setrq ourselves but before we
		 * swtch()'ed, we might not be on the queue indicated by
		 * our priority.
		 */
		(void) spl6();
		setrq(p);
		u.u_ru.ru_nivcsw++;
		swtch();
	}
	if (u.u_prof.pr_scale) {
		register struct timeval *tv = &u.u_ru.ru_stime;

		i = (tv->tv_sec - syst_tv_sec) * 1000;  /* dont generate tmps */
		i += (tv->tv_usec - syst_tv_usec) / 1000;
		dummy0 = tick / 1000;
		i /= dummy0;
		if (i)
			addupc(locr0[PC], &u.u_prof, i);
	}
	curpri = p->p_pri;
}

halt_tick()
{
	if (haltreboot >= 3)
		panic("three NMI's within one second\n");
	else
		haltreboot = 0;
}

/*
 * Called from the trap handler when a system call occurs
 */
/*
 * The arguments and local variables within trap and syscall have been declared
 * in such a way as to cause d2-d7 & a2-a5 to be saved.  Furthermore, there
 * can be no local non-register variables within these routines, nor can the
 * compiler allocate any space for intermediate temporaries within the frames.
 */
/*ARGSUSED*/
syscall(exsf)	/* args passed as a structure because some are 16 bitters */
	struct {
		int	exsf_sp;	/* user stack pointer */
		int	exsf_regs[4];	/* saved temp registers */
		short	exsf_code;	/* system call number */
		short	exsf_type;

		int	exsf_psl;	/* processor status longword */
		int	exsf_pc;	/* program counter */
		ushort	exsf_vector;	/* frame format & vector offset */
	} exsf;
#	define	sp	exsf.exsf_sp
#	define	type	exsf.exsf_type
#	define	code	exsf.exsf_code
#	define	pc	exsf.exsf_pc
#	define	psl	exsf.exsf_psl
{
	register int *locr0 = ((int *)&psl)-PS;
	register struct sysent *callp;
	register struct proc *p;
	register int i, opc;
	register long syst_tv_sec, syst_tv_usec;
	register int dummy0, dummy1;

	syst_tv_sec = u.u_ru.ru_stime.tv_sec;
	syst_tv_usec = u.u_ru.ru_stime.tv_usec;
	if (!USERMODE(locr0[PS])) {
		panic("syscall");
		dummy0 = dummy1 = 0;
	}

#ifdef SYSCALLTRACE
#ifdef SCTRACE4
	if (u.u_procp->p_pid < 4)		/* */
		syscalltrace=0;			/* */
	else					/* */
		syscalltrace=1;			/* */
#endif SCTRACE4
#ifdef SYSCALLTRACE

#endif SYSCALLTRACE
	if (syscalltrace)
		printf("PID%d:",u.u_procp->p_pid);
#endif SYSCALLTRACE
	u.u_ar0 = locr0;

	if (code < 0) {
		sigcleanup(code);
		goto done;
	}

	u.u_error = 0;
	opc = pc - 2;
	callp = (code >= nsysent || code < 0) ? &sysent[63] : &sysent[code];
	u.u_ap = u.u_arg;
	u.u_dirp = (caddr_t)u.u_arg[0];
	u.u_r.r_val1 = 0;
	u.u_r.r_val2 = locr0[R1];
	if (setjmp(&u.u_qsave)) {
		if (u.u_error == 0 && u.u_eosys == JUSTRETURN)
			u.u_error = EINTR;
	} else {
		u.u_eosys = JUSTRETURN;
#ifdef SYSCALLTRACE
		if (syscalltrace) {
			register char *cp;

			if (code >= nsysent || code < 0)
				printf("0x%x", code);
			else
				printf("%s", syscallnames[code]);
			cp = "(";
			for (i= 0; i < callp->sy_narg; i++) {
				printf("%s%x", cp, u.u_arg[i]);
				cp = ", ";
			}
			if (i)
				putchar(')', 0);
/*			putchar('\n', 0);/**/
		}
#endif
		(*(callp->sy_call))();
	}
	if (u.u_eosys == RESTARTSYS)
		pc = opc;
#ifdef notdef
	else if (u.u_eosys == SIMULATERTI)
		dorti();
#endif
	else if (u.u_error) {
		locr0[R0] = u.u_error;
		locr0[PS] |= PSL_C;	/* carry bit */
	} else {
		locr0[PS] &= ~PSL_C;
		locr0[R0] = u.u_r.r_val1;
		locr0[R1] = u.u_r.r_val2;
	}
done:
	p = u.u_procp;
	if (p->p_cursig || ISSIG(p))
		psig();
	p->p_pri = p->p_usrpri;
	if (runrun) {
		/*
		 * Since we are u.u_procp, clock will normally just change
		 * our priority without moving us from one queue to another
		 * (since the running process is not on a queue.)
		 * If that happened after we setrq ourselves but before we
		 * swtch()'ed, we might not be on the queue indicated by
		 * our priority.
		 */
		(void) spl6();
		setrq(p);
		u.u_ru.ru_nivcsw++;
		swtch();
	}
	if (u.u_prof.pr_scale) {
		register struct timeval *tv = &u.u_ru.ru_stime;

		i = (tv->tv_sec - syst_tv_sec) * 1000;  /* dont generate tmps */
		i += (tv->tv_usec - syst_tv_usec) / 1000;
		dummy0 = tick / 1000;
		i /= dummy0;
		if (i)
			addupc(locr0[PC], &u.u_prof, i);
	}
	curpri = p->p_pri;
#ifdef SYSCALLTRACE
	if (syscalltrace)
		printf(" :PID%d\n",u.u_procp->p_pid);
#endif SYSCALLTRACE
}

/*
 * nonexistent system call-- signal process (may want to handle it)
 * flag error if process won't see signal immediately
 * Q: should we do that all the time ??
 */
nosys()
{
	if (u.u_signal[SIGSYS] == SIG_IGN || u.u_signal[SIGSYS] == SIG_HOLD)
		u.u_error = EINVAL;
	psignal(u.u_procp, SIGSYS);
}

/*
 * Verify trap and syscall local variable and save mask requirements have not 
 * been violated; both functions should start with: 
 *	link fp,#0xffd8; movml #0x3cfc,sp@
 * If the warnings below occur then adb, dbx, ...  will not work correctly.
 */
trapcheck()
{
	if (((ushort *)trap)[1]!=0xffd8 || ((ushort *)trap)[3]!=0x3cfc)
		printf("***  WARNING:  Argument violation in trap ***\n");
	if (((ushort *)syscall)[1]!=0xffd8 || ((ushort *)syscall)[3]!=0x3cfc)
		printf("***  WARNING:  Argument violation in syscall ***\n");
}
