/*	pte.h	6.1	83/07/29	*/

/*
 * IS68K20 page table entrys
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering.
 */

#ifndef LOCORE
#define	PG_BITS	"\20\40PG_V\37PG_RO\36PG_M\35PG_R\30PG_FOD\27SWVM\26RVM"

struct pte {
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:1,		/* access control */
		pg_m:1,			/* hardware maintained modified bit */
		pg_r:1,			/* referenced bit */
		:5,			/* TRASH, fileno */
		pg_fod:1,		/* is fill on demand (=0) */
		pg_swapm:1,		/* have to write back to swap */
		pg_vreadm:1,		/* modified since vread (or with _m) */
		:4,
		pg_pfnum:16;
};

/* NOTE: CLSIZE is 1 (no clustering), so this structure is not used. CTH */
struct hpte {
unsigned int	pg_high:12,		/* special for clustering */
		:4,
		pg_pfnum:16;
};

struct fpte {
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:1,		/* access control */
		pg_m:1,			/* hardware maintained modified bit */
		pg_r:1,			/* referenced bit */
		:4,			/* TRASH */
		pg_fileno:1,		/* file mapped from or TEXT or ZERO */
		pg_fod:1,		/* is fill on demand (=1) */
		pg_blkno:22;		/* file system block number */
};
#endif	LOCORE

#define	PG_V		0x80000000
#define	PG_PROT		0x40000000
#define	PG_M		0x20000000
#define	PG_R		0x10000000
#define	PG_FOD		0x00400000
#define	PG_VREADM	0x00100000
#define	PG_PFNUM	0x0000FFFF

#define	PG_M_BIT	29
#define	PG_R_BIT	28

#define	PG_FZERO	0
#define	PG_FTEXT	1
#define	PG_FMAX		(PG_FTEXT)


#define	PG_NOACC	0
#define	PG_KW		0x00000000
#define	PG_KR		0x40000000
#define	PG_UW		0x00000000
#define	PG_URKR		0x40000000

#ifndef LOCORE
/* Pte related macros */
#define	dirty(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
			    (anycl_mod(pte) || (pte)->pg_swapm))
#define	referenced(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
			     anycl_ref(pte))

#ifdef	KERNEL
struct	pte *vtopte();

/* utilities defined in locore.s */
extern	struct pte Sysmap[];
extern	struct pte Usrptmap[];
extern	struct pte usrpt[];
extern	struct pte Forkmap[];
extern	struct pte Xswapmap[];
extern	struct pte Xswap2map[];
extern	struct pte Swapmap[];
extern	struct pte Pushmap[];
extern	struct pte Vfmap[];
extern	struct pte mcrmap[];
extern	struct pte mmap[];
extern	struct pte msgbufmap[];
extern	struct pte camap[];
#ifdef	VBUS
#ifdef	GWS
extern	struct pte vidbufmap[];
#endif	GWS
#ifdef	ENP
extern	struct pte enpmap[];
#endif	ENP
extern	struct pte vbmap[];
#endif	VBUS
extern	struct pte eSysmap[];		/* end marker */
#endif	KERNEL
#endif	LOCORE
