/*	param.h	6.1	83/12/30	*/

/*
 * Machine dependent constants for is68k.
 */
#define	NBPG	4096		/* bytes/page */
#define	PGOFSET	(NBPG-1)	/* byte offset into page */
#define	PGSHIFT	12		/* LOG2(NBPG) */

#define	CLSIZE		1
#define	CLSIZELOG2	0

#define	SSIZE	1		/* initial stack size/NBPG */
#define	SINCR	1		/* increment of stack/NBPG */

#define	UPAGES	1		/* pages of u-area */
#ifndef	M68020
#ifdef	QBUS
#define IOPAGES	2		/* number of io pages at top of kernel space */
#define NBUF18	8		/* number of MAXBSIZE buffers in 18 bit land */
#else	QBUS
#define IOPAGES	32		/* number of io pages at top of kernel space */
#endif	QBUS
#endif	M68020

/*
 * Some macros for units conversion
 */
/* Core clicks (4096 bytes) to segments and vice versa */
#define	ctos(x)		(((x)+31)>>5)
#define	stoc(x)		((x)<<5)
#ifdef	QBUS
#ifndef	M68020
#define	ctosold(x)	(((x)+15)>>4)
#define	stocold(x)	((x)<<4)
#endif	M68020
#endif	QBUS

#ifdef	M68020
/* Core clicks (4096 bytes) to page table pointer and vice versa */
#define	ctop(x)	(((x)+511)>>9)
#define	ptoc(x)	((x)<<9)
#else	M68020
#define	ctop(x)	(x)
#define	ptoc(x)	(x)
#endif	M68020
/* Core clicks (4096 bytes) to disk blocks */
#define	ctod(x)	(x<<3)
#define	dtoc(x)	((((unsigned)x)+7)>>3)
#define	dtob(x)	((x)<<9)

/* clicks to bytes */
#define	ctob(x)	((x)<<12)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+(NBPG-1))>>12)

/*
 * Macros to decode processor status word.
 */
#define	USERMODE(ps)	(((ps) & PSL_CURMOD) == 0)
#define	BASEPRI(ps)	(((ps) & PSL_IPL) == 0)

#define	DELAY(n)	{ register int N = (n); while (--N > 0); }

/* macros for referencing longs as two shorts */
#define	loword(X)	(((ushort *)&(X))[1])
#define	hiword(X)	(((ushort *)&(X))[0])

/* macros for making byte refs to word regs on the Qbus (note byte reversal) */
#define	Qlobyte(X)	(((uchar_t *)&X)[1])
#define	Qhibyte(X)	(((uchar_t *)&X)[0])
